/*
*  RAL -- Rubrica Addressbook Library
*  file: io.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_IO_H
#define _R_IO_H

#include <glib.h>
#include <libxml/tree.h>

#include "error.h"


void r_io_write_str    (xmlNodePtr node, gchar *label, gchar* string);
void r_io_write_bool   (xmlNodePtr node, gchar *label, gboolean bool);
void r_io_write_number (xmlNodePtr node, gchar *label, gulong val);
void r_io_write_date   (xmlNodePtr node, gboolean bool, time_t date);

#define r_io_write_time(node, lbl, val) r_io_write_number (node, lbl, val)


gchar*   r_io_get               (xmlNodePtr node, const gchar* name, 
				 RError* e);
gchar*   r_io_get_content       (xmlNodePtr node, RError* err);
gboolean r_io_get_bool          (xmlNodePtr node, gchar* key, RError* err);
glong    r_io_get_date          (xmlNodePtr node, gchar* key, RError* err); 
time_t   r_io_get_calendar      (xmlNodePtr node, gchar** day, gchar** month, 
				 gchar** year, RError *err);

gchar*   r_io_get_prop          (xmlNodePtr node, gchar* key, RError *err);
gchar*   r_io_get_prop_from     (xmlNodePtr node, gchar* node_name,
				 gchar* key, RError* err);  

gboolean r_io_get_bool_from     (xmlNodePtr node, gchar* node_name,
				 gchar* key, RError* err);

time_t   r_io_get_calendar_from (xmlNodePtr node, gchar* node_name,
				 gchar** day, gchar** month, 
				 gchar** year, RError *err);

xmlNodePtr r_io_get_node        (xmlNodePtr node, xmlChar* key);
xmlNodePtr r_io_get_child       (xmlNodePtr node, xmlChar* key);
xmlNodePtr r_io_get_brother     (xmlNodePtr brother, xmlChar* key);

#endif
