/*
*  RAL -- Rubrica Addressbook Library
*  file: csv.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_RUBRICA_H
#define _R_RUBRICA_H

#include <stdio.h>
#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>

#include "abook.h"
#include "error.h"
#include "plugin.h"

#define R_RUBRICA_TYPE            (r_rubrica_get_type())

#define R_RUBRICA(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),  \
                                   R_RUBRICA_TYPE, RRubrica))

#define R_RUBRICA_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),   \
                                   R_RUBRICA_TYPE, RRubricaClass))

#define IS_R_RUBRICA(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),  \
                                   R_RUBRICA_TYPE))

#define IS_R_RUBRICA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),   \
                                   R_RUBRICA_TYPE))

#define R_RUBRICA_GET_CLASS(obj)  (G_TYPE_CHECK_INSTANCE_GET_CLASS((obj), \
                                   R_RUBRICA_TYPE, RRubricaClass))


typedef struct _RRubrica          RRubrica;
typedef struct _RRubricaClass     RRubricaClass;
typedef struct _RRubricaPrivate   RRubricaPrivate;


struct _RRubrica 
{
  GObject parent;
  

  /* private */
  RRubricaPrivate* private;
};


struct _RRubricaClass
{
  GObjectClass parent;  
};


GType       r_rubrica_get_type   (void);


/* ************ Public ************
*/

// RRubrica* r_rubrica_new   (void);
// void      r_rubrica_free  (RRubrica *rubrica);

// void      plugin_init     (RPlugin* plugin);
// void      plugin_fini     (RPlugin* plugin);


G_MODULE_EXPORT void plugin_init (RPlugin* plugin, gchar* file);
G_MODULE_EXPORT void plugin_fini (void);

#endif  /* _R_RUBRICA_H */ 
