/*
*  RAL -- Rubrica Addressbook Library
*  file: save.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _RUBRICA_SAVE_H
#define _RUBRICA_SAVE_H


#include <glib.h>
#include <libxml/tree.h>

#include "card.h"
#include "personal.h"
#include "company.h"



void r_write_card      (RCard *card, xmlNodePtr cardxml);

void r_write_infos     (RCard *card, xmlNodePtr cardxml); 
void r_write_group     (RCard *card, xmlNodePtr node);
void r_write_refs      (RCard *card, xmlNodePtr node);

void r_write_addresses (RCard *card, xmlNodePtr node);
void r_write_net       (RCard *card, xmlNodePtr node);
void r_write_telephone (RCard *card, xmlNodePtr node);

void r_write_contact   (RPersonalCard *card, xmlNodePtr node);
void r_write_work      (RPersonalCard *card, xmlNodePtr node);
void r_write_notes     (RPersonalCard *card, xmlNodePtr node);

void r_write_company   (RCompanyCard *card, xmlNodePtr node);

#endif
