/*
*  RAL -- Rubrica Addressbook Library
*  file: csv.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_CSV_THUNDERBIRD_H
#define _R_CSV_THUNDERBIRD_H

#include <stdio.h>
#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>

#include "abook.h"
#include "csv_engine.h"
#include "error.h"
#include "plugin.h"


#define R_CSV_THUNDERBIRD_TYPE          (r_csv_thunderbird_get_type())

#define R_CSV_THUNDERBIRD(obj)          (G_TYPE_CHECK_INSTANCE_CAST((obj), \
                                         R_CSV_THUNDERBIRD_TYPE,           \
                                         RCsvThunderbird))

#define R_CSV_THUNDERBIRD_CLASS(kls)    (G_TYPE_CHECK_CLASS_CAST((kls),    \
                                         R_CSV_THUNDERBIRD_TYPE,           \
                                         RCsvThunderbirdClass))

#define IS_R_CSV_THUNDERBIRD(obj)       (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
                                         R_CSV_THUNDERBIRD_TYPE))

#define IS_R_CSV_THUNDERBIRD_CLASS(kls) (G_TYPE_CHECK_CLASS_TYPE((kls),    \
                                         R_CSV_THUNDERBIRD_TYPE))

#define R_CSV_THUNDERBIRD_GET_CLASS(o)  (G_TYPE_CHECK_INSTANCE_GET_CLASS((o), \
                                         R_CSV_THUNDERBIRD_TYPE,              \
                                         RCsvThunderbirdClass))


typedef struct _RCsvThunderbird          RCsvThunderbird;
typedef struct _RCsvThunderbirdClass     RCsvThunderbirdClass;
typedef struct _RCsvThunderbirdPrivate   RCsvThunderbirdPrivate;


struct _RCsvThunderbird 
{
  RCsvEngine parent;

  /* private */
  RCsvThunderbirdPrivate* priv;
};


struct _RCsvThunderbirdClass
{
  RCsvEngineClass parent;
};


GType r_csv_thunderbird_get_type   (void);


G_MODULE_EXPORT void plugin_init (RPlugin* plugin, gchar* file);
G_MODULE_EXPORT void plugin_fini (void);


#endif  /* _R_CSV_THUNDERBIRD_H */ 
