/*
*  Rubrica
*  file: vcard.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_VCARD_H
#define _R_VCARD_H

#include <stdio.h>
#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>

#include <libral.h>


#define R_VCARD_TYPE            (r_vcard_get_type())
#define R_VCARD(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),      \
                                 R_VCARD_TYPE, RVCard))
#define R_VCARD_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),       \
                                 R_VCARD_TYPE, RVCardClass))
#define IS_R_VCARD(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),      \
                                 R_VCARD_TYPE))
#define IS_R_VCARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),       \
                                 R_VCARD_TYPE))
#define R_VCARD_GET_CLASS(obj)  (G_TYPE_CHECK_INSTANCE_GET_CLASS((obj), \
                                 R_VCARD_TYPE, RVCardClass))


typedef struct _RVCard          RVCard;
typedef struct _RVCardClass     RVCardClass;
typedef struct _RVCardPrivate   RVCardPrivate;

#undef VERSION


/* error code returned by r_vcard_open_file 
*/
enum {
  R_VCARD_FILE_OPEN_SUCCESS,
  R_VCARD_FILE_OPEN_FAIL,
  R_VCARD_FILE_IMPORT_SUCCESS
};


typedef enum {
  EVOLUTION_EXT = 0,
  KADDRBOOK_EXT,
  R_EXT,
  VCARD_EXT,
  BAD_EXT
} RVCardExt;


/*
   fn;              FN 
   n;               N => family name 
   gn;              N => given name 
   an;              N => additional names 
   hp;              N => honorific prefix 
   hs;              N => honorific suffix 
   nick;            nickname 
   photo;           photo (uri or inline binary) - todo 
   bday;            birthday 
   label;           label (postal address) 
   title;           job title or functional position 
   role;            role, occupation or business category 
   org;             organization 
   note;            
   class;           
   key;             public key 

   pbox;            post offix box    
   extadd;          extended address 
   str;             street address   
   loc;             locality (city)  
   reg;             region (state/province) 
   code;            postal code  
   count;           country name
   type;            address type 
  
   num;
   type;

  GList* email;            
  GList* url;             
  GList* adr;       address (RVCardAddress list) 
  GList* tel;       telephone (RVCardTelephone list)
  GList* cat;       categories (groups list) 
 */




struct _RVCard 
{
  GObject parent;
  
  gchar* filename;
  RAbook* book;

  /* private */
  RVCardPrivate* priv;
};


struct _RVCardClass
{
  GObjectClass parent;

  /* signals */
  void (*addressbook_saved)  (RVCard* self);
};





GType         r_vcard_get_type   (void);


/* ************ Public ************
 */


G_MODULE_EXPORT void plugin_init (RPlugin* plugin, gchar* file);
G_MODULE_EXPORT void plugin_fini (void);


/*
RVCard*  r_vcard_new  (gchar* filename); 
void     r_vcard_free (RVCard *vcard); 

void     r_vcard_load (RVCard *vcard); // load a vcard file and return a RAbook

gboolean r_vcard_save (RVCard* vcard);
*/
//void    r_vcard_save (RVCard *vcard); // get a RAbook and write a vcard file

#endif
