
%define rel   1

Name:      rubrica2
Summary:   Rubrica, an address book for Gnome Environment.
Version:   2.1.6
Release:   %rel
License:   GPL
Group:     Applications/Productivity
Source:    http://download.berlios.de/rubrica/%{name}-%{version}.tar.bz2
URL:       http://rubrica.berlios.de
Vendor:    Nicola Fragale <nicolafragale@gmail.com>
Packager:  Nicola Fragale <nicolafragale@gmail.com>

BuildRoot: %{_tmppath}/root-%{name}-%{version}
Prefix:    %{_prefix}
Requires:   gtk2 >= 2.6, libglade2, libxml2
BuildRequires: gtk2-devel >= 2.6, libglade2-devel, libxml2-devel


%description
An address book for GNOME Environment. 

%package devel
Summary: Address book engine
Version: 2.1.6
Release: 1
License: GPL
Group: Development/Libraries
URL: http://libral.berlios.de
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

BuildRequires: libxml2-devel, pkgconfig
BuildRequires: glib2-devel

%description devel
Libral is an address book engine, developed for the addressbook rubrica. 
It allows you to create your address books and to add personal and company 
cards to them. Data managed in a personal card include personal data 
(name, surname, address, etc.), Web links, email addresses, irc uris,
 telephone numbers, job information (company where the contact works,
 manager, collaborator, etc.), and notes. In a company card you can manage 
Web links, email addresses, telephone numbers, and notes. 
XML is used to store data. Libral can import addressbooks from GnomeCard, 
Kaddressbook, VCard, Evolution, and CSV.
This package contains the header files, static libraries and development
documentation for %{name}.




%prep
%setup

%build
%configure \
	--disable-install-schemas \
	--enable-nls
%{__make} %{?_smp_mflags}

%install
%{__rm} -rf %{buildroot}
export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL="1"
%makeinstall
%find_lang %{name}
%{__rm} -rf %{buildroot}%{_docdir}/rubrica2


%post
export GCONF_CONFIG_SOURCE="$(gconftool-2 --get-default-source)"
gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/%{name}.schemas &>/dev/null
scrollkeeper-update -q

%postun
scrollkeeper-update -q


%post devel
/sbin/ldconfig 2>/dev/null

%postun devel
/sbin/ldconfig 2>/dev/null


%clean
%{__rm} -rf %{buildroot}


%files -f %{name}.lang 
%defattr(-, root, root, 0755)
%doc README ChangeLog COPYING AUTHORS NEWS TODO CREDITS
%config %{_sysconfdir}/gconf/schemas/*.schemas
%{_bindir}/*
%{_libdir}/libral.*
%{_libdir}/libral/plugins/*
%{_datadir}/rubrica2/interface/
%{_datadir}/pixmaps/rubrica2/*
%{_datadir}/applications/*.desktop
%{_datadir}/mime-info/*
%exclude %{_libdir}/*.a
%exclude %{_libdir}/*.la
%exclude %{_libdir}/libral/plugins/*.?a
%exclude %{_libdir}/libral/plugins/*.la


%files devel
%defattr(-, root, root, 0755)
%{_includedir}/libral-1.0/
%{_libdir}/libral.a
%{_libdir}/libral.so
%exclude %{_libdir}/*.la
%{_libdir}/pkgconfig/libral.pc
%{_datadir}/gtk-doc/html/libRAL/
