/*
*  Rubrica
*  file: browse.c
*
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*    routine per la nagivazione delle schede inserite
*/
#include <gtk/gtk.h>

#include "libral.h"

#include "browse.h"
#include "app.h"
#include "view.h"
#include "cards_view.h"
#include "data_view.h"
#include "types.h"


void rubrica_browse_first_card(RubricaApp* app)
{ 
  RAbook* book;
  GtkWidget* card_view;
  GtkTreeView *view;
  GtkTreeModel *model;
  GtkTreeIter iter;
  GtkTreePath *path;
  GtkTreeSelection *select;
  gpointer card;
  glong id;
  
  book      = rubrica_app_get_active_addressbook(app);
  card_view = rubrica_app_get_current_view(app);
  view      = GTK_TREE_VIEW(rubrica_view_get_tree(RUBRICA_VIEW(card_view)));
  model     = gtk_tree_view_get_model(GTK_TREE_VIEW(view));
  select    = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));

  if (gtk_tree_model_get_iter_first(GTK_TREE_MODEL(model), &iter))
    {
      path  = gtk_tree_model_get_path(model, &iter);
      
      gtk_tree_selection_select_iter(select, &iter);
      gtk_tree_view_scroll_to_cell(view, path, NULL, FALSE, 0.5, 0.0);   
      
      gtk_tree_model_get(model, &iter, ID_COLUMN, &id, -1);
      card = r_abook_get_card_by_id(R_ABOOK(book), id);
      
      rubrica_app_display_card_data(RUBRICA_APP(app), card);

      gtk_tree_path_free(path);      
      
      /* enable/disable navigation buttons */
      rubrica_app_enable_previouses(app, FALSE);
      rubrica_app_enable_nexts(app, TRUE);
    }
}


void rubrica_browse_last_card(RubricaApp* app)

{
  RAbook* book;
  GtkTreeModel *model;
  GtkTreeIter iter;
  GtkTreePath *path;
  GtkWidget* card_view;
  GtkTreeView *view;
  GtkTreeSelection *select;
  gpointer card;
  glong id;
  gint n; 

  book      = rubrica_app_get_active_addressbook(app);
  card_view = rubrica_app_get_current_view(app);
  view      = GTK_TREE_VIEW(rubrica_view_get_tree(RUBRICA_VIEW(card_view)));
  model     = gtk_tree_view_get_model(GTK_TREE_VIEW(view));
  select    = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));

  n = gtk_tree_model_iter_n_children(model, NULL);
  if (gtk_tree_model_iter_nth_child(model, &iter, NULL, n-1))
    {
      path = gtk_tree_model_get_path(model, &iter);
      
      gtk_tree_selection_select_iter(select, &iter);
      gtk_tree_view_scroll_to_cell(view, path, NULL, FALSE, 0.5, 0.0);  
      
      gtk_tree_model_get(model, &iter, ID_COLUMN, &id, -1);
      card = r_abook_get_card_by_id(R_ABOOK(book), id);
      
      rubrica_app_display_card_data (RUBRICA_APP(app), card);
      
      gtk_tree_path_free(path); 
      
      /* enable/disable navigation buttons */
      rubrica_app_enable_nexts(app, FALSE);
      rubrica_app_enable_previouses(app, TRUE);    
    }
}


void rubrica_browse_next_card(RubricaApp* app)
{
  RAbook* book;
  GtkTreeModel *model;
  GtkTreeIter iter;
  GtkWidget* card_view;
  GtkTreeView *view;
  GtkTreePath *path;
  GtkTreeSelection *select;
  gpointer card;
  glong id;

  book      = rubrica_app_get_active_addressbook(app);
  card_view = rubrica_app_get_current_view(app);
  view      = GTK_TREE_VIEW(rubrica_view_get_tree(RUBRICA_VIEW(card_view)));
  model     = gtk_tree_view_get_model(GTK_TREE_VIEW(view));
  select    = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));

  if (gtk_tree_selection_get_selected(select, NULL, &iter))
    {
      path = gtk_tree_model_get_path(model, &iter);

      gtk_tree_path_next(path);
      
      gtk_tree_selection_select_path(select, path);
      gtk_tree_view_scroll_to_cell(view, path, NULL, FALSE, 0.5, 0.0);
      if (gtk_tree_model_get_iter(model, &iter, path))
	{      
	  
	  gtk_tree_model_get(model, &iter, ID_COLUMN, &id, -1);
	  card = r_abook_get_card_by_id(R_ABOOK(book), id);
	  
	  rubrica_app_display_card_data(RUBRICA_APP(app), card); 
	  
	  /* check next/previous cards */
	  rubrica_app_enable_previouses(app, TRUE);
	  if (gtk_tree_model_iter_next(model, &iter))
	    rubrica_app_enable_nexts(app, TRUE);
	  else
	    rubrica_app_enable_nexts(app, FALSE);
	}
      
      gtk_tree_path_free(path);      
    }
}


void rubrica_browse_previous_card(RubricaApp* app)
{
  RAbook* book;
  GtkTreeModel *model;
  GtkTreeIter iter;
  GtkWidget* card_view;
  GtkTreeView *view;
  GtkTreePath *path;
  GtkTreeSelection *select;
  gpointer card;
  glong id;

  book      = rubrica_app_get_active_addressbook(app);
  card_view = rubrica_app_get_current_view(app);
  view      = GTK_TREE_VIEW(rubrica_view_get_tree(RUBRICA_VIEW(card_view)));
  model     = gtk_tree_view_get_model(GTK_TREE_VIEW(view));
  select    = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));

  if (gtk_tree_selection_get_selected(select, NULL, &iter))
    {
      path = gtk_tree_model_get_path(model, &iter);
      
      gtk_tree_path_prev(path);
      
      gtk_tree_selection_select_path(select, path);
      gtk_tree_view_scroll_to_cell(view, path, NULL, TRUE, 0.5, 0.0);
      if (gtk_tree_model_get_iter(model, &iter, path))
	{
	  rubrica_app_enable_nexts(app, TRUE);
	  rubrica_app_enable_previouses(app, TRUE);
	  
	  gtk_tree_model_get(model, &iter, ID_COLUMN, &id, -1);
	  card = r_abook_get_card_by_id(R_ABOOK(book), id);
	  
	  rubrica_app_display_card_data(RUBRICA_APP(app), card);
	  
	  /* check next/previous cards */
	  rubrica_app_enable_nexts(app, TRUE);
	  if (gtk_tree_path_prev(path))
	    rubrica_app_enable_previouses(app, TRUE);	  
	  else
	    rubrica_app_enable_previouses(app, FALSE);
	}
      
      gtk_tree_path_free(path);
    }
}


void rubrica_browse_nth_card(RubricaApp* app, gchar *path_str, gboolean show)
{  
  RAbook* book;
  GtkWidget* card_view;
  GtkTreeModel *model;
  GtkTreeIter iter;
  GtkTreeView *view;
  GtkTreeSelection *select;
  GtkTreePath *path;
  gpointer card;
  glong id;
 
  book      = rubrica_app_get_active_addressbook(app);
  card_view = rubrica_app_get_current_view(app);
  view      = GTK_TREE_VIEW(rubrica_view_get_tree(RUBRICA_VIEW(card_view)));
  model     = gtk_tree_view_get_model(GTK_TREE_VIEW(view));
  select    = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
  path      = gtk_tree_path_new_from_string(path_str);

  gtk_tree_selection_unselect_all(select);
  gtk_tree_selection_select_path(select, path);      
  gtk_tree_view_scroll_to_cell(view, path, NULL, TRUE, 0.5, 0.0);
  if (show && gtk_tree_model_get_iter(model, &iter, path))
    {
      gtk_tree_model_get(model, &iter, ID_COLUMN, &id, -1);
      
      card = r_abook_get_card_by_id(R_ABOOK(book), id);
      rubrica_app_display_card_data(RUBRICA_APP(app), card);
    }

  gtk_tree_path_free(path);
}


