/* 
*  Copyright (C) Nicola Fragale <nicolafragale@gmail.com> 
*
*  This program is free software; you can redistribute it and/or modify 
*  it under the terms of the GNU General Public License as published by 
*  the Free Software Foundation; either version 3 of the License, or 
*  (at your option) any later version. 
*
*  This program is distributed in the hope that it will be useful, 
*  but WITHOUT ANY WARRANTY; without even the implied warranty of 
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
*  GNU General Public License for more details. 
*
*  You should have received a copy of the GNU General Public License 
*  along with this program; if not, write to the Free Software 
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
*/ 

#ifndef _CARDS_VIEW_H__
#define _CARDS_VIEW_H__


#include <gtk/gtk.h>

#include "libral.h"
#include "view.h"


G_BEGIN_DECLS


#define RUBRICA_CARDS_VIEW_TYPE             (rubrica_cards_view_get_type())

#define RUBRICA_CARDS_VIEW(obj)             (G_TYPE_CHECK_INSTANCE_CAST((obj),\
                                             RUBRICA_CARDS_VIEW_TYPE,         \
                                             RubricaCardsView))

#define RUBRICA_CARDS_VIEW_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST((klass), \
                                             RUBRICA_CARDS_VIEW_TYPE,         \
                                             RubricaCardsViewClass))

#define IS_RUBRICA_CARDS_VIEW(obj)          (G_TYPE_CHECK_INSTANCE_TYPE((obj),\
                                             RUBRICA_CARDS_VIEW_TYPE))

#define IS_RUBRICA_CARDS_VIEW_CLASS(klass)  (G_TYPE_INSTANCE_GET_CLASS((kls), \
                                             RUBRICA_CARDS_VIEW_TYPE))

#define RUBRICA_CARDS_VIEW_GET_CLASS(klass) (G_TYPE_INSTANCE_GET_CLASS(klass),\
                                             RUBRICA_CARDS_VIEW_TYPE,         \
                                             RubricaCardsViewClass)


typedef struct _RubricaCardsView        RubricaCardsView;
typedef struct _RubricaCardsViewClass   RubricaCardsViewClass;
typedef struct _RubricaCardsViewPrivate RubricaCardsViewPrivate;


typedef enum {
  CARD_MARKED,
  CARD_UNMARKED,
  CARD_MARKED_PRINT,
  CARD_UNMARKED_PRINT,
} RubricaCardsViewMark;


struct _RubricaCardsView 
{
  RubricaView parent;
  
  RubricaCardsViewPrivate* priv;
};


struct _RubricaCardsViewClass
{
  RubricaViewClass parent_class;  

  /* Signals */
  void (*mark)   (RubricaCardsView* view, glong card_id,
		  RubricaCardsViewMark mark);
};




GType      rubrica_cards_view_get_type (void);

 
GtkWidget* rubrica_cards_view_new                  (gchar* file);

RAbook*    rubrica_cards_view_get_addressbook      (RubricaCardsView* view);
gchar*     rubrica_cards_view_get_addressbook_name (RubricaCardsView* view);

void       rubrica_cards_view_add_card             (RubricaCardsView* view,
						    RCard* card);
void       rubrica_cards_view_delete_card          (RubricaCardsView* view,
						    RCard* card);
void       rubrica_cards_view_modify_card          (RubricaCardsView* view,
						    RCard* card);

void       rubrica_cards_view_display_results      (RubricaCardsView* view, 
						    GList* list);
void       rubrica_cards_view_update_infos         (RubricaCardsView* view);
GList*     rubrica_cards_view_get_selected_cards   (RubricaCardsView* view);

void       rubrica_cards_view_mark_card            (RubricaCardsView* view);
void       rubrica_cards_view_mark_all             (RubricaCardsView* view);
 

G_END_DECLS

#endif
