/*
*  Rubrica
*  file: personal-form.c
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include <gtk/gtk.h>
#include <glade/glade.h>

#include "libral.h"

#include "app.h"
#include "form.h"
#include "company_gui.h"
#include "groups_cb.h"
#include "models.h"
#include "types.h"
#include "utils.h"



/* Public
 */
CompanyDialog* 
rubrica_company_dialog_new (RubricaApp* app)
{
  CompanyDialog *form = NULL;
  GladeXML      *gui;  

  gui = glade_xml_new (RUBRICA_GUI_DIR"/CompanyCard.glade", NULL, NULL);
  if (!gui)
    g_error("Can't load gui");
  
  form = (CompanyDialog*) g_malloc0(sizeof(CompanyDialog));  
  if (!form)
    g_error("out of memory");
  
  form->app     = app;  
  form->dialog  = glade_xml_get_widget(gui, "CompanyForm");
  form->card    = rubrica_form_card_new(app, gui);
  form->info    = rubrica_form_info_new(app, gui);
  form->address = rubrica_form_address_new(app, gui);
  form->net     = rubrica_form_net_new (app, gui,  FORM_NET_COMPANY);
  form->tel     = rubrica_form_phone_new(app, gui, FORM_PHONE_COMPANY);
  form->notes   = glade_xml_get_widget(gui, "company_notes");
  
  g_object_unref(gui);

  return form;
}



void 
rubrica_company_run_add_dialog (CompanyDialog* form)
{
  RubricaApp *app;
  RAbook *book;
  RCompanyCard *card = NULL;
  gint response;
  
  app  = form->app;
  book = rubrica_app_get_active_addressbook(app);

  response = gtk_dialog_run(GTK_DIALOG(form->dialog));
  switch (response)
    {
    case GTK_RESPONSE_OK:
      card = rubrica_company_extract_card_data(form);

      if (card)
	r_abook_add_card(R_ABOOK(book), R_CARD(card));	  
      break;
      
    case GTK_RESPONSE_CANCEL:
      break;
      
    default:
      break;
    }
  
  gtk_widget_hide(form->dialog);
  g_free(form);
}


RCompanyCard* 
rubrica_company_run_modify_dialog(CompanyDialog* form)
{
  RCompanyCard* card = NULL;
  gint response;  

  response = gtk_dialog_run(GTK_DIALOG(form->dialog));
  switch (response)
    {
    case GTK_RESPONSE_OK:
      card = rubrica_company_extract_card_data(form);
      break;
      
    case GTK_RESPONSE_CANCEL:
      break;
      
    default:
      break;
    }
  
  gtk_widget_hide(form->dialog);
  g_free(form);

  return (RCompanyCard*) card;
}



RCompanyCard*
rubrica_company_extract_card_data(CompanyDialog* form)
{
  RCompanyCard *card;
  GtkTextIter start, end;
  GtkTextBuffer *buffer;
  gchar* text;

  card = r_company_card_new();
  
  g_print("\n get company card data");
  rubrica_form_extract_data (RUBRICA_FORM(form->card),    R_CARD(card));
  rubrica_form_extract_data (RUBRICA_FORM(form->info),    R_CARD(card));
  rubrica_form_extract_data (RUBRICA_FORM(form->address), R_CARD(card));
  rubrica_form_extract_data (RUBRICA_FORM(form->net),     R_CARD(card));
  rubrica_form_extract_data (RUBRICA_FORM(form->tel),     R_CARD(card));

  g_print("\nget notes (text buffer)");
  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW (form->notes));  
  gtk_text_buffer_get_bounds (buffer, &start, &end);
  text = gtk_text_buffer_get_text(buffer, &start, &end, FALSE);

  g_object_set(card, "company-notes", text, NULL);

  return card;
}


void
rubrica_company_display_card_data(CompanyDialog* form, RCard* card)
{
  GtkTextIter start, end;
  GtkTextBuffer *buffer;
  gchar* text;

  g_return_if_fail(IS_R_CARD(card));

  rubrica_form_display_data (RUBRICA_FORM(form->card),    card);
  rubrica_form_display_data (RUBRICA_FORM(form->info),    card);
  rubrica_form_display_data (RUBRICA_FORM(form->address), card);
  rubrica_form_display_data (RUBRICA_FORM(form->net),     card);
  rubrica_form_display_data (RUBRICA_FORM(form->tel),     card);
  
  g_object_get(card, "notes", &text, NULL);
  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW (form->notes));  
  gtk_text_buffer_get_bounds (buffer, &start, &end);
  gtk_text_buffer_delete(buffer, &start, &end);
  gtk_text_buffer_get_iter_at_offset(buffer, &start, 0);  
  gtk_text_buffer_insert (buffer, &start, text, -1);
}

