/* 
*  Rubrica
*  file: filechooser_extra.h
*
*  Copyright (C) Nicola Fragale <nicolafragale@gmail.com> 
*
*  This program is free software; you can redistribute it and/or modify 
*  it under the terms of the GNU General Public License as published by 
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful, 
*  but WITHOUT ANY WARRANTY; without even the implied warranty of 
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
*  GNU General Public License for more details. 
*
*  You should have received a copy of the GNU General Public License 
*  along with this program; if not, write to the Free Software 
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
*/ 

#ifndef _CHOOSER_EXTRA_H__
#define _CHOOSER_EXTRA_H__


#include <gtk/gtk.h>
#include "app.h"


#define RUBRICA_CHOOSER_EXTRA_TYPE  (rubrica_chooser_extra_get_type())

#define RUBRICA_CHOOSER_EXTRA(o)         (G_TYPE_CHECK_INSTANCE_CAST((o), \
                                          RUBRICA_CHOOSER_EXTRA_TYPE, \
                                          RubricaChooserExtra))

#define RUBRICA_CHOOSER_EXTRA_CLASS(kls) (G_TYPE_CHECK_CLASS_CAST((kls),  \
                                          RUBRICA_CHOOSER_EXTRA_TYPE, \
                                          RubricaChooserExtraClass))

#define IS_RUBRICA_CHOOSER_EXTRA(o)          (G_TYPE_CHECK_INSTANCE_TYPE((o), \
                                              RUBRICA_CHOOSER_EXTRA_TYPE))

#define IS_RUBRICA_CHOOSER_EXTRA_CLASS(kls)  (G_TYPE_INSTANCE_GET_CLASS((kls),\
                                              RUBRICA_CHOOSER_EXTRA_TYPE))

#define RUBRICA_CHOOSER_EXTRA_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS(kls), \
                                              RUBRICA_CHOOSER_EXTRA_TYPE,     \
                                              RubricaChooserExtraClass)


typedef struct _RubricaChooserExtra        RubricaChooserExtra;
typedef struct _RubricaChooserExtraClass   RubricaChooserExtraClass;
typedef struct _RubricaChooserExtraPrivate RubricaChooserExtraPrivate;


struct _RubricaChooserExtra 
{
  GtkVBox parent;
  
  RubricaChooserExtraPrivate* priv;
};


struct _RubricaChooserExtraClass
{
  GtkVBoxClass parent_class;  
};


typedef enum {
  RUBRICA_CHOOSER_OPEN_FILE,
  RUBRICA_CHOOSER_SAVE_FILE,
  RUBRICA_CHOOSER_UNKNOW,
} RubricaChooserFlag;


GType      rubrica_chooser_extra_get_type      (void);


GtkWidget* rubrica_chooser_extra_new           (RubricaApp* app, 
					        RubricaChooserFlag flag);
void       rubrica_chooser_extra_free          (RubricaChooserExtra* extra);

void       rubrica_chooser_extra_enable_plugin (RubricaChooserExtra* extra, 
						gchar* plugin);

#endif



