/*
*  Program: Rubrica
*  file: form_info.h
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef _RUBRICA_FORM_INFO_H
#define _RUBRICA_FORM_INFO_H


#include <glib.h>
#include <glib-object.h>
#include <glade/glade.h>

#include "app.h"
#include "form.h"


#define RUBRICA_FORM_INFO_TYPE           (rubrica_form_info_get_type())

#define RUBRICA_FORM_INFO(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj), \
                                          RUBRICA_FORM_INFO_TYPE,           \
                                          RubricaFormInfo))

#define RUBRICA_FORM_INFO_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST((klass),  \
                                          RUBRICA_FORM_INFO_TYPE,           \
                                          RubricaFormInfoClass))

#define IS_RUBRICA_FORM_INFO(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
                                          RUBRICA_FORM_INFO_TYPE))

#define IS_RUBRICA_FORM_INFO_CLASS(kls)  (G_TYPE_CHECK_CLASS_TYPE((kls),    \
                                          RUBRICA_FORM_INFO_TYPE))

#define RUBRICA_FORM_INFO_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS((kls),  \
			                  RUBRICA_FORM_INFO_TYPE,           \
                                          RubricaFormInfoClass))



typedef struct _RubricaFormInfo        RubricaFormInfo; 
typedef struct _RubricaFormInfoClass   RubricaFormInfoClass;
typedef struct _RubricaFormInfoPrivate RubricaFormInfoPrivate;


struct _RubricaFormInfo {
  RubricaForm parent;
   
  RubricaFormInfoPrivate* priv;  
};



struct _RubricaFormInfoClass {
   RubricaFormClass parent;
};


GType            rubrica_form_info_get_type (void);


RubricaFormInfo* rubrica_form_info_new  (RubricaApp* app, GladeXML *gui);
void             rubrica_form_info_free (RubricaFormInfo* form);

#endif
