/*
*  program: Rubrica
*  file: form_work.h
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef _RUBRICA_FORM_WORK_H
#define _RUBRICA_FORM_WORK_H

#include <glib.h>
#include <glib-object.h>
#include <glade/glade.h>

#include "app.h"
#include "form.h"


#define RUBRICA_FORM_WORK_TYPE           (rubrica_form_work_get_type())

#define RUBRICA_FORM_WORK(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj), \
                                          RUBRICA_FORM_WORK_TYPE,           \
                                          RubricaFormWork))

#define RUBRICA_FORM_WORK_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST((klass),  \
                                          RUBRICA_FORM_WORK_TYPE,           \
                                          RubricaFormWorkClass))

#define IS_RUBRICA_FORM_WORK(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
                                          RUBRICA_FORM_WORK_TYPE))

#define IS_RUBRICA_FORM_WORK_CLASS(kls)  (G_TYPE_CHECK_CLASS_TYPE((kls),    \
                                          RUBRICA_FORM_WORK_TYPE))

#define RUBRICA_FORM_WORK_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS((kls),  \
			                  RUBRICA_FORM_WORK_TYPE,           \
                                          RubricaFormWorkClass))



typedef struct _RubricaFormWork        RubricaFormWork; 
typedef struct _RubricaFormWorkClass   RubricaFormWorkClass;
typedef struct _RubricaFormWorkPrivate RubricaFormWorkPrivate;



struct _RubricaFormWork {
  RubricaForm parent;
   
  RubricaFormWorkPrivate* priv;  
};



struct _RubricaFormWorkClass {
   RubricaFormClass parent;
};



GType            rubrica_form_work_get_type (void);


RubricaFormWork* rubrica_form_work_new      (RubricaApp* app, GladeXML *gui);
void             rubrica_form_work_free     (RubricaFormWork* form);

#endif

