/* 
*  program: Rubrica
*  file: groups_view.h
*
*  Copyright (C) Nicola Fragale <nicolafragale@gmail.com> 
*
*  This program is free software; you can redistribute it and/or modify 
*  it under the terms of the GNU General Public License as published by 
*  the Free Software Foundation; version 3 of the License
*
*  This program is distributed in the hope that it will be useful, 
*  but WITHOUT ANY WARRANTY; without even the implied warranty of 
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
*  GNU General Public License for more details. 
*
*  You should have received a copy of the GNU General Public License 
*  along with this program; if not, write to the Free Software 
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
*/ 

#include <gtk/gtk.h>
#include <libral.h>

#include "view.h"

#ifndef _GROUPS_VIEW_H__
#define _GROUPS_VIEW_H__



G_BEGIN_DECLS


#define RUBRICA_GROUPS_VIEW_TYPE           (rubrica_groups_view_get_type())

#define RUBRICA_GROUPS_VIEW(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj), \
                                            RUBRICA_GROUPS_VIEW_TYPE,         \
                                            RubricaGroupsView))

#define RUBRICA_GROUPS_VIEW_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST((klass),  \
                                            RUBRICA_GROUPS_VIEW_TYPE,         \
                                            RubricaGroupsViewClass))

#define IS_RUBRICA_GROUPS_VIEW(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
                                            RUBRICA_GROUPS_VIEW_TYPE))

#define IS_RUBRICA_GROUPS_VIEW_CLASS(kls)  (G_TYPE_INSTANCE_GET_CLASS((kls),  \
                                            RUBRICA_GROUPS_VIEW_TYPE))

#define RUBRICA_GROUPS_VIEW_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS(kls),  \
                                            RUBRICA_GROUPS_VIEW_TYPE,        \
                                            RubricaGroupsViewClass)


typedef struct _RubricaGroupsView        RubricaGroupsView;
typedef struct _RubricaGroupsViewClass   RubricaGroupsViewClass;
typedef struct _RubricaGroupsViewPrivate RubricaGroupsViewPrivate;



typedef enum {
  APP_GROUPS,
  FORM_GROUPS
} RubricaGroupViewType;

struct _RubricaGroupsView 
{
  RubricaView parent;
  
  RubricaGroupsViewPrivate* priv;
};


struct _RubricaGroupsViewClass
{
  RubricaViewClass parent_class;  
};




GType      rubrica_groups_view_get_type (void);
 
GtkWidget* rubrica_groups_view_new           (RGroupBox *box, 
					      RubricaGroupViewType type);
  
void       rubrica_groups_view_add_group     (RubricaGroupsView* view, 
					      RGroup* group);
void       rubrica_groups_view_del_group     (RubricaGroupsView* view, 
					      RGroup* group);

RGroupBox* rubrica_groups_view_get_group_box (RubricaGroupsView* view);


G_END_DECLS

#endif
