/*
 *  Program: rubrica
 *  file: main.c
 *  
 *  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 3 of the License
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include "libral.h"

#include <libnotify/notify.h>
#include <libnotify/notification.h>

#include "app.h"
#include "types.h"
#include "utils.h"
#include "callbacks.h"
#include "preferences.h"
#include "themes.h"

void rubrica_init(void);

gchar* rubfile   = NULL;
gchar* csvfile   = NULL;
gchar* vcardfile = NULL;


GOptionEntry options[] = {
  {"rub", 'r', 0, G_OPTION_ARG_FILENAME, &rubfile, 
   "Open a rubrica's file", NULL},
  {"csv", 'c', 0, G_OPTION_ARG_FILENAME, &csvfile, 
   "Open a csv file", NULL}, 
  {"vcard", 'v', 0, G_OPTION_ARG_FILENAME, &vcardfile, 
   "Open a vcard file", NULL}, 
  {NULL}
};

GOptionContext* ctx;


void 
rubrica_open_addressbooks(RubricaApp* app, gchar *argv[])
{
  if (rubfile)
    {
      rubrica_app_set_plugin_name(app, "rubrica");
      rubrica_app_load_file(app, rubfile);
    }
      
  if (csvfile)
    {
      rubrica_app_set_plugin_name(app, "csv");
      rubrica_app_load_file(app, csvfile);
    }

  if (vcardfile)
    {
      rubrica_app_set_plugin_name(app, "vcard");
      rubrica_app_load_file(app, vcardfile);   
    }

  ++argv;
  for (; *argv; argv++)
    {
      rubrica_app_set_plugin_name(app, "autodetect");
      rubrica_app_load_file(app, *argv);
    }
}


void rubrica_init(void)
{
  bindtextdomain (GETTEXT_PACKAGE, RUBRICA_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  g_set_application_name ("Rubrica");
  gtk_window_set_default_icon_name ("rubrica");

  rubrica_themes_add_directory(RUBRICA_ICONS_DIR"/16x16");
  rubrica_themes_add_directory(RUBRICA_ICONS_DIR"/22x22");
  rubrica_themes_add_directory(RUBRICA_ICONS_DIR"/24x24");
  rubrica_themes_add_directory(RUBRICA_ICONS_DIR"/48x48");
  rubrica_themes_add_directory(RUBRICA_ICONS_DIR"/scalable");
}



int 
main (int argc, char *argv[])
{ 
  GOptionContext* context;
  RubricaApp* app = NULL;
  GError *error = NULL;

  context = g_option_context_new ("Rubrica");
  g_option_context_add_main_entries (context, options, GETTEXT_PACKAGE);
  g_option_context_parse (context, &argc, &argv, &error);
  g_option_context_free(context);

  g_thread_init(NULL);
  gtk_init(&argc, &argv);
  if (!notify_init("Rubrica"))
    {
      g_warning("\nCan't initialize libnotify");
    }
  
  g_print("\n\nRubrica ***");
  g_print("\nRubrica *** Rubrica is copyright by Nicola Fragale "
	  "<nicolafragale@gmail.com>");
  g_print("\nRubrica *** This program is free software, released under");
  g_print("\nRubrica *** the term of GNU GPL version 3");
  g_print("\nRubrica *** See file Copying for more information.");
  g_print("\nRubrica ***");
  
  g_print("\n\nRubrica ***");
  g_print("\nRubrica *** Version: %s - %s", RUBRICA_VERSION, PACKAGE_STATUS); 
  g_print("\nRubrica *** Home page: http://rubrica.berlios.de");  

  g_print("\nRubrica *** Please notify me for all bugs that you'll find."); 

  g_print("\nRubrica *** For suggestions, patches, localizations,"
	  " bugs, other...");
  g_print("\nRubrica *** write me: nicolafragale@gmail.com");
  g_print("\nRubrica ***");

  g_print("\n\nRubrica ***");
  g_print("\nRubrica *** rubrica needs localization, please help me");
  g_print("\nRubrica ***");
  g_print("\n\n"); 

  r_lib_init();
  rubrica_init();

  app = rubrica_app_new();

  rubrica_open_addressbooks(app, argv);

  rubrica_app_run(app);
  gtk_main();

  g_print("\n");
  return 0;
}
