/*
*  program: Rubrica
*  file: models.c
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include "libral.h"

#include "models.h"
#include "preferences.h"
#include "themes.h"
#include "types.h"


GtkTreeModel* 
rubrica_model_new(RubricaModelType type)
{
  GtkListStore *model = NULL;
  
  switch (type)
    {
      /* Address model */
    case ADDRESS_MODEL:
      model = gtk_list_store_new(LAST_ADDRESS_COLUMN, 
				 G_TYPE_STRING,        /* street        */
				 G_TYPE_STRING,        /* street number */
				 G_TYPE_STRING,        /* city          */
				 G_TYPE_STRING,        /* type label    */
				 G_TYPE_STRING,        /* address type  */
				 G_TYPE_STRING,        /* zip           */ 
				 G_TYPE_STRING,        /* province      */
				 G_TYPE_STRING,        /* state         */
				 G_TYPE_STRING);       /* country       */
      break;

      /* net model */
    case NET_MODEL:
      model = gtk_list_store_new(LAST_NET_COLUMN, 
				 G_TYPE_STRING,        /* url       */
				 G_TYPE_STRING);       /* url type  */
      break;

      /* telephone model */
    case TELEPHONE_MODEL:
      // type label is for localization
      model = gtk_list_store_new(LAST_TEL_COLUMN, 
				 G_TYPE_STRING,        /* telephone number */
				 G_TYPE_STRING,        /* type label       */
				 G_TYPE_STRING);       /* telephone type   */
      break;
      
    case INFO_MODEL:
      model = gtk_list_store_new(LAST_INFO_COLUMN,
				 G_TYPE_STRING,        // card label
				 G_TYPE_STRING,        // first name
				 G_TYPE_STRING,        // last name
				 G_TYPE_STRING,        // assignment
				 G_TYPE_STRING,        // telephone
				 G_TYPE_STRING,        // email
				 G_TYPE_INT);          // card id
      break;
      
    default:
      break;
    }

  return GTK_TREE_MODEL(model);
}

GtkTreeModel* 
rubrica_model_combo_new ()
{
  return (GtkTreeModel *) gtk_list_store_new(COMBO_LAST_COLUMN, 
			    GDK_TYPE_PIXBUF, G_TYPE_STRING);    
}



void 
rubrica_model_redisplay_groups_view(GtkTreeView* view, RGroupBox* box)
{
  GtkTreeModel* model;
  GtkTreeIter iter;  
  GtkIconTheme* theme;
  RGroup* group;
  
  theme = gtk_icon_theme_get_default(); 
  model = gtk_tree_view_get_model(view);
  gtk_list_store_clear (GTK_LIST_STORE(model));

  r_group_box_reset(box);
  group = r_group_box_get_group(box);
  for(; group; group = r_group_box_get_next_group(box))
    {
      gboolean enabled = FALSE;
      gchar* name   = NULL;
      gchar* label = NULL;
      gchar* owner = NULL;
      gchar* pixmap = NULL;
      GdkPixbuf* pixbuf;
      GError *error = NULL;
     
      g_object_get(group, 
		   "group-name", &name, "group-label", &label,		   
		   "group-owner", &owner, "group-pixmap", &pixmap, 
		   "enabled", &enabled, NULL);  

      pixbuf = gtk_icon_theme_load_icon (theme, pixmap, 20, 0, NULL);
      if (!pixbuf)
	pixbuf = gdk_pixbuf_new_from_file_at_size (pixmap, 20, 20, &error);

      if (!pixbuf)
	g_warning("\npixbuf: %s", error->message);

      gtk_list_store_append(GTK_LIST_STORE(model), &iter);
      gtk_list_store_set(GTK_LIST_STORE(model), &iter, 
			 GROUP_BELONG_COLUMN,   enabled, 
			 GROUP_PIXMAP_COLUMN,   pixbuf, 
			 GROUP_NAME_COLUMN,     name,
			 GROUP_LABEL_COLUMN,    label,
			 GROUP_OWNER_COLUMN,    owner,
			 GROUP_PIXMAP_PATH,     pixmap,
			 -1);
    }
}


void 
rubrica_model_add_columns(GtkTreeView *view, RubricaColumnsType type)
{
  GtkCellRenderer *renderer;
  GtkTreeModel *model;
  
  model = gtk_tree_view_get_model(GTK_TREE_VIEW(view));

  switch(type)
    {  
    case ADDRESS_COLUMNS:
      renderer = gtk_cell_renderer_text_new();
      gtk_tree_view_insert_column_with_attributes (view, /* tree view */
						   -1,  _("Street"),
						   renderer, "text",      
						   ADDRESS_STREET_COLUMN,  
						   NULL);

      renderer = gtk_cell_renderer_text_new();
      gtk_tree_view_insert_column_with_attributes (view, 
						   -1,  _("Number"),
						   renderer, "text",      
						   ADDRESS_NUMBER_COLUMN,  
						   NULL);

      renderer = gtk_cell_renderer_text_new();
      gtk_tree_view_insert_column_with_attributes (view, 
						   -1,  _("City"),
						   renderer, "text",      
						   ADDRESS_CITY_COLUMN,  
						   NULL);  

      renderer = gtk_cell_renderer_text_new();
      gtk_tree_view_insert_column_with_attributes (view, 
						   -1,  _("Address type"),
						   renderer, "text",      
						   ADDRESS_LABEL_COLUMN,  
						   NULL);       
      break;

    case URI_COLUMNS:
      renderer = gtk_cell_renderer_text_new();
      gtk_tree_view_insert_column_with_attributes (view, 
						   -1,  _("Net URL"),
						   renderer, "text",      
						   URI_COLUMN,  
						   NULL);       
      renderer = gtk_cell_renderer_text_new();
      gtk_tree_view_insert_column_with_attributes (view, -1, _("Type"), 
						   renderer, "text", 
						   URI_TYPE_COLUMN, 
						   NULL);     
      break;

    case TELEPHONE_COLUMNS:
      renderer = gtk_cell_renderer_text_new();
      gtk_tree_view_insert_column_with_attributes (view, -1, _("Number"), 
						   renderer, "text", 
						   TELEPHONE_NUMBER_COLUMN, 
						   NULL);   
      
      renderer = gtk_cell_renderer_text_new();
      gtk_tree_view_insert_column_with_attributes (view, -1, _("Type"), 
						   renderer, "text", 
						   TELEPHONE_LABEL_COLUMN, 
						   NULL);     
      break;

    case INFO_COLUMNS:
      renderer = gtk_cell_renderer_text_new();
      gtk_tree_view_insert_column_with_attributes (view, -1, _("Card"), 
						   renderer, "text", 
						   INFO_CARD_LABEL_COLUMN, 
						   NULL);

      renderer = gtk_cell_renderer_text_new();
      gtk_tree_view_insert_column_with_attributes (view, -1, _("First name"), 
						   renderer, "text", 
						   INFO_FIRST_NAME_COLUMN, 
						   NULL);

      renderer = gtk_cell_renderer_text_new();
      gtk_tree_view_insert_column_with_attributes (view, -1, _("Last name"), 
						   renderer, "text", 
						   INFO_LAST_NAME_COLUMN, 
						   NULL);

      renderer = gtk_cell_renderer_text_new();
      gtk_tree_view_insert_column_with_attributes (view, -1, _("Assignment"), 
						   renderer, "text", 
						   INFO_ASSIGNMENT_COLUMN, 
						   NULL);

      renderer = gtk_cell_renderer_text_new();
      gtk_tree_view_insert_column_with_attributes (view, -1, _("Telephone"), 
						   renderer, "text", 
						   INFO_TELEPHONE_COLUMN, 
						   NULL);

      renderer = gtk_cell_renderer_text_new();
      gtk_tree_view_insert_column_with_attributes (view, -1, _("Email"), 
						   renderer, "text", 
						   INFO_EMAIL_COLUMN, 
						   NULL);   
      break;
      
    default:
      break;
    }
}

/* 
void rubrica_model_set_column_attributes(GConfClient *client,  
					 GtkTreeView *view,  
					 gchar *key, gint col)  
{  
  GtkTreeViewColumn *column;   
   
  column = gtk_tree_view_get_column(view, col);  

  gtk_tree_view_column_set_resizable(column, TRUE); 
  gtk_tree_view_column_set_clickable(column, TRUE); 

  gtk_tree_view_column_set_reorderable(column, TRUE);

  rubrica_preferences_column_config(client, column, key);
}
*/


void  
rubrica_model_toggle_group(GtkCellRendererToggle *cell,   
			   gchar *path_str, gpointer data)  
{ 
  GtkTreeModel *model;  
  GtkTreeIter iter;  
  GtkTreePath *path;  
  gboolean status;       

  model = (GtkTreeModel *) data; 
  path  = gtk_tree_path_new_from_string(path_str);  

  gtk_tree_model_get_iter (model, &iter, path);  
  gtk_tree_model_get (model, &iter, GROUP_BELONG_COLUMN, &status, -1);  

  status ^= 1;  
  gtk_list_store_set(GTK_LIST_STORE(model), &iter,   
		     GROUP_BELONG_COLUMN, status, -1);  
}

/*
void
rubrica_model_populate_combo(GtkComboBox* combo, RubricaCombo* array)
{
  RubricaCombo* lst = array;
  GtkWidget *cellview;  
  GError *error = NULL;
  GtkIconTheme *theme;
  GtkListStore *store;
  GtkTreeIter iter;

  theme    = gtk_icon_theme_get_default();
  cellview = gtk_cell_view_new ();
  store    = (GtkListStore*) gtk_combo_box_get_model(GTK_COMBO_BOX(combo));

  for (; lst->icon; lst++)
    {
      GdkPixbuf *pixbuf = NULL;

      pixbuf = gtk_icon_theme_load_icon (theme, lst->icon, 40, 0, &error);
      
      gtk_list_store_append (store, &iter);
      if (pixbuf)
	gtk_list_store_set (store, &iter,
			    COMBO_PIXMAP, pixbuf,
			    COMBO_LABEL, lst->label,
			    -1);
      else
	gtk_list_store_set (store, &iter,
			    COMBO_PIXMAP, NULL,
			    COMBO_LABEL, lst->label,
			    -1);	
    }

  gtk_widget_destroy (cellview);
}
*/
