/*
*  program: Rubrica
*  file: personal_form.c
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include <gtk/gtk.h>
#include <glade/glade.h>
#include "libral.h"

#include "app.h"
#include "personal_gui.h"
#include "form.h"
#include "form_card.h"
#include "form_address.h"
#include "form_contact.h"
#include "form_net.h"
#include "form_notes.h"
#include "form_phone.h"
#include "form_work.h"
#include "groups_cb.h"
#include "models.h"
#include "types.h"
#include "utils.h"



/* Public
 */
PersonalDialog* 
rubrica_personal_dialog_new (RubricaApp* app)
{
  PersonalDialog *form = NULL;
  GladeXML       *gui;  

  gui = glade_xml_new (RUBRICA_GUI_DIR"/PersonalCard.glade", NULL, NULL);
  if (!gui)
    g_error("Can't load gui");
  
  form = (PersonalDialog*) g_malloc0(sizeof(PersonalDialog));  
  if (!form)
    g_error("out of memory");
  
  form->app     = app;  
  form->dialog  = glade_xml_get_widget(gui, "PersonalForm");
  form->card    = rubrica_form_card_new(app, gui);
  form->contact = rubrica_form_contact_new(app, gui);
  form->work    = rubrica_form_work_new(app, gui);
  form->address = rubrica_form_address_new(app, gui);
  form->net     = rubrica_form_net_new(app, gui, FORM_NET_PERSONAL);
  form->tel     = rubrica_form_phone_new(app, gui, FORM_PHONE_PERSONAL);
  form->note    = rubrica_form_notes_new(app, gui);
  
  g_object_unref(gui);
  
  return form;
}




RPersonalCard*
rubrica_personal_run_add_dialog (PersonalDialog* form)
{
  RubricaApp *app;
  RAbook *book;
  RPersonalCard *card = NULL;
  gint response;
  
  app  = form->app;
  book = rubrica_app_get_active_addressbook(app);
  
  response = gtk_dialog_run(GTK_DIALOG(form->dialog));
  switch (response)
    {
    case GTK_RESPONSE_OK:
      card = rubrica_personal_extract_card_data(form);

      if (card)
	{
	  r_abook_add_card(R_ABOOK(book), R_CARD(card));
	}
      break;
      
    case GTK_RESPONSE_CANCEL:
      break;
      
    default:
      break;
    }
  
  gtk_widget_hide(form->dialog);
  g_free(form);

  return card;
}


RPersonalCard* 
rubrica_personal_run_modify_dialog(PersonalDialog* form)
{
  RPersonalCard* card = NULL;
  gint response;  

  response = gtk_dialog_run(GTK_DIALOG(form->dialog));
  switch (response)
    {
    case GTK_RESPONSE_OK:
      card = rubrica_personal_extract_card_data(form);
      break;
      
    case GTK_RESPONSE_CANCEL:
      break;
      
    default:
      break;
    }
  
  gtk_widget_hide(form->dialog);
  g_free(form);

  return (RPersonalCard*) card;
}



RPersonalCard*
rubrica_personal_extract_card_data(PersonalDialog* form)
{
  RPersonalCard *card;

  card = r_personal_card_new();
  
  rubrica_form_extract_data(RUBRICA_FORM(form->card),    R_CARD(card));
  rubrica_form_extract_data(RUBRICA_FORM(form->contact), R_CARD(card));
  rubrica_form_extract_data(RUBRICA_FORM(form->work),    R_CARD(card));
  rubrica_form_extract_data(RUBRICA_FORM(form->address), R_CARD(card));
  rubrica_form_extract_data(RUBRICA_FORM(form->net),     R_CARD(card));
  rubrica_form_extract_data(RUBRICA_FORM(form->tel),     R_CARD(card));
  rubrica_form_extract_data(RUBRICA_FORM(form->note),    R_CARD(card));

  return card;
}


void
rubrica_personal_display_card_data(PersonalDialog* form, RCard* card)
{
  RGroupBox *box;
  
  g_return_if_fail(IS_R_CARD(card));

  box = rubrica_app_get_groups(form->app);
  
  rubrica_form_display_data (RUBRICA_FORM(form->card),    card);
  rubrica_form_display_data (RUBRICA_FORM(form->contact), card);
  rubrica_form_display_data (RUBRICA_FORM(form->work),    card);
  rubrica_form_display_data (RUBRICA_FORM(form->address), card);
  rubrica_form_display_data (RUBRICA_FORM(form->net),     card);
  rubrica_form_display_data (RUBRICA_FORM(form->tel),     card);
  rubrica_form_display_data (RUBRICA_FORM(form->note),    card);  
}

