/*
*  program: Rubrica
*  file: personal_gui.h
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _RUBRICA_PERSONAL_FORM_H
#define _RUBRICA_PERSONAL_FORM_H

#include <gtk/gtk.h>
#include "libral.h"

#include "app.h"
#include "form.h"
#include "form_card.h"
#include "form_address.h"
#include "form_contact.h"
#include "form_net.h"
#include "form_notes.h"
#include "form_phone.h"
#include "form_work.h"


typedef struct _PersonalForm {
  RubricaApp  *app;

  GtkWidget   *dialog;
  
  RubricaFormCard    *card;
  RubricaFormContact *contact;
  RubricaFormWork    *work;
  RubricaFormAddress *address;
  RubricaFormNet     *net;
  RubricaFormPhone   *tel;
  RubricaFormNotes   *note;
} PersonalDialog;


PersonalDialog* rubrica_personal_dialog_new        (RubricaApp* app);

RPersonalCard*  rubrica_personal_run_add_dialog    (PersonalDialog* form);
RPersonalCard*  rubrica_personal_run_modify_dialog (PersonalDialog* form);

RPersonalCard*  rubrica_personal_extract_card_data (PersonalDialog* form);
void            rubrica_personal_display_card_data (PersonalDialog* form, 
						    RCard* card);

#endif
