
/* 
*  Rubrica
*  file: print.h
*
*  Copyright (C) Nicola Fragale <nicolafragale@gmail.com> 
*
*  This program is free software; you can redistribute it and/or modify 
*  it under the terms of the GNU General Public License as published by 
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful, 
*  but WITHOUT ANY WARRANTY; without even the implied warranty of 
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
*  GNU General Public License for more details. 
*
*  You should have received a copy of the GNU General Public License 
*  along with this program; if not, write to the Free Software 
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
*/ 

#ifndef _RUBRICA_PRINT_H__
#define _RUBRICA_PRINT_H__


#include <gtk/gtk.h>

G_BEGIN_DECLS


#define RUBRICA_PRINT_TYPE           (rubrica_print_get_type())

#define RUBRICA_PRINT(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj),    \
				      RUBRICA_PRINT_TYPE, RubricaPrint))

#define RUBRICA_PRINT_CLASS(kls)     (G_TYPE_CHECK_CLASS_CAST((kls),       \
                                      RUBRICA_PRINT_TYPE, RubricaPrintClass))

#define IS_RUBRICA_PRINT(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj),    \
                                      RUBRICA_PRINT_TYPE))

#define IS_RUBRICA_PRINT_CLASS(kls)  (G_TYPE_INSTANCE_GET_CLASS((kls),     \
                                      RUBRICA_PRINT_TYPE))

#define RUBRICA_PRINT_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS(kls),      \
                                      RUBRICA_PRINT_TYPE, RubricaPrintClass)


typedef struct _RubricaPrint        RubricaPrint;
typedef struct _RubricaPrintClass   RubricaPrintClass;
typedef struct _RubricaPrintPrivate RubricaPrintPrivate;


struct _RubricaPrint 
{
  GObject parent;
 
  GtkPrintOperation* operation;
  
  RubricaPrintPrivate* priv;
};


struct _RubricaPrintClass
{
  GObjectClass parent_class;  
};


GType         rubrica_print_get_type      (void);

RubricaPrint* rubrica_print_new           (void);


G_END_DECLS

#endif
