/*
* Program:  Rubrica
*  file: statusbar.h
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _RUBRICA_STATUSBAR_H__
#define _RUBRICA_STATUSBAR_H__


#include <glib.h>
#include <gtk/gtk.h>

#include "types.h"

G_BEGIN_DECLS


#define RUBRICA_STATUSBAR_TYPE           (rubrica_statusbar_get_type())

#define RUBRICA_STATUSBAR(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj), \
                                          RUBRICA_STATUSBAR_TYPE,           \
                                          RubricaStatusbar))

#define RUBRICA_STATUSBAR_CLASS(kls)     (G_TYPE_CHECK_CLASS_CAST((kls),    \
                                          RUBRICA_STATUSBAR_TYPE,           \
                                          RubricaStatusbarClass))

#define IS_RUBRICA_STATUSBAR(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
                                          RUBRICA_STATUSBAR_TYPE))

#define IS_RUBRICA_STATUSBAR_CLASS(kls)  (G_TYPE_INSTANCE_GET_CLASS((kls),  \
                                          RUBRICA_STATUSBAR_TYPE))

#define RUBRICA_STATUSBAR_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS(kls),   \
                                          RUBRICA_STATUSBAR_TYPE,           \
                                          RubricaStatusbarClass)



typedef struct _RubricaStatusbar        RubricaStatusbar;
typedef struct _RubricaStatusbarClass   RubricaStatusbarClass;
typedef struct _RubricaStatusbarPrivate RubricaStatusbarPrivate;


struct _RubricaStatusbar 
{
  GtkStatusbar parent;
  
  RubricaStatusbarPrivate* priv;
};


struct _RubricaStatusbarClass
{
  GtkStatusbarClass parent_class;  
};


GType      rubrica_statusbar_get_type        (void);


GtkWidget* rubrica_statusbar_new             (void);
void       rubrica_statusbar_free            (RubricaStatusbar* bar);

void rubrica_statusbar_push_message   (RubricaStatusbar* bar, gchar* message);
void rubrica_statusbar_clean_messages (RubricaStatusbar* bar);
void rubrica_statusbar_enable_extra   (RubricaStatusbar* bar, gboolean bool);
void rubrica_statusbar_enable_images  (RubricaStatusbar* bar, gboolean bool);

void rubrica_statusbar_extra_set_text (RubricaStatusbar* bar, gchar* text);
void rubrica_statusbar_extra_set_rate (RubricaStatusbar* bar, 
				       RubricaPixmap rate);
void rubrica_statusbar_extra_set_lock (RubricaStatusbar* bar, 
				       RubricaPixmap lock);




G_END_DECLS

#endif
