/*
 *  Program: Rubrica
 *  file: tab.h 
 *  
 *  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <gtk/gtk.h>

#ifndef _RUBRICA_TAB_H
#define _RUBRICA_TAB_H


G_BEGIN_DECLS


#define RUBRICA_TAB_TYPE           (rubrica_tab_get_type())

#define RUBRICA_TAB(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj),    \
                                    RUBRICA_TAB_TYPE, RubricaTab))

#define RUBRICA_TAB_CLASS(kls)     (G_TYPE_CHECK_CLASS_CAST((kls),       \
                                    RUBRICA_TAB_TYPE, RubricaTabClass))

#define IS_RUBRICA_TAB(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj),    \
                                    RUBRICA_TAB_TYPE))

#define IS_RUBRICA_TAB_CLASS(kls)  (G_TYPE_INSTANCE_GET_CLASS((kls),     \
                                    RUBRICA_TAB_TYPE))

#define RUBRICA_TAB_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS(kls),      \
                                    RUBRICA_TAB_TYPE, RubricaTabClass)


typedef struct _RubricaTab        RubricaTab;
typedef struct _RubricaTabClass   RubricaTabClass;
typedef struct _RubricaTabPrivate RubricaTabPrivate;


struct _RubricaTab 
{
  GtkHBox parent;
  
  RubricaTabPrivate* priv;
};


struct _RubricaTabClass
{
  GtkHBoxClass parent_class;  
};


GType      rubrica_tab_get_type (void);


GtkWidget* rubrica_tab_new            (GtkWidget* brother);
GtkWidget* rubrica_tab_new_with_label (GtkWidget* brother, gchar* label);
void       rubrica_tab_free           (RubricaTab* tab);

GtkWidget* rubrica_tab_get_label      (RubricaTab* tab);
GtkWidget* rubrica_tab_get_button     (RubricaTab* tab);

void       rubrica_tab_set_brother    (RubricaTab* tab, GtkWidget* brother);
GtkWidget* rubrica_tab_get_brother    (RubricaTab* tab);



G_END_DECLS


#endif
