/*
*  Rubrica
*  file: utils.c
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <gtk/gtk.h>

#include "libral.h"

#include "utils.h"
#include "types.h"



void rubrica_utils_add_filters(GtkWidget* chooser)
{
  RPluginManager* manager;
  GList* filters = NULL;
  GtkFileFilter* filefilter;

  manager = r_lib_get_manager();
  filters = r_plugin_manager_get_all_filters(manager);
  for (; filters; filters = filters->next)
    {
      gchar *name, *mime, *pattern;
      RFilter* filter = (RFilter*) filters->data;
      
      filefilter = gtk_file_filter_new();
      g_object_get(filter, "filter-name", &name, 
		   "filter-mime", &mime, NULL);
      gtk_file_filter_set_name (filefilter, name);
      gtk_file_filter_add_mime_type (filefilter, mime);

      r_filter_reset(filter);
      pattern = r_filter_get_pattern(filter);
      for (; pattern; pattern = r_filter_get_next_pattern(filter))
	gtk_file_filter_add_pattern(filefilter, pattern);	   
      
      gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(chooser), filefilter);
    }
}


void
rubrica_utils_enable_filter(GtkFileChooser* chooser, const gchar* filter_name)
{
  GSList* filters = NULL;
  const gchar* filter;

  filter  = g_ascii_strdown(filter_name, -1);
  filters = gtk_file_chooser_list_filters (chooser);
  
  for (; filters; filters = filters->next)
    {
      const gchar *name = NULL;
      
      name = gtk_file_filter_get_name(GTK_FILE_FILTER(filters->data));      
      if (g_ascii_strcasecmp(name, filter) == 0)
	gtk_file_chooser_set_filter(chooser, GTK_FILE_FILTER(filters->data));
    }
}

