/* 
*  Rubrica
*  file: view.h
*
*  Copyright (C) Nicola Fragale <nicolafragale@gmail.com> 
*
*  This program is free software; you can redistribute it and/or modify 
*  it under the terms of the GNU General Public License as published by 
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful, 
*  but WITHOUT ANY WARRANTY; without even the implied warranty of 
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
*  GNU General Public License for more details. 
*
*  You should have received a copy of the GNU General Public License 
*  along with this program; if not, write to the Free Software 
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
*/ 

#ifndef _VIEW_H__
#define _VIEW_H__


#include <gtk/gtk.h>

G_BEGIN_DECLS


#define RUBRICA_VIEW_TYPE             (rubrica_view_get_type())

#define RUBRICA_VIEW(obj)             (G_TYPE_CHECK_INSTANCE_CAST((obj),    \
                                       RUBRICA_VIEW_TYPE,                   \
                                       RubricaView))

#define RUBRICA_VIEW_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST((klass),     \
                                       RUBRICA_VIEW_TYPE,                   \
                                       RubricaViewClass))

#define IS_RUBRICA_VIEW(obj)          (G_TYPE_CHECK_INSTANCE_TYPE((obj),    \
                                       RUBRICA_VIEW_TYPE))

#define IS_RUBRICA_VIEW_CLASS(klass)  (G_TYPE_INSTANCE_GET_CLASS((kls),     \
                                       RUBRICA_VIEW_TYPE))

#define RUBRICA_VIEW_GET_CLASS(klass) (G_TYPE_INSTANCE_GET_CLASS(klass),    \
                                       RUBRICA_VIEW_TYPE, RubricaViewClass)


typedef struct _RubricaView        RubricaView;
typedef struct _RubricaViewClass   RubricaViewClass;
typedef struct _RubricaViewPrivate RubricaViewPrivate;


struct _RubricaView 
{
  GtkVBox parent;
  
  RubricaViewPrivate* priv;
};


struct _RubricaViewClass
{
  GtkVBoxClass parent_class;  
  
  /* signals */
  void (*changed) (RubricaView*);
};


GType             rubrica_view_get_type      (void);


GtkWidget*        rubrica_view_new           (void);

void              rubrica_view_set_model     (RubricaView* view, 
					      GtkTreeModel* model);

GtkWidget*        rubrica_view_get_tree      (RubricaView* view);
GtkTreeSelection* rubrica_view_get_selection (RubricaView* view);
GtkTreeModel*     rubrica_view_get_model     (RubricaView* view);


G_END_DECLS

#endif
