#include <stdlib.h>
#include <glib.h>
#include <glib-object.h>

#include <libral.h>

gboolean print = FALSE;
gboolean write = FALSE;

void 
open_abook_fail(RAbook* abook, RError err, gpointer user_data)
{
  g_return_if_fail(IS_R_ABOOK(abook));

  g_print("\n%s", (gchar*) user_data);
  g_print("\nError: %d", err);
}


void item_read(RAbook* abook, gpointer card, gpointer user_data)
{
  gchar* name;
  gint rank;

  g_return_if_fail(IS_R_ABOOK(abook));
  
  g_object_get(R_CARD(card), 
	       "card-name", &name, 
	       "card-rank", &rank,
	       NULL);
  g_print("\nCard read: %-20s ** rank: %d", name, rank);
  g_free(name);

  if (print)
    {
      RInfos* infos = NULL;

      infos = r_card_get_infos(card);
      if (infos)
	g_print("\nFirst name: %s"
		"\nLast name: %s"
		"\nProfession: %s"
		"\nCity: %s"
		"\nCountry: %s"
		"\nWeb: %s"
		"\nEmail: %s"
		"\nTelephone: %s\n", 
		r_infos_get_first(infos),
		r_infos_get_last(infos),
		r_infos_get_profession(infos),
		r_infos_get_city(infos),
		r_infos_get_country(infos),
		r_infos_get_web(infos),
		r_infos_get_email(infos),
		r_infos_get_telephone(infos));
    }  
}


void 
abook_addressbook_read(RAbook* abook, gpointer user_data)
{
  g_return_if_fail(IS_R_ABOOK(abook));

  g_print("\n\nAddressbook read successfully");
}


int 
main(int argc, char* argv[])
{
  RAbook* abook;
  char *file, *plugin, *name, *path, *out, *plugin_out;

  if (argc < 3)
    {
      g_print("\nSyntax: abook options file [file.out]"
	      "\n\n"
	      "file is the addressbook to open\n"
	      "-r open a rubrica's addressbook\n"
	      "-v open a vcard's addressbook\n" 
	      "-c open a csv's addressbook\n"
	      "-wr write addressbook as rubrica's file\n"
	      "-wc write addressbook as csv's file\n"
	      "-wv write addressbook as vcard's file\n"
	      "-p print read card\n");

      return -1;
    }
  
  *argv++;
  while (*argv)
    {
      if (*argv && (argv[0][0] == '-'))
	{
	  switch (argv[0][1])
	    {
	    case 'r':
	      plugin = g_strdup("rubrica");
	      file = g_strdup(*(argv +1));		
	      break;

	    case 'v':
	      plugin = g_strdup("vcard");
	      file = g_strdup(*(argv +1));		
	      break;

	    case 'c':
	      plugin = g_strdup("csv");
	      file = g_strdup(*(argv +1));		
	      break;

	    case 'p':
	      print = TRUE;
	      break;
	      
	    case 'w':
	      write = TRUE;
	      out = g_strdup(*(argv +1));		
	      
	      switch (argv[0][2])
		{
		case 'r':
		  plugin_out = g_strdup("rubrica");
		  break;

		case 'c':
		  plugin_out = g_strdup("csv");
		  break;	

		case 'v':
		  plugin_out = g_strdup("vcard");
		  break;
		  
		default:
		  break;
		}

	    default:
	      break;
	    }
	}
      
      argv++;
    }

  g_type_init();
  r_lib_init();
  
  abook = r_abook_new();

  g_signal_connect(G_OBJECT (abook), "open_fail",
		   (GCallback) open_abook_fail, "Apertura fallita");

  g_signal_connect(G_OBJECT (abook), "card_read",
		   (GCallback) item_read, NULL);

  g_signal_connect(G_OBJECT (abook), "addressbook_read",
		   (GCallback) abook_addressbook_read, NULL);

  if (r_abook_load_plugin(abook, plugin))
    g_print("\n%s plugin loaded\n", plugin);
  else
    g_error("\ncan't get %s plugin\n", plugin);
  
  r_abook_open_file(abook, file);

  g_object_get(abook, 
	       "addressbook-name", &name, 
	       "addressbook-path", &path, NULL);
  g_print("\n\n"
	  "Address book name: %s\n"
	  "Address book path: %s\n"
	  "Items in address book: %d",name, path, r_abook_get_items(abook));

  if (write)
    {
      if (r_abook_load_plugin(abook, plugin_out))
	g_print("\n%s plugin loaded\n", plugin_out);
      else
	g_error("\ncan't get %s plugin\n", plugin_out); 
      
      r_abook_save_file(abook, out, 0);
    }

  g_print("\n\nFree memory...");
  r_abook_free(abook);
  g_print(" ok");

  g_free(file);
  g_free(plugin);

  g_print("\n\nIt works... ;-)\n\n");

  return 0;
}


