#include <glib.h>

#include <libral.h>

void press_key(void)
{
  gchar key;

  g_print("\npress a key");
  scanf("%c", &key);
}

int 
main (int argc, char* argv[])
{
  RAddress* address;
  RAddress* copy;
  RAddressType type;
  gchar *street, *number, *city, *zip, *province, *state, *country;
  
  g_type_init();
  r_lib_init();

  street = number = city = zip = province = state = country = NULL;

  g_print("\nTesting the address object");
  g_print("\nbuilding a new address");
  press_key();

  address = r_address_new();

  g_print("\nSetting address's values...");
  g_object_set(address, 
	       "address-type",  R_ADDRESS_HOME, 
	       "street",        "somewhere avenue", 
	       "street-number", "123", 
	       //	       "city",          "Lamezia Terme", 
	       //	       "zip",           "88046", 
	       "province",      "CZ", 
	       "state",         "UE", 
	       "country",       "Italy", NULL);
  g_print(" ok");

  
  g_print("\n\nTest check property");
  if (r_address_check(address, "street", &street))
    g_print("\nstreet check success (expected result) - street is: %s", 
	    street);
  else
    g_print("\nstreet check fails");
  
  if (r_address_check(address, "city", &city))
    g_print("\ncity success - city is: %s", city);
  else
    g_print("\ncity check fails (expected result) ");
  
  if (r_address_check(address, "zip", &zip))
    g_print("\nzip check success - zip is: %s", zip);
  else
    g_print("\nzip check fails (expected result)");
  
  if (r_address_check(address, "state", NULL))
    g_print("\nstate check success (expected result)");
  else
    g_print("\nstate check fails");
  press_key();  

  g_print("\n\nSet a value for city and zip");
  g_object_set(address, "city", "Lamezia Terme", "zip", "88046", NULL);  


  g_print("\n\nGetting address's values...");
  g_object_get(address, 
	       "address-type",  &type, 
	       "street",        &street, 
	       "street-number", &number, 
	       "city",          &city, 
	       "zip",           &zip, 
	       "province",      &province, 
	       "state",         &state, 
	       "country",       &country, NULL);
  g_print(" ok");
  
  g_print("\n\nPrint values");
  g_print("\naddress type: %s", r_address_lookup_enum2str(type));
  g_print("\nstreet: %s",       street);
  g_print("\nnumber: %s",       number);
  g_print("\ncity: %s",         city);
  g_print("\npostal code: %s",  zip);
  g_print("\nprovince: %s",     province);
  g_print("\nstate: %s",        state);
  g_print("\ncountry: %s",      country);

  
  g_print("\n\nCopy test");
  press_key();

  g_print("\nCopying the address...");
  copy = r_address_copy(address);
  g_print(" ok");

  g_print("\nGetting copy's values...");
  g_object_get(copy, 
	       "address-type",  &type,  
	       "street",        &street, 
	       "street-number", &number, 
	       "city",          &city,   
	       "zip",           &zip,             
	       "province",      &province,  
	       "state",         &state, 
	       "country",       &country, NULL); 
  g_print(" ok");
  
  g_print("\n\nPrint values");
  g_print("\naddress type: %s", r_address_lookup_enum2str(type));
  g_print("\nstreet: %s",       street);
  g_print("\nnumber: %s",       number);
  g_print("\ncity: %s",         city);
  g_print("\npostal code: %s",  zip);
  g_print("\nprovince: %s",     province);
  g_print("\nstate: %s",        state);
  g_print("\ncountry: %s",      country);
  
  
  g_print("\n\nFree the memory");
  g_print("\nFree the address...");
  r_address_free(address);
  g_print(" ok");

  g_print("\nFree the copy...");
  r_address_free(copy);
  g_print(" ok");

  g_print("\n\nIt works... ;-)\n\n");

  return 0;
}
