#include <glib.h>
#include <glib-object.h>

#include <libral.h>

void press_key(void)
{
  gchar key;

  g_print("\npress a key");
  scanf("%c", &key);
}


int 
main(int argc, char* argv[])
{
  RContact* contact;
  RContact* copy;
  gchar *first = NULL, *middle, *last, *nick, *prof = NULL;
  gchar *pref, *title, *photo;
  gchar *day, *month, *year; 
  

  g_type_init();
  r_lib_init();

  g_print("\nTesting the contact object");
  g_print("\nbuilding a new contact");
  press_key();
  
  contact = r_contact_new();

  g_print("\nFill contact with some values...");
  g_object_set(contact, 
	       "first-name", "given name", 
	       "middle-name", "middle name", 
	       "last-name", "surname", 
	       "nick-name", "TheNick", 
//	       "profession", "the profession", 
	       "prefix", "the prefix", 
	       "title", "title", 
	       "photo", "/path/to/contact/photo/photo1.jpg", NULL);
  r_contact_set_birthday(contact, 1, 1, 91);
  g_print(" ok");


  // test check
  if (r_contact_check(contact, "first-name", &first))
    g_print("\nfirst name check success (expected result) - "
	    "first name is: %s", first);
  else
    g_print("\nfirst name check fails");
  
  if (r_contact_check(contact, "title", &title))
    g_print("\ntitle check success (expected result) - title is: %s", title);
  else
    g_print("\nfirst name check fails");
  
  if (r_contact_check(contact, "profession", &prof))
    g_print("\nprofession check success - profession is: %s", prof);
  else
    g_print("\nprofession check fails (expected result)");

  if (r_contact_check(contact, "photo", NULL))
    g_print("\nphoto check success (expected result)");
  else
    g_print("\nphoto check fails");
  press_key();  

  g_print("\nSet a value for profession");
  g_object_set(contact, "profession", "the profession", NULL);  

  g_print("\nCopying the contact...");
  copy = r_contact_copy(contact);
  g_print(" ok");            

  g_print("\nGetting data from copy...");
  g_object_get(copy, 
	       "first-name", &first, 
	       "middle-name", &middle, 
	       "last-name", &last, 
	       "nick-name", &nick,
	       "profession", &prof, 
	       "prefix", &pref,
	       "title", &title, 
	       "photo", &photo, NULL);

  day   = r_contact_get_birth_day(contact);
  month = r_contact_get_birth_month(contact);
  year  = r_contact_get_birth_year(contact);
  g_print(" ok");

  g_print("\n\nWill print copy's values...");
  press_key();

  g_print("\nGiven name: %s\nMiddle name: %s\nSurname: %s\nNick name: %s"
	  "\nProfession: %s\nPrefix: %s\nTitle: %s\nPhoto: %s"
	  "\nBirthday: Day: %s\tMonth: %s\tYear: %s",
	  first, middle, last, nick, prof, pref, 
	  title, photo, day, month, year);
  
  press_key();
  g_print("\n\nFree the memory");
  g_print("\nfree the object...");
  r_contact_free(contact); 
  g_print(" ok");
  g_print("\nfree object's copy...");
  r_contact_free(copy);
  g_print(" ok");
  
  g_print("\n\nIt works... ;-)\n\n");

  return 0;
}


