#include <glib.h>
#include <glib-object.h>

#include <libral.h>


int 
main(int argc, char* argv[])
{
  RAbook* book;
  gpointer data;
  
  g_type_init();

  /* libral initialization */
  r_lib_init();
  
  if (argc <2)
    {
      g_print("\ncsv nomefile");
      return -1;
    }
  
  book = r_abook_new();

  g_print("\n\nChoosing csv plugin");
  if (r_abook_load_plugin(book, "csv"))
    g_print("\nPlugin loaded");
  else
    g_error("\nCan't get plugin");  
  
  g_print("\nMaking new addressbook");
  g_object_set(book, "addressbook-name", argv[1], "addressbook-path", ".",
	       NULL); 
 
  if (r_abook_open_file(R_ABOOK(book), argv[1]))
    {
      gchar *name, *path;
       
  g_object_get(book, 
	       "addressbook-name", &name, "addressbook-path", &path, NULL);

      g_print("\nAddressbook: %s (path: %s) successfully opened", name, path);
      g_print("\nItems in addressbook: %d",
	      r_abook_get_items(R_ABOOK(book)));
      
      g_print("\n\nprint addressbook");
      data = r_abook_get_card(R_ABOOK(book));
      for (; data; data = r_abook_get_next_card(R_ABOOK(book)))
	{
	  RInfos *infos;
	  gchar *type, buf;	  
	  
	  g_object_get(R_CARD(data), "card-type", &type, NULL);
	  
	  if (g_ascii_strcasecmp(type, "personal") == 0)
	    {
	      infos = r_card_get_infos(R_CARD(data));
	      
	      g_print("\nDisplay name : %s", r_infos_get_label(infos));
	      g_print("\nFirst name   : %s", r_infos_get_first(infos));
	      g_print("\nLast name    : %s", r_infos_get_last(infos));
	      g_print("\nProfession   : %s", r_infos_get_profession(infos));
	      g_print("\nCity         : %s", r_infos_get_city(infos));
	      g_print("\nCountry      : %s", r_infos_get_country(infos));
	      g_print("\nAssignment   : %s", r_infos_get_assignment(infos));
	      g_print("\nHome page    : %s", r_infos_get_web(infos));
	      g_print("\nEmail        : %s", r_infos_get_email(infos));
	      g_print("\nTelephone    : %s", r_infos_get_telephone(infos));
	      g_print("\n");
	      
	      scanf("%c", &buf);
	    }
	}
    }
  else
    {
      g_print("\nCan't read file");
      return -1;
    }
		
  g_print("\ntry to save the csv addressbook as a rubrica's addressbook");
  g_print("\nloading rubrica plugin...");
  if (r_abook_load_plugin(book, "rubrica"))
    g_print("\nPlugin loaded");
  else
    g_error("\nCan't get plugin");  
  
  if(!r_abook_save_file(R_ABOOK(book), "imported_from_csv.rub", 0))
    g_print("\nCan't save file");
  
  g_print("\n\nIt works... ;-)\n\n");

  return 0;
}


