#include <stdio.h>
#include <wchar.h>
#include <glib.h>

#include "libral.h"


void card_read_cb(RAbook *book, gpointer card, gpointer data)
{
  gchar** buffer = card;
  
  g_print("\nName:  %s", buffer[0]);
  g_print("\nEmail: %s", buffer[1]);
  g_print("\nNotes: %s\n\n", buffer[2]);
}




int main (int argc, char* argv[])
{
  RPluginManager* manager;
  RAbook* book;
  
  g_type_init();

  if (argc < 2)
    g_error("manca nome file");

  r_lib_init();
  manager = r_lib_get_manager();

  book = r_abook_new(); 
  g_signal_connect(G_OBJECT(book), "card_read", 
		  G_CALLBACK(card_read_cb), NULL);

  g_object_set(book, "file-filter", "gmail_csv", NULL);
  
  r_abook_open_file(book, argv[1]);

  return 0;
}
