#include <glib.h>
#include <glib-object.h>

#include <libral.h>


void press_key(void)
{
  gchar key;

  g_print("\npress a key");
  scanf("%c", &key);
}

int 
main(int argc, char* argv[])
{
  RGroupBox* box;
  RGroup *group, *copy;
  GList* lst = NULL;
  gpointer data;  
  gchar *name, *owner, *pixmap;
  gboolean bool, enabled;

  g_type_init();
  r_lib_init();
  
  g_print("\nTesting the group and group-box objects");
  press_key();

  g_print("\nbuilding a new group box...");
  box = r_group_box_new();
  g_print(" ok");
 
  g_print("\nadding groups to group box");
  g_print("\nadding group first (disabled group)...");
  group = r_group_new();
  g_object_set(group, 
	       "group-name", "first", 
	       "group-owner", "rubrica", 
	       "group-pixmap", "path/to/pixmap/pix.png", NULL);
  r_group_box_add_group(box, group);
  g_print(" ok");
  
  g_print("\nadding group second (enabled group)...");
  group = r_group_new();
  g_object_set(group, 
	       "group-name", "second", 
	       "group-owner", "rubrica", 
	       "group-pixmap", "path/subdir/img.jpg", 
	       "enabled", TRUE, NULL);
  r_group_box_add_group(box, group);
  g_print(" ok");

  g_print("\nadding group third (enabled, no pixmap)...");
  group = r_group_new();
  g_object_set(group, 
	       "group-name", "third", 
	       "group-owner", "user",
	       "enabled", TRUE, NULL);
  r_group_box_add_group(box, group);
  g_print(" ok");

  g_print("\nadding group fourth (disabled, no pixmap)...");
  group = r_group_new();
  g_object_set(group, 
	       "group-name", "fourth", 
	       "group-owner", "user", NULL);
  r_group_box_add_group(box, group);
  g_print(" ok");
  
  g_print("\n\nPrint groups");
  press_key();

  data = r_group_box_get_group(box);
  for (; data; data = r_group_box_get_next_group(box))
    {
      g_object_get(R_GROUP(data), 
		   "group-name", &name, 
		   "group-owner", &owner, 
		   "group-pixmap", &pixmap,
		   "enabled", &enabled, 
		   NULL);
      g_print("\ngroup: %s\towner: %s\tenabled: %s\tpixmap: %s", 
	      name, owner, enabled ? "yes" : "no", pixmap);
    }

  g_print("\n\nSome test on box and groups...");
  press_key();
  
  /*    test group existence
  */
  g_print("\nTest if box has got \"second\" and \"my-group\"...");
  g_print("\nbox owns the group %s ...", "second");
  bool = r_group_box_owns_group(box, "second"); 
  g_print(" %s", bool ? "yes" : "no");

  g_print("\nbox owns the group %s ...", "my-group"); 
  bool = r_group_box_owns_group(box, "my-group"); 
  g_print(" %s", bool ? "yes" : "no"); 
  press_key();
  

  /*    Print default (rubrica) groups
  */
  g_print("\n\nLooking for the groups owned by rubrica");
  lst = r_group_box_find_groups_owned_by(box, "rubrica");
  for (; lst; lst = lst->next)
    {
      g_object_get(lst->data, "group-name", &name, NULL);
      g_print("\nGroup: %s", name);
    }
  

  /*    Print user's defined groups
  */
  g_print("\n\nLooking for the groups owned by user");
  lst = r_group_box_find_groups_owned_by(box, "user");
  for (; lst; lst = lst->next)
    {
      g_object_get(lst->data, "group-name", &name, NULL);
      g_print("\nGroup: %s", name);
    }  
  press_key();

  /*    search groups
   */
  g_print("\n\nLooking for the group: fourth");
  data = r_group_box_find(box, "fourth");
  if (!data)
    g_print("\nbox doesn't contains this group");
  else
    g_print("\nfound");

  g_print("\n\nLooking for the group: foo-bar");
  data = r_group_box_find(box, "foo-bar");
  if (!data)
    g_print("\nbox doesn't contains this group");
  else
    g_print("\nfound");
  
  /*    delete a group
   */
  g_print("\n\nDeleting the group \"third\"...");
  group = r_group_box_find(box, "third");
  r_group_box_delete_group(box, group);
  g_print(" ok");

  /*    rename a group
   */    
  g_print("\n\nRenaming the group \"second\" to \"renamed\"...");
  r_group_box_modify_group_name(box, "second", "renamed");
  g_print(" ok");
    

  g_print("\n\nPrint group box");
  press_key();
  
  r_group_box_reset(box);
  data = r_group_box_get_group(box);
  for (; data; data = r_group_box_get_next_group(box))
   {
     g_object_get(R_GROUP(data), 
		  "group-name", &name, 
		  "group-owner", &owner, 
		  "group-pixmap", &pixmap,
		  "enabled", &enabled, 
		  NULL);
     g_print("\ngroup: %s\towner: %s\tenabled: %s\tpixmap: %s", 
	     name, owner, enabled ? "yes" : "no", pixmap);
   }
  press_key();
  
  /*    Copy test
   */
  g_print("\n\nCopy test");
  press_key();

  g_print("\ncopying the group \"first\"...");
  data = r_group_box_find(box, "first");
  copy = r_group_copy(R_GROUP(data));
  g_print(" ok");
  
  g_print("\nprint copy's values");
  g_object_get(copy, "group-name", &name, "group-owner", &owner,
	       "group-pixmap", &pixmap, "enabled", &enabled, NULL);
  g_print("\ngroup: %s\towner: %s\tenabled: %s\tpixmap: %s", 
	      name, owner, enabled ? "yes" : "no", pixmap);
  
  /*    Print default (rubrica) groups
  */
  g_print("\n\nLooking for the groups owned by rubrica");
  press_key();
  lst = r_group_box_find_groups_owned_by(box, "rubrica");
  for (; lst; lst = lst->next)
    {
      g_object_get(lst->data, "group-name", &name, NULL);
      g_print("\nGroup: %s", name);
    }
  

  /*    Print user's defined groups
  */
  g_print("\n\nLooking for the groups owned by user");
  lst = r_group_box_find_groups_owned_by(box, "user");
  for (; lst; lst = lst->next)
    {
      g_object_get(lst->data, "group-name", &name, NULL);
      g_print("\nGroup: %s", name);
    }  
  press_key();

  g_print("\n\nFree memory");
  press_key();
  g_print("\nfree copy...");
  r_group_free(copy);
  g_print(" ok");

  g_print("\nfree box (and owned groups)...");
  r_group_box_free(box);
  g_print(" ok");

  g_print("\n\nIt works... ;-)\n\n");

  return 0;
}


