#include <glib.h>
#include <stdio.h>

#include <libral.h>


gboolean 
press_key(void)
{
  gchar key;

  g_print("\npress a key");
  scanf("%c", &key);
  
  return FALSE;
}


void test_autosave(RAbook* book, RTimeout* timeout)
{
  g_print("\nAnd last, test autosave...");  
  g_print("\nEnabling timeout...");   
  while (press_key()); 
  r_timeout_enable(timeout);    
  g_print("ok\n\nJust wait 1 seconds...");   
   
  r_timeout_restart(timeout, 1);    
}


void 
autosave (gpointer obj, gpointer user_data)
{
  RAbook* book = (RAbook*) user_data;

  g_print("\nautosave");
  
  if (!r_abook_load_plugin(book, "rubrica"))
    g_error("\nCan't load plugin");  
  
  g_object_set(book, 
	       "addressbook-name", "autosaved.rub", 
	       "addressbook-path", ".",
	       NULL);  
  
  if(r_abook_save_file(book, "autosaved.rub", 0))
    g_print("\nsaved");  
  else
    g_print("\nnot saved");  
}


int 
main (int argc, char* argv[])
{
  GMainLoop *loop;
  RAbook* book;
  gpointer data;

  RCard  *copia, *copia_cmp;
  RPersonalCard *card, *card2, *card3;
  RCompanyCard *cmp;
  RGroup* group;
  RContact* contact;
  RWork* work;
  RNotes* notes;
  RTelephone* tel;
  RNetAddress* net;
  RAddress* add;
  RRef* ref;
  GList *lst, *alias;
  glong id, ref_id;
  gchar *tmp, *name, *path, *file_name;
  RTimeout *timeout;
  
  g_type_init();
  r_lib_init();
  loop = g_main_loop_new(NULL, FALSE);

  file_name = g_strdup("addressbook-test.rub");
  
  g_print("\nMaking new addressbook");
  book = r_abook_new();  

  timeout = r_lib_get_timeout(); 
  if (r_timeout_is_running(timeout)) 
    { 
      g_print("\nSetting timeout to 1 seconds ");
      g_print("\nGet timeout and stopping it...");

      r_timeout_restart(timeout, 1);       
      r_timeout_disable(timeout);
    }
  else
    g_error("\nTimeout not running");

  
  // connect an autosave callback funtion to "timeout" signal
  g_signal_connect(G_OBJECT(timeout), "timeout", 
		   G_CALLBACK(autosave), book);

  g_print("\n\nReading Rubrica plugin");
  if (r_abook_load_plugin(book, "rubrica"))
    g_print("\nPlugin loaded");
  else
    g_error("\nCan't load plugin");

  g_object_get(book, 
	       "addressbook-name", &name, 
	       "addressbook-path", &path,
	       NULL);
  g_print("\n\ngetting filename and path..."
	  "\nfilename: %s\tpath: %s", name, path);
  
  g_object_set(book, 
	       "addressbook-name", file_name, 
	       "addressbook-path", "./",
	       NULL);

  g_object_get(book, 
	       "addressbook-name", &name, 
	       "addressbook-path", &path,
	       NULL);
  g_print("\nI've setted new values\nfilename: %s\tpath: %s", name, path);
  

  /* First personal card 
   */
  g_print("\nMaking first Personal Card...  (with a test align)");
  g_print("\nfirst card id: 1, aligned to id: 10");

  press_key();

  /* create a new personal card */
  card = r_personal_card_new();
  g_object_set(R_CARD(card), 
	       "card-locked", TRUE, 
	       "card-deleted", FALSE,
	       "card-marked", FALSE, 
	       "card-name", "Autore Rubrica", 
	       "card-rate", R_RATE_VERY_HIGH, NULL);
  r_card_reassign_id(R_CARD(card), 10);
  
  
  /* add card to groups: favorites, user_made_group, strategies, programmers
  */
  /* add a group */
  group = r_group_new();
  g_object_set(group, 
	       "group-name", "favorites", 
	       "group-owner", "rubrica",
	       "group-pixmap", "/path/to/pixmap", 
	       "enabled", TRUE, NULL);
  r_card_add_group(R_CARD(card), group);

  /* add a group */
  group = r_group_new();
  g_object_set(group, 
	       "group-name", "user_made_group", 
	       "group-owner", "user",
	       "group-pixmap", "/path/to/pixmap", 
	       "enabled", TRUE, NULL);
  r_card_add_group(R_CARD(card), group);
  
  /* add a group */
  group = r_group_new();
  g_object_set(group, 
	       "group-name", "strategies", 
	       "group-owner", "rubrica", 
	       "enabled", TRUE, NULL);
  r_card_add_group(R_CARD(card), group);

  /* add a group */
  group = r_group_new();
  g_object_set(group, 
	       "group-name", "programmers", 
	       "group-owner", "rubrica", 
	       "enabled", TRUE, NULL);
  r_card_add_group(R_CARD(card), group);
  
  /* create contact's data */
  contact = r_contact_new();
  g_object_set(contact, 
	       "first-name", "Nicola", 
	       "middle-name", "Giuseppe", 
	       "last-name", "Fragale",
	       "nick-name", "the nick", 
	       "profession", "the profession",
	       NULL);
  r_contact_set_birthday(contact, 1, 1, 01);

  /* contact's work */
  work    = r_work_new();
  g_object_set(work, "assignment", "student", NULL);
  
  /* contact's notes */
  notes   = r_notes_new();
  g_object_set(notes, 
	       "has-partner", FALSE, 
	       "pubkey", "dfvkladifhvajjjfsfllfo4883jskdf8878s***é*é", NULL);
 
  r_personal_card_set_contact(card, contact);
  r_personal_card_set_work(card, work);
  r_personal_card_set_notes(card, notes);
 
  /* add an address */
  add = r_address_new(); 
  g_object_set(add, 
	       "address-type", R_ADDRESS_HOME, 
	       "street", "The Street", 
	       "street-number", "the Number", 
	       "city", "Lamezia Terme", 
	       "zip", "88046", NULL);
  r_card_add_address(R_CARD(card), add);

  /* add an address */
  add = r_address_new(); 
  g_object_set(add, 
	       "address-type", R_ADDRESS_WORK, 
	       "street", "street work address",
	       "street-number", "484746", NULL);
  r_card_add_address(R_CARD(card), add);

  /* add a telephone number */
  tel = r_telephone_new();
  g_object_set(tel, 
	       "telephone-number", "555 123456", 
	       "telephone-type", R_TELEPHONE_HOME, NULL);
  r_card_add_telephone(R_CARD(card), tel);

  /* add a telephone number */
  tel = r_telephone_new();
  g_object_set(tel, 
	       "telephone-number", "06 9876543", 
	       "telephone-type", R_TELEPHONE_CUSTOMER_CARE, NULL);
  r_card_add_telephone(R_CARD(card), tel);
  
  /* add a net address */
  net = r_net_address_new();
  g_object_set(net, 
	       "url", "nicolafragale@libero.it", 
	       "url-type", R_NET_ADDRESS_EMAIL, NULL);
  r_card_add_net_address(R_CARD(card), net);
  
  /* add a net address */
  net = r_net_address_new();
  g_object_set(net, 
	       "url", "http://digilander.libero.it/nfragale", 
	       "url-type",R_NET_ADDRESS_WEB, NULL);
  r_card_add_net_address(R_CARD(card), net);  
  /* ************************ 
   */

  /* Second personal card 
   */
  g_print("\nMaking second Personal Card (id should be #2, I'll have #11)");
  g_print("\ntest align to 5 (it must fails, I'll have 11)");
  card2   = r_personal_card_new();

  press_key();

  r_card_reassign_id(R_CARD(card2), 5);
  g_object_get(R_CARD(card2), "card-id", &id, NULL);
  g_print("\nCheck second card's id: %ld\n", id);

  g_object_set(R_CARD(card2), 
	       "card-name", "Rubrica Author", 
	       "card-rate", R_RATE_NORMAL, NULL);

  /* add card to group:
     programmers, another_user_made_group
  */
  group = r_group_new();
  g_object_set(group, "group-name", "programmers", "enabled", TRUE, NULL);
  r_card_add_group(R_CARD(card2), group);

  group = r_group_new();
  g_object_set(group, "group-name", "another_user_made_group", 
	       "group-owner", "user", "enabled", TRUE, 
	       "group-pixmap", "local/path/to/pixmap", NULL);
  r_card_add_group(R_CARD(card2), group);

  contact = r_contact_new();
  g_object_set(contact, "first-name", "Nicola", "last-name", "Fragale", NULL);
  r_personal_card_set_contact(card2, contact);

  work = r_work_new();
  g_object_set(work, "assignment", "the work", 
	       "manager-name", "Mr Red", 
	       "manager-phone", "+39 0 987-654 321", 
	       "collaborator", "Miss Green", 
	       "collaborator-phone", "123 456 789", NULL);
  r_personal_card_set_work(card2, work);
  
  notes = r_notes_new();
  g_object_set(notes, 
	       "pubkey", 
	       "sdsffsdfdsfsdsdfsdfdsfdiruqu9384"
	       "48rr2dbfsakljhxfakdkfskdfhjksdhfsj09349kjn"
	       "82397098sdhlaksdjapieuweyuehdus", NULL);  
  r_personal_card_set_notes(card2, notes);

  add = r_address_new();
  g_object_set(add, "address-type", R_ADDRESS_DOM, 
	       "street", "the street", "street-number", "937", NULL);

  r_card_add_address(R_CARD(card2), add);
  
  tel = r_telephone_new();
  g_object_set(tel, "telephone-number", "098 7654321", 
	       "telephone-type", R_TELEPHONE_CELLPHONE, NULL);
  r_card_add_telephone(R_CARD(card2), tel);
  
  net = r_net_address_new();
  g_object_set(net, "url", "nicolafragale@gmail.com", 
	       "url-type", R_NET_ADDRESS_EMAIL, NULL);
  r_card_add_net_address(R_CARD(card2), net); 

  net = r_net_address_new();
  g_object_set(net, "url", "4542234543545", 
	       "url-type", R_NET_ADDRESS_IRC_JABBER, NULL);
  r_card_add_net_address(R_CARD(card2), net);  

  net = r_net_address_new();
  g_object_set(net, "url", "439878239861", 
	       "url-type", R_NET_ADDRESS_IRC_ICQ, NULL);
  r_card_add_net_address(R_CARD(card2), net); 


  /* Third personal card (id=12)
   */
  g_print("\nMaking third Personal Card");
  card3   = r_personal_card_new();

  press_key();

  g_object_set(R_CARD(card3), "card-name", "Card name", NULL);

  /* add card to group:
     friends
  */
  group = r_group_new();
  g_object_set(group, "group-name", "friends", "enabled", TRUE, NULL);
  r_card_add_group(R_CARD(card3), group);

  contact = r_contact_new();
  g_object_set(contact, "first-name", "first name", 
	       "last-name", "last name", "nick-name", "nick", NULL);
  r_personal_card_set_contact(card3, contact);

  work    = r_work_new();
  g_object_set(work, "assignment", "role", NULL);
  r_personal_card_set_work(card3, work);
  
  notes   = r_notes_new();
  g_object_set(notes, "has-partner", TRUE, "partner-name", "Jane", NULL);  
  r_personal_card_set_notes(card3, notes);

  add = r_address_new();
  g_object_set(add, "address-type", R_ADDRESS_DOM, 
	       "street", "the street", "street-number", "17/R", 
	       "city", "Naples", "zip", "98765", "province", "Na", 
	       "country", "Italy", "state", "European Union", NULL);

  r_card_add_address(R_CARD(card3), add);
  
  tel = r_telephone_new();
  g_object_set(tel, "telephone-number", "112 6463283", 
	       "telephone-type", R_TELEPHONE_HOME, NULL);
  r_card_add_telephone(R_CARD(card3), tel);
  
  net = r_net_address_new();
  g_object_set(net, "url", "some_email@some_provider.com", 
	       "url-type", R_NET_ADDRESS_EMAIL, NULL);
  r_card_add_net_address(R_CARD(card3), net); 
  
  net = r_net_address_new();
  g_object_set(net, "url", "0983332271", 
	       "url-type", R_NET_ADDRESS_EKIGA, NULL);
  r_card_add_net_address(R_CARD(card3), net); 


  /* Company card (id=13)
   */
  g_print("\nMaking first Company Card");

  press_key();

  cmp = r_company_card_new();
  g_object_set(R_CARD(cmp), "card-name", "Foo INC",
	       "card-locked", FALSE, "card-rate", R_RATE_HIGH, NULL);

  /* add card to group:
     programmers, another_user_made_group
  */
  group = r_group_new();
  g_object_set(group, "group-name", "bussines", NULL);
  r_card_add_group(R_CARD(cmp), group);

  group = r_group_new();
  g_object_set(group, "group-name", "strategies", "group-owner", "user", NULL);
  r_card_add_group(R_CARD(card), group);

  g_object_set(cmp, "company-name", "Foo INC",     
	       "company-vat", "nclfrg18m3t208x", 
	       "company-notes", "Notes, bla bla bla, foo foo foo ...", NULL);

  /* get company card's id */
  g_object_get(R_CARD(cmp), "card-id", &id, NULL);
  ref = r_ref_new(id); 
  g_object_set(ref, 
	       "ref-info", "best client I had....", NULL);

  /* add a reference at company card to first personal card */
  r_card_add_ref(R_CARD(card), ref); 
    
  /* get first personal card's id */
  g_object_get(R_CARD(card), "card-id", &id, NULL);
  ref = r_ref_new(id); 
  g_object_set(ref, 
	       "ref-info", "I'm the ", NULL);

  /* add a reference at first personal card to company card */
  r_card_add_ref(R_CARD(cmp), ref); 

  /* first personal card has a reference to the company card */

  add = r_address_new();
  g_object_set(add,  "address-type", R_ADDRESS_COMPANY, 
	       "street", "company street", "street-number", "1", 
	       "city", "Lamezia Terme", "zip", "88046",
	       "province", "CZ", "country", "Italy", "state", "UE", NULL);

  r_card_add_address(R_CARD(cmp), add); 

  tel = r_telephone_new();
  g_object_set(tel, "telephone-number", "0968 111222", 
	       "telephone-type", R_TELEPHONE_WORK, NULL);
  r_card_add_telephone(R_CARD(cmp), tel);

  tel = r_telephone_new();
  g_object_set(tel, "telephone-number", "5544-33445566", 
	       "telephone-type", R_TELEPHONE_FAX, NULL);
  r_card_add_telephone(R_CARD(cmp), tel);
  
  net = r_net_address_new();
  g_object_set(net, "url", "http://www.theCompanyInc.com", 
	       "url-type", R_NET_ADDRESS_WEB, NULL);
  r_card_add_net_address(R_CARD(cmp), net);  
  

  /* Do stuffs
   */
  g_print("\n\nCopying cards...");
  g_print("\nI will copy the first personal card");

  press_key();
  
  copia = r_card_copy(R_CARD(card));
  g_object_get(R_CARD(card), "card-name", &name, NULL);
  tmp = g_strdup_printf("%s (Copia)", name);
  g_object_set(R_CARD(copia), "card-name", tmp, NULL);
  g_free(tmp);

  g_print("\nI will copy the company card and reassign the id");
  g_print("\ncopy's id is 15, it will be set to 123");

  press_key();

  g_object_get(R_CARD(cmp), "card-name", &name, NULL);
  tmp = g_strdup_printf("%s (Copia)", name);  

  copia_cmp = (RCard*) r_card_copy(R_CARD(cmp));
  g_object_set(R_CARD(copia_cmp), "card-name", tmp, NULL);
  g_free(tmp);
  
  g_object_get(R_CARD(copia_cmp), "card-id", &id, NULL);
  g_print("\nId before reassign: %ld", id);
  
  r_card_reassign_id(R_CARD(copia_cmp), 123);
  g_object_get(R_CARD(copia_cmp), "card-id", &id, NULL);
  g_print("\nId after reassign: %ld", id);


  /* Build Addressbook 
   */
  g_print("\n\nAdding cards to addressbook...");

  press_key();

  r_abook_add_card(book, R_CARD(card));
  g_object_get(R_CARD(card), "card-name", &name, NULL);
  g_print("\nadded card: %s", name);

  r_abook_add_card(book, R_CARD(card2));
  g_object_get(R_CARD(card2), "card-name", &name, NULL);
  g_print("\nadded card: %s", name);

  r_abook_add_card(book, R_CARD(card3));
  g_object_get(R_CARD(card3), "card-name", &name, NULL);
  g_print("\nadded card: %s", name);
  
  r_abook_add_card(book, R_CARD(cmp));
  g_object_get(R_CARD(cmp), "card-name", &name, NULL);
  g_print("\nadded card: %s", name);

  r_abook_add_card(book, R_CARD(copia));
  g_object_get(R_CARD(copia), "card-name", &name, NULL);
  g_print("\nadded card: %s", name);

  r_abook_add_card(book, R_CARD(copia_cmp));
  g_object_get(R_CARD(copia_cmp), "card-name", &name, NULL);
  g_print("\nadded card: %s", name);

  g_print("\n\nDo somethings with addressbook"
	  "\nThis addressbook has %d item(s)",
	  r_abook_get_items(book));

  press_key();
  
  g_print("\nShow cards in addressbook");
  press_key();

  r_abook_reset_book(book);
  data = r_abook_get_card(book);
  for (; data; data = r_abook_get_next_card(book))
    {
      glong id;
      gchar* card_name;
      
      g_object_get(data, "card-id", &id, "card-name", &card_name, NULL);
      g_print("\nCard id: %-4ld %-15s", id, card_name);
    }
  g_print("\nCards in addressbook: %d", r_abook_get_items(book));
  press_key();
  
  g_print("\n\nFind all cards that belongs to group \"programmers\"");
  press_key();
  
  lst = r_abook_find_cards_by_group(book, "programmers");
  g_print("\nItems found: %d", g_list_length(lst));
  press_key();

  for (alias = lst; alias; alias = alias->next)
    {
      gpointer card;
      glong id = (glong) alias->data;
      
      card = r_abook_get_card_by_id(book, id);
      g_object_get(R_CARD(card), "card-id", &id, "card-name", &name, NULL);
      g_print("\nCard id:\t%ld\nCard name:\t%s\nEmail:\t\t%s",
	      id, name, r_card_get_email(R_CARD(card)));
      press_key();
    }
  
  data = NULL;
  g_print("\n\nGetting a card from addressbook (get_by_id)");
  g_print("\nget card with id: 2");  
  g_print("\nAn error is expected, because a card with "
	  "this id dosn't exists (id has been aligned)");
  press_key();

  data = r_abook_get_card_by_id(book, 2); 
  if (!data)
    g_print("\nCan't find requested card....\nALIGN WORKED!");
  else
    g_print("\n... something is wrong, a non existend card was find");
  
  g_print("\n\nCheck reference id in company card");
  g_print("\nGet ref_id");
  press_key();
  r_card_reset_ref(R_CARD(cmp));
  ref = r_card_get_ref(R_CARD(cmp));
  if (ref)
    {
      gchar* info;

      g_object_get(ref, "ref-to", &ref_id, "ref-info", &info, NULL);
      g_print("\nref id:\t%ld\nref info:\t%s", ref_id, info);
      g_print("\nPrinting data of reference");
      press_key();
 
      data = r_abook_get_card_by_id(book, ref_id);
      g_object_get(R_CARD(data), "card-name", &name, NULL);
      g_print("\nCard ref: %s", name);
    }
  
  
  /*    Undo
  */
  g_print("\n\nTest Undo...");
  g_print("\nGet card with id: 13, and move it to trash");
  press_key();

  g_print("\nCards in addressbook (before delete): %d", 
	  r_abook_get_items(book)); 
  g_print("\nCards in trash: %d", r_abook_get_deleted(book));

  data = r_abook_get_card_by_id(book, 13); 
  r_abook_delete_card(book, data);

  g_print("\nCards in addressbook (cards that belongs to addressbook, trash included): %d",
	  r_abook_get_items(book));
  g_print("\nCards in trash: %d", r_abook_get_deleted(book));
  
  press_key();
  
  g_print("\nRecovery card");
  press_key();
  r_abook_recovery_card(book, data);
  g_print("\nCards in addressbook (after undo): %d",
	  r_abook_get_items(book));  
  g_print("\nCards in trash: %d", r_abook_get_deleted(book));

  g_print("\n\nOk...\ntry to save addressbook");

  press_key();
  
  g_object_get(book, "addressbook-name", &name, NULL);
  if (g_file_test(name, G_FILE_TEST_EXISTS))
    remove(name);
  if(r_abook_save_file(book, name, 0))
    g_print("\n%s saved", name);
  else
    g_print("\nWARNING, addressbook not saved");
  

  g_print("\n\nOk...\ntry to save addressbook as csv");
  press_key();
  
  g_object_get(book, "addressbook-name", &tmp, NULL);
  name = g_strdup_printf("%s.csv", tmp);

  /* load csv plugin */
  if (r_abook_load_plugin(book, "csv"))
    g_print("\nPlugin loaded\n");
  else
    g_error("\nCan't load plugin\n");
  
  if (g_file_test(name, G_FILE_TEST_EXISTS))
    remove(name);
  if(r_abook_save_file(book, name, 0))
    g_print("\n%s saved", name);
  else
    g_print("\nWARNING, addressbook not saved");
  
  g_free(tmp);
  g_free(name);

  g_print("\n\nRemove a card from addressbook");
  g_print("\nItems before: %d", r_abook_get_items(book));
  g_print("\nNow I'm removing the card with id 11");
  
  press_key();

  r_abook_delete_card(book, data);
  g_print("\n\nCard removed. Free memory of removed card"); 

  press_key();  
  r_card_free(R_CARD(data));

  g_print("\nItems after: %d", r_abook_get_items(book));  
    
  g_print("\n\nFree addressbook");
  r_abook_free(book);

  g_print("\n\nTry to load the saved addressbook...");
  press_key();  
  
  book = r_abook_new(); 
  
  g_object_set(book, "addressbook-name", file_name, "addressbook-path", ".",
	       NULL);

  if (r_abook_load_plugin(book, "rubrica"))
    g_print("\nPlugin loaded");
  else
    g_error("\nCan't load plugin");

  if (r_abook_open_file(book, file_name))
    g_print("\nAddressbook loaded");
  
  g_main_loop_run(loop);
  test_autosave(book, timeout);

  while (press_key());
  
  g_print("\n\nIt works... ;-)\n\n");
  return 0;
}

