#include <glib.h>

#include <libral.h>


void press_key(void)
{
  gchar key;

  g_print("\npress a key");
  scanf("%c", &key);
}


int main (int argc, char* argv[])
{
  RPersonalCard *card, *copia;
  RGroup* group;
  RContact* contact;
  RWork* work;
  RNotes* notes;
  RTelephone* tel;
  RNetAddress* net;
  RAddress* add;
  gchar* tmp, *name;
  
  g_type_init();
  r_lib_init();
  
  g_print("\nMaking Personal Card...");

  press_key();

  card    = r_personal_card_new();
  contact = r_contact_new();
  work    = r_work_new();
  notes   = r_notes_new();

  g_print("\nhave a new card...");
  g_object_set(R_CARD(card), "card-locked", TRUE, "card-deleted", FALSE,
	       "card-marked", FALSE, "card-name", "Autore Rubrica", 
	       "card-rate", R_RATE_VERY_HIGH, NULL);

  /* add card to group:
     favorites, user_made_group, strategies, programmers
  */
  g_print("\nadding groups...");

  group = r_group_new();
  g_object_set(group, "group-name", "favorites", "group-owner", "rubrica", 
	       "group-pixmap", "/path/to/pixmap", "enabled", TRUE, NULL);
  r_card_add_group(R_CARD(card), group);

  group = r_group_new();
  g_object_set(group, "group-name", "user_made_group", "group-owner", "user", 
	       "group-pixmap", "/thepix", "enabled", TRUE, NULL);
  r_card_add_group(R_CARD(card), group);
  
  group = r_group_new();
  g_object_set(group, "group-name", "strategies", "group-owner", "rubrica", 
	       "group-pixmap", "no pix", "enabled", TRUE, NULL);
  r_card_add_group(R_CARD(card), group);

  group = r_group_new();
  g_object_set(group, "group-name", "programmers", "group-owner", "rubrica",
	       "group-pixmap", "/pixmaps/pix.png", "enabled", TRUE, NULL);
  r_card_add_group(R_CARD(card), group);
  
  g_print("\nfilling personal data...");  
  g_object_set(contact, "first-name", "Nicola", "middle-name", "Giuseppe", 
	       "last-name", "Fragale", "nick-name", "the nick", 
	       "profession", "Software Engegneer (I hope)",
	       "prefix", "", "title", "sig.", 
	       "photo", "path/to/photo", NULL);
  
  g_print("\nfilling work data...");  
  g_object_set(work, "assignment", "Student", 
	       "organization", "The organization Inc.", 
	       "department", "the department", 
	       "sub-department", "", 
	       "manager-name", "manager name", 
	       "manager-phone", "manager's telephone",
	       "collaborator", "coll name", 
	       "collaborator-phone", "collaborator's telephone", NULL);

  g_print("\nfilling notes data...");  
  g_object_set(notes, "has-partner", FALSE, "partner-name", "partner name", 
	       "other-notes", "bla bla bla",  
	       "pubkey", "jjjfsfllfo4883jskdf8878s***é*é", NULL);

  r_personal_card_set_contact(card, contact);
  r_personal_card_set_work(card, work);
  r_personal_card_set_notes(card, notes); 

  g_print("\nadding addresses...");

  add = r_address_new();
  g_object_set(add, "address-type", R_ADDRESS_HOME, 
	       "street", "The Street", "street-number", "the Number", 
	       "city", "Lamezia Terme", "zip", "88046",
	       "province", "CZ", "country", "Italy", "state", "UE", NULL);

  r_card_add_address(R_CARD(card), add);

  add = r_address_new(); 
  g_object_set(add, "address-type", R_ADDRESS_WORK, 
	       "street", "Work address", "street-number", "484746", 
	       "city", "MI", "zip", "84349", "province", "MI", 
	       "country", "IT", "state", "UE", NULL);
 
  r_card_add_address(R_CARD(card), add);

  g_print("\nadding telephone numbers...");

  tel = r_telephone_new();
  g_object_set(tel, "telephone-number", "0968 123456", 
	       "telephone-type", R_TELEPHONE_HOME, NULL);
  r_card_add_telephone(R_CARD(card), tel);

  tel = r_telephone_new();
  g_object_set(tel, "telephone-number", "0968 987654", 
	       "telephone-type", R_TELEPHONE_WORK, NULL);
  r_card_add_telephone(R_CARD(card), tel);

  g_print("\nadding net addresses...");

  net = r_net_address_new();
  g_object_set(net, "url", "nicolafragale@libero.it", 
	       "url-type", R_NET_ADDRESS_EMAIL, NULL);
  r_card_add_net_address(R_CARD(card), net);
  
  net = r_net_address_new();
  g_object_set(net, "url", "http://digilander.libero.it/nfragale", 
	       "url-type", R_NET_ADDRESS_WEB, NULL );
  r_card_add_net_address(R_CARD(card), net);  

  g_print("\nCard builded successfully...");

  /* Do stuffs 
   */
  g_print("\n\nCopying card...");
  g_print("\nI will copy the personal card");
  press_key();

  copia = (RPersonalCard*) r_card_copy(R_CARD(card));
  g_object_get(card, "card-name", &name, NULL);
  tmp = g_strdup_printf("%s (Copia)", name);
  g_object_set(R_CARD(copia), "card-name", tmp, NULL);
  g_free(tmp);

  g_print("\n\nFreeing memory...");
  press_key();

  r_card_free(R_CARD(card));
  r_card_free(R_CARD(copia));

  g_print("\n\nIt works... ;-)\n\n");
  return 0;
}
