#include <glib.h>
#include <glib-object.h>

#include <libral.h>



int 
main(int argc, char* argv[])
{
  RRef* ref;
  gchar *info;
  gulong ref_to, ref_from;  

  g_type_init();
  r_lib_init();

  ref = r_ref_new(123);

  g_print("\nSetting info for ref:");
  g_print("\nI'll set: rappresentante di QualcheAzienda Srl");

  /* object has a reference to #123 and is referenced by #987654321 */
  g_object_set(G_OBJECT(ref), 
	       "ref-from", 987654321, 
	       "ref-info", "rappresentante di QualcheAzienda Srl", NULL);

  g_print("\nOk...\n\nGet data from object");
  g_object_get(G_OBJECT(ref), "ref-to", &ref_to, "ref-info", &info, NULL);
  
  g_print("\nOk...\n\nObject's data:"
	  "\nCard Ref (card's id): %ld"
	  "\nCompany infos: %s", 
	  ref_to, info);

  r_ref_free(ref);
  
  g_print("\n\nIt works... ;-)\n\n");

  return 0;
}
  

