#include <glib.h>
#include <glib/gstdio.h>
#include <glib-object.h>

#include <libral.h>


int 
main(int argc, char* argv[])
{
  RAbook* book;
  gchar* file;
  gchar* out;
  gpointer data;
  gpointer plugin;

  if (argc < 3)
    {
      g_print("\nsyntax: vcard file.vcard file.rub\n");
      g_print("\nRead the vcard file and write data in rub file\n\n");
      
      return -1;
    }

  g_type_init();
  r_lib_init();
  
  book = r_abook_new();
  
  if (argc == 1)
    {
      file = g_strdup("./rubrica.vcd");
      out  = g_strdup("./rubrica.rub");
    }
  else
    {
      file = g_strdup(argv[1]);
      out  = g_strdup(argv[2]);
    }
  
  g_object_set(book, 
	       "addressbook-name", file, 
	       "addressbook-path", ".", NULL);  
  
  if (r_abook_open_file(book, file))
    {
      gchar *name, *path;
      
      g_object_get(book, 
		   "addressbook-name", &name, 
		   "addressbook-path", &path, NULL);
      
      g_print("\nAddressbook: %s (path: %s) successfully opened", name, path);
      g_print("\nItems in addressbook: %d",
	      r_abook_get_items(R_ABOOK(book)));
      
      g_print("\n\nList addressbook's cards");
      data = r_abook_get_card(R_ABOOK(book));
      for (; data; data = r_abook_get_next_card(R_ABOOK(book)))
	{
	  gchar* name;
	  
	  g_object_get(R_CARD(data), "card-name", &name, NULL);
	  g_print("\n*** Card: %s", name);
	}
    }
  else
    g_error("\nFile not found");
  
  g_print("\n\nSave addressbook");
  if (r_abook_plugin_from_file(book, out))
    {      
      plugin = r_abook_get_plugin(book);
      g_print("\nChoosed %s plugin", r_plugin_get_name(R_PLUGIN(plugin)));
      g_print("\nPlugin's info: %s", r_plugin_get_info(R_PLUGIN(plugin)));
    }
  else 
    {
      g_print("\nChoosing rubrica plugin");
      if (r_abook_load_plugin(book, "rubrica"))
	g_print("\nPlugin loaded");
      else
	g_error("\nCan't get plugin");
    }
  
  g_remove(out);
  if(!r_abook_save_file(R_ABOOK(book), out, 0))    
    g_print("\nCan't save file");
  
  g_print("\n\nIt works... ;-)\n\n");

  return 0;
}


