#include <glib.h>

#include <libral.h>

void press_key(void)
{
  gchar key;

  g_print("\npress a key");
  scanf("%c", &key);
}

int 
main (int argc, char* argv[])
{
  RWork* work;
  RWork* copy;
  gchar *assignment = NULL, *org = NULL, *dep = NULL, *subdep = NULL;
  gchar *manager = NULL, *manager_phone = NULL;
  gchar *collaborator = NULL, *collaborator_phone = NULL;
						       
  g_type_init();
  r_lib_init();

  g_print("\nTesting the work object");
  press_key();

  work = r_work_new();

  g_print("\nSetting work's values...");
  
  // leave empty department and sub-department 
  g_object_set(work, 
	       "assignment", "my role in company",
	       "organization", "the organization",
	       "manager-name", "Dr. Manager",
	       "manager-phone", "555-444-333",
	       "collaborator", "Dr. Collaborator",
	       "collaborator-phone", "555-333-444", NULL);
  g_print(" ok");

  
  g_print("\n\nTest check property");
  if (r_work_check(work, "assignment", &assignment))
    g_print("\nassignment check success (expected result) - assignment is: %s",
	    assignment);
  else
    g_print("\nCheck fails");
  
  if (r_work_check(work, "department", &dep))
    g_print("\nDepartment check success - Department is: %s", dep);
  else
    g_print("\nCheck fails (expected result)");
  
  if (r_work_check(work, "sub-department", &subdep))
    g_print("\nSub department check success -  Sub department is: %s", subdep);
  else
    g_print("\nCheck fails (expected result)");
  
  press_key();  

  g_print("\n\nSet a value for department and sub department");
  g_object_set(work, 
	       "department", "My department", 
	       "sub-department", "Sub dep", NULL);  

  g_print("\n\nGetting work's values...");
  g_object_get(work, 
	       "assignment",         &assignment,
	       "organization",       &org,
	       "department",         &dep,
	       "sub-department",     &subdep,
	       "manager-name",       &manager,
	       "manager-phone",      &manager_phone,
	       "collaborator",       &collaborator,
	       "collaborator-phone", &collaborator_phone, NULL);
  g_print(" ok");
  
  g_print("\n\nPrint values");
  g_print("\nAssignment: %s",           assignment);
  g_print("\nOrganization: %s",         org);
  g_print("\nDepartment: %s",           dep);
  g_print("\nSub department: %s",       subdep);
  g_print("\nManager: %s",              manager);
  g_print("\nManager's phone: %s",      manager_phone);
  g_print("\nCollaborator: %s",         collaborator);
  g_print("\nCollaborator's phone: %s", collaborator_phone);
  
  g_print("\n\nCopy test");
  press_key();

  g_print("\nCopying the work...");  
  copy = r_work_copy(work);
  g_print(" ok");

  g_print("\nGetting copy's values...");
  g_object_get(copy, 
	       "assignment",         &assignment,
	       "organization",       &org,
	       "department",         &dep,
	       "sub-department",     &subdep,
	       "manager-name",       &manager,
	       "manager-phone",      &manager_phone,
	       "collaborator",       &collaborator,
	       "collaborator-phone", &collaborator_phone, NULL);
  g_print(" ok");
  
  g_print("\n\nPrint copy's values");
  g_print("\nAssignment: %s",           assignment);
  g_print("\nOrganization: %s",         org);
  g_print("\nDepartment: %s",           dep);
  g_print("\nSub department: %s",       subdep);
  g_print("\nManager: %s",              manager);
  g_print("\nManager's phone: %s",      manager_phone);
  g_print("\nCollaborator: %s",         collaborator);
  g_print("\nCollaborator's phone: %s", collaborator_phone);
  
  g_print("\n\nFree the memory");
  g_print("\nFree the work...");
  r_work_free(work);
  g_print(" ok");

  g_print("\nFree the copy...");
  r_work_free(copy);
  g_print(" ok");

  g_print("\n\nIt works... ;-)\n\n");

  return 0;
}
