/***  B4SOI 11/30/2005 Xuemei (Jane) Xi Release   ***/

/**********
 * Copyright 2005 Regents of the University of California.  All rights reserved.
 * Authors: 1998 Samuel Fung, Dennis Sinitsky and Stephen Tang
 * Authors: 1999-2004 Pin Su, Hui Wan, Wei Jin, b3soi.c
 * Authors: 2005- Hui Wan, Xuemei Xi, Ali Niknejad, Chenming Hu.
 * File: b4soi.c          
 * Modified by Hui Wan, Xuemei Xi 11/30/2005 
 **********/


#include "ngspice.h"
#include "devdefs.h"
#include "b4soidef.h"
#include "suffix.h"

IFparm B4SOIpTable[] = { /* parameters */
IOP( "l",   B4SOI_L,      IF_REAL   , "Length"),
IOP( "w",   B4SOI_W,      IF_REAL   , "Width"),
IOP( "m",   B4SOI_M,      IF_REAL   , "Parallel Multiplier"),
IOP( "nf",  B4SOI_NF,     IF_REAL   , "Number of fingers"),
IOP( "sa",  B4SOI_SA,     IF_REAL   , "distance between  OD edge to poly of one side "),
IOP( "sb",  B4SOI_SB,     IF_REAL   , "distance between  OD edge to poly of the other side"),
IOP( "sd",  B4SOI_SD,     IF_REAL   , "distance between neighbour fingers"),
IOP( "ad",  B4SOI_AD,     IF_REAL   , "Drain area"),
IOP( "as",  B4SOI_AS,     IF_REAL   , "Source area"),
IOP( "pd",  B4SOI_PD,     IF_REAL   , "Drain perimeter"),
IOP( "ps",  B4SOI_PS,     IF_REAL   , "Source perimeter"),
IOP( "nrd", B4SOI_NRD,    IF_REAL   , "Number of squares in drain"),
IOP( "nrs", B4SOI_NRS,    IF_REAL   , "Number of squares in source"),
IOP( "off", B4SOI_OFF,    IF_FLAG   , "Device is initially off"),
IP( "ic",  B4SOI_IC,     IF_REALVEC , "Vector of DS,GS,BS initial voltages"),
OP( "gmbs",         B4SOI_GMBS,       IF_REAL,    "Gmb"),
OP( "gm",           B4SOI_GM,         IF_REAL,    "Gm"),
OP( "gmids",        B4SOI_GMID,       IF_REAL,    "Gm/Ids"),
OP( "gds",          B4SOI_GDS,        IF_REAL,    "Gds"),
OP( "vdsat",        B4SOI_VDSAT,      IF_REAL,    "Vdsat"),
OP( "vth",          B4SOI_VON,        IF_REAL,    "Vth"),
OP( "ids",          B4SOI_CD,         IF_REAL,    "Ids"),
OP( "vbs",          B4SOI_VBS,        IF_REAL,    "Vbs"),
OP( "vgs",          B4SOI_VGS,        IF_REAL,    "Vgs"),
OP( "vds",          B4SOI_VDS,        IF_REAL,    "Vds"),
OP( "ves",	    B4SOI_VES,	      IF_REAL,    "Ves"),
OP( "ibd",          B4SOI_IBD,        IF_REAL,    "Ibd"),
OP( "ibs",          B4SOI_IBS,        IF_REAL,    "Ibs"),
OP( "isub",         B4SOI_ISUB,       IF_REAL,    "Isub"),
OP( "igidl",        B4SOI_IGIDL,      IF_REAL,    "Igidl"),
OP( "igs",          B4SOI_IGS,        IF_REAL,    "Igs"),
OP( "igd",          B4SOI_IGD,        IF_REAL,    "Igd"),
OP( "igb",          B4SOI_IGB,        IF_REAL,    "Igb"),
OP( "igcs",         B4SOI_IGCS,       IF_REAL,    "Igcs"),
OP( "igcd",         B4SOI_IGCD,       IF_REAL,    "Igcd"),
OP( "cgg",         B4SOI_CGG,       IF_REAL,    "Cggb"),
OP( "cgs",         B4SOI_CGS,       IF_REAL,    "Cgsb"),
OP( "cgd",         B4SOI_CGD,       IF_REAL,    "Cgdb"),
OP( "cbg",         B4SOI_CBG,       IF_REAL,    "Cbgb"),
OP( "cbd",         B4SOI_CBD,       IF_REAL,    "Cbdb"),
OP( "cbs",         B4SOI_CBS,       IF_REAL,    "Cbsb"),
OP( "cdg",         B4SOI_CDG,       IF_REAL,    "Cdgb"),
OP( "cdd",         B4SOI_CDD,       IF_REAL,    "Cddb"),
OP( "cds",         B4SOI_CDS,       IF_REAL,    "Cdsb"),
OP( "capbd",       B4SOI_CAPBD,      IF_REAL,    "Capbd"),
OP( "capbs",       B4SOI_CAPBS,      IF_REAL,    "Capbs"),
OP( "qg",          B4SOI_QG,         IF_REAL,    "Qgate"),
OP( "qb",          B4SOI_QB,         IF_REAL,    "Qbulk"),
OP( "qd",          B4SOI_QD,         IF_REAL,    "Qdrain"),
OP( "qs",          B4SOI_QS,         IF_REAL,    "Qsource"),

IOP( "bjtoff", B4SOI_BJTOFF,	      IF_INTEGER, "BJT on/off flag"),
IOP( "debug", B4SOI_DEBUG,	      IF_INTEGER, "BJT on/off flag"),
IOP( "rth0", B4SOI_RTH0,  IF_REAL,    "Instance Thermal Resistance"),
IOP( "cth0", B4SOI_CTH0,  IF_REAL,    "Instance Thermal Capacitance"),
IOP( "nrb", B4SOI_NRB,    IF_REAL,    "Number of squares in body"),
IOP( "frbody", B4SOI_FRBODY,    IF_REAL,    "layout dependent body-resistance coefficient"),

/* v4.0 */
IOP( "nf",  B4SOI_NF,     IF_REAL   , "Number of fingers"),
IOP( "rbdb", B4SOI_RBDB,  IF_REAL   , "Body resistance"),
IOP( "rbsb", B4SOI_RBSB,  IF_REAL   , "Body resistance"),
IOP( "delvto", B4SOI_DELVTO,  IF_REAL, "Zero bias threshold voltage variation"),
/* v4.0 end */

IOP( "soimod", B4SOI_SOIMOD, IF_INTEGER,    "Instance model selector for PD/FD operation"), /* v3.2 */

/* v2.0 release */
IOP( "nbc",      B4SOI_NBC,      IF_REAL, "Number of body contact isolation edge"),
IOP( "nseg",     B4SOI_NSEG,     IF_REAL, "Number segments for width partitioning"),
IOP( "pdbcp",    B4SOI_PDBCP,    IF_REAL, "Perimeter length for bc parasitics at drain side"),
IOP( "psbcp",    B4SOI_PSBCP,    IF_REAL, "Perimeter length for bc parasitics at source side"),
IOP( "agbcp",    B4SOI_AGBCP,    IF_REAL, "Gate to body overlap area for bc parasitics"),
IOP( "agbcpd",   B4SOI_AGBCPD,   IF_REAL, "Gate to body overlap area for bc parasitics in DC"),
IOP( "aebcp",    B4SOI_AEBCP,    IF_REAL, "Substrate to body overlap area for bc prasitics"),
IOP( "vbsusr",   B4SOI_VBSUSR,   IF_REAL, "Vbs specified by user"),
IOP( "tnodeout", B4SOI_TNODEOUT, IF_FLAG, "Flag indicating external temp node"),

/*v3.1 added rgatemod */
IOP( "rgatemod", B4SOI_RGATEMOD, IF_INTEGER, "Gate resistance model selector"),
/*v3.1 added rgatemod */
IOP( "rbodymod", B4SOI_RBODYMOD, IF_INTEGER, "Body R model selector"),/* v4.0 */
};

IFparm B4SOImPTable[] = { /* model parameters */
IOP( "capmod", B4SOI_MOD_CAPMOD, IF_INTEGER, "Capacitance model selector"),
IOP( "mobmod", B4SOI_MOD_MOBMOD, IF_INTEGER, "Mobility model selector"),
/*IOP( "noimod", B4SOI_MOD_NOIMOD, IF_INTEGER, "Noise model selector"), v3.2 */
IOP( "paramchk", B4SOI_MOD_PARAMCHK, IF_INTEGER, "Model parameter checking selector"),
IOP( "binunit", B4SOI_MOD_BINUNIT, IF_INTEGER, "Bin  unit  selector"),
IOP( "version", B4SOI_MOD_VERSION, IF_REAL, " parameter for model version"),
IOP( "tox", B4SOI_MOD_TOX, IF_REAL, "Gate oxide thickness in meters"),
IOP( "toxm", B4SOI_MOD_TOXM, IF_REAL, "Gate oxide thickness used in extraction"), /* v3.2 */
IOP( "dtoxcv", B4SOI_MOD_DTOXCV, IF_REAL, "Delta oxide thickness in meters in CapMod3"), /* v2.2.3 */

IOP( "cdsc", B4SOI_MOD_CDSC, IF_REAL, "Drain/Source and channel coupling capacitance"),
IOP( "cdscb", B4SOI_MOD_CDSCB, IF_REAL, "Body-bias dependence of cdsc"), 
IOP( "cdscd", B4SOI_MOD_CDSCD, IF_REAL, "Drain-bias dependence of cdsc"), 
IOP( "cit", B4SOI_MOD_CIT, IF_REAL, "Interface state capacitance"),
IOP( "nfactor", B4SOI_MOD_NFACTOR, IF_REAL, "Subthreshold swing Coefficient"),
IOP( "vsat", B4SOI_MOD_VSAT, IF_REAL, "Saturation velocity at tnom"),
IOP( "at", B4SOI_MOD_AT, IF_REAL, "Temperature coefficient of vsat"),
IOP( "a0", B4SOI_MOD_A0, IF_REAL, "Non-uniform depletion width effect coefficient."), 
IOP( "ags", B4SOI_MOD_AGS, IF_REAL, "Gate bias  coefficient of Abulk."), 
IOP( "a1", B4SOI_MOD_A1, IF_REAL, "Non-saturation effect coefficient"),
IOP( "a2", B4SOI_MOD_A2, IF_REAL, "Non-saturation effect coefficient"),
IOP( "keta", B4SOI_MOD_KETA, IF_REAL, "Body-bias coefficient of non-uniform depletion width effect."),
IOP( "nsub", B4SOI_MOD_NSUB, IF_REAL, "Substrate doping concentration with polarity"),
IOP( "nch", B4SOI_MOD_NPEAK, IF_REAL, "Channel doping concentration"),
IOP( "ngate", B4SOI_MOD_NGATE, IF_REAL, "Poly-gate doping concentration"),
IOP( "gamma1", B4SOI_MOD_GAMMA1, IF_REAL, "Vth body coefficient"),
IOP( "gamma2", B4SOI_MOD_GAMMA2, IF_REAL, "Vth body coefficient"),
IOP( "vbx", B4SOI_MOD_VBX, IF_REAL, "Vth transition body Voltage"),
IOP( "vbm", B4SOI_MOD_VBM, IF_REAL, "Maximum body voltage"),

IOP( "xt", B4SOI_MOD_XT, IF_REAL, "Doping depth"),
IOP( "k1", B4SOI_MOD_K1, IF_REAL, "Bulk effect coefficient 1"),
IOP( "kt1", B4SOI_MOD_KT1, IF_REAL, "Temperature coefficient of Vth"),
IOP( "kt1l", B4SOI_MOD_KT1L, IF_REAL, "Temperature coefficient of Vth"),
IOP( "kt2",  B4SOI_MOD_KT2, IF_REAL, "Body-coefficient of kt1"),
IOP( "k2",   B4SOI_MOD_K2,  IF_REAL, "Bulk effect coefficient 2"),
IOP( "k3",   B4SOI_MOD_K3,  IF_REAL, "Narrow width effect coefficient"),
IOP( "k3b",  B4SOI_MOD_K3B, IF_REAL, "Body effect coefficient of k3"),
IOP( "w0",   B4SOI_MOD_W0,  IF_REAL, "Narrow width effect parameter"),
IOP( "lpe0",  B4SOI_MOD_LPE0, IF_REAL, "Lateral non-uniform doping effect"),
IOP( "lpeb",  B4SOI_MOD_LPEB, IF_REAL, "Lateral non-uniform doping effect for body bias"),
IOP( "dvt0", B4SOI_MOD_DVT0, IF_REAL, "Short channel effect coeff. 0"),
IOP( "dvt1", B4SOI_MOD_DVT1, IF_REAL, "Short channel effect coeff. 1"),
IOP( "dvt2", B4SOI_MOD_DVT2, IF_REAL, "Short channel effect coeff. 2"),
IOP( "dvt0w", B4SOI_MOD_DVT0W, IF_REAL, "Narrow Width coeff. 0"),
IOP( "dvt1w", B4SOI_MOD_DVT1W, IF_REAL, "Narrow Width effect coeff. 1"),
IOP( "dvt2w", B4SOI_MOD_DVT2W, IF_REAL, "Narrow Width effect coeff. 2"),
IOP( "drout", B4SOI_MOD_DROUT, IF_REAL, "DIBL coefficient of output resistance"),
IOP( "dsub", B4SOI_MOD_DSUB, IF_REAL, "DIBL coefficient in the subthreshold region"),
IOP( "vth0", B4SOI_MOD_VTH0, IF_REAL,"Threshold voltage"),
IOP( "vtho", B4SOI_MOD_VTH0, IF_REAL,"Threshold voltage"),
IOP( "ua", B4SOI_MOD_UA, IF_REAL, "Linear gate dependence of mobility"),
IOP( "ua1", B4SOI_MOD_UA1, IF_REAL, "Temperature coefficient of ua"),
IOP( "ub", B4SOI_MOD_UB, IF_REAL, "Quadratic gate dependence of mobility"),
IOP( "ub1", B4SOI_MOD_UB1, IF_REAL, "Temperature coefficient of ub"),
IOP( "uc", B4SOI_MOD_UC, IF_REAL, "Body-bias dependence of mobility"),
IOP( "uc1", B4SOI_MOD_UC1, IF_REAL, "Temperature coefficient of uc"),
IOP( "u0", B4SOI_MOD_U0, IF_REAL, "Low-field mobility at Tnom"),
IOP( "ute", B4SOI_MOD_UTE, IF_REAL, "Temperature coefficient of mobility"),
IOP( "voff", B4SOI_MOD_VOFF, IF_REAL, "Threshold voltage offset"),
IOP( "tnom", B4SOI_MOD_TNOM, IF_REAL, "Parameter measurement temperature"),
IOP( "cgso", B4SOI_MOD_CGSO, IF_REAL, "Gate-source overlap capacitance per width"),
IOP( "cgdo", B4SOI_MOD_CGDO, IF_REAL, "Gate-drain overlap capacitance per width"),
IOP( "xpart", B4SOI_MOD_XPART, IF_REAL, "Channel charge partitioning"),
IOP( "delta", B4SOI_MOD_DELTA, IF_REAL, "Effective Vds parameter"),
IOP( "rsh", B4SOI_MOD_RSH, IF_REAL, "Source-drain sheet resistance"),
IOP( "rdsw", B4SOI_MOD_RDSW, IF_REAL, "Source-drain resistance per width"),    
IOP( "rsw", B4SOI_MOD_RSW, IF_REAL, "Source resistance per width"),  /* v4.0 */ 
IOP( "rdw", B4SOI_MOD_RDW, IF_REAL, "Drain resistance per width"),   /* v4.0 */ 
IOP( "rswmin", B4SOI_MOD_RSWMIN, IF_REAL, "Source resistance per width at high Vg"),    
IOP( "rdwmin", B4SOI_MOD_RDWMIN, IF_REAL, "Drain resistance per width at hight Vg"),    

IOP( "prwg", B4SOI_MOD_PRWG, IF_REAL, "Gate-bias effect on parasitic resistance "),    
IOP( "prwb", B4SOI_MOD_PRWB, IF_REAL, "Body-effect on parasitic resistance "),    

IOP( "prt", B4SOI_MOD_PRT, IF_REAL, "Temperature coefficient of parasitic resistance "),    
IOP( "eta0", B4SOI_MOD_ETA0, IF_REAL, "Subthreshold region DIBL coefficient"),
IOP( "etab", B4SOI_MOD_ETAB, IF_REAL, "Subthreshold region DIBL coefficient"),
IOP( "pclm", B4SOI_MOD_PCLM, IF_REAL, "Channel length modulation Coefficient"),
IOP( "pdiblc1", B4SOI_MOD_PDIBL1, IF_REAL, "Drain-induced barrier lowering coefficient"),   
IOP( "pdiblc2", B4SOI_MOD_PDIBL2, IF_REAL, "Drain-induced barrier lowering coefficient"),   
IOP( "pdiblcb", B4SOI_MOD_PDIBLB, IF_REAL, "Body-effect on drain-induced barrier lowering"),   

IOP( "pvag", B4SOI_MOD_PVAG, IF_REAL, "Gate dependence of output resistance parameter"),   

IOP( "shmod", B4SOI_MOD_SHMOD, IF_INTEGER, "Self heating mode selector"),
IOP( "ddmod", B4SOI_MOD_DDMOD, IF_INTEGER, "Dynamic depletion mode selector"),
IOP( "tbox", B4SOI_MOD_TBOX, IF_REAL, "Back gate oxide thickness in meters"),   
IOP( "tsi", B4SOI_MOD_TSI, IF_REAL, "Silicon-on-insulator thickness in meters"),   
IOP( "xj", B4SOI_MOD_XJ, IF_REAL, "Junction Depth"),   
IOP( "rth0", B4SOI_MOD_RTH0, IF_REAL, "Self-heating thermal resistance"),   
IOP( "cth0", B4SOI_MOD_CTH0, IF_REAL, "Self-heating thermal capacitance"),
IOP( "egidl", B4SOI_MOD_EGIDL, IF_REAL, "GIDL first parameter"),   
IOP( "agidl", B4SOI_MOD_AGIDL, IF_REAL, "GIDL second parameter"),   
IOP( "bgidl", B4SOI_MOD_BGIDL, IF_REAL, "GIDL third parameter"),   
IOP( "cgidl", B4SOI_MOD_CGIDL, IF_REAL, "GIDL vb parameter"),   
IOP( "ndiode", B4SOI_MOD_NDIODES, IF_REAL,"Diode non-ideality factor"),/*v4.0*/
IOP( "ndioded", B4SOI_MOD_NDIODED, IF_REAL,"Diode non-ideality factor"),/*v4.0*/
IOP( "xbjt", B4SOI_MOD_XBJT, IF_REAL, "Temperature coefficient for Isbjt"),   

IOP( "xdif", B4SOI_MOD_XDIFS, IF_REAL, "Temperature coefficient for Isdif"),
IOP( "xrec", B4SOI_MOD_XRECS, IF_REAL, "Temperature coefficient for Isrec"),   
IOP( "xtun", B4SOI_MOD_XTUNS, IF_REAL, "Temperature coefficient for Istun"),   
IOP( "xdifd", B4SOI_MOD_XDIFD, IF_REAL, "Temperature coefficient for Iddif"),
IOP( "xrecd", B4SOI_MOD_XRECD, IF_REAL, "Temperature coefficient for Idrec"),
IOP( "xtund", B4SOI_MOD_XTUND, IF_REAL, "Temperature coefficient for Idtun"),

IOP( "pbswg", B4SOI_MOD_PBSWGS, IF_REAL, "Source(gate side) sidewall junction capacitance built in potential"), /* v4.0 */
IOP( "pbswgd", B4SOI_MOD_PBSWGD, IF_REAL, "Drain(gate side) sidewall junction capacitance built in potential"), /* v4.0 */
IOP( "mjswg", B4SOI_MOD_MJSWGS, IF_REAL, "Source (gate side) sidewall junction capacitance grading coefficient"), /* v4.0 */
IOP( "mjswgd", B4SOI_MOD_MJSWGD, IF_REAL, "Drain (gate side) sidewall junction capacitance grading coefficient"), /* v4.0 */
IOP( "cjswg", B4SOI_MOD_CJSWGS, IF_REAL, "Source(gate side) sidewall junction capacitance per unit width"), 	/* v4.0 */
IOP( "cjswgd", B4SOI_MOD_CJSWGD, IF_REAL, "Drain (gate side) sidewall junction capacitance per unit width"),	/* v4.0 */
IOP( "lint", B4SOI_MOD_LINT, IF_REAL, "Length reduction parameter"),
IOP( "ll",   B4SOI_MOD_LL, IF_REAL, "Length reduction parameter"),
IOP( "llc",   B4SOI_MOD_LLC, IF_REAL, "Length reduction parameter"), /* v2.2.3 */
IOP( "lln",  B4SOI_MOD_LLN, IF_REAL, "Length reduction parameter"),
IOP( "lw",   B4SOI_MOD_LW,  IF_REAL, "Length reduction parameter"),
IOP( "lwc",   B4SOI_MOD_LWC,  IF_REAL, "Length reduction parameter"), /* v2.2.3 */
IOP( "lwn",  B4SOI_MOD_LWN, IF_REAL, "Length reduction parameter"),
IOP( "lwl",  B4SOI_MOD_LWL, IF_REAL, "Length reduction parameter"),
IOP( "lwlc",  B4SOI_MOD_LWLC, IF_REAL, "Length reduction parameter"), /* v2.2.3 */

IOP( "wr",   B4SOI_MOD_WR, IF_REAL, "Width dependence of rds"),
IOP( "wint", B4SOI_MOD_WINT, IF_REAL, "Width reduction parameter"),
IOP( "dwg",  B4SOI_MOD_DWG, IF_REAL, "Width reduction parameter"),
IOP( "dwb",  B4SOI_MOD_DWB, IF_REAL, "Width reduction parameter"),

IOP( "wl",   B4SOI_MOD_WL, IF_REAL, "Width reduction parameter"),
IOP( "wlc",   B4SOI_MOD_WLC, IF_REAL, "Width reduction parameter"), /* v2.2.3 */
IOP( "wln",  B4SOI_MOD_WLN, IF_REAL, "Width reduction parameter"),
IOP( "ww",   B4SOI_MOD_WW, IF_REAL, "Width reduction parameter"),
IOP( "wwc",   B4SOI_MOD_WWC, IF_REAL, "Width reduction parameter"), /* v2.2.3 */
IOP( "wwn",  B4SOI_MOD_WWN, IF_REAL, "Width reduction parameter"),
IOP( "wwl",  B4SOI_MOD_WWL, IF_REAL, "Width reduction parameter"),
IOP( "wwlc",  B4SOI_MOD_WWLC, IF_REAL, "Width reduction parameter"), /* v2.2.3 */

IOP( "b0",  B4SOI_MOD_B0, IF_REAL, "Abulk narrow width parameter"),
IOP( "b1",  B4SOI_MOD_B1, IF_REAL, "Abulk narrow width parameter"),

IOP( "cgsl", B4SOI_MOD_CGSL, IF_REAL, "New C-V model parameter"),
IOP( "cgdl", B4SOI_MOD_CGDL, IF_REAL, "New C-V model parameter"),
IOP( "ckappa", B4SOI_MOD_CKAPPA, IF_REAL, "New C-V model parameter"),
IOP( "cf",  B4SOI_MOD_CF, IF_REAL, "Fringe capacitance parameter"),
IOP( "clc", B4SOI_MOD_CLC, IF_REAL, "Vdsat parameter for C-V model"),
IOP( "cle", B4SOI_MOD_CLE, IF_REAL, "Vdsat parameter for C-V model"),
IOP( "dwc", B4SOI_MOD_DWC, IF_REAL, "Delta W for C-V model"),
IOP( "dlc", B4SOI_MOD_DLC, IF_REAL, "Delta L for C-V model"),

IOP( "alpha0", B4SOI_MOD_ALPHA0, IF_REAL, "substrate current model parameter"),

IOP( "noia", B4SOI_MOD_NOIA, IF_REAL, "Flicker noise parameter"),
IOP( "noib", B4SOI_MOD_NOIB, IF_REAL, "Flicker noise parameter"),
IOP( "noic", B4SOI_MOD_NOIC, IF_REAL, "Flicker noise parameter"),

/* v3.2 */
IOP( "fnoimod", B4SOI_MOD_FNOIMOD, IF_INTEGER, "Flicker noise model selector"),
IOP( "tnoimod", B4SOI_MOD_TNOIMOD, IF_INTEGER, "Thermal noise model selector"),
IOP( "tnoia", B4SOI_MOD_TNOIA, IF_REAL, "Thermal noise parameter"),
IOP( "tnoib", B4SOI_MOD_TNOIB, IF_REAL, "Thermal noise parameter"),
IOP( "rnoia", B4SOI_MOD_RNOIA, IF_REAL, "Thermal noise coefficient"),
IOP( "rnoib", B4SOI_MOD_RNOIB, IF_REAL, "Thermal noise coefficient"),
IOP( "ntnoi", B4SOI_MOD_NTNOI, IF_REAL, "Thermal noise parameter"),
/* v3.2 */

/* v4.0  stress effect*/
IOP( "saref", B4SOI_MOD_SAREF, IF_REAL, "Reference distance between OD edge to poly of one side"),
IOP( "sbref", B4SOI_MOD_SBREF, IF_REAL, "Reference distance between OD edge to poly of the other side"),
IOP( "wlod", B4SOI_MOD_WLOD, IF_REAL, "Width parameter for stress effect"),
IOP( "ku0", B4SOI_MOD_KU0, IF_REAL, "Mobility degradation/enhancement coefficient for LOD"),
IOP( "kvsat", B4SOI_MOD_KVSAT, IF_REAL, "Saturation velocity degradation/enhancement parameter for LOD"),
IOP( "kvth0", B4SOI_MOD_KVTH0, IF_REAL, "Threshold degradation/enhancement parameter for LOD"),
IOP( "tku0", B4SOI_MOD_TKU0, IF_REAL, "Temperature coefficient of KU0"),
IOP( "llodku0",  B4SOI_MOD_LLODKU0, IF_REAL, "Length parameter for u0 LOD effect"),
IOP( "wlodku0",  B4SOI_MOD_WLODKU0, IF_REAL, "Width parameter for u0 LOD effect"),
IOP( "llodvth",  B4SOI_MOD_LLODVTH, IF_REAL, "Length parameter for vth LOD effect"),
IOP( "wlodvth",  B4SOI_MOD_WLODVTH, IF_REAL, "Width parameter for vth LOD effect"),
IOP( "lku0", B4SOI_MOD_LKU0, IF_REAL, "Length dependence of ku0"),
IOP( "wku0", B4SOI_MOD_WKU0, IF_REAL, "Width dependence of ku0"),
IOP( "pku0", B4SOI_MOD_PKU0, IF_REAL, "Cross-term dependence of ku0"),
IOP( "lkvth0", B4SOI_MOD_LKVTH0, IF_REAL, "Length dependence of kvth0"),
IOP( "wkvth0", B4SOI_MOD_WKVTH0, IF_REAL, "Width dependence of kvth0"),
IOP( "pkvth0", B4SOI_MOD_PKVTH0, IF_REAL, "Cross-term dependence of kvth0"),
IOP( "stk2", B4SOI_MOD_STK2, IF_REAL, "K2 shift factor related to stress effect on vth"),
IOP( "lodk2", B4SOI_MOD_LODK2, IF_REAL, "K2 shift modification factor for stress effect"),
IOP( "steta0", B4SOI_MOD_STETA0, IF_REAL, "eta0 shift factor related to stress effect on vth"),
IOP( "lodeta0", B4SOI_MOD_LODETA0, IF_REAL, "eta0 shift modification factor for stress effect"),
/* v4.0 stress effect end */

/* v4.0 */
IOP( "gbmin", B4SOI_MOD_GBMIN, IF_REAL, "Minimum body conductance"),
IOP( "rbdb", B4SOI_MOD_RBDB, IF_REAL, "Resistance between bNode and dbNode"),
IOP( "rbsb", B4SOI_MOD_RBSB, IF_REAL, "Resistance between bNode and sbNode"),
IOP( "bf", B4SOI_MOD_BF, IF_REAL, "Flicker noise length dependence exponent"),
IOP( "w0flk", B4SOI_MOD_W0FLK, IF_REAL, "Flicker noise width dependence"),
IOP( "frbody", B4SOI_MOD_FRBODY,IF_REAL, "Layout dependent rbody multiplier "),
IOP( "dvtp0",  B4SOI_MOD_DVTP0, IF_REAL, "First parameter for Vth shift due to pocket"),
IOP( "ldvtp0",  B4SOI_MOD_LDVTP0, IF_REAL, "Length dependence of dvtp0"),
IOP( "wdvtp0",  B4SOI_MOD_WDVTP0, IF_REAL, "Width dependence of dvtp0"),
IOP( "pdvtp0",  B4SOI_MOD_PDVTP0, IF_REAL, "Cross-term dependence of dvtp0"),
IOP( "dvtp1",  B4SOI_MOD_DVTP1, IF_REAL, "Second parameter for Vth shift due to pocket"),
IOP( "ldvtp1",  B4SOI_MOD_LDVTP1, IF_REAL, "Length dependence of dvtp1"),
IOP( "wdvtp1",  B4SOI_MOD_WDVTP1, IF_REAL, "Width dependence of dvtp1"),
IOP( "pdvtp1",  B4SOI_MOD_PDVTP1, IF_REAL, "Cross-term dependence of dvtp1"),
IOP( "minv", B4SOI_MOD_MINV, IF_REAL, "For moderate invversion in Vgsteff"),
IOP( "lminv", B4SOI_MOD_LMINV, IF_REAL, "Length dependence of minv"),
IOP( "wminv", B4SOI_MOD_WMINV, IF_REAL, "width dependence of minv"),
IOP( "pminv", B4SOI_MOD_PMINV, IF_REAL, "Cross-term dependence of minv"),
IOP( "pdits", B4SOI_MOD_PDITS, IF_REAL, "Coefficient for drain-induced Vth shifts"),
IOP( "pditsl", B4SOI_MOD_PDITSL, IF_REAL, "Length dependence of drain-induced Vth shifts"),
IOP( "pditsd", B4SOI_MOD_PDITSD, IF_REAL, "Vds dependence of drain-induced Vth shifts"),
IOP( "fprout", B4SOI_MOD_FPROUT, IF_REAL, "Rout degradation coefficient for pocket devices"),
IOP( "lfprout", B4SOI_MOD_LFPROUT, IF_REAL, "Length dependence of pdiblcb"),
IOP( "lpdits", B4SOI_MOD_LPDITS, IF_REAL, "Length dependence of pdits"),
IOP( "lpditsd", B4SOI_MOD_LPDITSD, IF_REAL, "Length dependence of pditsd"),
IOP( "wfprout", B4SOI_MOD_WFPROUT, IF_REAL, "Width dependence of pdiblcb"),
IOP( "wpdits", B4SOI_MOD_WPDITS, IF_REAL, "Width dependence of pdits"),
IOP( "wpditsd", B4SOI_MOD_WPDITSD, IF_REAL, "Width dependence of pditsd"),
IOP( "pfprout", B4SOI_MOD_PFPROUT, IF_REAL, "Cross-term dependence of pdiblcb"),
IOP( "ppdits", B4SOI_MOD_PPDITS, IF_REAL, "Cross-term dependence of pdits"),
IOP( "ppditsd", B4SOI_MOD_PPDITSD, IF_REAL, "Cross-term dependence of pditsd"),

/* v4.0 */

IOP( "em", B4SOI_MOD_EM, IF_REAL, "Flicker noise parameter"),
IOP( "ef", B4SOI_MOD_EF, IF_REAL, "Flicker noise frequency exponent"),
IOP( "af", B4SOI_MOD_AF, IF_REAL, "Flicker noise exponent"),
IOP( "kf", B4SOI_MOD_KF, IF_REAL, "Flicker noise coefficient"),
IOP( "noif", B4SOI_MOD_NOIF, IF_REAL, "Floating body excess noise ideality factor"),

/* v2.0 release */
IOP( "k1w1", B4SOI_MOD_K1W1, IF_REAL, "First Body effect width dependent parameter"),    
IOP( "k1w2", B4SOI_MOD_K1W2, IF_REAL, "Second Boby effect width dependent parameter"),
IOP( "ketas", B4SOI_MOD_KETAS, IF_REAL, "Surface potential adjustment for bulk charge effect"),
IOP( "dwbc", B4SOI_MOD_DWBC, IF_REAL, "Width offset for body contact isolation edge"),
IOP( "beta0", B4SOI_MOD_BETA0, IF_REAL, "First Vds dependent parameter of impact ionizition current"),
IOP( "beta1", B4SOI_MOD_BETA1, IF_REAL, "Second Vds dependent parameter of impact ionizition current"),
IOP( "beta2", B4SOI_MOD_BETA2, IF_REAL, "Third Vds dependent parameter of impact ionizition current"),
IOP( "vdsatii0", B4SOI_MOD_VDSATII0, IF_REAL, "Nominal drain saturation voltage at threshold for impact ionizition current"),
IOP( "tii", B4SOI_MOD_TII, IF_REAL, "Temperature dependent parameter for impact ionizition"),
IOP( "lii", B4SOI_MOD_LII, IF_REAL, "Channel length dependent parameter at threshold for impact ionizition current"),
IOP( "sii0", B4SOI_MOD_SII0, IF_REAL, "First Vgs dependent parameter for impact ionizition current"),
IOP( "sii1", B4SOI_MOD_SII1, IF_REAL, "Second Vgs dependent parameter for impact ionizition current"),
IOP( "sii2", B4SOI_MOD_SII2, IF_REAL, "Third Vgs dependent parameter for impact ionizition current"),
IOP( "siid", B4SOI_MOD_SIID, IF_REAL, "Vds dependent parameter of drain saturation voltage for impact ionizition current"),
IOP( "fbjtii", B4SOI_MOD_FBJTII, IF_REAL, "Fraction of bipolar current affecting the impact ionization"),
IOP( "esatii", B4SOI_MOD_ESATII, IF_REAL, "Saturation electric field for impact ionization"),
IOP( "ntun", B4SOI_MOD_NTUNS, IF_REAL,"Reverse tunneling non-ideality factor"),
IOP( "ntund", B4SOI_MOD_NTUND, IF_REAL,"Reverse tunneling non-ideality factor"),
IOP( "nrecf0", B4SOI_MOD_NRECF0S, IF_REAL, "Recombination non-ideality factor at forward bias"),
IOP( "nrecf0d", B4SOI_MOD_NRECF0D, IF_REAL, "Recombination non-ideality factor at forward bias"),
IOP( "nrecr0", B4SOI_MOD_NRECR0S, IF_REAL, "Recombination non-ideality factor at reversed bias"),
IOP( "nrecr0d", B4SOI_MOD_NRECR0D, IF_REAL, "Recombination non-ideality factor at reversed bias"),
IOP( "isbjt", B4SOI_MOD_ISBJT, IF_REAL, "BJT injection saturation current"),
IOP( "idbjt", B4SOI_MOD_IDBJT, IF_REAL, "BJT injection saturation current"),
IOP( "isdif", B4SOI_MOD_ISDIF, IF_REAL, "Body to source/drain injection saturation current"),
IOP( "iddif", B4SOI_MOD_IDDIF, IF_REAL, "Body to source/drain injection saturation current"), /* v4.0 */
IOP( "isrec", B4SOI_MOD_ISREC, IF_REAL, "Recombination in depletion saturation current"),
IOP( "idrec", B4SOI_MOD_IDREC, IF_REAL, "Recombination in depletion saturation current"),
IOP( "istun", B4SOI_MOD_ISTUN, IF_REAL, "Reverse tunneling saturation current"),
IOP( "idtun", B4SOI_MOD_IDTUN, IF_REAL, "Reverse tunneling saturation current"),
IOP( "ln", B4SOI_MOD_LN, IF_REAL, "Electron/hole diffusion length"),
IOP( "vrec0", B4SOI_MOD_VREC0S, IF_REAL, "Voltage dependent parameter for recombination current"),
IOP( "vrec0d", B4SOI_MOD_VREC0D, IF_REAL, "Voltage dependent parameter for recombination current"),
IOP( "vtun0", B4SOI_MOD_VTUN0S, IF_REAL, "Voltage dependent parameter for tunneling current"),
IOP( "vtun0d", B4SOI_MOD_VTUN0D, IF_REAL, "Voltage dependent parameter for tunneling current"),
IOP( "nbjt", B4SOI_MOD_NBJT, IF_REAL, "Power coefficient of channel length dependency for bipolar current"),
IOP( "lbjt0", B4SOI_MOD_LBJT0, IF_REAL, "Refferenc channel length for bipolar cuurent"),
IOP( "ldif0", B4SOI_MOD_LDIF0, IF_REAL, "Channel-length dependency coefficient of diffusion cap"),
IOP( "vabjt", B4SOI_MOD_VABJT, IF_REAL, "Early voltage for bipolar current"),
IOP( "aely", B4SOI_MOD_AELY, IF_REAL, "Channel length dependency of early voltage for bipolar cuurent"),
IOP( "ahli", B4SOI_MOD_AHLIS, IF_REAL, "High level injection parameter for bipolar current"), /* v4.0 */
IOP( "ahlid", B4SOI_MOD_AHLID, IF_REAL, "High level injection parameter for bipolar current"), /* v4.0 */
IOP( "rbody", B4SOI_MOD_RBODY, IF_REAL, "Intrinsic body contact sheet resistance"),
IOP( "rbsh", B4SOI_MOD_RBSH, IF_REAL, "Extrinsic body contact sheet resistance"),
IOP( "cgeo", B4SOI_MOD_CGEO, IF_REAL, "Gate substrate overlap capacitance per unit channel length"),
IOP( "tt", B4SOI_MOD_TT, IF_REAL, "Diffusion capacitance transit time coefficient"),
IOP( "ndif", B4SOI_MOD_NDIF, IF_REAL, "Power coefficient of channel length dependency for diffusion capacitance"),
IOP( "vsdfb", B4SOI_MOD_VSDFB, IF_REAL, "Source/drain bottom diffusion capacitance flatband voltage"),
IOP( "vsdth", B4SOI_MOD_VSDTH, IF_REAL, "Source/drain bottom diffusion capacitance threshold voltage"),
IOP( "csdmin", B4SOI_MOD_CSDMIN, IF_REAL, "Source/drain bottom diffusion minimum capacitance"),
IOP( "asd", B4SOI_MOD_ASD, IF_REAL, "Source/drain bottom diffusion smoothing parameter"),
IOP( "csdesw", B4SOI_MOD_CSDESW, IF_REAL, "Source/drain sidewall fringing capacitance per unit length"),
IOP( "ntrecf", B4SOI_MOD_NTRECF, IF_REAL, "Temperature coefficient for Nrecf"),
IOP( "ntrecr", B4SOI_MOD_NTRECR, IF_REAL, "Temperature coefficient for Nrecr"),
IOP( "dlcb", B4SOI_MOD_DLCB, IF_REAL, "Length offset fitting parameter for body charge"),
IOP( "fbody", B4SOI_MOD_FBODY, IF_REAL, "Scaling factor for body charge"),
IOP( "tcjswg", B4SOI_MOD_TCJSWGS, IF_REAL, "Temperature coefficient of Cjswgs"),
IOP( "tpbswg", B4SOI_MOD_TPBSWGS, IF_REAL, "Temperature coefficient of Pbswgs"),
IOP( "tcjswgd", B4SOI_MOD_TCJSWGD, IF_REAL, "Temperature coefficient of Cjswgd"),
IOP( "tpbswgd", B4SOI_MOD_TPBSWGD, IF_REAL, "Temperature coefficient of Pbswgd"),
IOP( "acde", B4SOI_MOD_ACDE, IF_REAL, "Exponential coefficient for charge thickness in capMod=3 for accumulation and depletion regions"),
IOP( "moin", B4SOI_MOD_MOIN, IF_REAL, "Coefficient for the gate-bias dependent surface potential"),
IOP( "noff", B4SOI_MOD_NOFF, IF_REAL, "C-V turn-on/off parameter"), /* v3.2 */
IOP( "delvt", B4SOI_MOD_DELVT, IF_REAL, "Threshold voltage adjust for CV"),
IOP( "kb1", B4SOI_MOD_KB1, IF_REAL, "Scaling factor for backgate charge"),
IOP( "dlbg", B4SOI_MOD_DLBG, IF_REAL, "Length offset fitting parameter for backgate charge"),


/* v2.2 release */
IOP( "igmod",  B4SOI_MOD_IGBMOD, IF_INTEGER, "gate-body tunneling current model selector"), /* v3.1.1 */
IOP( "igbmod", B4SOI_MOD_IGBMOD, IF_INTEGER, "gate-body tunneling current model selector"), /* v3.0 */
IOP( "igcmod", B4SOI_MOD_IGCMOD, IF_INTEGER, "gate-channel tunneling current model selector"), /* v3.0 */
IOP( "toxqm", B4SOI_MOD_TOXQM, IF_REAL, "effective oxide thickness considering quantum effect"),
IOP( "wth0", B4SOI_MOD_WTH0, IF_REAL, "Minimum width for thermal resistance calculation"),
IOP( "rhalo", B4SOI_MOD_RHALO, IF_REAL, "body halo sheet resistance"),
IOP( "ntox", B4SOI_MOD_NTOX, IF_REAL, "power term of gate current"),
IOP( "toxref", B4SOI_MOD_TOXREF, IF_REAL, "target oxide thickness"),
IOP( "ebg", B4SOI_MOD_EBG, IF_REAL, "effective bandgap in gate current calcula."),
IOP( "vevb", B4SOI_MOD_VEVB, IF_REAL, "Vaux parameter for valence-band electron tunneling"),
IOP( "alphagb1", B4SOI_MOD_ALPHAGB1, IF_REAL, "First Vox dependent parameter for gate curent in inversion"),
IOP( "betagb1", B4SOI_MOD_BETAGB1, IF_REAL, "Second Vox dependent parameter for gate currnt in inversion"),
IOP( "vgb1", B4SOI_MOD_VGB1, IF_REAL, "Third Vox dependent parameter for gate current in inversion"),
IOP( "vecb", B4SOI_MOD_VECB, IF_REAL, "Vaux parameter for conduction-band electron tunneling"),
IOP( "alphagb2", B4SOI_MOD_ALPHAGB2, IF_REAL, "First Vox dependent parameter for gate current in accumulation"),
IOP( "betagb2", B4SOI_MOD_BETAGB2, IF_REAL, "Second Vox dependent parameter for gate current in accumulation"),
IOP( "vgb2", B4SOI_MOD_VGB2, IF_REAL, "Third Vox dependent parameter for gate current in accumulation"),
IOP( "voxh", B4SOI_MOD_VOXH, IF_REAL, "the limit of Vox in gate current calculation"),
IOP( "deltavox", B4SOI_MOD_DELTAVOX, IF_REAL, "the smoothing parameter in the Vox smoothing function"),

/* v3.0 */
IOP( "aigc", B4SOI_MOD_AIGC, IF_REAL, "Parameter for Igc"),
IOP( "bigc", B4SOI_MOD_BIGC, IF_REAL, "Parameter for Igc"),
IOP( "cigc", B4SOI_MOD_CIGC, IF_REAL, "Parameter for Igc"),
IOP( "aigsd", B4SOI_MOD_AIGSD, IF_REAL, "Parameter for Igs,d"),
IOP( "bigsd", B4SOI_MOD_BIGSD, IF_REAL, "Parameter for Igs,d"),
IOP( "cigsd", B4SOI_MOD_CIGSD, IF_REAL, "Parameter for Igs,d"),
IOP( "nigc", B4SOI_MOD_NIGC, IF_REAL, "Parameter for Igc slope"),
IOP( "pigcd", B4SOI_MOD_PIGCD, IF_REAL, "Parameter for Igc partition"),
IOP( "poxedge", B4SOI_MOD_POXEDGE, IF_REAL, "Factor for the gate edge Tox"),
IOP( "dlcig", B4SOI_MOD_DLCIG, IF_REAL, "Delta L for Ig model"),

/* v3.0 */
IOP( "soimod", B4SOI_MOD_SOIMOD, IF_INTEGER, "model selector for SOI technology"), /* v3.2 bug fix */
IOP( "vbs0pd", B4SOI_MOD_VBS0PD, IF_REAL, "Upper bound of built-in potential lowering for PD operation"), /* v3.2 */
IOP( "vbs0fd", B4SOI_MOD_VBS0FD, IF_REAL, "Lower bound of built-in potential lowering for FD operation"), /* v3.2 */
IOP( "vbsa", B4SOI_MOD_VBSA, IF_REAL, "Vbs0t offset voltage"),
IOP( "nofffd", B4SOI_MOD_NOFFFD,IF_REAL, "smoothing parameter in FD module"),
IOP( "vofffd", B4SOI_MOD_VOFFFD,IF_REAL, "smoothing parameter in FD module"),
IOP( "k1b", B4SOI_MOD_K1B, IF_REAL, "first backgate body effect parameter"),
IOP( "k2b", B4SOI_MOD_K2B, IF_REAL, "second backgate body effect parameter for short channel effect"),
IOP( "dk2b", B4SOI_MOD_DK2B, IF_REAL, "third backgate body effect parameter for short channel effect"),
IOP( "dvbd0", B4SOI_MOD_DVBD0, IF_REAL, "first short-channel effect parameter in FD module"),
IOP( "dvbd1", B4SOI_MOD_DVBD1, IF_REAL, "second short-channel effect parameter in FD module"),
IOP( "moinfd", B4SOI_MOD_MOINFD, IF_REAL, "Coefficient for the gate-bias dependent surface potential in FD"),
/* v3.0 */


/* v3.1 added for RF */
IOP( "rgatemod", B4SOI_MOD_RGATEMOD, IF_INTEGER, "Gate R model selector"),
IOP("xrcrg1", B4SOI_MOD_XRCRG1, IF_REAL, "First fitting parameter the bias-dependent Rg"),
IOP("xrcrg2", B4SOI_MOD_XRCRG2, IF_REAL, "Second fitting parameter the bias-dependent Rg"),
IOP("rshg", B4SOI_MOD_RSHG, IF_REAL, "Gate sheet resistance"),
IOP("ngcon", B4SOI_MOD_NGCON, IF_REAL, "Number of gate contacts"),
IOP( "xgw",  B4SOI_MOD_XGW, IF_REAL, "Distance from gate contact center to device edge"),
IOP( "xgl",  B4SOI_MOD_XGL, IF_REAL, "Variation in Ldrawn"),
/* v3.1 added for RF end */

/* 4.0 */
IOP( "rbodymod", B4SOI_MOD_RBODYMOD, IF_INTEGER, "Body R model selector"),
/* 4.0 */
IOP( "rdsmod", B4SOI_MOD_RDSMOD, IF_INTEGER, "Bias-dependent S/D resistance model selector"),	/* v4.0 */

/* Added for binning - START */
/* Length Dependence */
/* v3.1 */
IOP( "lxj", B4SOI_MOD_LXJ, IF_REAL, "Length dependence of xj"),
IOP( "lalphagb1", B4SOI_MOD_LALPHAGB1, IF_REAL, "Length dependence of alphagb1"),
IOP( "lbetagb1", B4SOI_MOD_LBETAGB1, IF_REAL, "Length dependence of betagb1"),
IOP( "lalphagb2", B4SOI_MOD_LALPHAGB2, IF_REAL, "Length dependence of alphagb2"),
IOP( "lbetagb2", B4SOI_MOD_LBETAGB2, IF_REAL, "Length dependence of betagb2"),
IOP( "lcgsl", B4SOI_MOD_LCGSL, IF_REAL, "Length dependence of cgsl"),
IOP( "lcgdl", B4SOI_MOD_LCGDL, IF_REAL, "Length dependence of cgdl"),
IOP( "lckappa", B4SOI_MOD_LCKAPPA, IF_REAL, "Length dependence of ckappa"),
IOP( "lndif", B4SOI_MOD_LNDIF, IF_REAL, "Length dependence of ndif"),
IOP( "lute", B4SOI_MOD_LUTE, IF_REAL, "Length dependence of ute"),
IOP( "lkt1", B4SOI_MOD_LKT1, IF_REAL, "Length dependence of kt1"),
IOP( "lkt1l", B4SOI_MOD_LKT1L, IF_REAL, "Length dependence of kt1l"),
IOP( "lkt2",  B4SOI_MOD_LKT2, IF_REAL, "Length dependence of kt2"),
IOP( "lua1", B4SOI_MOD_LUA1, IF_REAL, "Length dependence of ua1"),
IOP( "lub1", B4SOI_MOD_LUB1, IF_REAL, "Length dependence of ub1"),
IOP( "luc1", B4SOI_MOD_LUC1, IF_REAL, "Length dependence of uc1"),
IOP( "lat", B4SOI_MOD_LAT, IF_REAL, "Length dependence of at"),
IOP( "lprt", B4SOI_MOD_LPRT, IF_REAL, "Length dependence of prt "),
IOP( "lntrecf", B4SOI_MOD_LNTRECF, IF_REAL, "Length dependence of ntrecf"),
IOP( "lntrecr", B4SOI_MOD_LNTRECR, IF_REAL, "Length dependence of ntrecr"),
IOP( "lxbjt", B4SOI_MOD_LXBJT, IF_REAL, "Length dependence of xbjt"),
IOP( "lxdif", B4SOI_MOD_LXDIFS, IF_REAL, "Length dependence of xdif"),
IOP( "lxrec", B4SOI_MOD_LXRECS, IF_REAL, "Length dependence of xrec"),
IOP( "lxtun", B4SOI_MOD_LXTUNS, IF_REAL, "Length dependence of xtun"),
IOP( "lxdifd", B4SOI_MOD_LXDIFD, IF_REAL, "Length dependence of xdifd"),
IOP( "lxrecd", B4SOI_MOD_LXRECD, IF_REAL, "Length dependence of xrecd"),
IOP( "lxtund", B4SOI_MOD_LXTUND, IF_REAL, "Length dependence of xtund"),

/* v3.0 */
IOP( "laigc", B4SOI_MOD_LAIGC, IF_REAL, "Length dependence of aigc"),
IOP( "lbigc", B4SOI_MOD_LBIGC, IF_REAL, "Length dependence of bigc"),
IOP( "lcigc", B4SOI_MOD_LCIGC, IF_REAL, "Length dependence of cigc"),
IOP( "laigsd", B4SOI_MOD_LAIGSD, IF_REAL, "Length dependence of aigsd"),
IOP( "lbigsd", B4SOI_MOD_LBIGSD, IF_REAL, "Length dependence of bigsd"),
IOP( "lcigsd", B4SOI_MOD_LCIGSD, IF_REAL, "Length dependence of cigsd"),
IOP( "lnigc", B4SOI_MOD_LNIGC, IF_REAL, "Length dependence of nigc"),
IOP( "lpigcd", B4SOI_MOD_LPIGCD, IF_REAL, "Length dependence for pigcd"),
IOP( "lpoxedge", B4SOI_MOD_LPOXEDGE, IF_REAL, "Length dependence for poxedge"),

IOP( "lnch",  B4SOI_MOD_LNPEAK, IF_REAL, "Length dependence of nch"),
IOP( "lnsub", B4SOI_MOD_LNSUB, IF_REAL, "Length dependence of nsub"),
IOP( "lngate", B4SOI_MOD_LNGATE, IF_REAL, "Length dependence of ngate"),
IOP( "lvth0", B4SOI_MOD_LVTH0, IF_REAL,"Length dependence of vto"),
IOP( "lk1",   B4SOI_MOD_LK1,  IF_REAL, "Length dependence of k1"),
IOP( "lk1w1",   B4SOI_MOD_LK1W1,  IF_REAL, "Length dependence of k1w1"),
IOP( "lk1w2",   B4SOI_MOD_LK1W2,  IF_REAL, "Length dependence of k1w2"),
IOP( "lk2",   B4SOI_MOD_LK2,  IF_REAL, "Length dependence of k2"),
IOP( "lk3",   B4SOI_MOD_LK3,  IF_REAL, "Length dependence of k3"),
IOP( "lk3b",  B4SOI_MOD_LK3B, IF_REAL, "Length dependence of k3b"),
IOP( "lkb1",  B4SOI_MOD_LKB1, IF_REAL, "Length dependence of kb1"),
IOP( "lw0",   B4SOI_MOD_LW0,  IF_REAL, "Length dependence of w0"),
IOP( "llpe0",  B4SOI_MOD_LLPE0, IF_REAL, "Length dependence of lpe0"),
IOP( "llpeb",  B4SOI_MOD_LLPEB, IF_REAL, "Length dependence of lpeb"),
IOP( "ldvt0", B4SOI_MOD_LDVT0, IF_REAL, "Length dependence of dvt0"),
IOP( "ldvt1", B4SOI_MOD_LDVT1, IF_REAL, "Length dependence of dvt1"),
IOP( "ldvt2", B4SOI_MOD_LDVT2, IF_REAL, "Length dependence of dvt2"),
IOP( "ldvt0w", B4SOI_MOD_LDVT0W, IF_REAL, "Length dependence of dvt0w"),
IOP( "ldvt1w", B4SOI_MOD_LDVT1W, IF_REAL, "Length dependence of dvt1w"),
IOP( "ldvt2w", B4SOI_MOD_LDVT2W, IF_REAL, "Length dependence of dvt2w"),
IOP( "lu0",  B4SOI_MOD_LU0, IF_REAL, "Length dependence of u0"),
IOP( "lua",  B4SOI_MOD_LUA, IF_REAL, "Length dependence of ua"),
IOP( "lub", B4SOI_MOD_LUB, IF_REAL, "Length dependence of ub"),
IOP( "luc",  B4SOI_MOD_LUC, IF_REAL, "Length dependence of uc"),
IOP( "lvsat", B4SOI_MOD_LVSAT, IF_REAL, "Length dependence of vsat"),
IOP( "la0", B4SOI_MOD_LA0, IF_REAL, "Length dependence of a0"),
IOP( "lags", B4SOI_MOD_LAGS, IF_REAL, "Length dependence of ags"),
IOP( "lb0",  B4SOI_MOD_LB0, IF_REAL, "Length dependence of b0"),
IOP( "lb1",  B4SOI_MOD_LB1, IF_REAL, "Length dependence of b1"),
IOP( "lketa", B4SOI_MOD_LKETA, IF_REAL, "Length dependence of keta"),
IOP( "lketas", B4SOI_MOD_LKETAS, IF_REAL, "Length dependence of ketas"),
IOP( "la1", B4SOI_MOD_LA1, IF_REAL, "Length dependence of a1"),
IOP( "la2", B4SOI_MOD_LA2, IF_REAL, "Length dependence of a2"),
IOP( "lrdsw", B4SOI_MOD_LRDSW,  IF_REAL, "Length dependence of rdsw "),
IOP( "lrsw", B4SOI_MOD_LRSW, IF_REAL, "Length dependence of rsw"),  /* v4.0 */
IOP( "lrdw", B4SOI_MOD_LRDW, IF_REAL, "Length dependence of rdw"),  /* v4.0 */ 
IOP( "lprwb", B4SOI_MOD_LPRWB,  IF_REAL, "Length dependence of prwb "),
IOP( "lprwg", B4SOI_MOD_LPRWG,  IF_REAL, "Length dependence of prwg "),
IOP( "lwr",  B4SOI_MOD_LWR, IF_REAL, "Length dependence of wr"),
IOP( "lnfactor", B4SOI_MOD_LNFACTOR, IF_REAL, "Length dependence of nfactor"),
IOP( "ldwg", B4SOI_MOD_LDWG, IF_REAL, "Length dependence of dwg"),
IOP( "ldwb", B4SOI_MOD_LDWB, IF_REAL, "Length dependence of dwb"),
IOP( "lvoff", B4SOI_MOD_LVOFF, IF_REAL, "Length dependence of voff"),
IOP( "leta0", B4SOI_MOD_LETA0, IF_REAL, "Length dependence of eta0"),
IOP( "letab", B4SOI_MOD_LETAB, IF_REAL, "Length dependence of etab"),
IOP( "ldsub", B4SOI_MOD_LDSUB, IF_REAL, "Length dependence of dsub"),
IOP( "lcit",   B4SOI_MOD_LCIT,  IF_REAL, "Length dependence of cit"),
IOP( "lcdsc",  B4SOI_MOD_LCDSC, IF_REAL, "Length dependence of cdsc"),
IOP( "lcdscb", B4SOI_MOD_LCDSCB, IF_REAL, "Length dependence of cdscb"),
IOP( "lcdscd", B4SOI_MOD_LCDSCD, IF_REAL, "Length dependence of cdscd"),
IOP( "lpclm", B4SOI_MOD_LPCLM, IF_REAL, "Length dependence of pclm"),
IOP( "lpdiblc1", B4SOI_MOD_LPDIBL1, IF_REAL, "Length dependence of pdiblc1"),
IOP( "lpdiblc2", B4SOI_MOD_LPDIBL2, IF_REAL, "Length dependence of pdiblc2"),
IOP( "lpdiblcb", B4SOI_MOD_LPDIBLB, IF_REAL, "Length dependence of pdiblcb"),
IOP( "ldrout", B4SOI_MOD_LDROUT, IF_REAL, "Length dependence of drout"),
IOP( "lpvag", B4SOI_MOD_LPVAG, IF_REAL, "Length dependence of pvag"),
IOP( "ldelta", B4SOI_MOD_LDELTA, IF_REAL, "Length dependence of delta"),
IOP( "lalpha0", B4SOI_MOD_LALPHA0, IF_REAL, "Length dependence of alpha0"),
IOP( "lfbjtii", B4SOI_MOD_LFBJTII, IF_REAL, "Length dependence of fbjtii"),
IOP( "lbeta0", B4SOI_MOD_LBETA0, IF_REAL, "Length dependence of beta0"),
IOP( "lbeta1", B4SOI_MOD_LBETA1, IF_REAL, "Length dependence of beta1"),
IOP( "lbeta2", B4SOI_MOD_LBETA2, IF_REAL, "Length dependence of beta2"),
IOP( "lvdsatii0", B4SOI_MOD_LVDSATII0, IF_REAL, "Length dependence of vdsatii0"),
IOP( "llii", B4SOI_MOD_LLII, IF_REAL, "Length dependence of lii"),
IOP( "lesatii", B4SOI_MOD_LESATII, IF_REAL, "Length dependence of esatii"),
IOP( "lsii0", B4SOI_MOD_LSII0, IF_REAL, "Length dependence of sii0"),
IOP( "lsii1", B4SOI_MOD_LSII1, IF_REAL, "Length dependence of sii1"),
IOP( "lsii2", B4SOI_MOD_LSII2, IF_REAL, "Length dependence of sii2"),
IOP( "lsiid", B4SOI_MOD_LSIID, IF_REAL, "Length dependence of siid"),
IOP( "lagidl", B4SOI_MOD_LAGIDL, IF_REAL, "Length dependence of agidl"),
IOP( "lbgidl", B4SOI_MOD_LBGIDL, IF_REAL, "Length dependence of bgidl"),
IOP( "lcgidl", B4SOI_MOD_LCGIDL, IF_REAL, "Length dependence of cgidl"),
IOP( "legidl", B4SOI_MOD_LEGIDL, IF_REAL, "Length dependence of egidl"),
IOP( "lntun", B4SOI_MOD_LNTUNS, IF_REAL, "Length dependence of ntun"),
IOP( "lntund", B4SOI_MOD_LNTUND, IF_REAL, "Length dependence of ntund"),
IOP( "lndiode", B4SOI_MOD_LNDIODES, IF_REAL, "Length dependence of ndiode"),
IOP( "lndioded", B4SOI_MOD_LNDIODED, IF_REAL, "Length dependence of ndioded"),
IOP( "lnrecf0", B4SOI_MOD_LNRECF0S, IF_REAL, "Length dependence of nrecf0"),
IOP( "lnrecf0d", B4SOI_MOD_LNRECF0D, IF_REAL, "Length dependence of nrecf0d"),
IOP( "lnrecr0", B4SOI_MOD_LNRECR0S, IF_REAL, "Length dependence of nrecr0"),
IOP( "lnrecr0d", B4SOI_MOD_LNRECR0D, IF_REAL, "Length dependence of nrecr0d"),
IOP( "lisbjt", B4SOI_MOD_LISBJT, IF_REAL, "Length dependence of isbjt"),
IOP( "lidbjt", B4SOI_MOD_LIDBJT, IF_REAL, "Length dependence of idbjt"),
IOP( "lisdif", B4SOI_MOD_LISDIF, IF_REAL, "Length dependence of isdif"),
IOP( "liddif", B4SOI_MOD_LIDDIF, IF_REAL, "Length dependence of iddif"),
IOP( "lisrec", B4SOI_MOD_LISREC, IF_REAL, "Length dependence of isrec"),
IOP( "lidrec", B4SOI_MOD_LIDREC, IF_REAL, "Length dependence of idrec"),
IOP( "listun", B4SOI_MOD_LISTUN, IF_REAL, "Length dependence of istun"),
IOP( "lidtun", B4SOI_MOD_LIDTUN, IF_REAL, "Length dependence of idtun"),
IOP( "lvrec0", B4SOI_MOD_LVREC0S, IF_REAL, "Length dependence of vrec0"),
IOP( "lvrec0d", B4SOI_MOD_LVREC0D, IF_REAL, "Length dependence of vrec0d"),
IOP( "lvtun0", B4SOI_MOD_LVTUN0S, IF_REAL, "Length dependence of vtun0"),
IOP( "lvtun0d", B4SOI_MOD_LVTUN0D, IF_REAL, "Length dependence of vtun0d"),
IOP( "lnbjt", B4SOI_MOD_LNBJT, IF_REAL, "Length dependence of nbjt"),
IOP( "llbjt0", B4SOI_MOD_LLBJT0, IF_REAL, "Length dependence of lbjt0"),
IOP( "lvabjt", B4SOI_MOD_LVABJT, IF_REAL, "Length dependence of vabjt"),
IOP( "laely", B4SOI_MOD_LAELY, IF_REAL, "Length dependence of aely"),
IOP( "lahli", B4SOI_MOD_LAHLIS, IF_REAL, "Length dependence of ahli"),/*v4.0*/
IOP( "lahlid", B4SOI_MOD_LAHLID, IF_REAL, "Length dependence of ahlid"),/*v4.0*/
IOP( "lvsdfb", B4SOI_MOD_LVSDFB, IF_REAL, "Length dependence of vsdfb"),
IOP( "lvsdth", B4SOI_MOD_LVSDTH, IF_REAL, "Length dependence of vsdth"),
IOP( "ldelvt", B4SOI_MOD_LDELVT, IF_REAL, "Length dependence of delvt"),
IOP( "lacde", B4SOI_MOD_LACDE, IF_REAL, "Length dependence of acde"),
IOP( "lmoin", B4SOI_MOD_LMOIN, IF_REAL, "Length dependence of amoin"),
IOP( "lnoff", B4SOI_MOD_LNOFF, IF_REAL, "Length dependence of noff"), /* v3.2 */

/* v3.1 added for RF */
IOP("lxrcrg1", B4SOI_MOD_LXRCRG1, IF_REAL, "Length dependence of xrcrg1"),
IOP("lxrcrg2", B4SOI_MOD_LXRCRG2, IF_REAL, "Length dependence of xrcrg2"),
/* v3.1 added for RF end*/

/* Width Dependence */
/* v3.1 */
IOP( "wxj", B4SOI_MOD_WXJ, IF_REAL, "Width dependence of xj"),
IOP( "walphagb1", B4SOI_MOD_WALPHAGB1, IF_REAL, "Width dependence of alphagb1"),
IOP( "wbetagb1", B4SOI_MOD_WBETAGB1, IF_REAL, "Width dependence of betagb1"),
IOP( "walphagb2", B4SOI_MOD_WALPHAGB2, IF_REAL, "Width dependence of alphagb2"),
IOP( "wbetagb2", B4SOI_MOD_WBETAGB2, IF_REAL, "Width dependence of betagb2"),
IOP( "wcgsl", B4SOI_MOD_WCGSL, IF_REAL, "Width dependence of cgsl"),
IOP( "wcgdl", B4SOI_MOD_WCGDL, IF_REAL, "Width dependence of cgdl"),
IOP( "wckappa", B4SOI_MOD_WCKAPPA, IF_REAL, "Width dependence of ckappa"),
IOP( "wndif", B4SOI_MOD_WNDIF, IF_REAL, "Width dependence of ndif"),
IOP( "wute", B4SOI_MOD_WUTE, IF_REAL, "Width dependence of ute"),
IOP( "wkt1", B4SOI_MOD_WKT1, IF_REAL, "Width dependence of kt1"),
IOP( "wkt1l", B4SOI_MOD_WKT1L, IF_REAL, "Width dependence of kt1l"),
IOP( "wkt2",  B4SOI_MOD_WKT2, IF_REAL, "Width dependence of kt2"),
IOP( "wua1", B4SOI_MOD_WUA1, IF_REAL, "Width dependence of ua1"),
IOP( "wub1", B4SOI_MOD_WUB1, IF_REAL, "Width dependence of ub1"),
IOP( "wuc1", B4SOI_MOD_WUC1, IF_REAL, "Width dependence of uc1"),
IOP( "wat", B4SOI_MOD_WAT, IF_REAL, "Width dependence of at"),
IOP( "wprt", B4SOI_MOD_WPRT, IF_REAL, "Width dependence of prt "),
IOP( "wntrecf", B4SOI_MOD_WNTRECF, IF_REAL, "Width dependence of ntrecf"),
IOP( "wntrecr", B4SOI_MOD_WNTRECR, IF_REAL, "Width dependence of ntrecr"),
IOP( "wxbjt", B4SOI_MOD_WXBJT, IF_REAL, "Width dependence of xbjt"),
IOP( "wxdif", B4SOI_MOD_WXDIFS, IF_REAL, "Width dependence of xdif"),
IOP( "wxrec", B4SOI_MOD_WXRECS, IF_REAL, "Width dependence of xrec"),
IOP( "wxtun", B4SOI_MOD_WXTUNS, IF_REAL, "Width dependence of xtun"),
IOP( "wxdifd", B4SOI_MOD_WXDIFD, IF_REAL, "Width dependence of xdifd"),
IOP( "wxrecd", B4SOI_MOD_WXRECD, IF_REAL, "Width dependence of xrecd"),
IOP( "wxtund", B4SOI_MOD_WXTUND, IF_REAL, "Width dependence of xtund"),

/* v3.0 */
IOP( "waigc", B4SOI_MOD_WAIGC, IF_REAL, "Width dependence of aigc"),
IOP( "wbigc", B4SOI_MOD_WBIGC, IF_REAL, "Width dependence of bigc"),
IOP( "wcigc", B4SOI_MOD_WCIGC, IF_REAL, "Width dependence of cigc"),
IOP( "waigsd", B4SOI_MOD_WAIGSD, IF_REAL, "Width dependence of aigsd"),
IOP( "wbigsd", B4SOI_MOD_WBIGSD, IF_REAL, "Width dependence of bigsd"),
IOP( "wcigsd", B4SOI_MOD_WCIGSD, IF_REAL, "Width dependence of cigsd"),
IOP( "wnigc", B4SOI_MOD_WNIGC, IF_REAL, "Width dependence of nigc"),
IOP( "wpigcd", B4SOI_MOD_WPIGCD, IF_REAL, "Width dependence for pigcd"),
IOP( "wpoxedge", B4SOI_MOD_WPOXEDGE, IF_REAL, "Width dependence for poxedge"),

IOP( "wnch",  B4SOI_MOD_WNPEAK, IF_REAL, "Width dependence of nch"),
IOP( "wnsub", B4SOI_MOD_WNSUB, IF_REAL, "Width dependence of nsub"),
IOP( "wngate", B4SOI_MOD_WNGATE, IF_REAL, "Width dependence of ngate"),
IOP( "wvth0", B4SOI_MOD_WVTH0, IF_REAL,"Width dependence of vto"),
IOP( "wk1",   B4SOI_MOD_WK1,  IF_REAL, "Width dependence of k1"),
IOP( "wk1w1",   B4SOI_MOD_WK1W1,  IF_REAL, "Width dependence of k1w1"),
IOP( "wk1w2",   B4SOI_MOD_WK1W2,  IF_REAL, "Width dependence of k1w2"),
IOP( "wk2",   B4SOI_MOD_WK2,  IF_REAL, "Width dependence of k2"),
IOP( "wk3",   B4SOI_MOD_WK3,  IF_REAL, "Width dependence of k3"),
IOP( "wk3b",  B4SOI_MOD_WK3B, IF_REAL, "Width dependence of k3b"),
IOP( "wkb1",  B4SOI_MOD_WKB1, IF_REAL, "Width dependence of kb1"),
IOP( "ww0",   B4SOI_MOD_WW0,  IF_REAL, "Width dependence of w0"),
IOP( "wlpe0",  B4SOI_MOD_WLPE0, IF_REAL, "Width dependence of lpe0"),
IOP( "wlpeb",  B4SOI_MOD_WLPEB, IF_REAL, "Width dependence of lpeb"),
IOP( "wdvt0", B4SOI_MOD_WDVT0, IF_REAL, "Width dependence of dvt0"),
IOP( "wdvt1", B4SOI_MOD_WDVT1, IF_REAL, "Width dependence of dvt1"),
IOP( "wdvt2", B4SOI_MOD_WDVT2, IF_REAL, "Width dependence of dvt2"),
IOP( "wdvt0w", B4SOI_MOD_WDVT0W, IF_REAL, "Width dependence of dvt0w"),
IOP( "wdvt1w", B4SOI_MOD_WDVT1W, IF_REAL, "Width dependence of dvt1w"),
IOP( "wdvt2w", B4SOI_MOD_WDVT2W, IF_REAL, "Width dependence of dvt2w"),
IOP( "wu0",  B4SOI_MOD_WU0, IF_REAL, "Width dependence of u0"),
IOP( "wua",  B4SOI_MOD_WUA, IF_REAL, "Width dependence of ua"),
IOP( "wub", B4SOI_MOD_WUB, IF_REAL, "Width dependence of ub"),
IOP( "wuc",  B4SOI_MOD_WUC, IF_REAL, "Width dependence of uc"),
IOP( "wvsat", B4SOI_MOD_WVSAT, IF_REAL, "Width dependence of vsat"),
IOP( "wa0", B4SOI_MOD_WA0, IF_REAL, "Width dependence of a0"),
IOP( "wags", B4SOI_MOD_WAGS, IF_REAL, "Width dependence of ags"),
IOP( "wb0",  B4SOI_MOD_WB0, IF_REAL, "Width dependence of b0"),
IOP( "wb1",  B4SOI_MOD_WB1, IF_REAL, "Width dependence of b1"),
IOP( "wketa", B4SOI_MOD_WKETA, IF_REAL, "Width dependence of keta"),
IOP( "wketas", B4SOI_MOD_WKETAS, IF_REAL, "Width dependence of ketas"),
IOP( "wa1", B4SOI_MOD_WA1, IF_REAL, "Width dependence of a1"),
IOP( "wa2", B4SOI_MOD_WA2, IF_REAL, "Width dependence of a2"),
IOP( "wrdsw", B4SOI_MOD_WRDSW,  IF_REAL, "Width dependence of rdsw "),
IOP( "wrsw", B4SOI_MOD_WRSW, IF_REAL, "Width dependence of rsw"),  /* v4.0 */
IOP( "wrdw", B4SOI_MOD_WRDW, IF_REAL, "Width dependence of rdw"),  /* v4.0 */ 
IOP( "wprwb", B4SOI_MOD_WPRWB,  IF_REAL, "Width dependence of prwb "),
IOP( "wprwg", B4SOI_MOD_WPRWG,  IF_REAL, "Width dependence of prwg "),
IOP( "wwr",  B4SOI_MOD_WWR, IF_REAL, "Width dependence of wr"),
IOP( "wnfactor", B4SOI_MOD_WNFACTOR, IF_REAL, "Width dependence of nfactor"),
IOP( "wdwg", B4SOI_MOD_WDWG, IF_REAL, "Width dependence of dwg"),
IOP( "wdwb", B4SOI_MOD_WDWB, IF_REAL, "Width dependence of dwb"),
IOP( "wvoff", B4SOI_MOD_WVOFF, IF_REAL, "Width dependence of voff"),
IOP( "weta0", B4SOI_MOD_WETA0, IF_REAL, "Width dependence of eta0"),
IOP( "wetab", B4SOI_MOD_WETAB, IF_REAL, "Width dependence of etab"),
IOP( "wdsub", B4SOI_MOD_WDSUB, IF_REAL, "Width dependence of dsub"),
IOP( "wcit",   B4SOI_MOD_WCIT,  IF_REAL, "Width dependence of cit"),
IOP( "wcdsc",  B4SOI_MOD_WCDSC, IF_REAL, "Width dependence of cdsc"),
IOP( "wcdscb", B4SOI_MOD_WCDSCB, IF_REAL, "Width dependence of cdscb"),
IOP( "wcdscd", B4SOI_MOD_WCDSCD, IF_REAL, "Width dependence of cdscd"),
IOP( "wpclm", B4SOI_MOD_WPCLM, IF_REAL, "Width dependence of pclm"),
IOP( "wpdiblc1", B4SOI_MOD_WPDIBL1, IF_REAL, "Width dependence of pdiblc1"),
IOP( "wpdiblc2", B4SOI_MOD_WPDIBL2, IF_REAL, "Width dependence of pdiblc2"),
IOP( "wpdiblcb", B4SOI_MOD_WPDIBLB, IF_REAL, "Width dependence of pdiblcb"),
IOP( "wdrout", B4SOI_MOD_WDROUT, IF_REAL, "Width dependence of drout"),
IOP( "wpvag", B4SOI_MOD_WPVAG, IF_REAL, "Width dependence of pvag"),
IOP( "wdelta", B4SOI_MOD_WDELTA, IF_REAL, "Width dependence of delta"),
IOP( "walpha0", B4SOI_MOD_WALPHA0, IF_REAL, "Width dependence of alpha0"),
IOP( "wfbjtii", B4SOI_MOD_WFBJTII, IF_REAL, "Width dependence of fbjtii"),
IOP( "wbeta0", B4SOI_MOD_WBETA0, IF_REAL, "Width dependence of beta0"),
IOP( "wbeta1", B4SOI_MOD_WBETA1, IF_REAL, "Width dependence of beta1"),
IOP( "wbeta2", B4SOI_MOD_WBETA2, IF_REAL, "Width dependence of beta2"),
IOP( "wvdsatii0", B4SOI_MOD_WVDSATII0, IF_REAL, "Width dependence of vdsatii0"),
IOP( "wlii", B4SOI_MOD_WLII, IF_REAL, "Width dependence of lii"),
IOP( "wesatii", B4SOI_MOD_WESATII, IF_REAL, "Width dependence of esatii"),
IOP( "wsii0", B4SOI_MOD_WSII0, IF_REAL, "Width dependence of sii0"),
IOP( "wsii1", B4SOI_MOD_WSII1, IF_REAL, "Width dependence of sii1"),
IOP( "wsii2", B4SOI_MOD_WSII2, IF_REAL, "Width dependence of sii2"),
IOP( "wsiid", B4SOI_MOD_WSIID, IF_REAL, "Width dependence of siid"),
IOP( "wagidl", B4SOI_MOD_WAGIDL, IF_REAL, "Width dependence of agidl"),
IOP( "wbgidl", B4SOI_MOD_WBGIDL, IF_REAL, "Width dependence of bgidl"),
IOP( "wcgidl", B4SOI_MOD_WCGIDL, IF_REAL, "Width dependence of cgidl"),
IOP( "wegidl", B4SOI_MOD_WEGIDL, IF_REAL, "Width dependence of egidl"),
IOP( "wntun", B4SOI_MOD_WNTUNS, IF_REAL, "Width dependence of ntun"),
IOP( "wntund", B4SOI_MOD_WNTUND, IF_REAL, "Width dependence of ntund"),
IOP( "wndiode", B4SOI_MOD_WNDIODES, IF_REAL, "Width dependence of ndiode"),
IOP( "wndioded", B4SOI_MOD_WNDIODED, IF_REAL, "Width dependence of ndioded"),
IOP( "wnrecf0", B4SOI_MOD_WNRECF0S, IF_REAL, "Width dependence of nrecf0"),
IOP( "wnrecf0d", B4SOI_MOD_WNRECF0D, IF_REAL, "Width dependence of nrecf0d"),
IOP( "wnrecr0", B4SOI_MOD_WNRECR0S, IF_REAL, "Width dependence of nrecr0"),
IOP( "wnrecr0d", B4SOI_MOD_WNRECR0D, IF_REAL, "Width dependence of nrecr0d"),
IOP( "wisbjt", B4SOI_MOD_WISBJT, IF_REAL, "Width dependence of isbjt"),
IOP( "widbjt", B4SOI_MOD_WIDBJT, IF_REAL, "Width dependence of idbjt"),
IOP( "wisdif", B4SOI_MOD_WISDIF, IF_REAL, "Width dependence of isdif"),
IOP( "widdif", B4SOI_MOD_WIDDIF, IF_REAL, "Width dependence of iddif"),
IOP( "wisrec", B4SOI_MOD_WISREC, IF_REAL, "Width dependence of isrec"),
IOP( "widrec", B4SOI_MOD_WIDREC, IF_REAL, "Width dependence of idrec"),
IOP( "wistun", B4SOI_MOD_WISTUN, IF_REAL, "Width dependence of istun"),
IOP( "widtun", B4SOI_MOD_WIDTUN, IF_REAL, "Width dependence of idtun"),
IOP( "wvrec0", B4SOI_MOD_WVREC0S, IF_REAL, "Width dependence of vrec0"),
IOP( "wvrec0d", B4SOI_MOD_WVREC0D, IF_REAL, "Width dependence of vrec0d"),
IOP( "wvtun0", B4SOI_MOD_WVTUN0S, IF_REAL, "Width dependence of vtun0"),
IOP( "wvtun0d", B4SOI_MOD_WVTUN0D, IF_REAL, "Width dependence of vtun0d"),
IOP( "wnbjt", B4SOI_MOD_WNBJT, IF_REAL, "Width dependence of nbjt"),
IOP( "wlbjt0", B4SOI_MOD_WLBJT0, IF_REAL, "Width dependence of lbjt0"),
IOP( "wvabjt", B4SOI_MOD_WVABJT, IF_REAL, "Width dependence of vabjt"),
IOP( "waely", B4SOI_MOD_WAELY, IF_REAL, "Width dependence of aely"),
IOP( "wahli", B4SOI_MOD_WAHLIS,IF_REAL, "Width dependence of ahli"),/* v4.0 */
IOP( "wahlid", B4SOI_MOD_WAHLID,IF_REAL, "Width dependence of ahlid"),/* v4.0 */
IOP( "wvsdfb", B4SOI_MOD_WVSDFB, IF_REAL, "Width dependence of vsdfb"),
IOP( "wvsdth", B4SOI_MOD_WVSDTH, IF_REAL, "Width dependence of vsdth"),
IOP( "wdelvt", B4SOI_MOD_WDELVT, IF_REAL, "Width dependence of delvt"),
IOP( "wacde", B4SOI_MOD_WACDE, IF_REAL, "Width dependence of acde"),
IOP( "wmoin", B4SOI_MOD_WMOIN, IF_REAL, "Width dependence of amoin"),
IOP( "wnoff", B4SOI_MOD_WNOFF, IF_REAL, "Width dependence of noff"), /* v3.2 */

/* v3.1 added for RF */
IOP("wxrcrg1", B4SOI_MOD_WXRCRG1, IF_REAL, "Width dependence of xrcrg1"),
IOP("Wxrcrg2", B4SOI_MOD_WXRCRG2, IF_REAL, "Width dependence of xrcrg2"),
/* added for RF model end*/


/* Cross-term Dependence */
/* v3.1 */
IOP( "pxj", B4SOI_MOD_PXJ, IF_REAL, "Cross-term dependence of xj"),
IOP( "palphagb1", B4SOI_MOD_PALPHAGB1, IF_REAL, "Cross-term dependence of alphagb1"),
IOP( "pbetagb1", B4SOI_MOD_PBETAGB1, IF_REAL, "Cross-term dependence of betagb1"),
IOP( "palphagb2", B4SOI_MOD_PALPHAGB2, IF_REAL, "Cross-term dependence of alphagb2"),
IOP( "pbetagb2", B4SOI_MOD_PBETAGB2, IF_REAL, "Cross-term dependence of betagb2"),
IOP( "pcgsl", B4SOI_MOD_PCGSL, IF_REAL, "Cross-term dependence of cgsl"),
IOP( "pcgdl", B4SOI_MOD_PCGDL, IF_REAL, "Cross-term dependence of cgdl"),
IOP( "pckappa", B4SOI_MOD_PCKAPPA, IF_REAL, "Cross-term dependence of ckappa"),
IOP( "pndif", B4SOI_MOD_PNDIF, IF_REAL, "Cross-term dependence of ndif"),
IOP( "pute", B4SOI_MOD_PUTE, IF_REAL, "Cross-term dependence of ute"),
IOP( "pkt1", B4SOI_MOD_PKT1, IF_REAL, "Cross-term dependence of kt1"),
IOP( "pkt1l", B4SOI_MOD_PKT1L, IF_REAL, "Cross-term dependence of kt1l"),
IOP( "pkt2",  B4SOI_MOD_PKT2, IF_REAL, "Cross-term dependence of kt2"),
IOP( "pua1", B4SOI_MOD_PUA1, IF_REAL, "Cross-term dependence of ua1"),
IOP( "pub1", B4SOI_MOD_PUB1, IF_REAL, "Cross-term dependence of ub1"),
IOP( "puc1", B4SOI_MOD_PUC1, IF_REAL, "Cross-term dependence of uc1"),
IOP( "pat", B4SOI_MOD_PAT, IF_REAL, "Cross-term dependence of at"),
IOP( "pprt", B4SOI_MOD_PPRT, IF_REAL, "Cross-term dependence of prt "),
IOP( "pntrecf", B4SOI_MOD_PNTRECF, IF_REAL, "Cross-term dependence of ntrecf"),
IOP( "pntrecr", B4SOI_MOD_PNTRECR, IF_REAL, "Cross-term dependence of ntrecr"),
IOP( "pxbjt", B4SOI_MOD_PXBJT, IF_REAL, "Cross-term dependence of xbjt"),
IOP( "pxdif", B4SOI_MOD_PXDIFS, IF_REAL, "Cross-term dependence of xdif"),
IOP( "pxrec", B4SOI_MOD_PXRECS, IF_REAL, "Cross-term dependence of xrec"),
IOP( "pxtun", B4SOI_MOD_PXTUNS, IF_REAL, "Cross-term dependence of xtun"),
IOP( "pxdifd", B4SOI_MOD_PXDIFD, IF_REAL, "Cross-term dependence of xdifd"),
IOP( "pxrecd", B4SOI_MOD_PXRECD, IF_REAL, "Cross-term dependence of xrecd"),
IOP( "pxtund", B4SOI_MOD_PXTUND, IF_REAL, "Cross-term dependence of xtund"),

/* v3.0 */
IOP( "paigc", B4SOI_MOD_PAIGC, IF_REAL, "Cross-term dependence of aigc"),
IOP( "pbigc", B4SOI_MOD_PBIGC, IF_REAL, "Cross-term dependence of bigc"),
IOP( "pcigc", B4SOI_MOD_PCIGC, IF_REAL, "Cross-term dependence of cigc"),
IOP( "paigsd", B4SOI_MOD_PAIGSD, IF_REAL, "Cross-term dependence of aigsd"),
IOP( "pbigsd", B4SOI_MOD_PBIGSD, IF_REAL, "Cross-term dependence of bigsd"),
IOP( "pcigsd", B4SOI_MOD_PCIGSD, IF_REAL, "Cross-term dependence of cigsd"),
IOP( "pnigc", B4SOI_MOD_PNIGC, IF_REAL, "Cross-term dependence of nigc"),
IOP( "ppigcd", B4SOI_MOD_PPIGCD, IF_REAL, "Cross-term dependence for pigcd"),
IOP( "ppoxedge", B4SOI_MOD_PPOXEDGE, IF_REAL, "Cross-term dependence for poxedge"),

IOP( "pnch",  B4SOI_MOD_PNPEAK, IF_REAL, "Cross-term dependence of nch"),
IOP( "pnsub", B4SOI_MOD_PNSUB, IF_REAL, "Cross-term dependence of nsub"),
IOP( "pngate", B4SOI_MOD_PNGATE, IF_REAL, "Cross-term dependence of ngate"),
IOP( "pvth0", B4SOI_MOD_PVTH0, IF_REAL,"Cross-term dependence of vto"),
IOP( "pk1",   B4SOI_MOD_PK1,  IF_REAL, "Cross-term dependence of k1"),
IOP( "pk1w1",   B4SOI_MOD_PK1W1,  IF_REAL, "Cross-term dependence of k1w1"),
IOP( "pk1w2",   B4SOI_MOD_PK1W2,  IF_REAL, "Cross-term dependence of k1w2"),
IOP( "pk2",   B4SOI_MOD_PK2,  IF_REAL, "Cross-term dependence of k2"),
IOP( "pk3",   B4SOI_MOD_PK3,  IF_REAL, "Cross-term dependence of k3"),
IOP( "pk3b",  B4SOI_MOD_PK3B, IF_REAL, "Cross-term dependence of k3b"),
IOP( "pkb1",  B4SOI_MOD_PKB1, IF_REAL, "Cross-term dependence of kb1"),
IOP( "pw0",   B4SOI_MOD_PW0,  IF_REAL, "Cross-term dependence of w0"),
IOP( "plpe0",  B4SOI_MOD_PLPE0, IF_REAL, "Cross-term dependence of lpe0"),
IOP( "plpeb",  B4SOI_MOD_PLPEB, IF_REAL, "Cross-term dependence of lpeb"),
IOP( "pdvt0", B4SOI_MOD_PDVT0, IF_REAL, "Cross-term dependence of dvt0"),
IOP( "pdvt1", B4SOI_MOD_PDVT1, IF_REAL, "Cross-term dependence of dvt1"),
IOP( "pdvt2", B4SOI_MOD_PDVT2, IF_REAL, "Cross-term dependence of dvt2"),
IOP( "pdvt0w", B4SOI_MOD_PDVT0W, IF_REAL, "Cross-term dependence of dvt0w"),
IOP( "pdvt1w", B4SOI_MOD_PDVT1W, IF_REAL, "Cross-term dependence of dvt1w"),
IOP( "pdvt2w", B4SOI_MOD_PDVT2W, IF_REAL, "Cross-term dependence of dvt2w"),
IOP( "pu0",  B4SOI_MOD_PU0, IF_REAL, "Cross-term dependence of u0"),
IOP( "pua",  B4SOI_MOD_PUA, IF_REAL, "Cross-term dependence of ua"),
IOP( "pub", B4SOI_MOD_PUB, IF_REAL, "Cross-term dependence of ub"),
IOP( "puc",  B4SOI_MOD_PUC, IF_REAL, "Cross-term dependence of uc"),
IOP( "pvsat", B4SOI_MOD_PVSAT, IF_REAL, "Cross-term dependence of vsat"),
IOP( "pa0", B4SOI_MOD_PA0, IF_REAL, "Cross-term dependence of a0"),
IOP( "pags", B4SOI_MOD_PAGS, IF_REAL, "Cross-term dependence of ags"),
IOP( "pb0",  B4SOI_MOD_PB0, IF_REAL, "Cross-term dependence of b0"),
IOP( "pb1",  B4SOI_MOD_PB1, IF_REAL, "Cross-term dependence of b1"),
IOP( "pketa", B4SOI_MOD_PKETA, IF_REAL, "Cross-term dependence of keta"),
IOP( "pketas", B4SOI_MOD_PKETAS, IF_REAL, "Cross-term dependence of ketas"),
IOP( "pa1", B4SOI_MOD_PA1, IF_REAL, "Cross-term dependence of a1"),
IOP( "pa2", B4SOI_MOD_PA2, IF_REAL, "Cross-term dependence of a2"),
IOP( "prdsw", B4SOI_MOD_PRDSW,  IF_REAL, "Cross-term dependence of rdsw "),
IOP( "prsw", B4SOI_MOD_PRSW, IF_REAL, "Cross-term dependence of rsw "),/*v4.0*/
IOP( "prdw", B4SOI_MOD_PRDW, IF_REAL, "Cross-term dependence of rdw "),/*v4.0*/
IOP( "pprwb", B4SOI_MOD_PPRWB,  IF_REAL, "Cross-term dependence of prwb "),
IOP( "pprwg", B4SOI_MOD_PPRWG,  IF_REAL, "Cross-term dependence of prwg "),
IOP( "pwr",  B4SOI_MOD_PWR, IF_REAL, "Cross-term dependence of wr"),
IOP( "pnfactor", B4SOI_MOD_PNFACTOR, IF_REAL, "Cross-term dependence of nfactor"),
IOP( "pdwg", B4SOI_MOD_PDWG, IF_REAL, "Cross-term dependence of dwg"),
IOP( "pdwb", B4SOI_MOD_PDWB, IF_REAL, "Cross-term dependence of dwb"),
IOP( "pvoff", B4SOI_MOD_PVOFF, IF_REAL, "Cross-term dependence of voff"),
IOP( "peta0", B4SOI_MOD_PETA0, IF_REAL, "Cross-term dependence of eta0"),
IOP( "petab", B4SOI_MOD_PETAB, IF_REAL, "Cross-term dependence of etab"),
IOP( "pdsub", B4SOI_MOD_PDSUB, IF_REAL, "Cross-term dependence of dsub"),
IOP( "pcit",   B4SOI_MOD_PCIT,  IF_REAL, "Cross-term dependence of cit"),
IOP( "pcdsc",  B4SOI_MOD_PCDSC, IF_REAL, "Cross-term dependence of cdsc"),
IOP( "pcdscb", B4SOI_MOD_PCDSCB, IF_REAL, "Cross-term dependence of cdscb"),
IOP( "pcdscd", B4SOI_MOD_PCDSCD, IF_REAL, "Cross-term dependence of cdscd"),
IOP( "ppclm", B4SOI_MOD_PPCLM, IF_REAL, "Cross-term dependence of pclm"),
IOP( "ppdiblc1", B4SOI_MOD_PPDIBL1, IF_REAL, "Cross-term dependence of pdiblc1"),
IOP( "ppdiblc2", B4SOI_MOD_PPDIBL2, IF_REAL, "Cross-term dependence of pdiblc2"),
IOP( "ppdiblcb", B4SOI_MOD_PPDIBLB, IF_REAL, "Cross-term dependence of pdiblcb"),
IOP( "pdrout", B4SOI_MOD_PDROUT, IF_REAL, "Cross-term dependence of drout"),
IOP( "ppvag", B4SOI_MOD_PPVAG, IF_REAL, "Cross-term dependence of pvag"),
IOP( "pdelta", B4SOI_MOD_PDELTA, IF_REAL, "Cross-term dependence of delta"),
IOP( "palpha0", B4SOI_MOD_PALPHA0, IF_REAL, "Cross-term dependence of alpha0"),
IOP( "pfbjtii", B4SOI_MOD_PFBJTII, IF_REAL, "Cross-term dependence of fbjtii"),
IOP( "pbeta0", B4SOI_MOD_PBETA0, IF_REAL, "Cross-term dependence of beta0"),
IOP( "pbeta1", B4SOI_MOD_PBETA1, IF_REAL, "Cross-term dependence of beta1"),
IOP( "pbeta2", B4SOI_MOD_PBETA2, IF_REAL, "Cross-term dependence of beta2"),
IOP( "pvdsatii0", B4SOI_MOD_PVDSATII0, IF_REAL, "Cross-term dependence of vdsatii0"),
IOP( "plii", B4SOI_MOD_PLII, IF_REAL, "Cross-term dependence of lii"),
IOP( "pesatii", B4SOI_MOD_PESATII, IF_REAL, "Cross-term dependence of esatii"),
IOP( "psii0", B4SOI_MOD_PSII0, IF_REAL, "Cross-term dependence of sii0"),
IOP( "psii1", B4SOI_MOD_PSII1, IF_REAL, "Cross-term dependence of sii1"),
IOP( "psii2", B4SOI_MOD_PSII2, IF_REAL, "Cross-term dependence of sii2"),
IOP( "psiid", B4SOI_MOD_PSIID, IF_REAL, "Cross-term dependence of siid"),
IOP( "pagidl", B4SOI_MOD_PAGIDL, IF_REAL, "Cross-term dependence of agidl"),
IOP( "pbgidl", B4SOI_MOD_PBGIDL, IF_REAL, "Cross-term dependence of bgidl"),
IOP( "pcgidl", B4SOI_MOD_PCGIDL, IF_REAL, "Cross-term dependence of cgidl"),
IOP( "pegidl", B4SOI_MOD_PEGIDL, IF_REAL, "Cross-term dependence of egidl"),
IOP( "pntun", B4SOI_MOD_PNTUNS, IF_REAL, "Cross-term dependence of ntun"),
IOP( "pntund", B4SOI_MOD_PNTUND, IF_REAL, "Cross-term dependence of ntund"),
IOP( "pndiode", B4SOI_MOD_PNDIODES, IF_REAL,"Cross-term dependence of ndiode"),
IOP( "pndioded", B4SOI_MOD_PNDIODED, IF_REAL,"Cross-term dependence of ndiode"),
IOP( "pnrecf0", B4SOI_MOD_PNRECF0S, IF_REAL,"Cross-term dependence of nrecf0"),
IOP( "pnrecf0d", B4SOI_MOD_PNRECF0D, IF_REAL,"Cross-term dependence of nrecf0"),
IOP( "pnrecr0", B4SOI_MOD_PNRECR0S, IF_REAL,"Cross-term dependence of nrecr0"),
IOP( "pnrecr0d", B4SOI_MOD_PNRECR0D, IF_REAL,"Cross-term dependence of nrecr0"),
IOP( "pisbjt", B4SOI_MOD_PISBJT, IF_REAL, "Cross-term dependence of isbjt"),
IOP( "pidbjt", B4SOI_MOD_PIDBJT, IF_REAL, "Cross-term dependence of idbjt"),
IOP( "pisdif", B4SOI_MOD_PISDIF, IF_REAL, "Cross-term dependence of isdif"),
IOP( "piddif", B4SOI_MOD_PIDDIF, IF_REAL, "Cross-term dependence of iddif"),
IOP( "pisrec", B4SOI_MOD_PISREC, IF_REAL, "Cross-term dependence of isrec"),
IOP( "pidrec", B4SOI_MOD_PIDREC, IF_REAL, "Cross-term dependence of idrec"),
IOP( "pistun", B4SOI_MOD_PISTUN, IF_REAL, "Cross-term dependence of istun"),
IOP( "pidtun", B4SOI_MOD_PIDTUN, IF_REAL, "Cross-term dependence of idtun"),
IOP( "pvrec0", B4SOI_MOD_PVREC0S, IF_REAL, "Cross-term dependence of vrec0"),
IOP( "pvrec0d", B4SOI_MOD_PVREC0D, IF_REAL, "Cross-term dependence of vrec0d"),
IOP( "pvtun0", B4SOI_MOD_PVTUN0S, IF_REAL, "Cross-term dependence of vtun0"),
IOP( "pvtun0d", B4SOI_MOD_PVTUN0D, IF_REAL, "Cross-term dependence of vtun0d"),
IOP( "pnbjt", B4SOI_MOD_PNBJT, IF_REAL, "Cross-term dependence of nbjt"),
IOP( "plbjt0", B4SOI_MOD_PLBJT0, IF_REAL, "Cross-term dependence of lbjt0"),
IOP( "pvabjt", B4SOI_MOD_PVABJT, IF_REAL, "Cross-term dependence of vabjt"),
IOP( "paely", B4SOI_MOD_PAELY, IF_REAL, "Cross-term dependence of aely"),
IOP( "pahli",B4SOI_MOD_PAHLIS,IF_REAL, "X-term dependence of ahli"),/* v4.0 */
IOP( "pahlid",B4SOI_MOD_PAHLID,IF_REAL, "X-term dependence of ahlid"),/* v4.0 */
IOP( "pvsdfb", B4SOI_MOD_PVSDFB, IF_REAL, "Cross-term dependence of vsdfb"),
IOP( "pvsdth", B4SOI_MOD_PVSDTH, IF_REAL, "Cross-term dependence of vsdth"),
IOP( "pdelvt", B4SOI_MOD_PDELVT, IF_REAL, "Cross-term dependence of delvt"),
IOP( "pacde", B4SOI_MOD_PACDE, IF_REAL, "Cross-term dependence of acde"),
IOP( "pmoin", B4SOI_MOD_PMOIN, IF_REAL, "Cross-term dependence of amoin"),
IOP( "pnoff", B4SOI_MOD_PNOFF, IF_REAL, "Cross-term dependence of noff"), /* v3.2 */

/* v3.1 added for RF */
IOP("pxrcrg1", B4SOI_MOD_PXRCRG1, IF_REAL, "Cross-term dependence of xrcrg1"),
IOP("pxrcrg2", B4SOI_MOD_PXRCRG2, IF_REAL, "Cross-term dependence of xrcrg2"),
/* v3.1 added for RF end */

/* v4.0 backward compatibility */
IOP( "nlx",  B4SOI_MOD_NLX, IF_REAL, "Lateral non-uniform doping effect"),
IOP( "lnlx",  B4SOI_MOD_LNLX, IF_REAL, "Length dependence of nlx"),
IOP( "wnlx",  B4SOI_MOD_WNLX, IF_REAL, "Width dependence of nlx"),
IOP( "pnlx",  B4SOI_MOD_PNLX, IF_REAL, "Cross-term dependence of nlx"),
IOP( "ngidl", B4SOI_MOD_NGIDL, IF_REAL, "GIDL first parameter"),   
IOP( "lngidl", B4SOI_MOD_LNGIDL, IF_REAL, "Length dependence of ngidl"),
IOP( "wngidl", B4SOI_MOD_WNGIDL, IF_REAL, "Width dependence of ngidl"),
IOP( "pngidl", B4SOI_MOD_PNGIDL, IF_REAL, "Cross-term dependence of ngidl"),

/* Added for binning - END */

IP( "nmos", B4SOI_MOD_NMOS,  IF_FLAG, "Flag to indicate NMOS"),
IP( "pmos", B4SOI_MOD_PMOS,  IF_FLAG, "Flag to indicate PMOS"),
};

char *B4SOInames[] = {
   "Drain",
   "Gate",
   "Source",
   "Backgate",
   "",
   "Body",
   "Temp",
   "Charge",
};

int	B4SOInSize = NUMELEMS(B4SOInames);
int	B4SOIpTSize = NUMELEMS(B4SOIpTable);
int	B4SOImPTSize = NUMELEMS(B4SOImPTable);
int	B4SOIiSize = sizeof(B4SOIinstance);
int	B4SOImSize = sizeof(B4SOImodel);


