function svgcanvasload(n, file)
	if(length( regexp(file, "^/.*") )>=1) % UNIX
		fprintf( stderr, "~~svgcanvas: %d %s\n", n, file);
	elseif (length( regexp(file, "^.:.*") )>=1) % Windows
		fprintf( stderr, "~~svgcanvas: %d %s\n", n, file );
	else % Local file
		fprintf( stderr, "~~svgcanvas: %d %s/%s\n", n, pwd, file );
	endif
endfunction

function svgcanvas_delete_on_load(n, file)
	if(length( regexp(file, "^/.*") )>=1) % UNIX
		fprintf( stderr, "~~svgcanvasdeleteonload: %d %s\n", n, file);
	elseif (length( regexp(file, "^.:.*") )>=1) % Windows
		fprintf( stderr, "~~svgcanvasdeleteonload: %d %s\n", n, file );
	else % Local file
		fprintf( stderr, "~~svgcanvasdeleteonload: %d %s/%s\n", n, pwd, file );
	endif
endfunction

function svgcanvassave(n, width, height, file)
	if(length( regexp(file, "^/.*") )>=1) % UNIX
		fprintf( stderr, "~~svgcanvassave: %d %dx%d %s\n", n,  width, height, file);
	elseif (length( regexp(file, "^.:.*") )>=1) % Windows
		fprintf( stderr, "~~svgcanvassave: %d %dx%d %s\n", n,  width, height, file );
	else % Local file
		fprintf( stderr, "~~svgcanvassave: %d %dx%d %s/%s\n", n,  width, height, pwd, file );
	endif
endfunction