#   Copyright (C) 1987-2004 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Fri Sep  8 12:16:10 2006
#

######################################################################
#
# Option Definitions
#
# This file defines all of options and their default values.  Note that
# the default values here, can be overriddeng in the site-preferences
# file.
#

######################################################################
#
# General settings
#
Option::new siteName		Earth	-optclass General
Option::new userName    	""	-optclass General
Option::new helpBalloons	1	-optclass General
Option::new noviceMode		1	-optclass General
Option::new undoLength		50	-optclass General -minvalue 1 -maxvalue 999
Option::new allowDebug		0	-optclass General
Option::new contVerify		0	-optclass General
Option::new doSafeSave		1	-optclass General
Option::new saveWithCells	0	-optclass General
Option::new checkpointEnabled	0	-optclass General
Option::new checkpointFreq	300	-optclass General -minvalue 1 -maxvalue 9999
Option::new checkVersion	0	-optclass General
Option::new blockDropConnect	0	-optclass General

######################################################################
#
# Special settings
#
Option::new enableBeakModes	0	-optclass General
Option::new baderMode		0	-optclass General
Option::new trekMode		0	-optclass General
Option::new batMode		0	-optclass General
Option::new batRate		200	-optclass General

######################################################################
#
# Interface settings
#
Option::new smoothScroll	1	-optclass Interface
Option::new regionUpdate	1	-optclass Interface
Option::new showDialogImage	1	-optclass Interface
Option::new keyBindings		emacs	-optclass Interface
Option::new fontSet		normal	-optclass Interface

######################################################################
#
# Toolbar options
#
Option::new filetb		1		-optclass Toolbars
Option::new edittb		1		-optclass Toolbars
Option::new gateoptb		1		-optclass Toolbars
Option::new gateprop		1		-optclass Toolbars
Option::new undotb		1		-optclass Toolbars
Option::new zoomtb		1		-optclass Toolbars
Option::new modetb		1		-optclass Toolbars
Option::new moduletb		1		-optclass Toolbars
Option::new techtb		1		-optclass Toolbars
Option::new simctltb		1		-optclass Toolbars
Option::new simauxtb		1		-optclass Toolbars
Option::new symmodestb		1		-optclass Toolbars
Option::new symedittb		1		-optclass Toolbars
Option::new zoomtb		1		-optclass Toolbars
Option::new symporttb		1		-optclass Toolbars
Option::new symshifttb		1		-optclass Toolbars
Option::new symoprtb		1		-optclass Toolbars

######################################################################
#
# HDL text colors/fontification
#
Option::new hdlColorize		1		-optclass HDL
Option::new hdlIndenting	1		-optclass HDL
Option::new hdlIndentLevel	2		-optclass HDL -minvalue 0 -maxvalue 16
Option::new hdlIndentNoBegin	0		-optclass HDL
Option::new hdlIndentReturn	1		-optclass HDL
Option::new hdlDragSel		1		-optclass HDL
Option::new hdlCommentColor	"firebrick"	-optclass HDL
Option::new hdlCommentBold	0		-optclass HDL
Option::new hdlCommentItalic	1		-optclass HDL
Option::new hdlStringColor	"RosyBrown"	-optclass HDL
Option::new hdlStringBold	0		-optclass HDL
Option::new hdlStringItalic	0		-optclass HDL
Option::new hdlReservedColor	"magenta4"	-optclass HDL
Option::new hdlReservedBold	1		-optclass HDL
Option::new hdlReservedItalic	0		-optclass HDL
Option::new hdlGateWordColor	"red"		-optclass HDL
Option::new hdlGateWordBold	1		-optclass HDL
Option::new hdlGateWordItalic	0		-optclass HDL
Option::new hdlInstWordColor	"black"		-optclass HDL
Option::new hdlInstWordBold	1		-optclass HDL
Option::new hdlInstWordItalic	0		-optclass HDL
Option::new hdlTaskWordColor	"green4"	-optclass HDL
Option::new hdlTaskWordBold	1		-optclass HDL
Option::new hdlTaskWordItalic	0		-optclass HDL

######################################################################
#
# Simulator settings
#
Option::new simSortTraces	1	-optclass Simulate
Option::new simStepSize		1	-optclass Simulate -minvalue 1 -maxvalue 1000000
Option::new simClockStepSize	1	-optclass Simulate -minvalue 1 -maxvalue 1000000
Option::new simClockOverStep	21	-optclass Simulate -minvalue 0 -maxvalue 1000000
Option::new simDebugInterface	0	-optclass Simulate
Option::new simInitScript	""	-optclass Simulate
Option::new simCustomDelay	0	-optclass Simulate
Option::new simDelayFile	""	-optclass Simulate
Option::new valuePopUpDelay	333	-optclass Simulate -minvalue 1 -maxvalue 10000
Option::new simLogFile          ""      -optclass Simulate
Option::new warningMode		3	-optclass Simulate -minvalue 1 -maxvalue 4
Option::new glitchSuppress	1	-optclass Simulate

######################################################################
#
# Library Options
#
Option::new simVPDPath		"\${TKGATE_HOME}/vpd"		-optclass Libraries
Option::new simVLibPath		"\${TKGATE_HOME}/vlib"		-optclass Libraries
Option::new simVLibNames	""				-optclass Libraries

######################################################################
#
# Security Options
#
Option::new securityHandling	1	-optclass Security
Option::new securityExec	1	-optclass Security
Option::new securityWriteMem	0	-optclass Security
Option::new securityOpen	0	-optclass Security
Option::new securitySend	0	-optclass Security
Option::new securityEnqueue	1	-optclass Security


######################################################################
#
# HTML Options
#
Option::new browserCommand	"firefox %s"			-optclass HTML
Option::new emailCommand	"thunderbird %s"		-optclass HTML

######################################################################
#
# Critical Path Options
#
Option::new flashCPath		1
Option::new numCPath		10

######################################################################
#
# Default colors
#
Option::new instColor          "blue"		-optclass Color
Option::new moduleColor        "magenta4"	-optclass Color
Option::new modulePortColor    "cyan4"		-optclass Color
Option::new frameColor         "black"		-optclass Color
Option::new commentColor       "black"		-optclass Color
Option::new hyperlinkColor     "blue3"		-optclass Color
Option::new wireColor          "green4"		-optclass Color
Option::new busColor           "red"		-optclass Color
Option::new toolColor          "black"		-optclass Color
Option::new cpathColor         "red"		-optclass Color
Option::new gridColor          "black"		-optclass Color
Option::new oneColor           "green4"		-optclass Color
Option::new zeroColor          "magenta"	-optclass Color
Option::new floatColor         "blue"		-optclass Color
Option::new unknownColor       "red"		-optclass Color
Option::new offLedColor	       "lavender"	-optclass Color
Option::new onLedColor         "red"		-optclass Color
Option::new zLedColor          "yellow"		-optclass Color
Option::new backgroundColor    "white"		-optclass Color

######################################################################
#
# Print options
#
Option::new printer		default			-optclass Print
Option::new printDefCmdTmp	"lpr"			-optclass Print
Option::new printCmdTmp		"lpr -P\${PRINTER}"	-optclass Print
Option::new printCommands	{}			-optclass Print
Option::new printPgSize(US)	Letter			-optclass Print
Option::new printPgSize(*)	A4			-optclass Print
Option::new printPgOrient	landscape		-optclass Print
Option::new printDuplex		0			-optclass Print
Option::new printStyle		fit			-optclass Print
Option::new printIndex		0			-optclass Print
Option::new printGraph		0			-optclass Print
Option::new printMergeSmall	1			-optclass Print

