#   Copyright (C) 1987-2004 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Fri Jul 27 22:51:26 2007
#
#

set emptyImageData {#define aa_width 10
#define aa_height 10
static unsigned char aa_bits[] = {
   0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
   0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
   0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
   0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
   0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0};}

image create bitmap emptyImage -data $emptyImageData
font create SSValFont -family Helvetica -size 8

#############################################################################
#
# Procedures in this namespace are used to handle the color selector.
#
namespace eval Color {
  variable colors {
     red red3 firebrick orange brown coral1 sienna tan4 RosyBrown MistyRose3 seashell 
     green green2 green4 chartreuse4 YellowGreen OliveDrab turquoise aquamarine3 aquamarine DarkSeaGreen3 honeydew 
     blue MediumBlue navy RoyalBlue purple SlateBlue CornflowerBlue MediumOrchid4 SkyBlue lavender GhostWhite 
     magenta magenta2 magenta3 violet magenta4 DarkMagenta thistle2 plum3 plum3 LavenderBlush2 orchid4 
     yellow yellow2 yellow3 khaki1 LemonChiffon khaki3 cornsilk yellow4 beige seashell2 ivory4 
     cyan cyan2 LightSeaGreen PaleTurquoise cyan4 PowderBlue azure AliceBlue LightCyan3 CadetBlue DarkSlateGray 
     black gray10 gray20 gray30 gray40 gray50 gray60 gray70 gray80 gray90 white 
  }

  proc setReidaiColor {w c} {
    global colorreidai_w

    if { $w == ".opts.t.f.f.props.c.edit.backgroundc" } {
      $colorreidai_w.c1 configure -bg $c
      $colorreidai_w.c2 configure -bg $c
      return
    }

    foreach s {c1 c2} {
      #
      # Try both as some objects need -fill and others need -foreground
      #
      foreach t [$colorreidai_w.$s find withtag $w] {
	catch {
	  $colorreidai_w.$s itemconfigure $t -outline $c
	} r
	if { $r != "" } {
	  catch {
	    $colorreidai_w.$s itemconfigure $t -fill $c
	  } r
	}
	if { $r != "" } {
	  catch {
	    $colorreidai_w.$s itemconfigure $t -foreground $c
	  }
	}
      }
    }
  }

  proc setColor {w c vname} {
    catch { global $vname }

    set $vname $c
    $w configure  -bg $c -activebackground $c
    catch { setReidaiColor $w $c }
  }

  #
  # Dialog box for selecting color
  #
  proc postSelector {pw vname} {
    variable colors
    catch { global $vname }

    set x [expr [winfo rootx $pw] - 75]
    set y [expr [winfo rooty $pw] - 75]

    set n [llength $colors]
    set width [expr $n/7]

    set w .colorbox
    if { [catch {toplevel $w -cursor arrow }] } { return }
    wm resizable $w 0 0
    wm title $w "TkGate: Color Selection"
    wm geometry $w +${x}+$y
    wm transient $w $pw
    wm overrideredirect $w 1

    frame $w.pallet -bg gray90 -bd 2 -relief raised

    set bgcolor [$w.pallet cget -bg]


    set dialog_color [set $vname]
    set x 0
    set y 0
    foreach c $colors {
      if { $c == $dialog_color } { set relief sunken } else { set relief flat }


      button $w.pallet.c${x}_$y -image emptyImage -bg $c \
	  -activebackground $c -command "destroy $w" -relief $relief \
	  -highlightbackground $bgcolor -highlightthickness 2 -command "Color::setColor $pw $c $vname; destroy $w"
      grid $w.pallet.c${x}_$y -row $y -column $x -padx 1 -pady 1

      bind $w.pallet.c${x}_$y <Enter> "$w.pallet.c${x}_$y configure -highlightbackground cyan3 -relief raised"
      bind $w.pallet.c${x}_$y <Leave> "$w.pallet.c${x}_$y configure -highlightbackground $bgcolor -relief $relief"


      helpon $w.pallet.c${x}_$y $c

      incr y
      if { $y >= $width } {
	set y 0
	incr x
      }
    }

    pack $w.pallet -fill both -ipadx 15 -ipady 15

    button $w.dismiss -bg gray90 -text [m b.dismiss] -command "destroy $w"
    pack $w.dismiss -fill x


    dialogWait $w
  }

  proc setDefaults {w} {
    global tkgdef_moduleColor tkgdef_modulePortColor tkgdef_frameColor tkgdef_commentColor
    global tkgdef_hyperlinkColor tkgdef_wireColor tkgdef_busColor tkgdef_zeroColor
    global tkgdef_toolColor tkgdef_cpathColor tkgdef_gridColor tkgdef_oneColor tkgdef_instColor
    global tkgdef_floatColor tkgdef_unknownColor tkgdef_offLedColor tkgdef_onLedColor tkgdef_zLedColor tkgdef_backgroundColor

    setColor $w.edit.instc    $tkgdef_instColor			opts_instColor		
    setColor $w.edit.modc     $tkgdef_moduleColor		opts_moduleColor		
    setColor $w.edit.modpc    $tkgdef_modulePortColor		opts_modulePortColor	
    setColor $w.edit.framec   $tkgdef_frameColor		opts_frameColor		
    setColor $w.edit.commc    $tkgdef_commentColor		opts_commentColor	
    setColor $w.edit.hlinkc   $tkgdef_hyperlinkColor		opts_hyperlinkColor	
    setColor $w.edit.wirec    $tkgdef_wireColor			opts_wireColor		
    setColor $w.edit.busc     $tkgdef_busColor			opts_busColor		
    setColor $w.edit.toolc    $tkgdef_toolColor			opts_toolColor		
    setColor $w.edit.cpathc   $tkgdef_cpathColor		opts_cpathColor		
    setColor $w.edit.offledc  $tkgdef_offLedColor		opts_offLedColor		
    setColor $w.edit.onledc   $tkgdef_onLedColor		opts_onLedColor		
    setColor $w.edit.zledc    $tkgdef_zLedColor           	opts_zLedColor           
    setColor $w.scope.backgroundc $tkgdef_backgroundColor	opts_backgroundColor	

    setColor $w.scope.gridc    $tkgdef_gridColor		opts_gridColor		
    setColor $w.scope.onec     $tkgdef_oneColor			opts_oneColor		
    setColor $w.scope.zeroc    $tkgdef_zeroColor		opts_zeroColor		
    setColor $w.scope.floatc   $tkgdef_floatColor		opts_floatColor		
    setColor $w.scope.unknownc $tkgdef_unknownColor		opts_unknownColor	
  }

  proc selectorbutton {w vname} {
    variable colors
    catch { global $vname }

    set c [set $vname]

    catch { setReidaiColor $w $c }

    button $w -image emptyImage -bg $c -activebackground $c -command "Color::postSelector $w $vname"
  }
}

namespace eval NameDlg {
  variable w .namedlg
  variable result

  proc ok {} {
    variable w
    variable result
    set result [$w.t.e get]
    destroy  $w
  }

  proc cancel {} {
    variable w
    variable result
    set result ""
    destroy  $w
  }

  #############################################################################
  #
  # Query function that can be used to get aribirary names.
  #
  proc post args {
    variable w
    variable result

    set parent .
    set value ""
    set title "TkGate: Add Library"
    set caption [m opt.vlibadd.cap]
    set explaination [m opt.vlibadd.exp]
    set image [gifI general.gif]
    set label [m opt.libname]
    parseargs $args {-parent -value -title -caption -explaination -image -label}
    set parent [gettoplevel $parent]

    if { [catch {toplevel $w}] } { return }

    wm resizable $w 0 0
    wm title $w $title
    wm geometry $w [offsetgeometry $parent 50 50]
    wm transient $w $parent

    frame $w.t -relief raised -bd 2

    dialogImage $w.t.image -image $image -caption $caption -explaination $explaination
    pack $w.t.image -side left

    frame $w.t.pad1
    frame $w.t.pad2
    label $w.t.l -text $label
    entry $w.t.e
    $w.t.e insert end $value
    pack $w.t.pad1 -fill y -expand 1
    pack  $w.t.l  $w.t.e -anchor w -padx 50
    pack $w.t.pad2 -fill y -expand 1

    okcancel $w.b -okcommand NameDlg::ok  -cancelcommand NameDlg::cancel
    pack $w.t $w.b -fill both

    bind $w.t.e <Return> NameDlg::ok
    focus $w.t.e

    dialogWait $w
    
    return $result
  }
}

#############################################################################
#
# Create a dialog box group for editing a list of directories or files.
#
namespace eval PathSelector {
  variable ps_filter
  variable ps_filetypes

  proc add {w variable query} {
    variable ps_filter
    variable ps_filetypes
    catch { global $variable }

    if { $ps_filter($w) != "none" } {
      set dirname [$query -parent $w -defaultextension $ps_filter($w) -filetypes $ps_filetypes($w) ]
    } else {
      set dirname [$query -parent $w]
    }
    if {$dirname != "" } {
      $w.dirs.lb insert end $dirname
    }

    set $variable [$w.dirs.lb get 0 end]
  }

  proc del {w  variable} {
    catch { global $variable }
    
    set idx [$w.dirs.lb curselection]
    if { $idx != "" } {
      catch { $w.dirs.lb delete $idx }
    }

    set $variable [$w.dirs.lb get 0 end]
  }

  proc edit {w  variable edit} {
    catch { global $variable }

    set idx [$w.dirs.lb curselection]
    if { $idx != "" } {
      set name [$w.dirs.lb get $idx]
      set new_name [$edit -parent $w -value $name]
      if { $new_name != "" } {
	$w.dirs.lb insert $idx $new_name
	$w.dirs.lb delete [expr $idx+1]
      }
    }
    set $variable [$w.dirs.lb get 0 end]
  }

  proc create {w args} {
    variable ps_filter
    variable ps_filetypes

    set variable opts_simTIMPath
    set query tk_chooseDirectory
    set label [m opt.devfilepath]
    set filter "none"
    set filetypes "none"
    set height 3
    set edit ""
    parseargs $args {-variable -query -label -filter -filetypes -height -edit}
    catch { global $variable }

    set ps_filter($w) $filter
    set ps_filetypes($w) $filetypes

    labelframe $w $label -relief groove -bd 2
    frame $w.pad
    pack $w.pad -pady 3

    frame $w.dirs
    listbox $w.dirs.lb -height $height -xscrollcommand "$w.dirs.hb set" -yscrollcommand "$w.dirs.vb set" -bg white
    scrollbar $w.dirs.vb -orient vertical -command "$w.dirs.lb yview"
    scrollbar $w.dirs.hb -orient horizontal  -command "$w.dirs.lb xview"

    grid rowconfigure $w.dirs 0 -weight 1
    grid columnconfigure $w.dirs 0 -weight 1
    grid  $w.dirs.lb -row 0 -column 0 -sticky nsew
    grid  $w.dirs.vb -row 0 -column 1 -sticky ns
    grid  $w.dirs.hb -row 1 -column 0 -sticky ew
    pack  $w.dirs -padx 5 -pady 3 -side left -expand 1 -fill x

    button $w.add -text [m b.add] -command "PathSelector::add $w $variable $query"
    pack $w.add -padx 5 -pady 3 -fill x

    if {$height > 3  && $edit != ""} {
      button $w.edit -text [m b.edit] -command "PathSelector::edit $w $variable $edit"
      pack $w.edit -padx 5 -pady 3 -fill x
    }

    button $w.del -text [m b.remove] -command "PathSelector::del $w  $variable"
    pack $w.del -padx 5 -pady 3 -fill x

    foreach f [set $variable] {
      $w.dirs.lb insert end $f
    }
  }
}

#############################################################################
#
# Procedures in this namespace are used to handle the options dialog box.
#
namespace eval OptionDlg {
  variable edsamp_w

  #############################################################################
  #
  # User pressed the cancel button on the dialog box
  #
  proc cancel {} {
    destroy .opts
  }

  #############################################################################
  #
  # User pressed the ok button on the dialog box
  #
  proc ok {} {
    store
    destroy .opts
  }

  #############################################################################
  #
  # This function is called after clicking OK on the options dialog box.
  #
  proc store {} {
    global opts_keyBindings tkg_keyBindings tkg_gateHome
    set rereadbindings 0

    if {$opts_keyBindings != $tkg_keyBindings} {
      set rereadbindings 1
    }

    Option::dialogSave

    gat_reinitDelay
    gat_setcolors
    Option::writePreferences

#    if {$rereadbindings} {
#      KeyBinding::clearAll
#      source $tkg_gateHome/bindings/$tkg_keyBindings
#    }
  }


  #############################################################################
  #
  # Create as sample scope scene in a canvas
  #
  proc setupSampleScope {c w ew} {

    for { set y 10 } { $y < 150 } { incr y 20 } {
      $c create line 5 $y 37 $y				-tags $w.gridc
      $c create line 40 $y 200 $y -width 2		-tags $w.gridc
      for { set x 40 } { $x <= 200 } { incr x 40 } {
	$c create line $x [expr $y-2] $x [expr $y+2] -width 2 -tags $w.gridc
      }
    }

    $c create text 10 20 -text ck	 -anchor w	-tags $ew.wirec
    $c create text 10 40 -text A	 -anchor w	-tags $ew.wirec
    $c create text 10 60 -text B	 -anchor w	-tags $ew.wirec
    $c create text 10 80 -text D1	 -anchor w	-tags $ew.busc
    $c create text 10 100 -text D2 -anchor w	-tags $ew.busc

    #
    # The clock trace
    #
    set y1 15
    set y0 25
    set x 40
    set H 20
    while { $x < 175 } {
      $c create line $x $y0 [expr $x + $H]  $y0 -tags $w.zeroc
      incr x $H
      $c create line $x $y0 $x $y1 -tags $w.onec
      $c create line $x $y1 [expr $x + $H] $y1 -tags $w.onec
      incr x $H
      $c create line $x $y0 $x $y1 -tags $w.zeroc
    }

    #
    # "A" trace
    #
    set y1 35
    set yz 40
    set y0 45
    set x 40
    $c create line $x $y0 [expr $x + 45]  $y0 -tags $w.zeroc
    incr x 45
    $c create line $x $y0 $x $y1 -tags $w.onec
    $c create line $x $y1 [expr $x + 30] $y1 -tags $w.onec
    incr x 30
    $c create line $x $y1 $x $yz -tags $w.floatc
    $c create line $x $yz [expr $x + 40] $yz -tags $w.floatc
    incr x 40
    $c create line $x $yz $x $y1 -tags $w.onec
    $c create line $x $y1 [expr $x + 45] $y1 -tags $w.onec

    #
    # "B" trace
    #
    set y1 55
    set yz 60
    set y0 65
    set x 40
    $c create line $x $y0 [expr $x + 25]  $y0 -tags $w.zeroc
    incr x 25
    $c create line $x $y0 $x $y1 -tags $w.unknownc
    $c create line $x $y1 [expr $x + 30] $y1 -tags $w.unknownc
    $c create line $x $y0 [expr $x + 30] $y0 -tags $w.unknownc
    incr x 30
    $c create line $x $y0 $x $y1 -tags $w.onec
    $c create line $x $y1 [expr $x + 30] $y1 -tags $w.onec
    $c create line $x $y1 $x $y0 -tags $w.zeroc
    incr x 30
    $c create line $x $y1 $x $yz -tags $w.unknownc
    $c create line $x $yz [expr $x + 40] $yz -tags $w.unknownc
    $c create line $x $y1 [expr $x + 40] $y1 -tags $w.unknownc
    incr x 40
    $c create line $x $y1 $x $y0 -tags $w.zeroc
    $c create line $x $y0 [expr $x + 35] $y0 -tags $w.zeroc

    #
    # "D1" trace
    #
    set y1 75
    set yz 80
    set y0 85
    set x 40
    $c create text $x $yz -text 42 -tags $w.onec -font SSValFont -anchor w
    $c create line $x $y0 [expr $x + 35] $y0 -tags $w.onec
    $c create line $x $y1 [expr $x + 35] $y1 -tags $w.onec
    incr x 35
    $c create text $x $yz -text 45 -tags $w.onec -font SSValFont -anchor w
    $c create line $x $y1 $x $y0 -tags $w.onec
    $c create line $x $y0 [expr $x + 25] $y0 -tags $w.onec
    $c create line $x $y1 [expr $x + 25] $y1 -tags $w.onec
    incr x 25
    $c create text $x $yz -text 0 -tags $w.zeroc -font SSValFont -anchor w
    $c create line $x $y1 $x $y0 -tags $w.zeroc
    $c create line $x $y0 [expr $x + 30] $y0 -tags $w.zeroc
    $c create line $x $y1 [expr $x + 30] $y1 -tags $w.zeroc
    incr x 30
    $c create text $x $yz -text 41 -tags $w.onec -font SSValFont -anchor w
    $c create line $x $y1 $x $y0 -tags $w.onec
    $c create line $x $y0 [expr $x + 45] $y0 -tags $w.onec
    $c create line $x $y1 [expr $x + 45] $y1 -tags $w.onec
    incr x 45
    $c create text $x $yz -text 4B -tags $w.onec -font SSValFont -anchor w
    $c create line $x $y1 $x $y0 -tags $w.onec
    $c create line $x $y0 [expr $x + 25] $y0 -tags $w.onec
    $c create line $x $y1 [expr $x + 25] $y1 -tags $w.onec

    #
    # "D2" trace
    #
    set y1 95
    set yz 100
    set y0 105
    set x 40
    $c create text $x $yz -text 49 -tags $w.onec -font SSValFont -anchor w
    $c create line $x $y0 [expr $x + 50] $y0 -tags $w.onec
    $c create line $x $y1 [expr $x + 50] $y1 -tags $w.onec
    incr x 50
    $c create line $x $y1 $x $y0 -tags $w.floatc
    $c create line $x $yz [expr $x + 30] $yz -tags $w.floatc
    incr x 30
    $c create line $x $y1 $x $y0 -tags $w.unknownc
    $c create line $x $y0 [expr $x + 30] $y0 -tags $w.unknownc
    $c create line $x $y1 [expr $x + 30] $y1 -tags $w.unknownc
    incr x 30
    $c create text $x $yz -text 53 -tags $w.onec -font SSValFont -anchor w
    $c create line $x $y1 $x $y0 -tags $w.onec
    $c create line $x $y0 [expr $x + 50] $y0 -tags $w.onec
    $c create line $x $y1 [expr $x + 50] $y1 -tags $w.onec
  }

  #############################################################################
  #
  # Create as sample editing scene in a canvas
  #
  proc setupSampleEdit {c w} {
    global bd

    $c create text 75 105 -text Comment -justify left -anchor w	-tags $w.commc
    $c create text 155 105 -text Hyperlink -justify left -anchor w -tags $w.hlinkc

    $c create line 2 75 20 75				-tags $w.wirec
    $c create line 2 85 20 85				-tags $w.wirec
    $c create line 40 80 100 80				-tags $w.wirec
    $c create bitmap 30 80 -bitmap "@$bd/sampleand.b"	-tags $w.instc
    $c create text 102 80 -text E -justify left -anchor w	-tags $w.modpc

    $c create bitmap 30 20 -bitmap "@$bd/samplemark.b"	-tags $w.toolc


    $c create line 75 80 75 65				-tags $w.wirec
    $c create bitmap 75 65 -bitmap "@$bd/sampleled.b"	-tags $w.instc
    $c create bitmap 75 65 -bitmap "@$bd/sampleledI.b"	-tags $w.offledc
    $c create rectangle 74 79 76 81			-tags $w.instc
    $c create text 75 53 -text off 			-tags $w.commc


    $c create text 173 80 -text Q -justify right -anchor e -tags $w.modpc
    $c create line 175 80 200 80  200 65			-tags $w.wirec
    $c create bitmap 200 65 -bitmap "@$bd/sampleled.b"	-tags $w.instc
    $c create bitmap 200 65 -bitmap "@$bd/sampleledI.b"	-tags $w.onledc
    $c create text 200 53 -text on 			-tags $w.commc

    $c create text 173 40 -text Z -justify right -anchor e -tags $w.modpc
    $c create line 175 40 200 40  200 25			-tags $w.wirec
    $c create bitmap 200 25 -bitmap "@$bd/sampleled.b"	-tags $w.instc
    $c create bitmap 200 25 -bitmap "@$bd/sampleledI.b"	-tags $w.zledc
    $c create text 200 13 -text float 			-tags $w.commc


    $c create line 2 40 100 40 -width 2			-tags $w.busc
    $c create line 40 45 52 33				-tags $w.busc
    $c create text 45 30 -text 8				-tags $w.busc
    $c create text 102 40 -text D -justify left -anchor w	-tags $w.modpc


    $c create rectangle 100 25 175 90			-tags $w.modc
    $c create text 138 55 -text XYOP			-tags $w.modc


    $c create rectangle 10 60 60 100 -dash {3 3}		-tags $w.framec
    $c create rectangle 15 55 47 65 -fill white -outline white
    $c create text 30 60 -text AND 			-tags $w.framec

    $c create line 140 0  140 25				-tags $w.wirec
    $c create line 140 90 140 120				-tags $w.wirec

    $c create text 135 27 -text Cin -anchor n -tags $w.modpc
    $c create text 135 88 -text Cout -anchor s -tags $w.modpc

    for { set q 0 } { $q < 5 } { incr q } {
      set dy [expr $q*5]
      $c create line 135 [expr $dy + 5] 145 [expr $dy - 5]	-tags $w.cpathc
      $c create line 135 [expr 95 + $dy + 5] 145 [expr 95 + $dy - 5]	-tags $w.cpathc
    }
    
  }

  proc kbdOptSelect {w} {
    global tkg_gateHome

    frame $w
    label $w.l -text "[m opt.keybind]:"

    Dropbox::new $w.r -variable opts_keyBindings -width 12 -bd 1 -highlightthickness 0

    foreach kbd [glob $tkg_gateHome/bindings/*] {
      set kbd [file tail $kbd]
      if {[string first "~" $kbd] < 0} {
	Dropbox::itemadd $w.r $kbd
      }
    }

    pack $w.l $w.r -side left

    helpon $w.l [m ho.opt.keybind]
    helpon $w.r [m ho.opt.keybind]
  }

  proc fontSetSelect {w} {
    global tkg_gateHome

    frame $w
    label $w.l -text "[m opt.general.fontset]:"

    Dropbox::new $w.r -variable opts_fontSet -width 12 -bd 1 -highlightthickness 0
    Dropbox::itemadd $w.r small
    Dropbox::itemadd $w.r normal
    Dropbox::itemadd $w.r large
    Dropbox::itemadd $w.r huge

    pack $w.l $w.r -side left

    helpon $w.l [m ho.opt.general.fontset]
    helpon $w.r [m ho.opt.general.fontset]
  }


  proc identity {w} {

    labelframe $w [m opt.identity] -relief groove -bd 2

    label $w.siteL -text "[m opt.site]:" -anchor w
    entry $w.siteE -width 30 -textvariable opts_siteName -bg white

    label $w.nameL -text "[m opt.username]:" -anchor w
    entry $w.nameE -width 30 -textvariable opts_userName -bg white

    grid columnconfigure $w 1 -weight 1
    grid rowconfigure $w 0 -minsize 10
    grid $w.siteL -row 1 -column 0 -sticky e  -padx 5 -pady 5
    grid $w.siteE -row 1 -column 1 -sticky ew  -padx 5 -pady 5
    grid $w.nameL -row 2 -column 0 -sticky e  -padx 5 -pady 5
    grid $w.nameE -row 2 -column 1 -sticky ew  -padx 5 -pady 5

    helpon $w.siteL [m ho.opt.site]
    helpon $w.nameL [m ho.opt.name]
  }

  proc html {w} {
    frame $w

    labelframe $w.c [m opt.html.linkopts]

    frame $w.c.pad
    grid $w.c.pad -row 0 -column 0 -pady 5


    label $w.c.html_l -text [m opt.html.browser]:
    entry $w.c.html_e -textvariable opts_browserCommand

    label $w.c.email_l -text [m opt.html.email]:
    entry $w.c.email_e -textvariable opts_emailCommand

    grid columnconfigure $w.c 1 -weight 1
    grid $w.c.html_l -row 1 -column 0 -sticky e  -padx 5 -pady 5
    grid $w.c.html_e -row 1 -column 1 -sticky ew  -padx 5 -pady 5
    grid $w.c.email_l -row 2 -column 0 -sticky e  -padx 5 -pady 5
    grid $w.c.email_e -row 2 -column 1 -sticky ew  -padx 5 -pady 5

    pack $w.c -padx 5 -pady 5 -fill both -anchor w

    helpon $w.c.html_l [m ho.opt.html.browser]
    helpon $w.c.email_l [m ho.opt.html.email]
  }

  proc colors {w} {
    global colorreidai_w

    frame $w.c

    set colorreidai_w $w.reidai
    frame $w.reidai
    canvas $w.reidai.c1 -bd 2 -relief sunken -width 1 -height 115 -bg white
    canvas $w.reidai.c2 -bd 2 -relief sunken -width 1 -height 115 -bg white
    setupSampleEdit $w.reidai.c1 $w.c.edit
    setupSampleScope $w.reidai.c2 $w.c.scope $w.c.edit

    labelframe $w.c.edit [m opt.color.editwin]
    labelframe $w.c.scope [m opt.color.scopewin]
    pack $w.c.edit $w.c.scope -fill both -expand 1 -padx 5 -pady 5

    label $w.c.edit.inst -text [m opt.inst]
    Color::selectorbutton $w.c.edit.instc opts_instColor

    label $w.c.edit.mod -text [m opt.mods]
    Color::selectorbutton $w.c.edit.modc opts_moduleColor

    label $w.c.edit.modp -text [m opt.modports]
    Color::selectorbutton $w.c.edit.modpc opts_modulePortColor

    label $w.c.edit.frame -text [m opt.frames]
    Color::selectorbutton $w.c.edit.framec opts_frameColor

    label $w.c.edit.comm -text [m opt.comment]
    Color::selectorbutton $w.c.edit.commc opts_commentColor

    label $w.c.edit.hlink -text [m opt.hlink]
    Color::selectorbutton $w.c.edit.hlinkc opts_hyperlinkColor

    label $w.c.edit.wire -text [m opt.wire]
    Color::selectorbutton $w.c.edit.wirec opts_wireColor

    label $w.c.edit.bus -text [m opt.bus]
    Color::selectorbutton $w.c.edit.busc opts_busColor

    label $w.c.edit.tool -text [m opt.tools]
    Color::selectorbutton $w.c.edit.toolc opts_toolColor

    label $w.c.edit.cpath -text [m opt.cpath] 
   Color::selectorbutton $w.c.edit.cpathc opts_cpathColor

    label $w.c.edit.background -text [m opt.background]
    Color::selectorbutton $w.c.edit.backgroundc opts_backgroundColor

    label $w.c.edit.offled -text [m opt.offled]
    Color::selectorbutton $w.c.edit.offledc opts_offLedColor

    label $w.c.edit.onled -text [m opt.onled]
    Color::selectorbutton $w.c.edit.onledc opts_onLedColor

    label $w.c.edit.zled -text [m opt.zled]
    Color::selectorbutton $w.c.edit.zledc opts_zLedColor


    ### Scope Items
    label $w.c.scope.grid -text [m opt.grid]
    Color::selectorbutton $w.c.scope.gridc opts_gridColor

    label $w.c.scope.one -text [m opt.logic1]
    Color::selectorbutton $w.c.scope.onec opts_oneColor

    label $w.c.scope.zero -text [m opt.logic0]
    Color::selectorbutton $w.c.scope.zeroc opts_zeroColor

    label $w.c.scope.float -text [m opt.float]
    Color::selectorbutton $w.c.scope.floatc opts_floatColor

    label $w.c.scope.unknown -text [m opt.unknown]
    Color::selectorbutton $w.c.scope.unknownc opts_unknownColor

    set r 1
    set c 0
    set colorItem { background inst mod modp frame comm hlink wire bus tool cpath offled onled zled }
    foreach ci $colorItem {
      grid $w.c.edit.$ci     -row $r  -column $c -padx 5 -pady 0 -sticky w
      grid $w.c.edit.${ci}c  -row $r  -column [expr $c+1] -padx 5 -pady 0 -sticky w

      if { $c == 0 } {
	set c 3
      } else {
	set c 0
	incr r
      }
    }
    grid columnconfigure $w.c.edit 2 -minsize 50
    grid columnconfigure $w.c.edit 0 -minsize 130
    grid columnconfigure $w.c.edit 3 -minsize 130
    grid rowconfigure $w.c.edit 0 -minsize 10

    set r 1
    set c 0
    set colorItem { grid one zero float unknown  }
    foreach ci $colorItem {
      grid $w.c.scope.$ci     -row $r  -column $c -padx 5 -pady 0 -sticky w
      grid $w.c.scope.${ci}c     -row $r  -column [expr $c+1] -padx 5 -pady 0 -sticky w

      if { $c == 0 } {
	set c 3
      } else {
	set c 0
	incr r
      }
    }
    grid columnconfigure $w.c.scope 2 -minsize 50
    grid columnconfigure $w.c.scope 0 -minsize 130
    grid columnconfigure $w.c.scope 3 -minsize 130
    grid rowconfigure $w.c.scope 0 -minsize 10

    pack $w.c -anchor w -fill both -expand 1

    pack $w.reidai.c1 $w.reidai.c2 -side left -fill x -expand 1 -padx 5 -pady 3
    pack $w.reidai -fill both -expand 1
    
#    button $w.def -text [m opt.restdef] -command "Color::setDefaults $w.c"
#    pack $w.def -anchor sw -padx 5 -pady 5
  }

  proc stylegroup {w l v} {
    frame $w
    label $w.l -width 15 -text $l -justify left -anchor w

    Color::selectorbutton $w.color opts_${v}Color
    label $w.color_l -text [m opt.editor.color]

    trace variable ::opts_${v}Color w OptionDlg::editorDoColor

    frame $w.pad -width 4
    checkbutton $w.bold -text [m opt.editor.bold] -variable opts_${v}Bold -command OptionDlg::editorDoColor
    checkbutton $w.italic -text [m opt.editor.italic] -variable opts_${v}Italic -command OptionDlg::editorDoColor

    pack $w.l -padx 5 -pady 2 -side left -anchor w
    pack $w.color -padx 6 -pady 2 -side left -anchor w
    pack $w.color_l $w.pad -pady 2 -side left -anchor w
    pack $w.bold $w.italic -padx 8 -pady 2 -side left -anchor w
  }

  proc editorSample {w} {
    variable edsamp_w 

    set edsamp_w $w
    text $w -height 12 -bg white -width 22
    $w insert end "// line comment\n"
    $w insert end "module foo(X,Y,Z,A,B);\n"
    $w insert end "  output X,Y,Z;\n"
    $w insert end "  input A,B;\n"
    $w insert end "  reg Z;\n"
    $w insert end "   /* block comment */\n"
    $w insert end "  initial\n"
    $w insert end "    \$display(\"start\");\n"
    $w insert end "  and g1(X,A,B);\n"
    $w insert end "  bar g2(Y,A,B);\n"
    $w insert end "\n"
    $w insert end "endmodule\n"

    $w tag add hdlComment 1.0 1.end
    $w tag add hdlComment 6.3 6.end
    $w tag add hdlReserved 2.0 2.6
    $w tag add hdlReserved 3.2 3.8
    $w tag add hdlReserved 4.2 4.7
    $w tag add hdlReserved 5.2 5.5
    $w tag add hdlReserved 7.2 7.9
    $w tag add hdlReserved 12.0 12.9
    $w tag add hdlTaskWord 8.4 8.12
    $w tag add hdlString 8.13 8.20
    $w tag add hdlGateWord 9.2 9.5
    $w tag add hdlInstWord 10.2 10.5
    $w configure -state disabled
  }

  proc editorDoColor args {
    variable edsamp_w
    global opts_hdlColorize

    foreach vname {hdlComment hdlReserved hdlGateWord hdlInstWord hdlTaskWord hdlString} {
      global opts_${vname}Color opts_${vname}Bold opts_${vname}Italic
      catch {
	set bold ""
	set italic ""

	if { $opts_hdlColorize } {
	  set color [set opts_${vname}Color]
	  if {[set opts_${vname}Bold]} { set bold Bold }
	  if {[set opts_${vname}Italic]} { set italic Italic }
	} else {
	  set color black
	}


	$edsamp_w tag configure $vname -foreground $color -font hdl${bold}${italic}Font
      }
    }
  }

  proc editorOptions {w} {
    frame $w

    frame $w.pad -height 8
    pack $w.pad

    stylegroup $w.comment [m opt.editor.comments] hdlComment
    frame $w.bar1 -height 2 -bd 1 -relief sunken
    stylegroup $w.string [m opt.editor.strings] hdlString
    frame $w.bar2 -height 2 -bd 1 -relief sunken
    stylegroup $w.reserved [m opt.editor.reserved] hdlReserved
    frame $w.bar3 -height 2 -bd 1 -relief sunken
    stylegroup $w.gate [m opt.editor.gateword] hdlGateWord
    frame $w.bar4 -height 2 -bd 1 -relief sunken
    stylegroup $w.task [m opt.editor.taskword] hdlTaskWord
    frame $w.bar5 -height 2 -bd 1 -relief sunken
    stylegroup $w.inst [m opt.editor.instword] hdlInstWord

    pack $w.comment -anchor w
    pack $w.bar1 -fill x -expand 1 -padx 10
    pack $w.string -anchor w
    pack $w.bar2 -fill x -expand 1 -padx 10
    pack $w.reserved -anchor w
    pack $w.bar3 -fill x -expand 1 -padx 10
    pack $w.gate -anchor w
    pack $w.bar4 -fill x -expand 1 -padx 10
    pack $w.task -anchor w
    pack $w.bar5 -fill x -expand 1 -padx 10
    pack $w.inst -anchor w
  }

  proc editor {w} {
    frame $w

    labelframe $w.features [m opt.editor.features] -relief groove -bd 2
    frame $w.features.pad -height 3
    checkbutton $w.features.movesel -text [m opt.editor.movesel] -variable opts_hdlDragSel
    pack $w.features.pad $w.features.movesel -anchor w -padx 5 -pady 2

    helpon $w.features.movesel [m ho.opt.editor.movesel]

    checkframe $w.format [m opt.editor.format] -relief groove -bd 2 -variable opts_hdlIndenting
    frame $w.format.pad -height 8
    frame $w.format.indent
    label $w.format.indent.l -text [m opt.editor.indentlevel]
    entry $w.format.indent.e -bg white -width 5 -textvariable opts_hdlIndentLevel
    bindtags $w.format.indent.e [concat [list NumEntry] [bindtags $w.format.indent.e]]
    checkbutton $w.format.beginindent -text [m opt.editor.beginindent] -variable opts_hdlIndentNoBegin
    checkbutton $w.format.rtab -text [m opt.editor.returntab] -variable opts_hdlIndentReturn

    helpon $w.format_label [m ho.opt.editor.format]
    helpon $w.format.indent.l [m ho.opt.editor.indent]
    helpon $w.format.rtab [m ho.opt.editor.rtab]
    helpon $w.format.beginindent [m ho.opt.editor.beginindent]

    pack $w.format.indent.l $w.format.indent.e -side left
    pack $w.format.pad $w.format.indent  -anchor w -padx 5 -pady 4
    pack $w.format.beginindent $w.format.rtab -anchor w -padx 5 -pady 2

    checkframe $w.color [m opt.editor.colorize] -relief groove -bd 2 -variable opts_hdlColorize -command OptionDlg::editorDoColor

    helpon $w.color_label [m ho.opt.editor.colorize]

    editorOptions $w.color.opts
    pack $w.color.opts -side left

    editorSample $w.color.sample
    pack $w.color.sample -side left -padx 10 -pady 5 -fill x -expand 1

    # top-level packing in tab.
    pack $w.features  $w.format  $w.color -fill both -anchor w -padx 5 -pady 5

    editorDoColor
  }

  proc input {w} {
    labelframe $w [m opt.input] -relief groove -bd 2

    frame $w.f
    frame $w.f.f1
    frame $w.f.pad
    kbdOptSelect $w.f.f1.kbd
    pack $w.f.f1.kbd -anchor nw -pady 2

    #
    # top-level frames
    #
    pack $w.f.f1 -side left -anchor nw
    pack $w.f.pad -side left -anchor nw -padx 10
#    pack $w.f.f2 -side left -anchor nw
    pack $w.f -padx 10 -pady 10 -anchor w

  }

  proc display {w} {
    labelframe $w [m opt.display] -relief groove -bd 2
    frame $w.f
    frame $w.f.f1
    frame $w.f.pad
    frame $w.f.f2

    checkbutton $w.f.f1.ss -variable opts_smoothScroll -text [m opt.smoothscroll]
    checkbutton $w.f.f1.ru -variable opts_regionUpdate -text [m opt.regudate]
    checkbutton $w.f.f2.db -variable opts_showDialogImage -text [m opt.showimage]
    fontSetSelect $w.f.f2.fss

    pack $w.f.f1.ss -anchor w
    pack $w.f.f1.ru -anchor w
    pack $w.f.f2.db -anchor w
    pack $w.f.f2.fss -anchor w

    #
    # top-level frames
    #
    pack $w.f.f1 -side left -anchor nw
    pack $w.f.pad -side left -anchor nw -padx 10
    pack $w.f.f2 -side left -anchor nw
    pack $w.f -padx 10 -pady 10 -anchor w

    helpon $w.f.f1.ss [m ho.opt.smooth]
    helpon $w.f.f1.ru [m ho.opt.clip]
    helpon $w.f.f2.db [m ho.opt.showimage]
  }

  proc basic {w} {
    labelframe $w [m opt.features] -relief groove -bd 2

    frame $w.f
    frame $w.f.f1
    frame $w.f.pad
    frame $w.f.f2

    checkbutton $w.f.f1.ssave -variable opts_doSafeSave -text [m opt.safeSave]
    checkbutton $w.f.f1.fsave -variable opts_saveWithCells -text [m opt.saveCells]
#    checkbutton $w.f.f1.nv -variable opts_noviceMode -text [m opt.novice]
    checkbutton $w.f.f1.bdc -variable opts_blockDropConnect -text [m opt.blockDropConnect]

    pack $w.f.f1.ssave -anchor w -pady 2
    pack $w.f.f1.fsave -anchor w -pady 2
#    pack $w.f.f1.nv -anchor w -pady 2
    pack $w.f.f1.bdc -anchor w -pady 2


    frame $w.f.f2.cpe
    checkbutton $w.f.f2.cpe.b -variable opts_checkpointEnabled -text [m opt.ckpoint]
    label $w.f.f2.cpe.l -text "   [m opt.freq]:"
    entry $w.f.f2.cpe.e -textvariable opts_checkpointFreq -width 4 -bg white
    pack $w.f.f2.cpe.b $w.f.f2.cpe.l $w.f.f2.cpe.e -side left

    frame $w.f.f2.ud
    label $w.f.f2.ud.l -text "[m opt.undolen]:"
    entry $w.f.f2.ud.e -textvariable opts_undoLength -width 4 -bg white
    pack  $w.f.f2.ud.l  $w.f.f2.ud.e -side left
    checkbutton $w.f.f2.hb -variable opts_helpBalloons -text [m opt.balloon]

    pack $w.f.f2.cpe -anchor nw -pady 2
    pack $w.f.f2.ud -anchor nw -pady 2
    pack $w.f.f2.hb -anchor nw -pady 2



    #
    # top-level frames
    #
    pack $w.f.f1 -side left -anchor nw
    pack $w.f.pad -side left -anchor nw -padx 10
    pack $w.f.f2 -side left -anchor nw
    pack $w.f -padx 10 -pady 10 -anchor w

    helpon $w.f.f1.ssave [m ho.opt.ssave]
    helpon $w.f.f1.fsave [m ho.opt.fsave]
#    helpon $w.f.f1.nv [m ho.opt.novice]
    helpon $w.f.f1.bdc [m ho.opt.blockDropConnect]
    helpon $w.f.f2.cpe.b [m ho.opt.ckpt]
    helpon $w.f.f2.cpe.l [m ho.opt.ckptfreq]
    helpon $w.f.f2.ud [m ho.opt.undolen]
    helpon $w.f.f2.hb [m ho.opt.bhelp]
  }


  proc toolbar {w name toolbars} {
    labelframe $w $name -relief groove -bd 2

    frame $w.f

    set ncols [m @opt.tool.columns]
    set numInRow [expr ([llength $toolbars]+$ncols-1)/$ncols]

    set r 0
    set c 0
    foreach t $toolbars {
      set name [m [lindex $t 0]]
      set help [m [lindex $t 1]]
      set var  [lindex $t 2]

      checkbutton $w.f.b${r}_$c -variable $var -text $name
      grid  $w.f.b${r}_$c -row $r -column $c -sticky w

      helpon $w.f.b${r}_$c $help

      incr r
      if { $r >= $numInRow } {
	grid columnconfigure  $w.f [expr $c+1] -minsize [m @opt.tool.colwidth]
	incr c 2
	set r 0
      }
    }
    pack $w.f -padx 10 -pady 10 -anchor w
  }

  proc modes {w} {
    #  frame $w -relief groove -bd 2
    checkframe $w [m opt.useless] -relief groove -bd 2 -variable opts_enableBeakModes
    frame $w.pad
    pack $w.pad -pady 6

    frame $w.f
    checkbutton $w.f.bat -text [m opt.bat] -variable opts_batMode
    checkbutton $w.f.trek -text [m opt.trek] -variable opts_trekMode
    checkbutton $w.f.miles -text [m opt.miles] -variable opts_baderMode

    grid $w.f.bat -row 0 -column 0 -sticky w
    grid $w.f.trek -row 0 -column 2 -sticky w
    grid $w.f.miles -row 0 -column 4 -sticky w

    grid columnconfigure $w.f 1 -minsize 50
    grid columnconfigure $w.f 3 -minsize 50

    pack $w.f -padx 5 -pady 5 -anchor w

    helpon ${w}_label [m ho.opt.beak]
    helpon $w.f.miles [m ho.opt.miles]
    helpon $w.f.bat [m ho.opt.bat]
    helpon $w.f.trek [m ho.opt.trek]
  }

  proc debug {w} {

    frame $w

    frame $w.flags -relief groove -bd 2

    checkbutton $w.flags.cvfy -variable opts_contVerify -text [m opt.contver] -anchor w
    checkbutton $w.flags.simdbg -variable opts_simDebugInterface -text [m opt.showsimcmd] -anchor w
    pack $w.flags.cvfy  $w.flags.simdbg  -padx 5 -pady 5 -fill x -anchor w

    pack $w.flags -fill x -pady 5

    helpon $w.flags.cvfy [m ho.contver]
    helpon $w.flags.simdbg [m ho.simwatch]
  }

  #############################################################################
  #
  # simulator options
  #
  proc simBase {w} {
    global simscr_w

    labelframe $w [m opt.simbase] -relief groove -bd 2
    frame $w.pad
    pack $w.pad -pady 3

    frame $w.t

    label $w.t.simstepL -text "[m opt.estepsz]:"
    entry $w.t.simstepE -width 5 -textvariable opts_simStepSize -bg white

    label $w.t.clkstepL -text "[m opt.cstepsz]:"
    entry $w.t.clkstepE -width 5 -textvariable opts_simClockStepSize -bg white

    label $w.t.clkostepL -text "[m opt.overstep]:"
    entry $w.t.clkostepE -width 5 -textvariable opts_simClockOverStep -bg white

    label $w.t.vpopL -text "[m opt.vpopupdelay]:"
    entry $w.t.vpopE -width 5 -textvariable opts_valuePopUpDelay -bg white

    checkbutton $w.dosort -text "[m opt.sorttraces]" -variable opts_simSortTraces
    checkbutton $w.noglitch -text "[m opt.simulator.noglitch]" -variable opts_glitchSuppress

    grid columnconfigure $w.t 2 -weight 1
    grid $w.t.simstepL	-row 0 -column 0 -sticky e -padx 5 -pady 5
    grid $w.t.simstepE	-row 0 -column 1 -sticky w -padx 5 -pady 5
    grid $w.t.vpopL	-row 1 -column 0 -sticky e -padx 5 -pady 5
    grid $w.t.vpopE	-row 1 -column 1 -sticky w -padx 5 -pady 5 

    grid $w.t.clkostepL	-row 0 -column 3 -sticky e -padx 5 -pady 5
    grid $w.t.clkostepE	-row 0 -column 4 -sticky w -padx 5 -pady 5 
    grid $w.t.clkstepL	-row 1 -column 3 -sticky e -padx 5 -pady 5
    grid $w.t.clkstepE	-row 1 -column 4 -sticky w -padx 5 -pady 5 

    pack $w.t -anchor w -fill x
    pack $w.dosort -padx 5 -pady 5 -anchor w 
    pack $w.noglitch -padx 5 -pady 5 -anchor w 

    helpon $w.t.simstepL [m ho.opt.simstep]
    helpon $w.t.clkstepL [m ho.opt.ckstep]
    helpon $w.t.clkostepL [m ho.opt.ckover]
    helpon $w.t.vpopL [m ho.opt.vpopupdelay]
    helpon $w.dosort [m ho.opt.sorttraces]
    helpon $w.noglitch [m ho.opt.sim.noglitch]
  }

  proc simError {w} {
    global opts_simDelayFile

    labelframe $w [m opt.simulator.err] -relief groove -bd 2
    frame $w.pad
    pack $w.pad -pady 6

    radiobutton $w.stopany -text [m opt.simulator.stopany] -value 4 -variable opts_warningMode
    radiobutton $w.showall -text [m opt.simulator.showall] -value 3 -variable opts_warningMode
    radiobutton $w.showiferr -text [m opt.simulator.showiferr] -value 2 -variable opts_warningMode
    radiobutton $w.ignore -text [m opt.simulator.ignore] -value 1 -variable opts_warningMode

    pack $w.stopany -anchor w -padx 5
    pack $w.showall -anchor w -padx 5
    pack $w.showiferr -anchor w -padx 5
    pack $w.ignore -anchor w -padx 5

    frame $w.pad2
    pack $w.pad2 -pady 3

    helpon ${w}_label [m ho.opt.sim.err]
    helpon $w.stopany [m ho.opt.sim.err.stopany]
    helpon $w.showall [m ho.opt.sim.err.showall]
    helpon $w.showiferr [m ho.opt.sim.err.showiferr]
    helpon $w.ignore [m ho.opt.sim.err.ignore]
  }

  proc securityFeatures {w} {
    labelframe $w [m opt.sec.simfeatures]
    frame $w.pad
    pack $w.pad -pady 5

    checkbutton $w.send -text [m opt.sec.send] -variable opts_securitySend
    checkbutton $w.open -text [m opt.sec.open] -variable opts_securityOpen
    checkbutton $w.writemem -text [m opt.sec.writemem] -variable opts_securityWriteMem
    checkbutton $w.enqueue -text [m opt.sec.enqueue] -variable opts_securityEnqueue
    
    pack $w.send -anchor w -padx 5 -pady 2
    pack $w.open -anchor w -padx 5 -pady 2
    pack $w.writemem -anchor w -padx 5 -pady 2
    pack $w.enqueue -anchor w -padx 5 -pady 2

    helpon $w.send [m ho.opt.sec.send]
    helpon $w.open [m ho.opt.sec.open]
    helpon $w.writemem [m ho.opt.sec.writemem]
    helpon $w.enqueue [m ho.opt.sec.enqueue]
  }

  proc securityExecLevel {w} {
    labelframe $w [m opt.sec.execlevel]
    frame $w.pad
    pack $w.pad -pady 5

    radiobutton $w.exec -text [m opt.sec.exec] -variable opts_securityExec -value 2
    radiobutton $w.regexec -text [m opt.sec.regexec] -variable opts_securityExec -value 1
    radiobutton $w.noexec -text [m opt.sec.noexec] -variable opts_securityExec -value 0

    pack $w.exec -anchor w -padx 5 -pady 2
    pack $w.regexec -anchor w -padx 5 -pady 2
    pack $w.noexec -anchor w -padx 5 -pady 2

    helpon $w.exec [m ho.opt.sec.exec]
    helpon $w.regexec [m ho.opt.sec.regexec]
    helpon $w.noexec [m ho.opt.sec.noexec]
  }

  proc securityHandle {w} {
    labelframe $w [m opt.sec.handle]
    frame $w.pad
    pack $w.pad -pady 5

    radiobutton $w.stop -text [m opt.sec.stop] -value 2 -variable opts_securityHandling
    radiobutton $w.warn -text [m opt.sec.warn] -value 1 -variable opts_securityHandling
    radiobutton $w.ignore -text [m opt.sec.ignore] -value 0 -variable opts_securityHandling
    
    pack $w.stop -anchor w -padx 5 -pady 2
    pack $w.warn -anchor w -padx 5 -pady 2
    pack $w.ignore -anchor w -padx 5 -pady 2

    helpon $w.stop	[m ho.opt.sec.stop]
    helpon $w.warn	[m ho.opt.sec.warn]
    helpon $w.ignore	[m ho.opt.sec.ignore]
  }

  proc other {w} {
    frame $w -relief groove -bd 2
    checkbutton $w.l -text [m opt.vercheck] -anchor w -variable opts_checkVersionn -justify left
    pack $w.l -padx 5 -pady 3 -fill both -anchor w
  }

  proc analysis {w} {
    global opts_numCPath tkg_cpathListLengths


    labelframe $w [m opt.cpopts] -relief groove -bd 2
    frame $w.pad
    pack $w.pad -pady 5

    checkbutton $w.flash -text [m opt.cpflash] -variable opts_flashCPath

    frame $w.num
    label $w.num.l -text [m opt.maxpath]
    menubutton $w.num.v -text $opts_numCPath -indicatoron 1 -relief raised -bd 2 -menu $w.num.v.m -width 3
    menu $w.num.v.m -tearoff 0
    set path_maxes $tkg_cpathListLengths
    foreach n $path_maxes {
      $w.num.v.m add command -label $n -command "$w.num.v configure -text $n; set opts_numCPath $n"
    }
    pack $w.num.l  $w.num.v -side left

    pack $w.flash -padx 20 -pady 3 -anchor w
    pack $w.num -padx 20 -pady 3 -anchor w
  }

  #############################################################################
  #
  # Handle tabs on the options dialog box.
  #
  proc dotab {w tab} {
    global tkg_enableBeakModes

    frame $w
    frame $w.props
    pack $w.props -side right -fill both -expand 1

    set caption ""
    set explaination ""
    set gif general.gif

    switch $tab {
      General {
	identity $w.props.b
	basic $w.props.d
	pack  $w.props.b $w.props.d -padx 5 -pady 5 -fill both -anchor w

	if { $tkg_enableBeakModes } {
	  OptionDlg::modes $w.props.bm
	  pack $w.props.bm -fill both -padx 5 -pady 5
	}
	set explaination [m opt.general.exp]
	set caption [m opt.general.cap]
      }
      Interface {
	OptionDlg::display $w.props.dpy
	OptionDlg::input $w.props.in
	pack $w.props.in -padx 5 -pady 5 -fill both -anchor w
	pack $w.props.dpy -padx 5 -pady 5 -fill both -anchor w


	set explaination [m opt.interface.exp]
	set caption [m opt.interface.cap]
	set gif iface.gif
      }
      Toolbars {
	set base_toolbars {
	  {opt.tool.file ho.opt.tool.file opts_filetb}
	  {opt.tool.edit ho.opt.tool.edit opts_edittb}
	  {opt.tool.gateopt ho.opt.tool.gateopt opts_gateoptb}
	  {opt.tool.gateprop ho.opt.tool.gateprop opts_gateprop}
	  {opt.tool.undo ho.opt.tool.undo opts_undotb}
	  {opt.tool.zoom ho.opt.tool.zoom opts_zoomtb}
	  {opt.tool.mode ho.opt.tool.mode opts_modetb}
	  {opt.tool.module ho.opt.tool.module opts_moduletb}
	  {opt.tool.tech ho.opt.tool.tech opts_techtb}
	}
	set sim_toolbars {
	  {opt.tool.simctl ho.opt.tool.simctl opts_simctltb}
	  {opt.tool.simaux ho.opt.tool.simaux opts_simauxtb}
	}
	set symed_toolbars {
	  {opt.tool.symmode ho.opt.tool.symmode opts_symmodestb}
	  {opt.tool.symedit ho.opt.tool.symedit opts_symedittb}
	  {opt.tool.symport ho.opt.tool.symport opts_symporttb}
	  {opt.tool.symshift ho.opt.tool.symshift opts_symshifttb}
	  {opt.tool.symopr ho.opt.tool.symopr opts_symoprtb}
	}


	OptionDlg::toolbar $w.props.tb1 [m opt.gen.basetoolbar] $base_toolbars
	OptionDlg::toolbar $w.props.tb2 [m opt.gen.simtoolbar] $sim_toolbars
	OptionDlg::toolbar $w.props.tb3 [m opt.gen.symedtoolbar] $symed_toolbars

	pack $w.props.tb1 $w.props.tb2 $w.props.tb3 -padx 5 -pady 5 -fill both -anchor w
	set explaination [m opt.toolbars.exp]
	set caption [m opt.toolbars.cap]
	set gif iface.gif
      }
      HDL {
	editor $w.props.e
	pack $w.props.e -fill both -anchor w
	set caption [m opt.editor.cap]
	set explaination [m opt.editor.exp]
      }
      Print {
	PrintDlg::lprSelect $w.props.lpr -relief groove -radioframe 0 -fromoptions 1
	PrintDlg::paperSelect $w.props.pap right
	PrintDlg::styleSelect $w.props.sty groove
	pack $w.props.lpr -fill x -pady 5 -padx 5
	pack $w.props.pap -fill x -pady 5 -padx 5
	pack $w.props.sty -fill x -pady 5 -padx 5
	set explaination [m opt.print.exp]
	set caption [m opt.print.cap]
	set gif printer.gif
      }
      Analysis {
	OptionDlg::analysis $w.props.analy
	pack $w.props.analy -fill x  -padx 5 -pady 5
	set explaination [m opt.analysis.exp]
	set caption [m opt.analysis.cap]
      }
      Simulate {
	global gdf_filter gdf_filetypes

	OptionDlg::simBase $w.props.base
	pack $w.props.base -fill x -padx 5 -pady 5

	PathSelector::create $w.props.delay -label [m opt.delayfilepath] -query tk_getOpenFile -variable opts_simDelayFile \
	    -filter $gdf_filter -filetypes $gdf_filetypes -height 4
	pack $w.props.delay -fill x  -padx 5 -pady 5

	helpon $w.props.delay_label [m ho.opt.sim.tech]

	OptionDlg::simError $w.props.error
	pack $w.props.error -fill x  -padx 5 -pady 5

	frame $w.props.pad
	pack $w.props.pad -fill both -expand 1

	set explaination [m opt.simulator.exp]
	set caption [m opt.simulator.cap]
	set gif simulate.gif
      }
      Libraries {
	PathSelector::create $w.props.vpath -label [m opt.vlibpath] -query tk_chooseDirectory -variable opts_simVLibPath -height 4
	pack $w.props.vpath -fill x  -padx 5 -pady 5

	PathSelector::create $w.props.vlib -label [m opt.vlibnames] -query NameDlg::post -variable opts_simVLibNames -height 4
	pack $w.props.vlib -fill x  -padx 5 -pady 5

	PathSelector::create $w.props.vpd -label [m opt.devfilepath] -query tk_chooseDirectory -variable opts_simVPDPath -height 4
	pack $w.props.vpd -fill x  -padx 5 -pady 5

	helpon $w.props.vpath_label	[m ho.opt.lib.vpath]
	helpon $w.props.vlib_label	[m ho.opt.lib.vlib]
	helpon $w.props.vpd_label	[m ho.opt.lib.vpd]

	set explaination [m opt.library.exp]
	set caption [m opt.library.cap]
      }
      Security {
	OptionDlg::securityFeatures $w.props.sec
	pack $w.props.sec -fill x -padx 5 -pady 5

	OptionDlg::securityExecLevel $w.props.elevel
	pack $w.props.elevel -fill x -padx 5 -pady 5

	OptionDlg::securityHandle $w.props.handle
	pack $w.props.handle -fill x -padx 5 -pady 5

	set explaination [m opt.security.exp]
	set caption [m opt.security.cap]
	set gif general.gif
      }
      Color {
	OptionDlg::colors $w.props
	set explaination [m opt.color.exp]
	set caption [m opt.color.cap]
	set gif colorprops.gif
      }
      HTML {
	OptionDlg::html $w.props.html
	pack $w.props.html -fill x  -padx 5

	set explaination [m opt.html.exp]
	set caption [m opt.html.cap]
      }
      Debug {
	OptionDlg::debug $w.props.opts
	pack $w.props.opts -fill x  -padx 5
	set explaination [m opt.debug.exp]
	set caption [m opt.debug.cap]
	set gif bug.gif
      }
    }

    pack $w.props -fill both -pady 5

    dialogImage $w.image -image [gifI $gif] -caption $caption -explaination $explaination
    pack $w.image -fill both -side left -pady 10
  }

  proc restorePageDefaults {} {
    set w .opts.t
    set tab [TabBox::getactive $w]
    Option::restoreDefaults $tab
    TabBox::select $w [TabBox::getactiveidx $w] -reopen 1
  }

  proc restoreAllDefaults {} {
    set w .opts.t
    set tab [TabBox::getactive $w]
    Option::restoreDefaults
    TabBox::select $w [TabBox::getactiveidx $w] -reopen 1
  }

  proc buttonBar {w} {
    frame $w -relief raised -bd 2
    button $w.ok -text [m b.ok] -command OptionDlg::ok
    pack $w.ok -side left -padx 5 -pady 5

    button $w.cancel -text [m b.cancel] -command OptionDlg::cancel
    pack $w.cancel -side right -padx 5 -pady 5

    button $w.restore -text [m opt.bbar.restore] -command OptionDlg::restorePageDefaults
    pack $w.restore -side right -padx 5 -pady 5

    button $w.restoreall -text [m opt.bbar.restoreall] -command OptionDlg::restoreAllDefaults
    pack $w.restoreall -side right -padx 5 -pady 5
  }

  proc post {} {
    global tkg_allowDebug
    global tkg_fontScale
    global tkg_showDialogImage

    set width [expr ([m @opt.width] + 170*$tkg_showDialogImage) * $tkg_fontScale]
    set height [expr [m @opt.height]  * $tkg_fontScale]
    set tabwidth [expr [m @opt.tabwidth] * $tkg_fontScale]

    Option::dialogLoad

    set w .opts
    if { [catch {toplevel $w}] } { return }

    wm resizable $w 0 0
    wm title $w "TkGate: Options"
    wm geometry $w [offsetgeometry . 50 50]
    wm transient $w .

    frame $w.pad
    pack $w.pad -pady 3

    #  frame $w.t -relief raised -bd 2
    #    frame $w.t
    # [m opt.analysis] removed
    # 

    set tabs {General Interface Toolbars HDL Print Simulate Libraries Security Color HTML}
    set labels [list [m opt.general] [m opt.interface] [m opt.toolbars] [m opt.editor] [m opt.print] [m opt.simulate] [m opt.library] [m opt.security] [m opt.color] [m opt.html]]

    if { $tkg_allowDebug } {
      lappend tabs Debug
      lappend labels [m opt.debug]
    }

    TabBox::new $w.t -width $width -height $height -tabwidth $tabwidth -tabs $tabs -command OptionDlg::dotab -tablabels $labels

    #  pack $w.t.tab -padx 5 -pady 5
#    pack $w.t.tab

#    okcancel $w.b -okcommand OptionDlg::ok -cancelcommand OptionDlg::cancel
    buttonBar $w.b
    pack $w.t $w.b -fill both

    bind $w <Return> OptionDlg::ok

    dialogWait $w

    ToolBar::updateEnabled
  }
}


