#############################################################################
#
#   Copyright (C) 1987-2005 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Fri Sep 14 21:58:10 2007
#

#############################################################################
#
# The following variables have been set before this file executes:
#
#    sd				The directory with tcl script files
#    bd				The directory with bitmaps
#    lang			Language code (e.g. "en", "ja", "fr", ...)
#    territory			Territory code (e.g., "US", "GB", "JP", ...)
#    simOn			Indicates that the simulator is active.
#    tkg_gateHome		The home directory for tkgate.
#    tkg_doSplash		Indicates if a splash window should be displayed.
#    tkg_currentFile		Name of current file being edited.
#    tkg_tutotialDir		Directory with tutorial files.
#    tkg_exampleDir		Directory with example files.
#    tkg_progVer		TkGate version number
#    tkg_description		Text descrition of tkgate
#    tkg_copyright		Copyright message
#    tkg_mailContact		E-mail address of tkgate maintainer
#    tkg_homepage		Homepage of  tkgate maintainer
#    tkg_localdoc		Location of local html format documentation
#
#

#############################################################################
#
# This is the function that is called to start up tkgate.
#
proc startTkGate {} {
  global tkgate_isInitialized mode tkg_allowDebug
  global tkg_progName tkg_progVer tkg_gateHome tkg_prefFile
  global main_w tkg_checkpointFreq tkg_keyBindings
  global sd

  set tkgate_isInitialized 0

  global menu_forbidden
  if {[info tclversion] < 8.4} {
    set menu_forbidden {-compound -image -selectimage}
  } else {
    set menu_forbidden {}
  }


  #############################################################################
  #
  # Load in the basic tcl files we need to start the splash screen.
  #
  uplevel "source $sd/misc.tcl"
  uplevel "source $sd/optdefaults.tcl"
  uplevel "source $sd/parms.tcl"

  #############################################################################
  #
  # Read site preferences
  #
  if {[file exists $tkg_gateHome/site-preferences]} {
    uplevel "source $tkg_gateHome/site-preferences"
  }

  #############################################################################
  #
  # read user preferences
  #
  if {[file exists $tkg_prefFile]} {
    uplevel "source $tkg_prefFile"
  }

  #############################################################################
  #
  # Begin display of the splash window
  #
  start_splash

  #############################################################################
  #
  # Do font and options initialization.
  #
  uplevel "source $sd/init.tcl"


  #############################################################################
  #
  # Load in the primary tkgate tcl code
  #
  foreach f {keys ipanel dragger tabbox pane dropbox helpon tree spreadsheet wizard frame info
    blocktree blockops blocklist netlist portlist sidebar menu popups status print scope
    toolbar message errbox editgate find circuit simulator simopts breakpoint scriptmgr vpd file options
    cpath license undo action symboledit hdledit library debug} {

    uplevel "source $sd/${f}.tcl"
  }


  #############################################################################
  #
  # If debugging is enabled, set up debugging key bindings.
  #
  if { $tkg_allowDebug } {
    KeyBinding::new <F7>		Action::dumpWires
    KeyBinding::new <Alt-v>		Action::verify
    KeyBinding::new <F6>		Action::debugMode
  }


  #
  # Set up hex and number entry tags
  #
  hexEntrySetup
  numEntrySetup
  floatEntrySetup

  #
  # Set up main window panes.
  #
  panedSetup

  #
  # Side bar setup
  #
  tkg_setupSideBar .pane.sbar

  #
  # Status bar setup
  #
  makeStatus .status
  after [expr $tkg_checkpointFreq * 1000] tkg_checkpointReq

  #
  # Set key bindings
  #
  KeyBinding::loadBindings $tkg_gateHome/bindings/$tkg_keyBindings

  #
  # Toolbar initialization
  #
  ToolBar::init
  if { $tkg_allowDebug } {
    Menu::setFlags D
  }



  #
  # Basic setup for the main window.
  #
  wm title . "$tkg_progName $tkg_progVer"
  wm minsize . 830 585
  setupIconWindow


  #
  # Main canvas setup
  #
  tkg_gatewin $main_w.main   -width 100 -height 100 -takefocus 0 \
      -xscrollcommand "$main_w.horz set" -yscrollcommand "$main_w.vert set" -bg seashell
  grid $main_w.main -row 0 -column 0 -sticky nsew

  bind $main_w.main <Button-1> 	{ action -Press { tkg_buttonPress %W %x %y %s %b } }
  bind $main_w.main <Double-Button-1>	{ continueAction -DblPress { tkg_buttonDoublePress %W %x %y %s } }
  bind $main_w.main <ButtonRelease-1>	{ continueAction - { tkg_buttonRelease %W %x %y %s } }

  bind $main_w.main <Motion>	{ continueAction - { tkg_buttonMotion %W %x %y %s } }
  bind $main_w.main <Button-1>	{+ focus .tbar.m }
  
  bind $main_w.main <Button-3>	{ action -Select { PopupMenu::post %W %x %y %s %X %Y} }

  #############################################################################
  #
  # This forces the forces the focus to be returned to the menu bar (which
  # processes keyboard commands) any time the mouse is pressed in the main
  # window.  In most cases, the focus should stay there automatically.  This
  # handler is a contingency.
  #
  bind $main_w <Button> ToolBar::takeFocus


  #############################################################################
  #
  # Start the cpath flasher.
  #
  tkg_flashCPath

  #############################################################################
  #
  # Set up initial mode.
  #
  ToolBar::modeChanged $mode
  Menu::setState edit

  gat_init
  gat_makeMakeShortcuts

  VPD::loadScripts

  end_splash

  set tkgate_isInitialized 1

  update
#  Selection::init
}

#############################################################################
#
# Initialize the tkgate interface.
#
startTkGate
