/****************************************************************************
    Copyright (C) 1987-2005 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Wed Sep 12 08:34:36 2007
****************************************************************************/
#include <stdio.h>
#include <ctype.h>
#include <sys/time.h>
#include <stdarg.h>
#include "tkgate.h"

int guiActive = 0;

int MESSAGEBARSIZE = 50;

int MB_MESSAGEX = 25;
int MB_MESSAGEY = 40;

int MB_STATUSX = 25;
int MB_STATUSY = 20;

/*
 * The editstate is an optional argument need for modes 2 and 3.
 *
 * Notes:
 *   XGate.tcl		is non-zero if we are using a GUI
 *   guiActive		is non-zero if the GUI is being actively displayed
 *
 */
void message(int mode,const char *s,...)
{
  va_list ap;
  char buf[1024];
  extern int quietMode;
  int did_display = 0;		/* Could we display message in GUI? */

  va_start(ap, s);
  vsprintf(buf,s,ap);
  va_end(ap);


  if (XGate.tcl && mode == 0) {
    /*
     * Legacy support for old-style mode values
     */
    Tcl_SetVar(XGate.tcl,"tkg_statusMessage",buf,TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY);
    return;
  }

  if (XGate.tcl && (mode & MC_STATUS)) {
    Tcl_SetVar(XGate.tcl,"tkg_statusMessage",buf,TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY);
    did_display = 1;
  }


  if (guiActive && (mode & MC_ERRBOX)) {
    Tcl_VarEval(XGate.tcl, "errmsg {",buf,"}",0);
    did_display = 1;
  }

  if (XGate.tcl && (mode & MC_MSGLOG)) {
    const char *color = 0;

    if ((mode & MC_URGENT))
      color = "red";
    else if ((mode & MC_WARNING))
      color = "goldenrod";
    else
      color = "black";

    if ((mode & MC_SILENT))
      DoTclL("InfoPanel::log",buf,"-noshow","1","-color",color,NULL);
    else
      DoTclL("InfoPanel::log",buf,"-color",color,NULL);
    did_display = 1;
  }

  if (!quietMode && !did_display) {
#if HAVE_ICONV_H
    char qbuf[1024];
    DoTcl("iconv decode \"%s\"",quoteChars(qbuf,buf,TCL_SPECIALCHARS));
    strcpy(buf,XGate.tcl->result);
#endif
    fprintf(stderr,"tkgate: %s\n",buf);
  }
}

int fontheight(Tk_Font F)
{
  Tk_FontMetrics metrics;

  Tk_GetFontMetrics(F,&metrics);

  return metrics.linespace + 3;
}

/*
    Draw the string ala ZDrawString.  Includes temporary hacked support
    for strings with mixed latin and kanji characters.  Characters with
    the high bit set are assumed to be kanji.  This function is partially
    broken in that it assumes the font for the latin portion is XGate.textF
    when in fact it may be whatever is set in the gc.  For now, since kanji
    is only allowed in comments and frames, this should not be a problem.
*/
void GKDrawString(Display *D,Window W,GC gc,int x,int y,const char *ps,int l)
{
  if (XGate.japaneseMode) {
    char buf[STRMAX];
    char *s = buf;

    strncpy(buf,ps,STRMAX);
    while (l > 0) {
      int m = 0;
      int i;

      if ((s[0] & 0x80)) {		/* Kanji segment */
	for (m = 0;m < l && (s[m] & 0x80);m++);
	for (i = 0;i < m;i++) s[i] &= 0x7f;
	ZDrawString16(D,W,XGate.kanjiGC,x,y,(XChar2b*)s,m/2);
	if (m != l) x += KANJIFONT_WIDTH*(m/2);
	for (i = 0;i < m;i++) s[i] |= 0x80;
      } else {				/* non-Kanji segment */
	for (m = 0;m < l && !(s[m] & 0x80);m++);
	ZDrawString(D,W,gc,x,y,s,m);
	if (m != l) x += Tk_TextWidth(XGate.textF[XGate.circuit->zoom_factor],s,m);
      }

      l -= m;
      s += m;
    }
  } else {
    /*
     * If not handling Japanese, don't do any special processing.
     */
    ZDrawString(D,W,gc,x,y,(char*)ps,l);
  }
}

/*
   Get the width of a string.  This may be extended in the future to handle
   mixed english/japanese fonts.
*/
int GKTextWidth(Tk_Font F,const char *ps,int l)
{
  if (XGate.japaneseMode) {
    char buf[STRMAX];
    char *s = buf;
    int w = 0;


    strncpy(buf,ps,STRMAX);

    while (l > 0) {
      int m = 0;
      int i;

      if ((s[0] & 0x80)) {		/* Kanji segment */
	for (m = 0;m < l && (s[m] & 0x80);m++);
	for (i = 0;i < m;i++) s[i] &= 0x7f;
      
	w += KANJIFONT_WIDTH*(m/2);
	for (i = 0;i < m;i++) s[i] |= 0x80;
      } else {				/* non-Kanji segment */
	for (m = 0;m < l && !(s[m] & 0x80);m++);
	w += Tk_TextWidth(F,s,m);
      }

      l -= m;
      s += m;
    }

    return w;
  } else {
    return Tk_TextWidth(F,ps,l);
  }
}

int PosDrawString(Window W,Tk_Font F,GC gc,int x,int y,const char *S,int p){
  Tk_FontMetrics metrics;
  int x_w,y_w;

  if (!F) F = XGate.textF[1];

  Tk_GetFontMetrics(F,&metrics);

  //  unZoomMetrics(&metrics);
  
  if (*S == '_') {
    S++;
    x_w = GKTextWidth(F,S,strlen(S));
    y_w = metrics.linespace + 3;

    if (p & BetweenLeftAndRight) {
      ZDrawLine(XGate.D,W,gc,x - x_w/2,y - 2*y_w/3,
		x + x_w/2,y - 2*y_w/3);
    } else if (p & AtRight) {
      ZDrawLine(XGate.D,W,gc,x - x_w,y - 2*y_w/3,
		x,y - 2*y_w/3);
    } else if (p & AtLeft) {
      ZDrawLine(XGate.D,W,gc,x,y - 2*y_w/3,
		x + x_w,y - 2*y_w/3);
    }
  } else
    x_w = GKTextWidth(F,S,strlen(S));
  
  if (p & BetweenLeftAndRight)
    x -= x_w/2;
  else if (p & AtRight)
    x -= x_w;

  if (p & BetweenTopAndBottom)
    y += (metrics.ascent - metrics.descent)/2;
  else if (p & AtTop)
    y += metrics.ascent;
  else if (p & AtBottom)
    y -= metrics.descent;


  GKDrawString(XGate.D,W,gc,x,y,S,strlen(S));
  
  return x_w + x;
}

int dce_DrawString(GC gc,int x,int y,int p,const char *s)
{
  return PosDrawString(XGate.W,0,gc,ctow_x(x),ctow_y(y),s,p);
}

int RelPosDrawString(Window W,Tk_Font F,GC gc,int x,int y,const char *S,int p)
{
  int ex = PosDrawString(W,F,gc,ctow_x(x),ctow_y(y),S,p);
  return wtoc_x(ex);
}

/*
 * Lookup a message from the appropriate locality file.
 */
char *msgLookup(const char *tag)
{
  char *s = 0;
  int i;

  for (i = 0;i < 10;i++) {
    s = (char*) SHash_find(message_table,tag);

    if (!s) {
      /*
       * Message not found, generate placeholder message
       */
      char buf[1024];
      sprintf(buf,"<no-msg: %s>",tag);
      s = ob_strdup(buf);
      SHash_insert(message_table,tag,s);
      break;
    } else if (*s == '`') {
      /*
       * Redirection message.  Assume message body points to another message.
       */
      tag = s+1;
    } else
      break;
  }

  if (i == 10) {
    /*
     * Too many levels of indirection
     */
    char buf[1024];
    sprintf(buf,"<recursive: %s>",tag);
    s = ob_strdup(buf);
    SHash_insert(message_table,tag,s);
  }

  return s;
}

