/****************************************************************************
    Copyright (C) 1987-2005 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
/*

   Tunable Parameters

*/
#include "tkgate.h"

/*
 * Table of previous versions.  As of version 1.6, the table includes only
 * versions for which the flags change.  If the flag after the version name is
 * non-zero, then the save file is incompatable with the current version.
 */
VersionDef VERSIONS[]={
  {TKGATE_FULL_VERSION,0},
  {"1.9",	VF_NOBACK},
  {"1.6h",	VF_NOBACK},
  {"1.5c",	VF_NOBACK},
  {"0.5",	VF_OLD}
};
int numVersions = sizeof(VERSIONS)/sizeof(VERSIONS[0]);

/*
 * Version where extender bar features was added.
 */
char *extBarVersion = "1.6i";

char *tkg_errorLogFile	= 0;
char *tkg_siteName	= 0;
char *tkg_defaultTech	= 0;
char *tkg_browserCommand = 0;
char *tkg_emailCommand = 0;

char *BODYFONT		= "-adobe-courier-medium-r-normal--12-120-75-75-m-70-iso8859-1";
char *SMALLFONT		= "-adobe-courier-medium-r-normal--10-100-75-75-m-60-iso8859-1";
char *BOLDBODYFONT	= "-adobe-courier-bold-r-normal--12-120-75-75-m-70-iso8859-1";
char *BOLDSMALLFONT	= "-adobe-courier-bold-r-normal--10-100-75-75-m-60-iso8859-1";
char *KANJIFONT  	= "-misc-fixed-medium-r-normal--14-130-75-75-c-140-jisx0208.1983-0";
int KANJIFONT_WIDTH    	= 14;

/*
  Distances for hit testing.  The values should be the square of
  the hit distance.
 */
int MAXPORTRANGE = (12*12);		/* Maximum range for port hit */
int MAXWIRERANGE = (3*3);		/* Maximum range for wire hit */
int GATERANGE =	(15*15+1);		/* Maximum range for gate hit */
int SELMODETHRESH = (15*15);		/* Drag distance to activate select mode */

int regionUpdate = 1;
int smoothScroll = 1;
int changedp = 0;
int startrekp = 0;
int baderp = 0;
int batp = 0;
int batc = 0;
int flashCPath = 0;

/*
 * 1ns/1ns
 */
Timescale defaultTimescale = {1000000,1000000};
