/****************************************************************************
    Copyright (C) 1987-2005 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#include "tkgate.h"


#if 0
/*
 * This file containes only dead code as of 7/27/2007 - JPH
 */

/*****************************************************************************
 *
 * Helping function to clear all scripts and reclaim allocated memory.
 * Used in conjunction with Hash_flush().
 *
 *****************************************************************************/
static void script_flush(HashElem *e,Hash *h)
{
  Script *s = (Script*) HashElem_obj(e);
  delete_Script(s);
}

/*****************************************************************************
 *
 * Helping function used with qsort() to sort scripts by their ID value.
 *
 *****************************************************************************/
static int script_compare(const void *vA,const void *vB)
{
  const Script *A = *(Script**) vA;
  const Script *B = *(Script**) vB;

  return A->s_id - B->s_id;
}


/*****************************************************************************
 *
 * Delete script object.
 *
 *****************************************************************************/
void delete_Script(Script *s)
{
  int i;

  for (i = 0;i < s->s_numErrors;i++)
    ob_free(s->s_errors[i]);
  if (s->s_errors)
    ob_free(s->s_errors);
  ob_free(s->s_fileName);
  ob_free(s);
}

/*****************************************************************************
 *
 * Create new script object.
 *
 *****************************************************************************/
Script *new_Script(int id,int state, const char *fileName)
{
  Script *s = (Script*) ob_malloc(sizeof(Script),"Script");

  s->s_id = id;
  s->s_state = state;
  s->s_fileName = ob_strdup(fileName);
  s->s_numErrors = 0;
  s->s_errors = 0;

  return s;
}

/*****************************************************************************
 *
 * Insert a script into the script list in unloaded state.
 *
 *****************************************************************************/
int ScriptTable_insert(NHash *stab,int id,const char *fileName)
{
  Script *s;

  while (NHash_find(stab,id))
    id++;

  s = new_Script(id,SCS_UNLOADED,fileName);
  NHash_insert(stab,id,s);

  return id;
}

/*****************************************************************************
 *
 * Delete a script and unload
 *
 *****************************************************************************/
void ScriptTable_delete(NHash *stab,int id)
{
  Script *s = (Script*) NHash_find(stab,id);
  if (!s) return;

  if ((s->s_state  & SCS_UNLOADED_F))
    sendSimCmd("$delscript script:%d",id);

  delete_Script(s);
}

void ScriptTable_load(NHash *stab,int id)
{
  Script *s = (Script*) NHash_find(stab,id);
  if (!s) return;

  if (!XGate.circuit->simulator.active) return;
  sendSimCmd("$script script:%d %s",s->s_id, s->s_fileName);
}

void ScriptTable_unload(NHash *stab,int id)
{
  Script *s = (Script*) NHash_find(stab,id);
  if (!s) return;

  if (!XGate.circuit->simulator.active) return;
  sendSimCmd("$delscript script:%d",id);
}

void ScriptTable_loadAll(NHash *stab)
{
}

void ScriptTable_pause(NHash *stab,int id)
{
}

void ScriptTable_stop(NHash *stab,int id)
{
}

void ScriptTable_error(NHash *stab,int id,const char *message)
{
}

void ScriptTable_flush(NHash *stab)
{
}

#endif
