/****************************************************************************
    Copyright (C) 1987-2005 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#include "tkgate.h"

/*
 */

#define TTY_TD 0	/* Transmitted Data (out) */
#define TTY_RD 1	/* Receive Data (in) */
#define TTY_RTS 2	/* Request To Send (out) */
#define TTY_CTS 3	/* Clear To Send (in) */
#define TTY_DSR 4	/* Data Set Ready (in) */
#define TTY_DTR 5	/* Data Terminal Ready (out) */

static void TTY_WriteCellDef(FILE *f,GCellSpec *gcs);

static iconDimensions tty_iconDims[] = {
  {0,   0,    73, 53, 36, 27},
  {74,  0,    53, 73, 27, 36},
  {54, 74,    73, 53, 36, 25},
  {0,  54,    53, 73, 25, 36},
};
/*static int tty_iconBoldOffset = 54;*/
static int tty_iconBoldOffset = 128;

GPadLoc tty_TD_loc[] = {
 {37, -22, 37, -22, D_RIGHT},
 {-22, -37, -22, -37, D_UP},
 {-37, 22, -37, 22, D_LEFT},
 {22, 37, 22, 37, D_DOWN}
};

GPadLoc tty_RD_loc[] = {
 {37, -14, 37, -14, D_RIGHT},
 {-14, -37, -14, -37, D_UP},
 {-37, 14, -37, 14, D_LEFT},
 {14, 37, 14, 37, D_DOWN}
};

GPadLoc tty_RTS_loc[] = {
 {37, -5, 37, -5, D_RIGHT},
 {-5, -37, -5, -37, D_UP},
 {-37, 5, -37, 5, D_LEFT},
 {5, 37, 5, 37, D_DOWN}
};

GPadLoc tty_CTS_loc[] = {
 {37, 3, 37, 3, D_RIGHT},
 {3, -37, 3, -37, D_UP},
 {-37, -3, -37, -3, D_LEFT},
 {-3, 37, -3, 37, D_DOWN}
};

GPadLoc tty_DSR_loc[] = {
 {37, 11, 37, 11, D_RIGHT},
 {11, -37, 11, -37, D_UP},
 {-37, -11, -37, -11, D_LEFT},
 {-11, 37, -11, 37, D_DOWN}
};

GPadLoc tty_DTR_loc[] = {
 {37, 19, 37, 19, D_RIGHT},
 {19, -37, 19, -37, D_UP},
 {-37, -19, -37, -19, D_LEFT},
 {-19, 37, -19, 37, D_DOWN}
};

static char *psTty[] = {
  "%",
  "% Image for terminal",
  "%",
  "/tty_image <ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ffffffffffffffffffffffffffffff000000000000000000000000000000000000000000",
  "00",
  "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ffffffffffffffffffffffffffffff00ffffffffffffffffffffffffffffffffffffff00",
  "ff",
  "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ffffffffffffffffffffffffffffff00ffffffffffffffffffffffffffffffffffffff00",
  "ff",
  "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ffffffffffffffffffffffffffffff00ff0000000000ff000000ffffffffffffffffff00",
  "ff",
  "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ffffffffffffffffffffffffffffff00ffffff00ffffff00ffff00ffffffffffffffff00",
  "00",
  "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ffffffffffffffffffffffffffffff00ffffff00ffffff00ffff00ffffffffffffffff00",
  "00",
  "ffffffffffffffffffffffffff0000000000000000000000000000000000000000000000",
  "00000000000000000000ffffffffff00ffffff00ffffff00ffff00ffffffffffffffff00",
  "00",
  "ffffffffffffffffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffff",
  "ffffffffffffffff00ff00ffffffff00ffffff00ffffff00ffff00ffffffffffffffff00",
  "00",
  "ffffffffffffffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffff",
  "ffffffffffffff00ffffff00ffffff00ffffff00ffffff000000ffffffffffffffffff00",
  "ff",
  "ffffffffffffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffff",
  "ffffffffffff00ffffff0000ffffff00ffffffffffffffffffffffffffffffffffffff00",
  "ff",
  "ffffffffffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffff",
  "ffffffffff00ffffff00ff00ffffff00ffffffffffffffffffffffffffffffffffffff00",
  "ff",
  "ffffffffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ffffffff00ffffff00ffff00ffffff00ff000000ffffff000000ffffffffffffffffff00",
  "ff",
  "ffffffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ffffff00ffffff00ffffff00ffffff00ff00ffff00ffff00ffff00ffffffffffffffff00",
  "00",
  "ffffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ffff00ffffff00ffffffff00ffffff00ff00ffff00ffff00ffff00ffffffffffffffff00",
  "00",
  "ffffffffff00ff0000000000000000000000000000000000000000000000000000000000",
  "0000ffffff00ffffffffff00ffffff00ff000000ffffff00ffff00ffffffffffffffff00",
  "00",
  "ffffffffff0000ffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ffff00ff00ffffffffffff00ffffff00ff00ffff00ffff00ffff00ffffffffffffffff00",
  "00",
  "ffffffffff00ffff00000000000000000000000000000000000000000000000000000000",
  "ffffff00ffffffffffffff00ffffff00ff00ffff00ffff000000ffffffffffffffffff00",
  "ff",
  "ffffffffff00ffff00ffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "00ffff00ffffffffffffff00ffffff00ffffffffffffffffffffffffffffffffffffff00",
  "ff",
  "ffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ff00ff00ffffffffffffff00ffffff00ffffffffffffffffffffffffffffffffffffff00",
  "ff",
  "ffffffffff00ff00ffff0000000000ff00000000ff0000000000ffffffffffffffffffff",
  "ff00ff00ffffffffffffff00ffffff00ff000000ffff0000000000ffff0000ffffffff00",
  "ff",
  "ffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ff00ff00ffffffffffffff0000000000ff00ffff00ffffff00ffffff00ffffffffffff00",
  "ff",
  "ffffffffff00ff00ffff000000ff000000000000ffffffffffffffffffffffffffffffff",
  "ff00ff00ffffffffffffff00ffffff00ff00ffff00ffffff00ffffff000000ffffffff00",
  "00",
  "ffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ff00ff00ffffffffffffff0000000000ff000000ffffffff00ffffffffffff00ffffff00",
  "00",
  "ffffffffff00ff00ffff0000000000ff000000000000ff0000ffffffffffffffffffffff",
  "ff00ff00ffffffffffffff00ffffff00ff00ffff00ffffff00ffffff00ffff00ffffff00",
  "00",
  "ffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ff00ff00ffffffffffffff0000000000ff00ffff00ffffff00ffffffff0000ffffffff00",
  "ff",
  "ffffffffff00ff00ffff00ffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ff00ff00ffffffffffffff00ffffff00ffffffffffffffffffffffffffffffffffffff00",
  "ff",
  "ffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ff00ff00ffffffffffffff0000000000ffffffffffffffffffffffffffffffffffffff00",
  "ff",
  "ffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ff00ff00ffffffffffffff00ffffff00ffff0000ffff0000000000ffff0000ffffffff00",
  "ff",
  "ffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ff00ff00ffffffffffffff0000000000ff00ffff00ffffff00ffffff00ffffffffffff00",
  "ff",
  "ffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ff00ff00ffffffffffffff00ffffff00ff00ffffffffffff00ffffff00000000ffffff00",
  "00",
  "ffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ff00ff00ffffffffffffff0000000000ff00ffffffffffff00ffffffffffff00ffffff00",
  "00",
  "ffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ff00ff00ffffffffffffff00ffffff00ff00ffff00ffffff00ffffff00ffff00ffffff00",
  "00",
  "ffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ff00ff00ffffffffffffff00ffffff00ffff0000ffffffff00ffffffff0000ffffffff00",
  "ff",
  "ffffffffff00ff00ffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ff00ff00ffffffffffffff00ffffff00ffffffffffffffffffffffffffffffffffffff00",
  "ff",
  "ffffffffff00ffff00ffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "00ffff00ffffffffffffff00ffffff00ffffffffffffffffffffffffffffffffffffff00",
  "ff",
  "ffffffffff00ffffff000000000000000000000000000000000000000000000000000000",
  "ffffff00ffffffffffffff00ffffff00ff000000ffffffff0000ffff000000ffffffff00",
  "ff",
  "ffffffffff0000ffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ffff0000ffffffffffffff00ffffff00ff00ffff00ffff00ffffffff00ffff00ffffff00",
  "ff",
  "ffffffffff00ff0000000000000000000000000000000000000000000000000000000000",
  "0000ff00ffffffffffffff00ffffff00ff00ffff00ffff00000000ff00ffff00ffffff00",
  "00",
  "ffffffff00ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ffff00ffffffffffffffff00ffffff00ff00ffff00ffffffffff00ff000000ffffffff00",
  "00",
  "ffffffff00ff000000000000000000000000000000000000000000000000000000000000",
  "ffff00ffffffffffffffff00ffffff00ff00ffff00ffff00ffff00ff00ffff00ffffff00",
  "00",
  "ffffff00ffff0000ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00",
  "ff00ffffffffffffffff00ffffffff00ff000000ffffffff0000ffff00ffff00ffffff00",
  "ff",
  "ffffff00ff00ff00000000000000000000000000000000000000000000000000000000ff",
  "ff00ffffffffffffff00ffffffffff00ffffffffffffffffffffffffffffffffffffff00",
  "ff",
  "ffff00ffff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff0000ff",
  "00ffffffffffffff00ffffffffffff00ffffffffffffffffffffffffffffffffffffff00",
  "ff",
  "ffff00ff000000000000000000000000000000000000000000000000000000000000ffff",
  "00ffffffffffff00ffffffffffffff00ff000000ffff0000000000ff000000ffffffff00",
  "ff",
  "ff00ffff00ffff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00",
  "ffffffffffff00ffffffffffffffff00ff00ffff00ffffff00ffffff00ffff00ffffff00",
  "ff",
  "ff00ff00000000000000000000000000000000000000000000000000000000000000ff00",
  "ffffffffff00ffffffffffffffffff00ff00ffff00ffffff00ffffff00ffff00ffffff00",
  "00",
  "00ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff00ff",
  "ffffffff00ffffffffffffffffffff00ff00ffff00ffffff00ffffff000000ffffffff00",
  "00",
  "0000000000000000000000000000000000000000000000000000000000000000000000ff",
  "ffffff00ffffffffffffffffffffff00ff00ffff00ffffff00ffffff00ffff00ffffff00",
  "00",
  "00ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff00ff",
  "ffff00ffffffffffffffffffffffff00ff000000ffffffff00ffffff00ffff00ffffff00",
  "ff",
  "00ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff00ff",
  "ff00ffffffffffffffffffffffffff00ffffffffffffffffffffffffffffffffffffff00",
  "ff",
  "00ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff00ff",
  "00ffffffffffffffffffffffffffff00ffffffffffffffffffffffffffffffffffffff00",
  "ff",
  "00ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff0000",
  "ffffffffffffffffffffffffffffff000000000000000000000000000000000000000000",
  "00",
  "000000000000000000000000000000000000000000000000000000000000000000000000",
  "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
  "ff> def",
  "%",
  "% An tty gate",
  "%",
  "/pstty {",
  "  startgate",
  "  -36 28 translate",
  "  1 -1 scale",
  "  73 53 8 matrix { tty_image } image",
  "  grestore",
  "} bind def",
  0
};

GGateInfo gate_tty_info = {
  0,
  "TTY",
  "tty",0x0,
  "pstty",psTty,
  -1,-1,

  {{"T",	{"gm.io",0},		{"gm.io.tty",0,"x",200},	"gat_make TTY"},
   {0}},

  tty_iconDims,

  6,{{"TD",OUT,8,1,tty_TD_loc},
       {"RD",IN,8,1,tty_RD_loc},
       {"RTS",OUT,1,1,tty_RTS_loc},
       {"CTS",IN,1,1,tty_CTS_loc},
       {"DSR",IN,1,1,tty_DSR_loc},
       {"DTR",OUT,1,1,tty_DTR_loc}},
  {{0,-30,CT},{0,-30,CT},{0,-30,CT},{0,-30,CT}},
  {1},
  
  {"Dtr","Drts_up","Drts_dn","Drd","Ddtr_up","Ddtr_dn",0},

  Generic_Make,
  TTY_WriteCellDef,
  Generic_Init,
  Generic_Delete,
  Generic_GetExtents,
  Generic_HitDistance,
  Generic_Draw,
  Generic_Move,
  Generic_Copy,
  Err_AddInput,
  Err_AddOutput,
  Err_AddInOut,
  Generic_Rotate,
  Err_RemovePort,
  Err_ChangePin,
  Nop_SimStateFunc,
  Nop_SimHitFunc,
  Generic_PSWrite,
  Generic_EditProps,
  Generic_VerSave
};

/*****************************************************************************
 *
 * Generate primitive cell definition for TTYs.
 *
 * Parameters:
 *    f			File to write cell to.
 *    name		Name of cell to write.
 *
 *****************************************************************************/
static void TTY_WriteCellDef(FILE *f,GCellSpec *gcs)
{
  const char *invSpec = gcs->gc_invSpec;
  int invTD = 0, invRTS = 0, invDTR = 0;

  if (*invSpec) {
    if (*invSpec == 'N')
      invTD = 1;

    if (invSpec[1]) invSpec++;
    if (*invSpec == 'N')
      invRTS = 1;

    if (invSpec[1]) invSpec++;
    if (*invSpec == 'N')
      invDTR = 1;
  }

  GCellSpec_writeBeginModule(f,gcs);

  fprintf(f,"input CTS, DSR;\n");
  fprintf(f,"input [7:0] RD;\n");
  fprintf(f,"output [7:0] TD;\n");
  fprintf(f,"output RTS, DTR;\n");
  fprintf(f,"reg _RTS, _DTR;\n");
  fprintf(f,"reg [7:0] data;\n");


  fprintf(f,"\n");
  fprintf(f,"  initial\n");
  fprintf(f,"    begin\n");
  fprintf(f,"      _RTS = 0;\n");
  fprintf(f,"      data = 0;\n");
  fprintf(f,"      _DTR = 0;\n");
  fprintf(f,"    end\n");

  fprintf(f,"\n");
  fprintf(f,"  initial $tkg$exec(\"TTY::post %%m\");\n");

  fprintf(f,"\n");
  fprintf(f,"  always\n");
  fprintf(f,"    begin\n");
  fprintf(f,"      _DTR = 1'b0;\n");
  fprintf(f,"      @(negedge DSR);\n");
  fprintf(f,"      _DTR = 1'b1;\n");
  fprintf(f,"      # 5;\n");
  fprintf(f,"      $tkg$exec(\"TTY::data %%m %%d\", RD);\n");
  fprintf(f,"      # 10;\n");
  fprintf(f,"    end\n");

  fprintf(f,"\n");
  fprintf(f,"  always\n");
  fprintf(f,"    begin\n");
  fprintf(f,"      @ (negedge CTS);\n");
  fprintf(f,"      # 5;\n");
  fprintf(f,"      data = $tkg$read(\"%%m\");\n");
  fprintf(f,"      # 5;\n");
  fprintf(f,"      _RTS = 1'b1;\n");
  fprintf(f,"      @ (posedge CTS);\n");
  fprintf(f,"      _RTS = 1'b0;\n");
  fprintf(f,"    end\n");

  fprintf(f,"\n");
  fprintf(f,"  assign TD = %s data;\n",(invTD?"~":""));
  fprintf(f,"  assign RTS = %s_RTS;\n",(invRTS?"~":""));
  fprintf(f,"  assign DTR = %s_DTR;\n",(invDTR?"~":""));

  GCellSpec_writeEndModule(f,gcs);
}

void init_tty()
{
  Pixmap P;

  P = Pixmap_registerFromFile("tty","tty.b");
  gateinfo_iconInit(&gate_tty_info,P,tty_iconDims,tty_iconBoldOffset);
  RegisterGate(&gate_tty_info);
}
