//: version "2.0"
//: property prefix = "_GG"
//: property title = "74xx Chipset Library"

//: /netlistBegin main
module main;    //: root_module
wire w6;    //: /sn:0 {0}(42,64)(57,64){1}
wire w7;    //: /sn:0 {0}(42,48)(57,48){1}
wire w16;    //: /sn:0 {0}(180,94)(195,94){1}
wire w14;    //: /sn:0 {0}(180,126)(195,126){1}
wire w19;    //: /sn:0 {0}(180,46)(195,46){1}
wire w15;    //: /sn:0 {0}(180,110)(195,110){1}
wire w4;    //: /sn:0 {0}(42,96)(57,96){1}
wire w3;    //: /sn:0 {0}(42,112)(57,112){1}
wire w0;    //: /sn:0 {0}(42,160)(57,160){1}
wire w21;    //: /sn:0 {0}(286,78)(271,78){1}
wire w23;    //: /sn:0 {0}(286,46)(271,46){1}
wire w20;    //: /sn:0 {0}(286,94)(271,94){1}
wire w1;    //: /sn:0 {0}(42,144)(57,144){1}
wire w18;    //: /sn:0 {0}(180,62)(195,62){1}
wire w8;    //: /sn:0 {0}(148,96)(133,96){1}
wire w22;    //: /sn:0 {0}(286,62)(271,62){1}
wire w17;    //: /sn:0 {0}(180,78)(195,78){1}
wire w12;    //: /sn:0 {0}(180,158)(195,158){1}
wire w11;    //: /sn:0 {0}(148,48)(133,48){1}
wire w2;    //: /sn:0 {0}(42,128)(57,128){1}
wire w10;    //: /sn:0 {0}(148,64)(133,64){1}
wire w13;    //: /sn:0 {0}(180,142)(195,142){1}
wire w5;    //: /sn:0 {0}(42,80)(57,80){1}
wire w9;    //: /sn:0 {0}(148,80)(133,80){1}
//: enddecls

  H7402 g1 (.A1(w19), .A2(w18), .A3(w17), .A4(w16), .B1(w15), .B2(w14), .B3(w13), .B4(w12), .X1(w23), .X2(w22), .X3(w21), .X4(w20));   //: @(196, 30) /sz:(74, 144) /sn:0 /p:[ Li0>1 Li1>1 Li2>1 Li3>1 Li4>1 Li5>1 Li6>1 Li7>1 Ro0<1 Ro1<1 Ro2<1 Ro3<1 ]
  H7400 g0 (.A1(w7), .A2(w6), .A3(w5), .A4(w4), .B1(w3), .B2(w2), .B3(w1), .B4(w0), .X1(w11), .X2(w10), .X3(w9), .X4(w8));   //: @(58, 32) /sz:(74, 144) /sn:0 /p:[ Li0>1 Li1>1 Li2>1 Li3>1 Li4>1 Li5>1 Li6>1 Li7>1 Ro0<1 Ro1<1 Ro2<1 Ro3<1 ]

endmodule
//: /netlistEnd

//: /netlistBegin H7402
module H7402(B4, A4, X1, B3, B2, A2, B1, A3, X3, X2, A1, X4);
//: interface  /sz:(74, 144) /bd:[ Li0>B4(128/144) Li1>B3(112/144) Li2>B2(96/144) Li3>B1(80/144) Li4>A4(64/144) Li5>A3(48/144) Li6>A2(32/144) Li7>A1(16/144) Ro0<X4(64/144) Ro1<X3(48/144) Ro2<X2(32/144) Ro3<X1(16/144) ]
output X1;    //: /sn:0 {0}(125,144)(143,144)(143,144)(164,144){1}
input A3;    //: /sn:0 /dp:1 {0}(104,250)(74,250)(74,238)(48,238){1}
input A2;    //: /sn:0 /dp:1 {0}(104,189)(74,189)(74,178)(48,178){1}
input B2;    //: /sn:0 /dp:1 {0}(104,194)(74,194)(74,206)(48,206){1}
output X2;    //: /sn:0 {0}(164,192)(143,192)(143,192)(125,192){1}
input B1;    //: /sn:0 /dp:1 {0}(104,146)(74,146)(74,159)(48,159){1}
output X4;    //: /sn:0 {0}(125,307)(145,307)(145,307)(164,307){1}
input A1;    //: /sn:0 /dp:1 {0}(104,141)(74,141)(74,132)(48,132){1}
input B3;    //: /sn:0 /dp:1 {0}(104,255)(75,255)(75,271)(48,271){1}
input B4;    //: /sn:0 /dp:1 {0}(104,309)(74,309)(74,320)(49,320){1}
output X3;    //: /sn:0 {0}(125,253)(145,253)(145,253)(164,253){1}
input A4;    //: /sn:0 /dp:1 {0}(104,304)(74,304)(74,294)(49,294){1}
//: enddecls

  //: IN g8 (B4) @(47,320) /sn:0 /w:[ 1 ]
  //: IN g4 (A4) @(47,294) /sn:0 /w:[ 1 ]
  _GGNOR2 #(4) g3 (.I0(A4), .I1(B4), .Z(X4));   //: @(115,307) /sn:0 /w:[ 0 0 0 ]
  //: OUT g13 (X1) @(161,144) /sn:0 /w:[ 1 ]
  _GGNOR2 #(4) g2 (.I0(A3), .I1(B3), .Z(X3));   //: @(115,253) /sn:0 /w:[ 0 0 0 ]
  _GGNOR2 #(4) g1 (.I0(A2), .I1(B2), .Z(X2));   //: @(115,192) /sn:0 /w:[ 0 0 1 ]
  //: IN g11 (B3) @(46,271) /sn:0 /w:[ 1 ]
  //: IN g10 (B2) @(46,206) /sn:0 /w:[ 1 ]
  //: IN g6 (A2) @(46,178) /sn:0 /w:[ 1 ]
  //: IN g9 (B1) @(46,159) /sn:0 /w:[ 1 ]
  //: IN g7 (A3) @(46,238) /sn:0 /w:[ 1 ]
  //: OUT g15 (X3) @(161,253) /sn:0 /w:[ 1 ]
  //: OUT g14 (X2) @(161,192) /sn:0 /w:[ 0 ]
  //: IN g5 (A1) @(46,132) /sn:0 /w:[ 1 ]
  _GGNOR2 #(4) g0 (.I0(A1), .I1(B1), .Z(X1));   //: @(115,144) /sn:0 /w:[ 0 0 0 ]
  //: OUT g12 (X4) @(161,307) /sn:0 /w:[ 1 ]

endmodule
//: /netlistEnd

//: /netlistBegin H7400
module H7400(A4, B4, X1, B3, B2, A2, A3, B1, X3, A1, X2, X4);
//: interface  /sz:(74, 144) /bd:[ Li0>B4(128/144) Li1>B3(112/144) Li2>B2(96/144) Li3>B1(80/144) Li4>A4(64/144) Li5>A3(48/144) Li6>A2(32/144) Li7>A1(16/144) Ro0<X4(64/144) Ro1<X3(48/144) Ro2<X2(32/144) Ro3<X1(16/144) ]
output X1;    //: /sn:0 {0}(164,144)(125,144){1}
input A3;    //: /sn:0 {0}(48,238)(90,238)(90,250)(105,250){1}
input A2;    //: /sn:0 {0}(48,178)(90,178)(90,189)(105,189){1}
input B2;    //: /sn:0 {0}(48,206)(90,206)(90,194)(105,194){1}
output X2;    //: /sn:0 {0}(164,192)(126,192){1}
input B1;    //: /sn:0 {0}(48,159)(89,159)(89,146)(104,146){1}
output X4;    //: /sn:0 {0}(164,307)(146,307)(146,307)(129,307){1}
input A1;    //: /sn:0 {0}(48,132)(89,132)(89,141)(104,141){1}
input B4;    //: /sn:0 {0}(49,320)(93,320)(93,309)(108,309){1}
input B3;    //: /sn:0 {0}(48,271)(91,271)(91,255)(105,255){1}
output X3;    //: /sn:0 {0}(164,253)(126,253){1}
input A4;    //: /sn:0 {0}(49,294)(93,294)(93,304)(108,304){1}
//: enddecls

  //: IN g4 (A4) @(47,294) /sn:0 /w:[ 0 ]
  //: IN g8 (B4) @(47,320) /sn:0 /w:[ 0 ]
  _GGNAND2 #(4) g3 (.I0(A3), .I1(B3), .Z(X3));   //: @(116,253) /sn:0 /w:[ 1 1 1 ]
  //: OUT g13 (X1) @(161,144) /sn:0 /w:[ 0 ]
  _GGNAND2 #(4) g2 (.I0(A2), .I1(B2), .Z(X2));   //: @(116,192) /sn:0 /w:[ 1 1 1 ]
  _GGNAND2 #(4) g1 (.I0(A1), .I1(B1), .Z(X1));   //: @(115,144) /sn:0 /w:[ 1 1 1 ]
  //: IN g11 (B3) @(46,271) /sn:0 /w:[ 0 ]
  //: IN g10 (B2) @(46,206) /sn:0 /w:[ 0 ]
  //: IN g6 (A2) @(46,178) /sn:0 /w:[ 0 ]
  //: IN g7 (A3) @(46,238) /sn:0 /w:[ 0 ]
  //: IN g9 (B1) @(46,159) /sn:0 /w:[ 0 ]
  //: OUT g15 (X3) @(161,253) /sn:0 /w:[ 0 ]
  //: IN g5 (A1) @(46,132) /sn:0 /w:[ 0 ]
  //: OUT g14 (X2) @(161,192) /sn:0 /w:[ 0 ]
  _GGNAND2 #(4) g0 (.I0(A4), .I1(B4), .Z(X4));   //: @(119,307) /sn:0 /w:[ 1 1 1 ]
  //: OUT g12 (X4) @(161,307) /sn:0 /w:[ 0 ]

endmodule
//: /netlistEnd

//: /builtinBegin
module _GGNAND2 #(Diz=1) (I0, I1, Z);
output Z;
input I0;
input I1;

  assign #Diz Z = ~(I0 & I1);

endmodule
//: /builtinEnd

//: /builtinBegin
module _GGNOR2 #(Diz=1) (I0, I1, Z);
output Z;
input I0;
input I1;

  assign #Diz Z = ~(I0 | I1);

endmodule
//: /builtinEnd
