//: version "2.0-a6"
//: property prefix = "_GG"
//: property title = "menagerie.v"
//: property simAutoStart = 1
//: property discardChanges = 1
//: script "menagerie.vs"

//: require "tty"
//: require "coke"

`timescale 1ns/1ns


//: /symbolBegin: 141296144
//: /iconBegin normal 3404 0 0
//: /data "#define bitmap_width 73"
//: /data "#define bitmap_height 53"
//: /data "static unsigned char bitmap_bits[] = {"
//: /data "   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x01, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x08, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,"
//: /data "   0xe8, 0x3b, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x48,"
//: /data "   0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x48, 0x80, 0x01,"
//: /data "   0x00, 0xe0, 0xff, 0xff, 0xff, 0x3f, 0x88, 0x48, 0x80, 0x01, 0x00, 0x50,"
//: /data "   0x00, 0x00, 0x00, 0x50, 0x88, 0x48, 0x80, 0x01, 0x00, 0x28, 0x00, 0x00,"
//: /data "   0x00, 0x88, 0x88, 0x38, 0x80, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0xc4,"
//: /data "   0x08, 0x00, 0x80, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0xa2, 0x08, 0x00,"
//: /data "   0x80, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x91, 0xe8, 0x38, 0x80, 0x00,"
//: /data "   0x80, 0x02, 0x00, 0x00, 0x80, 0x88, 0x28, 0x49, 0x80, 0x01, 0x40, 0x01,"
//: /data "   0x00, 0x00, 0x40, 0x84, 0x28, 0x49, 0x80, 0x01, 0xa0, 0xff, 0xff, 0xff,"
//: /data "   0x3f, 0x82, 0xe8, 0x48, 0x80, 0x01, 0x60, 0x00, 0x00, 0x00, 0x40, 0x81,"
//: /data "   0x28, 0x49, 0x80, 0x01, 0x20, 0xff, 0xff, 0xff, 0x8f, 0x80, 0x28, 0x39,"
//: /data "   0x80, 0x00, 0x20, 0x01, 0x00, 0x00, 0x90, 0x80, 0x08, 0x00, 0x80, 0x00,"
//: /data "   0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80, 0x08, 0x00, 0x80, 0x00, 0xa0, 0x7c,"
//: /data "   0xef, 0x03, 0xa0, 0x80, 0xe8, 0x7c, 0x86, 0x00, 0xa0, 0x00, 0x00, 0x00,"
//: /data "   0xa0, 0x80, 0x2f, 0x11, 0x81, 0x00, 0xa0, 0xdc, 0x0f, 0x00, 0xa0, 0x80,"
//: /data "   0x28, 0x11, 0x87, 0x01, 0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80, 0xef, 0x10,"
//: /data "   0x88, 0x01, 0xa0, 0x7c, 0xbf, 0x01, 0xa0, 0x80, 0x28, 0x11, 0x89, 0x01,"
//: /data "   0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80, 0x2f, 0x11, 0x86, 0x00, 0xa0, 0x04,"
//: /data "   0x00, 0x00, 0xa0, 0x80, 0x08, 0x00, 0x80, 0x00, 0xa0, 0x00, 0x00, 0x00,"
//: /data "   0xa0, 0x80, 0x0f, 0x00, 0x80, 0x00, 0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80,"
//: /data "   0xc8, 0x7c, 0x86, 0x00, 0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80, 0x2f, 0x11,"
//: /data "   0x81, 0x00, 0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80, 0x28, 0x10, 0x8f, 0x01,"
//: /data "   0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80, 0x2f, 0x10, 0x88, 0x01, 0xa0, 0x00,"
//: /data "   0x00, 0x00, 0xa0, 0x80, 0x28, 0x11, 0x89, 0x01, 0xa0, 0x00, 0x00, 0x00,"
//: /data "   0xa0, 0x80, 0xc8, 0x10, 0x86, 0x00, 0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80,"
//: /data "   0x08, 0x00, 0x80, 0x00, 0x20, 0x01, 0x00, 0x00, 0x90, 0x80, 0x08, 0x00,"
//: /data "   0x80, 0x00, 0x20, 0xfe, 0xff, 0xff, 0x8f, 0x80, 0xe8, 0x30, 0x87, 0x00,"
//: /data "   0x60, 0x00, 0x00, 0x00, 0xc0, 0x80, 0x28, 0x09, 0x89, 0x00, 0xa0, 0xff,"
//: /data "   0xff, 0xff, 0xbf, 0x80, 0x28, 0x79, 0x89, 0x01, 0x10, 0x00, 0x00, 0x00,"
//: /data "   0x40, 0x80, 0x28, 0x41, 0x87, 0x01, 0xd0, 0xff, 0xff, 0xff, 0x4f, 0x80,"
//: /data "   0x28, 0x49, 0x89, 0x01, 0xc8, 0xaa, 0xaa, 0xaa, 0x2a, 0x40, 0xe8, 0x30,"
//: /data "   0x89, 0x00, 0xa8, 0xff, 0xff, 0xff, 0x27, 0x20, 0x08, 0x00, 0x80, 0x00,"
//: /data "   0xa4, 0xaa, 0xaa, 0xaa, 0x16, 0x10, 0x08, 0x00, 0x80, 0x00, 0xf4, 0xff,"
//: /data "   0xff, 0xff, 0x13, 0x08, 0xe8, 0x7c, 0x87, 0x00, 0x92, 0xaa, 0xaa, 0xaa,"
//: /data "   0x0a, 0x04, 0x28, 0x11, 0x89, 0x00, 0xfa, 0xff, 0xff, 0xff, 0x0b, 0x02,"
//: /data "   0x28, 0x11, 0x89, 0x01, 0x01, 0x00, 0x00, 0x00, 0x04, 0x01, 0x28, 0x11,"
//: /data "   0x87, 0x01, 0xff, 0xff, 0xff, 0xff, 0x87, 0x00, 0x28, 0x11, 0x89, 0x01,"
//: /data "   0x01, 0x00, 0x00, 0x00, 0x44, 0x00, 0xe8, 0x10, 0x89, 0x00, 0x01, 0x00,"
//: /data "   0x00, 0x00, 0x24, 0x00, 0x08, 0x00, 0x80, 0x00, 0x01, 0x00, 0x00, 0x00,"
//: /data "   0x14, 0x00, 0x08, 0x00, 0x80, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0c, 0x00,"
//: /data "   0xf8, 0xff, 0xff, 0x01, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00};"
//: /iconEnd
//: /iconBegin select 3389 0 0
//: /data "#define x_width 73"
//: /data "#define x_height 53"
//: /data "static unsigned char x_bits[] = {"
//: /data "   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x01, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x18, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,"
//: /data "   0xf8, 0x7b, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xd9,"
//: /data "   0xc0, 0x01, 0x00, 0xc0, 0xff, 0xff, 0xff, 0x3f, 0x98, 0xd9, 0xc0, 0x01,"
//: /data "   0x00, 0xe0, 0xff, 0xff, 0xff, 0x7f, 0x98, 0xd9, 0xc0, 0x01, 0x00, 0x70,"
//: /data "   0x00, 0x00, 0x00, 0xf8, 0x98, 0xd9, 0xc0, 0x01, 0x00, 0x38, 0x00, 0x00,"
//: /data "   0x00, 0xcc, 0x98, 0x79, 0xc0, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0xe6,"
//: /data "   0x18, 0x00, 0xc0, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0xf3, 0x18, 0x00,"
//: /data "   0xc0, 0x00, 0x00, 0x07, 0x00, 0x00, 0x80, 0xd9, 0xf8, 0x79, 0xc0, 0x00,"
//: /data "   0x80, 0x03, 0x00, 0x00, 0xc0, 0xcc, 0x78, 0xdb, 0xc0, 0x01, 0xc0, 0xff,"
//: /data "   0xff, 0xff, 0x7f, 0xc6, 0x78, 0xdb, 0xc0, 0x01, 0xe0, 0xff, 0xff, 0xff,"
//: /data "   0x3f, 0xc3, 0xf8, 0xd9, 0xc0, 0x01, 0x60, 0x00, 0x00, 0x00, 0xc0, 0xc1,"
//: /data "   0x78, 0xdb, 0xc0, 0x01, 0x60, 0xff, 0xff, 0xff, 0x8f, 0xc1, 0x78, 0x7b,"
//: /data "   0xc0, 0x00, 0xe0, 0xff, 0xff, 0xff, 0x9f, 0xc1, 0x18, 0x00, 0xc0, 0x00,"
//: /data "   0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1, 0x18, 0x00, 0xc0, 0x00, 0xe0, 0x7c,"
//: /data "   0xef, 0x03, 0xb0, 0xc1, 0xf8, 0x7d, 0xce, 0x00, 0xe0, 0x00, 0x00, 0x00,"
//: /data "   0xb0, 0xc1, 0x7f, 0x33, 0xc3, 0x00, 0xe0, 0xdc, 0x0f, 0x00, 0xb0, 0xc1,"
//: /data "   0x78, 0x33, 0xcf, 0x01, 0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1, 0xff, 0x30,"
//: /data "   0xd8, 0x01, 0xe0, 0x7c, 0xbf, 0x01, 0xb0, 0xc1, 0x78, 0x33, 0xdb, 0x01,"
//: /data "   0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1, 0x7f, 0x33, 0xce, 0x00, 0xe0, 0x04,"
//: /data "   0x00, 0x00, 0xb0, 0xc1, 0x18, 0x00, 0xc0, 0x00, 0xe0, 0x00, 0x00, 0x00,"
//: /data "   0xb0, 0xc1, 0x1f, 0x00, 0xc0, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1,"
//: /data "   0xd8, 0x7d, 0xce, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1, 0x7f, 0x33,"
//: /data "   0xc3, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1, 0x78, 0x30, 0xdf, 0x01,"
//: /data "   0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1, 0x7f, 0x30, 0xd8, 0x01, 0xe0, 0x00,"
//: /data "   0x00, 0x00, 0xb0, 0xc1, 0x78, 0x33, 0xdb, 0x01, 0xe0, 0x00, 0x00, 0x00,"
//: /data "   0xb0, 0xc1, 0xd8, 0x31, 0xce, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1,"
//: /data "   0x18, 0x00, 0xc0, 0x00, 0x60, 0x01, 0x00, 0x00, 0x98, 0xc1, 0x18, 0x00,"
//: /data "   0xc0, 0x00, 0x60, 0xfe, 0xff, 0xff, 0x8f, 0xc1, 0xf8, 0x70, 0xc7, 0x00,"
//: /data "   0xe0, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x78, 0x1b, 0xdb, 0x00, 0xe0, 0xff,"
//: /data "   0xff, 0xff, 0xbf, 0xc1, 0x78, 0xfb, 0xdb, 0x01, 0x30, 0x00, 0x00, 0x00,"
//: /data "   0xe0, 0xc0, 0x78, 0xc3, 0xcf, 0x01, 0xf0, 0xff, 0xff, 0xff, 0x6f, 0xc0,"
//: /data "   0x78, 0xdb, 0xdb, 0x01, 0xd8, 0xaa, 0xaa, 0xaa, 0x3a, 0x60, 0xf8, 0x70,"
//: /data "   0xdb, 0x00, 0xb8, 0xff, 0xff, 0xff, 0x37, 0x30, 0x18, 0x00, 0xc0, 0x00,"
//: /data "   0xac, 0xaa, 0xaa, 0xaa, 0x1e, 0x18, 0x18, 0x00, 0xc0, 0x00, 0xfc, 0xff,"
//: /data "   0xff, 0xff, 0x1b, 0x0c, 0xf8, 0x7c, 0xc7, 0x00, 0x96, 0xaa, 0xaa, 0xaa,"
//: /data "   0x0e, 0x06, 0x78, 0x33, 0xdb, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x0f, 0x03,"
//: /data "   0x78, 0x33, 0xdb, 0x01, 0x03, 0x00, 0x00, 0x00, 0x86, 0x01, 0x78, 0x33,"
//: /data "   0xc7, 0x01, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x00, 0x78, 0x33, 0xdb, 0x01,"
//: /data "   0xff, 0xff, 0xff, 0xff, 0x67, 0x00, 0xf8, 0x30, 0xdb, 0x00, 0x03, 0x00,"
//: /data "   0x00, 0x00, 0x36, 0x00, 0x18, 0x00, 0xc0, 0x00, 0x03, 0x00, 0x00, 0x00,"
//: /data "   0x1e, 0x00, 0xf8, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00,"
//: /data "   0xf8, 0xff, 0xff, 0x01, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00};"
//: /iconEnd
//: /port output TD[7:0] @(73, 5) /r:0
//: /port input DSR @(73, 38) /r:0
//: /port output RTS @(73, 22) /r:0
//: /port input RD[7:0] @(73, 13) /r:0
//: /port input CTS @(73, 30) /r:0
//: /port output DTR @(73, 46) /r:0
//: /symbolEnd
//: /netlistBegin main
module main;    //: root_module
reg _reset;    //: {0}(50:749,83)(749,31)(543,31){1}
//: {2}(539,31)(353,31){3}
//: {4}(349,31)(154,31){5}
//: {6}(351,33)(351,83){7}
//: {8}(541,33)(541,83){9}
wire w32;    //: /sn:0 {0}(589,342)(659,342){1}
wire [3:0] w45;    //: /sn:0 {0}(#:589,102)(659,102){1}
wire [3:0] w46;    //: /sn:0 {0}(#:589,117)(659,117){1}
wire w56;    //: /sn:0 {0}(589,284)(659,284){1}
wire w38;    //: /sn:0 {0}(455,157)(394,157){1}
wire [7:0] w51;    //: /sn:0 {0}(#:589,197)(659,197){1}
wire w0;    //: /sn:0 {0}(455,270)(394,270){1}
wire w37;    //: /sn:0 {0}(455,172)(394,172){1}
wire w34;    //: /sn:0 {0}(589,380)(659,380){1}
wire w43;    //: /sn:0 {0}(455,220)(394,220){1}
wire w54;    //: /sn:0 {0}(589,249)(659,249){1}
wire w58;    //: /sn:0 {0}(589,323)(659,323){1}
wire [15:0] DATA;    //: {0}(#:50:727,438)(727,473)(519,473){1}
//: {2}(517,471)(517,438){3}
//: {4}(515,473)(328,473)(328,438){5}
wire w41;    //: /sn:0 {0}(455,109)(394,109){1}
wire w36;    //: /sn:0 {0}(455,188)(394,188){1}
wire w40;    //: /sn:0 {0}(455,126)(394,126){1}
wire w35;    //: /sn:0 {0}(589,398)(659,398){1}
wire w59;    //: /sn:0 {0}(455,255)(394,255){1}
wire w53;    //: /sn:0 {0}(589,235)(659,235){1}
wire clk;    //: {0}(50:694,83)(694,66)(494,66){1}
//: {2}(490,66)(303,66){3}
//: {4}(299,66)(146,66){5}
//: {6}(301,68)(301,83){7}
//: {8}(492,68)(492,83){9}
wire w57;    //: /sn:0 {0}(589,304)(659,304){1}
wire [1:0] w49;    //: /sn:0 {0}(#:589,165)(659,165){1}
wire w44;    //: /sn:0 {0}(455,204)(394,204){1}
wire w52;    //: /sn:0 {0}(589,217)(659,217){1}
wire [1:0] w48;    //: /sn:0 {0}(#:589,149)(659,149){1}
wire w33;    //: /sn:0 {0}(589,360)(659,360){1}
wire w47;    //: /sn:0 {0}(589,134)(659,134){1}
wire [4:0] w50;    //: /sn:0 {0}(#:589,179)(659,179){1}
wire w42;    //: /sn:0 {0}(455,239)(394,239){1}
wire w55;    //: /sn:0 {0}(589,266)(659,266){1}
wire w39;    //: /sn:0 {0}(455,141)(394,141){1}
//: enddecls

  //: joint g4 (DATA) @(517, 473) /w:[ 1 2 4 -1 ]
  //: joint g3 (_reset) @(541, 31) /w:[ 1 -1 2 8 ]
  //: comment g13 @(17,390) /sn:0
  //: /line:"Circuit highlights:"
  //: /line:"<a href=\"#memory.tty0\">* TTY Device</a>"
  //: /line:"<a href=\"#iunit.mpc\">* Micro Program Counter</a>"
  //: /line:"<a href=\"#eunit.alu\">* ALU</a>"
  //: /line:"<a href=\"#memory.m1\">* Main Memory</a>"
  //: /line:"<a href=\"#memory.PC\">* Program Counter</a>"
  //: /line:""
  //: /end
  //: joint g2 (clk) @(492, 66) /w:[ 1 -1 2 8 ]
  //: comment g1 @(13,90)
  //: /line:"This circuit is a simple microprocessor."
  //: /line:"A simulation script will cause it to start"
  //: /line:"executing the \"Animals\" game as soon"
  //: /line:"as you start simulation mode. Click on"
  //: /line:"the various logic blocks and press the '>'"
  //: /line:"key to look at the sub-circuits inside."
  //: /line:"You can return to the parent module by"
  //: /line:"pressing the '&gt;' key.  While in"
  //: /line:"simulation mode, click on a wire to see"
  //: /line:"its current value, or double-click to"
  //: /line:"set a trace."
  //: /line:""
  //: /line:"Click on the links below to view the"
  //: /line:"contents of supporting files for"
  //: /line:"this circuit:"
  //: /line:""
  //: /line:"<a href=\"menagerie.gm\">* Microcode/Macrocode Definitions</a>"
  //: /line:"<a href=\"menagerie.mem\">* Memory Initialization File</a>"
  //: /line:"<a href=\"menagerie.vs\">* Simulator Script</a>"
  //: /line:"<a href=\"menagerie.map\">* Symbol Map</a>"
  //: /line:""
  //: /end
  IUNIT iunit (._CLR(_reset), .CK(clk), .IR(DATA), .COUT(w35), ._Z(w34), ._GT(w33), ._LT(w32), ._rdpc(w59), ._incmar(w0), ._rd(w44), .spc(w43), ._ldhmdr(w42), ._ldpc(w41), ._ldmar(w40), ._ldmdr(w39), ._incpc(w38), ._rdmdr(w37), ._wrt(w36), ._DOUT(w58), ._LDQL(w57), ._LDQH(w56), ._LDDATA(w55), .CIN(w54), ._LDQ(w53), ._CLQ(w52), .IDATA(w51), .FUNC(w50), .BOP(w49), .AOP(w48), ._WA(w47), .SB(w46), .SA(w45));   //: @(456, 84) /sz:(132, 353) /p:[ Ti0>9 Ti1>9 Bi0>3 Ri0>0 Ri1>0 Ri2>0 Ri3>0 Lo0<0 Lo1<0 Lo2<0 Lo3<0 Lo4<0 Lo5<0 Lo6<0 Lo7<0 Lo8<0 Lo9<0 Lo10<0 Ro0<0 Ro1<0 Ro2<0 Ro3<0 Ro4<0 Ro5<0 Ro6<0 Ro7<0 Ro8<0 Ro9<0 Ro10<0 Ro11<0 Ro12<0 Ro13<0 ]
  //: joint g6 (_reset) @(351, 31) /w:[ 3 -1 4 6 ]
  //: comment g9 @(43,50)
  //: /line:"This is the"
  //: /line:"system clock."
  //: /line:" "
  //: /end
  //: comment g7 @(43,7) /sn:0
  //: /line:"This is the"
  //: /line:"reset switch."
  //: /end
  MEMORY memory (._CLR(_reset), .CK(clk), ._incmar(w0), ._rdpc(w59), ._ldhmdr(w42), .spc(w43), ._rd(w44), ._wrt(w36), ._rdmdr(w37), ._incpc(w38), ._ldmdr(w39), ._ldmar(w40), ._ldpc(w41), .DATA(DATA));   //: @(268, 84) /sz:(125, 353) /p:[ Ti0>7 Ti1>7 Ri0>1 Ri1>1 Ri2>1 Ri3>1 Ri4>1 Ri5>1 Ri6>1 Ri7>1 Ri8>1 Ri9>1 Ri10>1 Bt0=5 ]
  //: comment g39 @(12,517) /sn:0
  //: /line:"<a href=\"../index.v\">[BACK]</a>"
  //: /end
  EUNIT eunit (._CLR(_reset), .CK(clk), ._DOUT(w58), ._LDQL(w57), ._LDQH(w56), ._LDDATA(w55), .SA(w45), .CIN(w54), ._LDQ(w53), ._CLQ(w52), .IDATA(w51), .FUNC(w50), .BOP(w49), .AOP(w48), ._WA(w47), .SB(w46), ._LT(w32), ._GT(w33), ._Z(w34), .COUT(w35), .DATA(DATA));   //: @(660, 84) /sz:(128, 353) /p:[ Ti0>0 Ti1>0 Li0>1 Li1>1 Li2>1 Li3>1 Li4>1 Li5>1 Li6>1 Li7>1 Li8>1 Li9>1 Li10>1 Li11>1 Li12>1 Li13>1 Lo0<1 Lo1<1 Lo2<1 Lo3<1 Bt0=0 ]
  //: joint g5 (clk) @(301, 66) /w:[ 3 -1 4 6 ]
  _GGCLOCK_P3000_0_50 g0 (.Z(clk));   //: @(133,66) /sn:0 /w:[ 5 ] /omega:3000 /phi:0 /duty:50
  //: SWITCH reset (_reset) @(137,31) /sn:0 /w:[ 5 ] /st:1

endmodule
//: /netlistEnd

//: /netlistBegin ALUshift
module ALUshift(A, B, OUT, FUNC);
//: interface  /sz:(170, 116) /bd:[ Ti0>A[15:0](34/170) Ti1>B[15:0](82/170) Ti2>FUNC[4:0](121/170) Bo0<OUT[15:0](85/170) ]
input [15:0] B;    //: /sn:0 {0}(#:244,259)(244,197)(342,197){1}
//: {2}(346,197)(446,197){3}
//: {4}(450,197)(546,197){5}
//: {6}(548,195)(548,123)(126,123){7}
//: {8}(548,199)(548,263){9}
//: {10}(448,199)(448,262){11}
//: {12}(344,199)(344,261){13}
input [15:0] A;    //: /sn:0 {0}(#:189,153)(155,153){1}
//: {2}(154,153)(124,153){3}
input [4:0] FUNC;    //: /sn:0 {0}(#:97,324)(122,324)(122,362){1}
//: {2}(122,363)(122,390){3}
output [15:0] OUT;    //: /sn:0 {0}(#:386,448)(386,376){1}
wire [15:0] w32;    //: /sn:0 {0}(#:392,347)(392,293)(448,293)(448,283){1}
wire [1:0] w19;    //: /sn:0 {0}(#:126,363)(363,363){1}
wire [15:0] w31;    //: /sn:0 {0}(#:380,347)(380,292)(344,292)(344,282){1}
wire [3:0] w18;    //: /sn:0 {0}(#:155,157)(155,220){1}
//: {2}(157,222)(292,222){3}
//: {4}(296,222)(346,222)(346,222)(399,222){5}
//: {6}(403,222)(498,222)(498,273)(511,273){7}
//: {8}(401,224)(401,272)(411,272){9}
//: {10}(294,224)(294,271)(307,271){11}
//: {12}(155,224)(155,269)(207,269){13}
wire [15:0] w30;    //: /sn:0 {0}(#:368,347)(368,318)(244,318)(244,280){1}
wire [15:0] w33;    //: /sn:0 {0}(#:404,347)(404,331)(548,331)(548,284){1}
//: enddecls

  //: IN g4 (A) @(122,153) /sn:0 /w:[ 3 ]
  //: IN g3 (B) @(124,123) /sn:0 /w:[ 7 ]
  //: joint g34 (w18) @(155, 222) /w:[ 2 1 -1 12 ]
  //: joint g51 (B) @(344, 197) /w:[ 2 -1 1 12 ]
  //: OUT g2 (OUT) @(386,445) /sn:0 /R:3 /w:[ 0 ]
  assign w19 = FUNC[1:0]; //: TAP g1 @(120,363) /sn:0 /R:2 /w:[ 0 2 1 ] /ss:1
  _GGROLL16 #(16, 18) g28 (.I(B), .Z(w33), .S(w18));   //: @(548,273) /sn:0 /w:[ 9 1 7 ]
  //: joint g50 (B) @(448, 197) /w:[ 4 -1 3 10 ]
  _GGRSHIFT16 #(16, 18) g27 (.I(B), .Z(w32), .S(w18));   //: @(448,272) /sn:0 /w:[ 11 1 9 ]
  //: joint g32 (B) @(548, 197) /w:[ -1 6 5 8 ]
  //: joint g31 (w18) @(401, 222) /w:[ 6 -1 5 8 ]
  _GGARSHIFT16 #(16, 18) g25 (.I(B), .Z(w30), .S(w18));   //: @(244,269) /sn:0 /w:[ 0 1 13 ]
  _GGMUX4x16 #(12, 12) g29 (.I0(w30), .I1(w31), .I2(w32), .I3(w33), .S(w19), .Z(OUT));   //: @(386,363) /sn:0 /w:[ 0 0 0 0 1 1 ] /ss:0 /do:0
  _GGLSHIFT16 #(16, 18) g26 (.I(B), .Z(w31), .S(w18));   //: @(344,271) /sn:0 /w:[ 13 1 11 ]
  //: joint g35 (w18) @(294, 222) /w:[ 4 -1 3 10 ]
  //: IN g0 (FUNC) @(95,324) /sn:0 /w:[ 0 ]
  assign w18 = A[3:0]; //: TAP g33 @(155,151) /sn:0 /R:1 /w:[ 0 2 1 ] /ss:1

endmodule
//: /netlistEnd

//: /netlistBegin MEMORY
module MEMORY(DATA, spc, _ldpc, _wrt, _rd, _ldmdr, _ldhmdr, _rdmdr, _rdpc, _CLR, _incmar, _ldmar, CK, _incpc);
//: interface  /sz:(125, 353) /bd:[ Ti0>CK(33/125) Ti1>_CLR(83/125) Ri0>_ldpc(25/353) Ri1>_ldmar(42/353) Ri2>_ldmdr(57/353) Ri3>_incpc(73/353) Ri4>_rdmdr(88/353) Ri5>_wrt(104/353) Ri6>_rd(120/353) Ri7>spc(136/353) Ri8>_ldhmdr(155/353) Ri9>_rdpc(171/353) Ri10>_incmar(186/353) Bt0=DATA[15:0](60/125) ]
input _rdpc;    //: /sn:0 {0}(259,285)(270,285)(270,306){1}
input _rd;    //: /sn:0 {0}(671,557)(671,614){1}
//: {2}(673,616)(708,616)(708,273)(740,273){3}
//: {4}(669,616)(512,616){5}
//: {6}(510,614)(510,579){7}
//: {8}(508,616)(482,616){9}
supply0 [5:0] w16;    //: /sn:0 {0}(#:545,861)(545,840){1}
reg [15:0] w38;    //: /sn:0 {0}(#:210,713)(300,713){1}
input CK;    //: /sn:0 {0}(753,813)(742,813)(742,833)(618,833)(618,815){1}
//: {2}(620,813)(631,813){3}
//: {4}(616,813)(524,813)(524,438){5}
//: {6}(526,436)(641,436)(641,334)(726,334){7}
//: {8}(522,436)(130,436){9}
//: {10}(128,434)(128,335){11}
//: {12}(130,333)(321,333)(321,307)(326,307){13}
//: {14}(128,331)(128,253)(151,253){15}
//: {16}(126,436)(62,436){17}
supply0 [7:0] w3;    //: /sn:0 {0}(#:683,269)(683,251)(662,251){1}
input _CLR;    //: /sn:0 {0}(512,218)(512,201){1}
//: {2}(514,199)(844,199)(844,327){3}
//: {4}(842,329)(802,329){5}
//: {6}(844,331)(844,770){7}
//: {8}(842,772)(716,772)(716,808)(707,808){9}
//: {10}(844,774)(844,808)(829,808){11}
//: {12}(510,199)(409,199){13}
//: {14}(405,199)(263,199)(263,248)(227,248){15}
//: {16}(407,201)(407,302)(402,302){17}
input _ldhmdr;    //: /sn:0 {0}(673,103)(709,103){1}
//: {2}(713,103)(871,103)(871,269){3}
//: {4}(711,105)(711,137){5}
input _wrt;    //: /sn:0 {0}(691,706)(424,706){1}
//: {2}(422,704)(422,510){3}
//: {4}(424,508)(454,508){5}
//: {6}(420,508)(399,508){7}
//: {8}(422,708)(422,758)(692,758){9}
input _ldmar;    //: /sn:0 {0}(458,247)(458,314)(438,314){1}
supply0 [15:0] w21;    //: /sn:0 {0}(#:220,59)(220,42)(194,42)(194,69){1}
input _ldpc;    //: /sn:0 {0}(233,131)(217,131)(217,152)(148,152){1}
//: {2}(144,152)(131,152){3}
//: {4}(146,154)(146,204)(165,204){5}
inout [15:0] DATA;    //: /sn:0 {0}(#:278,311)(297,311)(297,213)(371,213){1}
//: {2}(373,211)(373,167){3}
//: {4}(375,165)(508,165){5}
//: {6}(512,165)(547,165){7}
//: {8}(551,165)(568,165){9}
//: {10}(549,167)(549,246)(616,246){11}
//: {12}(510,163)(510,134){13}
//: {14}(371,165)(198,165)(198,188){15}
//: {16}(373,215)(373,248){17}
supply0 [7:0] w24;    //: /sn:0 {0}(#:595,538)(595,523){1}
supply1 w20;    //: /sn:0 {0}(241,70)(241,83)(202,83){1}
supply0 w23;    //: /sn:0 {0}(829,818)(844,818)(844,836){1}
supply0 [7:0] w1;    //: /sn:0 {0}(#:800,724)(800,677)(825,677)(825,687){1}
input _rdmdr;    //: /sn:0 {0}(624,284)(624,251){1}
reg [15:0] w40;    //: /sn:0 {0}(#:212,765)(301,765){1}
input _incpc;    //: /sn:0 {0}(233,126)(133,126){1}
input spc;    //: /sn:0 {0}(251,380)(207,380){1}
supply0 w17;    //: /sn:0 {0}(496,579)(496,592){1}
input _ldmdr;    //: /sn:0 {0}(876,269)(876,80)(673,80){1}
input _incmar;    //: /sn:0 {0}(438,309)(448,309)(448,281)(327,281){1}
//: {2}(325,279)(325,266){3}
//: {4}(327,264)(340,264){5}
//: {6}(325,262)(325,243){7}
//: {8}(325,283)(325,293)(313,293)(313,326)(223,326)(223,411)(96,411)(96,383){9}
wire [15:0] w6;    //: /sn:0 {0}(#:162,69)(162,47)(70,47)(70,360)(83,360){1}
wire [7:0] mdrin;    //: /sn:0 {0}(#:520,552)(557,552){1}
//: {2}(561,552)(663,552){3}
//: {4}(559,550)(559,523){5}
wire w46;    //: /sn:0 {0}(402,312)(417,312){1}
wire w14;    //: /sn:0 {0}(254,129)(272,129)(272,258)(227,258){1}
wire w15;    //: /sn:0 {0}(691,711)(645,711){1}
//: {2}(643,709)(643,672){3}
//: {4}(641,711)(436,711){5}
//: {6}(434,709)(434,512)(454,512){7}
//: {8}(432,711)(365,711){9}
wire [15:0] w19;    //: /sn:0 {0}(#:188,217)(188,243){1}
wire [15:0] w4;    //: /sn:0 {0}(#:584,165)(614,165){1}
wire [15:0] PC;    //: /sn:0 {0}(#:188,264)(188,309){1}
//: {2}(190,311)(262,311){3}
//: {4}(188,313)(188,348){5}
//: {6}(190,350)(264,350)(264,364){7}
//: {8}(186,350)(112,350){9}
wire w;    //: /sn:0 {0}(802,339)(874,339)(874,290){1}
wire DTR;    //: /sn:0 {0}(433,982)(565,982)(565,840){1}
wire w37;    //: /sn:0 {0}(713,761)(722,761)(722,818)(707,818){1}
wire [7:0] w34;    //: /sn:0 {0}(#:555,834)(555,668)(571,668)(571,523){1}
wire [15:0] w43;    //: /sn:0 {0}(#:363,297)(363,277){1}
wire RTS;    //: /sn:0 {0}(433,958)(555,958)(555,840){1}
wire w31;    //: /sn:0 {0}(366,763)(446,763){1}
//: {2}(450,763)(631,763){3}
//: {4}(635,763)(692,763){5}
//: {6}(633,761)(633,672){7}
//: {8}(448,761)(448,515)(454,515){9}
wire [15:0] w28;    //: /sn:0 {0}(#:344,711)(321,711){1}
wire DSR;    //: /sn:0 {0}(433,974)(800,974)(800,858){1}
wire [7:0] w36;    //: /sn:0 {0}(#:790,753)(790,803){1}
wire CTS;    //: /sn:0 {0}(790,858)(790,966)(433,966){1}
wire [7:0] w25;    //: /sn:0 {0}(#:763,286)(763,324){1}
wire [5:0] w35;    //: /sn:0 {0}(#:780,858)(780,881)(760,881){1}
wire [7:0] w8;    //: /sn:0 {0}(#:620,170)(695,170){1}
wire [15:0] w18;    //: /sn:0 {0}(#:274,393)(274,550){1}
//: {2}(276,552)(485,552){3}
//: {4}(274,554)(274,706){5}
//: {6}(276,708)(300,708){7}
//: {8}(274,710)(274,760)(301,760){9}
wire [15:0] w30;    //: /sn:0 {0}(#:345,763)(322,763){1}
wire w22;    //: /sn:0 {0}(154,83)(144,83){1}
wire [7:0] RD;    //: /sn:0 {0}(#:433,949)(668,949)(668,824){1}
wire [7:0] mdr;    //: /sn:0 {0}(#:780,724)(780,676)(724,676){1}
//: {2}(722,674)(722,552)(699,552){3}
//: {4}(697,550)(697,379){5}
//: {6}(699,377)(763,377)(763,345){7}
//: {8}(697,375)(697,241)(662,241){9}
//: {10}(695,552)(679,552){11}
//: {12}(720,676)(668,676)(668,803){13}
wire [15:0] w2;    //: /sn:0 {0}(#:656,246)(632,246){1}
wire w11;    //: /sn:0 {0}(503,529)(503,512)(475,512){1}
wire [1:0] w27;    //: /sn:0 {0}(#:600,507)(638,507)(638,666){1}
wire [7:0] w13;    //: /sn:0 {0}(#:753,257)(753,222)(577,222)(577,494){1}
wire [15:0] mar;    //: /sn:0 {0}(#:363,318)(363,349){1}
//: {2}(361,351)(284,351)(284,364){3}
//: {4}(363,353)(363,400)(136,400)(136,370)(112,370){5}
wire [7:0] w33;    //: /sn:0 {0}(#:790,852)(790,824){1}
wire [7:0] w5;    //: /sn:0 {0}(#:620,160)(661,160)(661,150)(695,150){1}
wire [7:0] TD;    //: /sn:0 {0}(#:433,941)(583,941)(583,523){1}
wire [15:0] w9;    //: /sn:0 {0}(#:178,188)(178,114){1}
//: {2}(178,110)(178,98){3}
//: {4}(180,112)(353,112)(353,248){5}
wire [7:0] w42;    //: /sn:0 {0}(#:773,257)(773,160)(724,160){1}
wire w26;    //: /sn:0 {0}(712,709)(745,709)(745,740)(767,740){1}
//: enddecls

  //: joint g4 (_rd) @(510, 616) /w:[ 5 6 8 -1 ]
  //: INOUT g8 (DATA) @(510,128) /sn:0 /R:3 /w:[ 13 ]
  //: joint g61 (w31) @(448, 763) /w:[ 2 8 1 -1 ]
  //: joint g58 (_CLR) @(844, 772) /w:[ -1 7 8 10 ]
  _GGREG8 #(10, 10, 20) g51 (.Q(RD), .D(mdr), .EN(w37), .CLR(_CLR), .CK(CK));   //: @(668,813) /sn:0 /w:[ 1 13 1 9 3 ]
  //: IN g37 (spc) @(205,380) /sn:0 /w:[ 1 ]
  //: IN g34 (_ldpc) @(129,152) /sn:0 /w:[ 3 ]
  //: IN g13 (_wrt) @(397,508) /sn:0 /w:[ 7 ]
  //: joint g86 (_wrt) @(422, 508) /w:[ 4 -1 6 3 ]
  //: joint g55 (CK) @(524, 436) /w:[ 6 -1 8 5 ]
  //: joint g3 (_CLR) @(512, 199) /w:[ 2 -1 12 1 ]
  //: comment g89 @(37,543) /sn:0
  //: /line:"This is the memory address line."
  //: /line:"The address can be selected from"
  //: /line:"the MAR (Memory Address Register)"
  //: /line:"or from the PC (Program Counter)."
  //: /end
  //: IN g2 (_rd) @(480,616) /sn:0 /w:[ 9 ]
  //: joint g65 (mdr) @(722, 676) /w:[ 1 2 12 -1 ]
  //: joint g76 (w9) @(178, 112) /w:[ 2 1 4 -1 ]
  //: IN g77 (_ldmdr) @(671,80) /sn:0 /w:[ 1 ]
  _GGNAND2 #(6) g59 (.I0(!_wrt), .I1(w31), .Z(w37));   //: @(703,761) /sn:0 /w:[ 9 5 0 ] /eb:0
  _GGBUFIF16 #(4, 6) g72 (.Z(DATA), .I(PC), .E(~_rdpc));   //: @(268,311) /sn:0 /w:[ 0 3 1 ]
  _GGREG16 #(10, 10, 20) PC (.Q(PC), .D(w19), .EN(w14), .CLR(_CLR), .CK(CK));   //: @(188,253) /w:[ 0 1 1 15 15 ]
  //: GROUND g1 (w17) @(496,598) /sn:0 /w:[ 1 ]
  //: joint g64 (_wrt) @(422, 706) /w:[ 1 2 -1 8 ]
  //: frame g16 @(110,659) /sn:0 /wi:762 /ht:347 /tx:"TTY Control"
  _GGMUX4x8 #(12, 12) g11 (.I0(mdrin), .I1(w34), .I2(TD), .I3(w24), .S(w27), .Z(w13));   //: @(577,507) /sn:0 /R:2 /w:[ 5 1 1 1 0 1 ] /ss:0 /do:1
  assign {w35, CTS, DSR} = w33; //: CONCAT g50  @(790,853) /sn:0 /R:1 /w:[ 0 0 1 0 ] /dr:0 /tp:0 /drp:0
  _GGADD16 #(132, 134, 126, 128) g28 (.A(w6), .B(w21), .S(w9), .CI(w20), .CO(w22));   //: @(178,85) /sn:0 /w:[ 0 1 3 1 0 ]
  //: joint g78 (PC) @(188, 350) /w:[ 6 5 8 -1 ]
  //: comment g87 @(210,776)
  //: /line:"These dip switches specify the"
  //: /line:"addresses for the tty status"
  //: /line:"and data registers."
  //: /end
  //: joint g10 (CK) @(128, 333) /w:[ 12 14 -1 11 ]
  //: joint g27 (DATA) @(373, 165) /w:[ 4 -1 14 3 ]
  //: joint g19 (mdr) @(697, 552) /w:[ 3 4 10 -1 ]
  _GGMUX2x16 #(8, 8) g32 (.I0(w9), .I1(DATA), .S(_incmar), .Z(w43));   //: @(363,264) /sn:0 /w:[ 5 17 5 1 ] /ss:0 /do:0
  _GGRAM16x8 #(10, 10, 70, 10, 10, 10, 10) m1 (.A(w18), .D(mdrin), .WE(w11), .OE(_rd), .CS(w17));   //: @(503,553) /w:[ 3 0 0 7 0 ]
  //: joint g38 (DATA) @(549, 165) /w:[ 8 -1 7 10 ]
  //: IN g69 (_ldhmdr) @(671,103) /sn:0 /w:[ 0 ]
  //: IN g6 (_rdmdr) @(624,286) /sn:0 /R:1 /w:[ 0 ]
  //: joint g57 (_CLR) @(844, 329) /w:[ -1 3 4 6 ]
  _GGREG8 #(10, 10, 20) g53 (.Q(w33), .D(w36), .EN(w23), .CLR(_CLR), .CK(CK));   //: @(790,813) /sn:0 /w:[ 1 1 0 11 0 ]
  _GGMUX2x8 #(8, 8) g9 (.I0(w13), .I1(w42), .S(_rd), .Z(w25));   //: @(763,273) /sn:0 /w:[ 0 0 3 0 ] /ss:0 /do:0
  _GGBUFIF8 #(4, 6) g7 (.Z(mdrin), .I(mdr), .E(_rd));   //: @(673,552) /sn:0 /R:2 /w:[ 3 11 0 ]
  //: joint g75 (DATA) @(373, 213) /w:[ -1 2 1 16 ]
  //: GROUND g20 (w3) @(683,275) /sn:0 /w:[ 0 ]
  assign {w8, w5} = w4; //: CONCAT g15  @(615,165) /sn:0 /R:2 /w:[ 0 0 1 ] /dr:0 /tp:0 /drp:0
  //: joint g71 (_ldhmdr) @(711, 103) /w:[ 2 -1 1 4 ]
  _GGMUX2x16 #(8, 8) g31 (.I0(PC), .I1(mar), .S(~_incmar), .Z(w6));   //: @(96,360) /sn:0 /R:3 /w:[ 9 5 9 1 ] /ss:1 /do:0
  _GGXOR2x16 #(8) g39 (.I0(w18), .I1(w38), .Z(w28));   //: @(311,711) /sn:0 /w:[ 7 1 1 ] /eb:0
  //: GROUND g67 (w23) @(844,842) /sn:0 /w:[ 1 ]
  _GGMUX2x8 #(8, 8) g68 (.I0(w5), .I1(w8), .S(~_ldhmdr), .Z(w42));   //: @(711,160) /sn:0 /R:1 /w:[ 1 1 5 1 ] /ss:1 /do:1
  //: GROUND g48 (w16) @(545,867) /sn:0 /w:[ 0 ]
  //: joint g43 (w18) @(274, 552) /w:[ 2 1 -1 4 ]
  //: IN g73 (_rdpc) @(257,285) /sn:0 /w:[ 0 ]
  _GGNAND2 #(6) g62 (.I0(!_wrt), .I1(w15), .Z(w26));   //: @(702,709) /sn:0 /w:[ 0 0 0 ] /eb:0
  //: VDD g29 (w20) @(252,70) /sn:0 /w:[ 0 ]
  _GGMUX2x16 #(8, 8) g25 (.I0(PC), .I1(mar), .S(~spc), .Z(w18));   //: @(274,380) /sn:0 /w:[ 7 3 0 0 ] /ss:0 /do:0
  //: joint g17 (DATA) @(510, 165) /w:[ 6 12 5 -1 ]
  //: IN g88 (_CLR) @(512,220) /sn:0 /R:1 /w:[ 0 ]
  //: joint g63 (w15) @(643, 711) /w:[ 1 2 4 -1 ]
  _GGNOR1x16 #(1) g42 (.I0(w30), .Z(w31));   //: @(356,763) /sn:0 /w:[ 0 0 ] /eb:0
  //: joint g52 (mdr) @(697, 377) /w:[ 6 8 -1 5 ]
  _GGNOR2 #(6) g83 (.I0(!_incmar), .I1(!_ldmar), .Z(w46));   //: @(427,312) /sn:0 /R:2 /w:[ 0 1 1 ] /eb:0
  //: joint g74 (PC) @(188, 311) /w:[ 2 1 -1 4 ]
  //: joint g56 (CK) @(618, 813) /w:[ 2 -1 4 1 ]
  //: frame g14 @(536,27) /sn:0 /wi:372 /ht:394 /tx:"MDR Control"
  //: joint g5 (_CLR) @(407, 199) /w:[ 13 -1 14 16 ]
  assign w34 = {w16, RTS, DTR}; //: CONCAT g47  @(555,835) /sn:0 /R:1 /w:[ 0 1 1 1 ] /dr:0 /tp:0 /drp:1
  //: joint g44 (w18) @(274, 708) /w:[ 6 5 -1 8 ]
  //: joint g79 (mar) @(363, 351) /w:[ -1 1 2 4 ]
  //: IN g80 (_incmar) @(325,241) /sn:0 /R:3 /w:[ 7 ]
  //: joint g36 (_ldpc) @(146, 152) /w:[ 1 -1 2 4 ]
  _GGBUFIF16 #(4, 6) g21 (.Z(DATA), .I(w2), .E(~_rdmdr));   //: @(626,246) /sn:0 /R:2 /w:[ 11 1 1 ]
  _GGREG8 #(10, 10, 20) mdr (.Q(mdr), .D(w25), .EN(w), .CLR(_CLR), .CK(CK));   //: @(763,334) /w:[ 7 1 0 5 7 ]
  _GGOR3 #(8) g84 (.I0(_wrt), .I1(w15), .I2(w31), .Z(w11));   //: @(465,512) /sn:0 /w:[ 5 7 9 1 ] /eb:0
  //: joint g85 (w15) @(434, 711) /w:[ 5 6 8 -1 ]
  //: joint g24 (CK) @(128, 436) /w:[ 9 10 16 -1 ]
  //: DIP TTYSTATUS (w38) @(172,713) /R:1 /w:[ 0 ] /st:16
  _GGNOR1x16 #(1) g41 (.I0(w28), .Z(w15));   //: @(355,711) /sn:0 /w:[ 0 9 ] /eb:0
  //: IN g23 (_ldmar) @(458,245) /sn:0 /R:3 /w:[ 0 ]
  //: joint g60 (w31) @(633, 763) /w:[ 4 6 3 -1 ]
  _GGXOR2x16 #(8) g40 (.I0(w18), .I1(w40), .Z(w30));   //: @(312,763) /sn:0 /w:[ 9 1 1 ] /eb:0
  _GGMUX2x8 #(8, 8) g54 (.I0(mdr), .I1(w1), .S(w26), .Z(w36));   //: @(790,740) /sn:0 /w:[ 0 0 1 0 ] /ss:0 /do:0
  //: joint g81 (_incmar) @(325, 264) /w:[ 4 6 -1 3 ]
  //: frame g93 @(354,466) /sn:0 /wi:421 /ht:164 /tx:"Main Memory"
  assign w27 = {w31, w15}; //: CONCAT g46  @(638,667) /sn:0 /R:1 /w:[ 1 7 3 ] /dr:0 /tp:0 /drp:1
  //: joint g45 (mdrin) @(559, 552) /w:[ 2 4 1 -1 ]
  _GGNOR2 #(6) g35 (.I0(!_incpc), .I1(!_ldpc), .Z(w14));   //: @(244,129) /sn:0 /w:[ 0 0 0 ] /eb:0
  _GGMUX2x16 #(8, 8) g26 (.I0(w9), .I1(DATA), .S(~_ldpc), .Z(w19));   //: @(188,204) /sn:0 /w:[ 0 15 5 0 ] /ss:0 /do:0
  //: IN g0 (CK) @(60,436) /sn:0 /w:[ 17 ]
  _GGREG16 #(10, 10, 20) mar (.Q(mar), .D(w43), .EN(w46), .CLR(_CLR), .CK(CK));   //: @(363,307) /w:[ 0 0 0 17 13 ]
  _GGBUF16 #(4) g22 (.I(DATA), .Z(w4));   //: @(574,165) /sn:0 /w:[ 9 0 ]
  _GGNOR2 #(6) g70 (.I0(!_ldhmdr), .I1(!_ldmdr), .Z(w));   //: @(874,280) /sn:0 /R:3 /w:[ 3 0 1 ] /eb:0
  //: comment g90 @(211,844) /sn:0
  //: /line:"This is the tty.  When simulation mode"
  //: /line:"starts, a tty window will be popped up"
  //: /line:"corresponding to this device.  The device"
  //: /line:"may be accessed through the simulated CPU"
  //: /line:"by reading or writing the addresses indicated"
  //: /line:"by the dip switches TTYSTATUS and TTYDATA."
  //: /end
  //: DIP TTYDATA (w40) @(174,765) /R:1 /w:[ 0 ] /st:17
  //: GROUND g66 (w1) @(825,693) /sn:0 /w:[ 1 ]
  //: joint g82 (_incmar) @(325, 281) /w:[ 1 2 -1 8 ]
  TTY tty0 (.TD(TD), .DSR(DSR), .RTS(RTS), .RD(RD), .CTS(CTS), .DTR(DTR));   //: @(396, 962) /symbol:141296144 /w:[ 0 0 0 0 1 0 ]
  //: joint g12 (_rd) @(671, 616) /w:[ 2 1 4 -1 ]
  assign w2 = {w3, mdr}; //: CONCAT g18  @(657,246) /sn:0 /R:2 /w:[ 0 1 9 ] /dr:0 /tp:0 /drp:1
  //: IN g33 (_incpc) @(131,126) /sn:0 /w:[ 1 ]
  //: GROUND g30 (w21) @(220,65) /sn:0 /w:[ 0 ]
  //: frame g91 @(45,27) /sn:0 /wi:441 /ht:397 /tx:"Address Resolution"
  //: GROUND g49 (w24) @(595,544) /sn:0 /w:[ 0 ]

endmodule
//: /netlistEnd

//: /netlistBegin REG4
module REG4(B, _ENA, SB, CK, _ENB, DIN, _WA, _CLR, SA, A);
//: interface  /sz:(107, 138) /bd:[ Ti0>DIN[15:0](52/107) Li0>SA[1:0](17/138) Li1>SB[1:0](33/138) Li2>_CLR(51/138) Li3>_ENA(70/138) Li4>_ENB(88/138) Li5>_WA(106/138) Li6>CK(123/138) Bo0<A[15:0](31/107) Bo1<B[15:0](79/107) ]
output [15:0] B;    //: /sn:0 {0}(#:507,666)(507,615){1}
input CK;    //: /sn:0 {0}(53,412)(175,412){1}
//: {2}(179,412)(317,412){3}
//: {4}(321,412)(462,412){5}
//: {6}(466,412)(598,412)(598,276)(613,276){7}
//: {8}(464,410)(464,277)(476,277){9}
//: {10}(319,410)(319,281)(326,281){11}
//: {12}(177,410)(177,277)(194,277){13}
input _CLR;    //: /sn:0 {0}(689,271)(701,271)(701,235)(581,235){1}
//: {2}(577,235)(448,235){3}
//: {4}(444,235)(297,235){5}
//: {6}(293,235)(54,235){7}
//: {8}(295,237)(295,272)(270,272){9}
//: {10}(446,237)(446,276)(402,276){11}
//: {12}(579,237)(579,272)(552,272){13}
output [15:0] A;    //: /sn:0 {0}(#:369,669)(369,616){1}
input _ENA;    //: /sn:0 {0}(51,297)(78,297){1}
//: {2}(82,297)(104,297){3}
//: {4}(80,299)(80,580)(403,580)(403,608)(374,608){5}
input [1:0] SB;    //: /sn:0 {0}(#:458,543)(484,543){1}
input [1:0] SA;    //: /sn:0 {0}(#:51,543)(101,543){1}
//: {2}(105,543)(346,543){3}
//: {4}(103,541)(103,340)(121,340){5}
input _ENB;    //: /sn:0 {0}(512,607)(531,607)(531,566)(51,566){1}
input _WA;    //: /sn:0 {0}(52,269)(91,269)(91,292)(104,292){1}
input [15:0] DIN;    //: /sn:0 {0}(#:650,266)(650,120)(515,120){1}
//: {2}(511,120)(365,120){3}
//: {4}(361,120)(233,120){5}
//: {6}(231,122)(231,267){7}
//: {8}(229,120)(53,120){9}
//: {10}(363,122)(363,271){11}
//: {12}(513,122)(513,267){13}
wire [15:0] w7;    //: /sn:0 {0}(#:369,556)(369,600){1}
wire [15:0] R2;    //: /sn:0 {0}(#:375,527)(375,487)(511,487){1}
//: {2}(513,485)(513,288){3}
//: {4}(513,489)(513,527){5}
wire [15:0] R1;    //: /sn:0 {0}(#:363,527)(363,453){1}
//: {2}(365,451)(501,451)(501,527){3}
//: {4}(363,449)(363,292){5}
wire [15:0] R3;    //: /sn:0 {0}(#:387,527)(387,505)(523,505){1}
//: {2}(527,505)(650,505)(650,287){3}
//: {4}(525,507)(525,527){5}
wire w2;    //: /sn:0 {0}(125,295)(134,295)(134,316){1}
wire w57;    //: /sn:0 {0}(150,334)(413,334)(413,286)(402,286){1}
wire [15:0] w10;    //: /sn:0 {0}(#:507,556)(507,599){1}
wire [15:0] R0;    //: /sn:0 {0}(#:351,527)(351,479){1}
//: {2}(353,477)(489,477)(489,527){3}
//: {4}(349,477)(231,477)(231,288){5}
wire w52;    //: /sn:0 {0}(150,358)(700,358)(700,281)(689,281){1}
wire w47;    //: /sn:0 {0}(150,322)(280,322)(280,282)(270,282){1}
wire w42;    //: /sn:0 {0}(150,346)(565,346)(565,282)(552,282){1}
//: enddecls

  _GGNDEMUX4 #(4, 4) g4 (.I(SA), .E(~w2), .Z0(w47), .Z1(w57), .Z2(w42), .Z3(w52));   //: @(134,340) /sn:0 /R:1 /w:[ 5 1 0 0 0 0 ] /ss:1 /do:1
  _GGMUX4x16 #(12, 12) g8 (.I0(R0), .I1(R1), .I2(R2), .I3(R3), .S(SB), .Z(w10));   //: @(507,543) /sn:0 /w:[ 3 3 5 5 1 0 ] /ss:0 /do:0
  //: joint g34 (SA) @(103, 543) /w:[ 2 4 1 -1 ]
  _GGMUX4x16 #(12, 12) g13 (.I0(R0), .I1(R1), .I2(R2), .I3(R3), .S(SA), .Z(w7));   //: @(369,543) /sn:0 /w:[ 0 0 0 0 3 0 ] /ss:0 /do:0
  //: joint g16 (R2) @(513, 487) /w:[ -1 2 1 4 ]
  //: joint g11 (CK) @(319, 412) /w:[ 4 10 3 -1 ]
  _GGREG16 #(10, 10, 20) R2 (.Q(R2), .D(DIN), .EN(w42), .CLR(_CLR), .CK(CK));   //: @(513,277) /w:[ 3 13 1 13 9 ]
  //: joint g28 (_ENA) @(80, 297) /w:[ 2 -1 1 4 ]
  //: joint g10 (CK) @(177, 412) /w:[ 2 12 1 -1 ]
  //: OUT g32 (B) @(507,663) /sn:0 /R:3 /w:[ 0 ]
  //: IN g27 (_ENA) @(49,297) /sn:0 /w:[ 0 ]
  //: IN g19 (SB) @(456,543) /sn:0 /w:[ 0 ]
  //: joint g6 (DIN) @(363, 120) /w:[ 4 10 3 -1 ]
  //: joint g7 (DIN) @(513, 120) /w:[ 1 -1 2 12 ]
  //: IN g9 (CK) @(51,412) /sn:0 /w:[ 0 ]
  //: IN g31 (_ENB) @(49,566) /sn:0 /w:[ 1 ]
  //: IN g20 (DIN) @(51,120) /sn:0 /w:[ 9 ]
  //: joint g15 (R1) @(363, 451) /w:[ 2 4 -1 1 ]
  _GGREG16 #(10, 10, 20) R1 (.Q(R1), .D(DIN), .EN(w57), .CLR(_CLR), .CK(CK));   //: @(363,281) /w:[ 5 11 1 11 11 ]
  _GGREG16 #(10, 10, 20) R3 (.Q(R3), .D(DIN), .EN(w52), .CLR(_CLR), .CK(CK));   //: @(650,276) /w:[ 3 0 1 0 7 ]
  _GGBUFIF16 #(4, 6) g29 (.Z(A), .I(w7), .E(~_ENA));   //: @(369,606) /sn:0 /R:3 /w:[ 1 1 5 ]
  //: IN g25 (_WA) @(50,269) /sn:0 /w:[ 0 ]
  //: joint g17 (R3) @(525, 505) /w:[ 2 -1 1 4 ]
  //: joint g5 (DIN) @(231, 120) /w:[ 6 8 5 -1 ]
  //: joint g14 (R0) @(351, 477) /w:[ 2 -1 4 1 ]
  //: joint g24 (_CLR) @(579, 235) /w:[ 1 -1 2 12 ]
  //: IN g21 (_CLR) @(52,235) /sn:0 /w:[ 7 ]
  //: joint g23 (_CLR) @(446, 235) /w:[ 3 -1 4 10 ]
  _GGREG16 #(10, 10, 20) R0 (.Q(R0), .D(DIN), .EN(w47), .CLR(_CLR), .CK(CK));   //: @(231,277) /w:[ 5 7 1 9 13 ]
  _GGOR2 #(6) g26 (.I0(_WA), .I1(_ENA), .Z(w2));   //: @(115,295) /sn:0 /w:[ 1 3 0 ] /eb:0
  //: joint g22 (_CLR) @(295, 235) /w:[ 5 -1 6 8 ]
  //: IN g18 (SA) @(49,543) /sn:0 /w:[ 0 ]
  //: joint g12 (CK) @(464, 412) /w:[ 6 8 5 -1 ]
  //: OUT g33 (A) @(369,666) /sn:0 /R:3 /w:[ 0 ]
  _GGBUFIF16 #(4, 6) g30 (.Z(B), .I(w10), .E(~_ENB));   //: @(507,605) /sn:0 /R:3 /w:[ 1 1 0 ]

endmodule
//: /netlistEnd

//: /netlistBegin ALU
module ALU(A, COUT, B, FUNC, CIN, _GT, _Z, OUT, _LT);
//: interface  /sz:(107, 127) /bd:[ Ti0>B[15:0](79/107) Ti1>A[15:0](31/107) Li0>CIN(95/127) Li1>FUNC[4:0](18/127) Bo0<OUT[15:0](56/107) Ro0<COUT(69/127) Ro1<_LT(52/127) Ro2<_GT(37/127) Ro3<_Z(20/127) ]
input [15:0] B;    //: /sn:0 {0}(#:100,99)(269,99){1}
//: {2}(273,99)(552,99)(552,171){3}
//: {4}(271,101)(271,171){5}
output _Z;    //: /sn:0 {0}(478,431)(488,431){1}
//: {2}(492,431)(556,431){3}
//: {4}(490,433)(490,505)(511,505){5}
output _LT;    //: /sn:0 {0}(557,467)(504,467){1}
//: {2}(500,467)(483,467)(483,467)(475,467){3}
//: {4}(502,469)(502,500)(511,500){5}
input CIN;    //: /sn:0 {0}(433,226)(467,226){1}
input [15:0] A;    //: /sn:0 {0}(#:100,67)(221,67){1}
//: {2}(225,67)(506,67)(506,171){3}
//: {4}(223,69)(223,171){5}
input [4:0] FUNC;    //: /sn:0 {0}(#:100,129)(128,129){1}
//: {2}(129,129)(308,129){3}
//: {4}(312,129)(593,129)(593,171){5}
//: {6}(310,131)(310,171){7}
output _GT;    //: /sn:0 {0}(532,503)(557,503){1}
output [15:0] OUT;    //: /sn:0 {0}(#:406,415)(406,429){1}
//: {2}(408,431)(457,431){3}
//: {4}(406,433)(406,466){5}
//: {6}(406,467)(406,510){7}
output COUT;    //: /sn:0 {0}(634,226)(674,226){1}
wire w3;    //: /sn:0 {0}(410,467)(459,467){1}
wire [2:0] w0;    //: /sn:0 {0}(#:306,402)(129,402)(129,133){1}
wire [15:0] w1;    //: /sn:0 {0}(#:416,386)(416,353)(559,353)(559,295){1}
wire [15:0] w35;    //: /sn:0 {0}(#:274,289)(274,354)(396,354)(396,386){1}
wire w2;    //: /sn:0 {0}(383,402)(327,402){1}
//: enddecls

  //: IN g4 (A) @(98,67) /sn:0 /w:[ 0 ]
  //: OUT g8 (COUT) @(671,226) /sn:0 /w:[ 1 ]
  //: IN g3 (B) @(98,99) /sn:0 /w:[ 0 ]
  //: joint g2 (OUT) @(406, 431) /w:[ 2 1 -1 4 ]
  _GGMUX2x16 #(8, 8) g1 (.I0(w35), .I1(w1), .S(w2), .Z(OUT));   //: @(406,402) /sn:0 /w:[ 1 0 0 0 ] /ss:0 /do:0
  assign w0 = FUNC[4:2]; //: TAP g11 @(129,127) /sn:0 /R:1 /w:[ 1 1 2 ] /ss:1
  //: joint g10 (FUNC) @(310, 129) /w:[ 4 -1 3 6 ]
  //: IN g38 (FUNC) @(98,129) /sn:0 /w:[ 0 ]
  //: joint g6 (B) @(271, 99) /w:[ 2 -1 1 4 ]
  //: IN g7 (CIN) @(431,226) /sn:0 /w:[ 0 ]
  ALUshift g9 (.FUNC(FUNC), .B(B), .A(A), .OUT(w35));   //: @(189, 172) /sz:(170, 116) /sn:0 /p:[ Ti0>7 Ti1>5 Ti2>5 Bo0<0 ]
  //: OUT g39 (_GT) @(554,503) /sn:0 /w:[ 1 ]
  _GGOR1x16 #(1) g43 (.I0(OUT), .Z(_Z));   //: @(468,431) /sn:0 /w:[ 3 0 ] /eb:0
  //: joint g48 (_Z) @(490, 431) /w:[ 2 -1 1 4 ]
  //: OUT g42 (_Z) @(553,431) /sn:0 /w:[ 3 ]
  _GGOR1x3 #(1) g5 (.I0(w0), .Z(w2));   //: @(317,402) /sn:0 /w:[ 0 1 ] /eb:0
  _GGNAND2 #(4) g47 (.I0(_LT), .I1(_Z), .Z(_GT));   //: @(522,503) /sn:0 /w:[ 5 5 0 ] /eb:0
  //: OUT g41 (OUT) @(406,507) /sn:0 /R:3 /w:[ 7 ]
  ALUbasic g54 (.FUNC(FUNC), .B(B), .A(A), .CIN(CIN), .OUT(w1), .COUT(COUT));   //: @(468, 172) /sz:(165, 122) /sn:0 /p:[ Ti0>5 Ti1>3 Ti2>3 Li0>1 Bo0<1 Ro0<0 ]
  //: OUT g40 (_LT) @(554,467) /sn:0 /w:[ 0 ]
  _GGNBUF #(2) g45 (.I(w3), .Z(_LT));   //: @(465,467) /sn:0 /w:[ 1 3 ]
  assign w3 = OUT[15]; //: TAP g46 @(404,467) /sn:0 /R:2 /w:[ 0 6 5 ] /ss:1
  //: joint g0 (A) @(223, 67) /w:[ 2 -1 1 4 ]
  //: joint g49 (_LT) @(502, 467) /w:[ 1 -1 2 4 ]

endmodule
//: /netlistEnd

//: /netlistBegin IUNIT
module IUNIT(CK, _LDQ, _WA, _rd, _DOUT, _rdmdr, _CLQ, FUNC, _CLR, _LDQH, SB, _ldmdr, IR, _ldmar, _incmar, _LDQL, SA, IDATA, _incpc, _LDDATA, COUT, _LT, _Z, spc, _ldpc, _wrt, _ldhmdr, _GT, AOP, BOP, _rdpc, CIN);
//: interface  /sz:(132, 353) /bd:[ Ti0>CK(37/132) Ti1>_CLR(86/132) Li0>_incmar(187/353) Bi0>IR[15:0](62/132) Ri0>_LT(258/353) Ri1>_GT(276/353) Ri2>_Z(296/353) Ri3>COUT(314/353) Lo0<_wrt(105/353) Lo1<_rdmdr(89/353) Lo2<_incpc(74/353) Lo3<_ldmdr(58/353) Lo4<_ldmar(43/353) Lo5<_ldpc(26/353) Lo6<_ldhmdr(156/353) Lo7<spc(137/353) Lo8<_rd(121/353) Ro0<SA[3:0](18/353) Ro1<SB[3:0](33/353) Ro2<_WA(50/353) Ro3<AOP[1:0](65/353) Ro4<BOP[1:0](81/353) Ro5<FUNC[4:0](95/353) Ro6<IDATA[7:0](113/353) Ro7<_CLQ(133/353) Ro8<_LDQ(150/353) Ro9<CIN(165/353) Ro10<_LDDATA(182/353) Ro11<_LDQH(200/353) Ro12<_LDQL(220/353) Ro13<_DOUT(239/353) Lt0=_rdpc(172/353) ]
input _Z;    //: /sn:0 {0}(1162,361)(1137,361)(1137,358)(1115,358){1}
input [15:0] IR;    //: /sn:0 {0}(#:59,70)(84,70){1}
output _CLQ;    //: /sn:0 {0}(693,714)(488,714){1}
output _rdpc;    //: /sn:0 {0}(494,1167)(704,1167){1}
output _rd;    //: /sn:0 {0}(494,1037)(704,1037){1}
input _LT;    //: /sn:0 {0}(1166,345)(1156,345)(1156,348)(1115,348){1}
supply0 [7:0] w15;    //: /sn:0 {0}(#:205,673)(205,717){1}
supply1 w19;    //: /sn:0 {0}(424,671)(424,662)(410,662)(410,649){1}
input CK;    //: /sn:0 {0}(436,1125)(436,1148)(264,1148)(264,773){1}
//: {2}(266,771)(429,771)(429,747){3}
//: {4}(264,769)(264,513){5}
//: {6}(266,511)(294,511){7}
//: {8}(262,511)(104,511){9}
//: {10}(102,509)(102,278){11}
//: {12}(104,276)(1069,276)(1069,315){13}
//: {14}(102,274)(102,122){15}
//: {16}(104,120)(233,120)(233,98)(243,98){17}
//: {18}(102,118)(102,98)(114,98){19}
//: {20}(100,511)(83,511){21}
output _LDQH;    //: /sn:0 {0}(494,1127)(704,1127){1}
output CIN;    //: /sn:0 {0}(693,704)(488,704){1}
input _CLR;    //: /sn:0 {0}(370,506)(525,506)(525,76){1}
//: {2}(527,74)(666,74)(666,460)(1074,460)(1074,391){3}
//: {4}(525,72)(525,63){5}
//: {6}(523,74)(387,74){7}
//: {8}(383,74)(201,74)(201,93)(190,93){9}
//: {10}(385,76)(385,93)(319,93){11}
output _ldmar;    //: /sn:0 {0}(494,1007)(704,1007){1}
output _ldhmdr;    //: /sn:0 {0}(704,1157)(494,1157){1}
output _wrt;    //: /sn:0 {0}(494,1057)(704,1057){1}
supply1 w21;    //: /sn:0 {0}(175,641)(175,659)(197,659){1}
output [4:0] FUNC;    //: /sn:0 {0}(#:769,956)(738,956){1}
output _ldpc;    //: /sn:0 {0}(494,1027)(704,1027){1}
supply0 w28;    //: /sn:0 {0}(839,352)(839,334)(813,334){1}
supply1 w24;    //: /sn:0 {0}(431,1049)(431,1036)(410,1036)(410,1016){1}
supply0 w20;    //: /sn:0 {0}(441,1049)(441,1025)(455,1025)(455,1036){1}
output [3:0] SB;    //: /sn:0 {0}(#:769,890)(738,890){1}
supply0 [7:0] w23;    //: /sn:0 {0}(#:360,361)(360,341)(325,341)(325,401){1}
output _LDDATA;    //: /sn:0 {0}(693,734)(488,734){1}
output [1:0] AOP;    //: /sn:0 {0}(#:488,684)(693,684){1}
output _LDQ;    //: /sn:0 {0}(693,724)(488,724){1}
output _rdmdr;    //: /sn:0 {0}(494,1047)(704,1047){1}
output [3:0] SA;    //: /sn:0 {0}(#:738,818)(769,818){1}
output _WA;    //: /sn:0 {0}(693,754)(488,754){1}
output _DOUT;    //: /sn:0 {0}(704,1137)(494,1137){1}
output _incpc;    //: /sn:0 {0}(494,997)(704,997){1}
supply0 w30;    //: /sn:0 {0}(434,671)(434,662)(455,662)(455,672){1}
output spc;    //: /sn:0 {0}(494,1067)(704,1067){1}
output _ldmdr;    //: /sn:0 {0}(704,1017)(494,1017){1}
supply0 w2;    //: /sn:0 {0}(199,416)(199,395){1}
supply0 w11;    //: /sn:0 {0}(372,1125)(372,1114){1}
output _incmar;    //: /sn:0 {0}(704,1177)(494,1177){1}
output [1:0] BOP;    //: /sn:0 {0}(#:488,694)(693,694){1}
output _LDQL;    //: /sn:0 {0}(494,1117)(704,1117){1}
supply0 w5;    //: /sn:0 {0}(368,745)(368,736){1}
input _GT;    //: /sn:0 {0}(1163,323)(1125,323)(1125,338)(1115,338){1}
supply0 w9;    //: /sn:0 {0}(380,528)(380,516)(370,516){1}
output [7:0] IDATA;    //: /sn:0 {0}(#:409,380)(540,380)(540,652){1}
//: {2}(542,654)(693,654){3}
//: {4}(538,654)(488,654){5}
input COUT;    //: /sn:0 {0}(1115,368)(1139,368)(1139,375)(1161,375){1}
wire w32;    //: /sn:0 {0}(901,386)(935,386){1}
//: {2}(939,386)(953,386)(953,368)(1025,368){3}
//: {4}(937,384)(937,314)(813,314){5}
wire [7:0] w6;    //: /sn:0 {0}(#:90,65)(149,65){1}
//: {2}(153,65)(280,65)(280,88){3}
//: {4}(151,67)(151,88){5}
wire [7:0] mp_nxtaddr;    //: /sn:0 {0}(#:354,1087)(331,1087)(331,733){1}
//: {2}(331,729)(331,711){3}
//: {4}(333,709)(350,709){5}
//: {6}(331,707)(331,522){7}
//: {8}(329,731)(237,731)(237,673){9}
wire [3:0] w45;    //: /sn:0 {0}(#:709,880)(601,880)(601,173)(325,173){1}
wire [4:0] w7;    //: /sn:0 {0}(#:325,192)(591,192)(591,946)(709,946){1}
wire ww;    //: /sn:0 {0}(891,358)(943,358){1}
//: {2}(947,358)(1000,358)(1000,358)(1025,358){3}
//: {4}(945,356)(945,307)(813,307){5}
wire [3:0] w46;    //: /sn:0 {0}(#:709,900)(568,900)(568,774)(488,774){1}
wire [1:0] w14;    //: /sn:0 {0}(#:488,644)(517,644)(517,455)(281,455)(281,417)(308,417){1}
wire _ldir;    //: /sn:0 {0}(488,674)(554,674)(554,113)(216,113)(216,103)(190,103){1}
wire w4;    //: /sn:0 {0}(813,294)(999,294)(999,338)(1025,338){1}
wire [2:0] w38;    //: /sn:0 {0}(#:325,241)(621,241)(621,443)(787,443)(787,429){1}
wire _SA;    //: /sn:0 {0}(870,356)(863,356)(863,320)(813,320){1}
wire [3:0] w3;    //: /sn:0 {0}(#:1058,353)(1031,353){1}
wire [7:0] OPR;    //: /sn:0 {0}(#:280,131)(280,109){1}
wire w0;    //: /sn:0 {0}(494,1147)(1064,1147)(1064,391){1}
wire [1:0] w37;    //: /sn:0 {0}(#:335,224)(325,224){1}
wire [31:0] mp_wrd0;    //: /sn:0 {0}(#:439,709)(482,709){1}
wire w43;    //: /sn:0 {0}(725,795)(725,780)(535,780)(535,1077)(494,1077){1}
wire [7:0] IRR;    //: /sn:0 {0}(#:151,131)(151,109){1}
wire [3:0] w41;    //: /sn:0 {0}(#:709,808)(610,808)(610,153)(325,153){1}
wire [7:0] w36;    //: /sn:0 {0}(#:181,368)(162,368)(162,259){1}
wire [7:0] w1;    //: /sn:0 {0}(#:337,401)(337,368)(216,368){1}
wire [7:0] w25;    //: /sn:0 {0}(#:100,75)(90,75){1}
wire _ldopr;    //: /sn:0 {0}(488,744)(570,744)(570,103)(319,103){1}
wire [31:0] w8;    //: /sn:0 {0}(#:488,1087)(446,1087){1}
wire w40;    //: /sn:0 {0}(820,413)(835,413)(835,1107)(494,1107){1}
wire w35;    //: /sn:0 {0}(784,311)(692,311)(692,433)(393,433)(393,413){1}
wire [2:0] w18;    //: /sn:0 {0}(#:488,664)(807,664)(807,429){1}
wire w22;    //: /sn:0 {0}(245,659)(255,659){1}
wire _SA0;    //: /sn:0 {0}(880,384)(850,384)(850,327)(813,327){1}
wire [4:0] w49;    //: /sn:0 {0}(#:494,987)(601,987)(601,966)(709,966){1}
wire [2:0] w44;    //: /sn:0 {0}(#:797,334)(797,400){1}
wire [7:0] w12;    //: /sn:0 {0}(#:380,390)(349,390)(349,401){1}
wire [31:0] w10;    //: /sn:0 {0}(#:425,1087)(389,1087){1}
wire [7:0] w13;    //: /sn:0 {0}(#:331,430)(331,501){1}
wire [7:0] w27;    //: /sn:0 {0}(#:409,400)(419,400)(419,480)(223,480){1}
//: {2}(221,478)(221,395)(313,395)(313,401){3}
//: {4}(221,482)(221,644){5}
wire [3:0] w48;    //: /sn:0 {0}(#:1109,353)(1079,353){1}
wire [1:0] w33;    //: /sn:0 {0}(#:335,208)(325,208){1}
wire w47;    //: /sn:0 {0}(725,867)(725,853)(545,853)(545,1087)(494,1087){1}
wire w42;    //: /sn:0 {0}(725,933)(725,921)(557,921)(557,1097)(494,1097){1}
wire [7:0] extra;    //: {0}(#:50:494,1187)(504,1187)(504,1234)(446,1234){1}
wire w55;    //: /sn:0 {0}(1025,348)(951,348)(951,333){1}
//: {2}(951,329)(951,300)(881,300){3}
//: {4}(879,298)(879,287)(813,287){5}
//: {6}(877,300)(813,300){7}
//: {8}(949,331)(911,331)(911,351){9}
//: {10}(909,353)(891,353){11}
//: {12}(911,355)(911,381)(901,381){13}
wire [3:0] w39;    //: /sn:0 {0}(#:488,764)(577,764)(577,828)(709,828){1}
wire [31:0] w26;    //: /sn:0 {0}(#:418,709)(385,709){1}
//: enddecls

  //: GROUND g8 (w11) @(372,1131) /sn:0 /w:[ 0 ]
  _GGNOR2 #(6) g4 (.I0(!w55), .I1(!ww), .Z(_SA));   //: @(880,356) /sn:0 /R:2 /w:[ 11 0 0 ] /eb:0
  //: comment g61 @(366,789)
  //: /line:"This is the low half"
  //: /line:"of the microinstruction"
  //: /line:"memory."
  //: /end
  //: joint g37 (CK) @(264, 511) /w:[ 6 -1 8 5 ]
  //: frame g86 @(741,228) /sn:0 /wi:482 /ht:251 /tx:"Condition Code Handling"
  //: joint g13 (mp_nxtaddr) @(331, 731) /w:[ -1 2 8 1 ]
  //: IN g3 (CK) @(81,511) /sn:0 /w:[ 21 ]
  _GGREG32 #(10, 10, 20) g34 (.Q(mp_wrd0), .D(w26), .EN(w30), .CLR(w19), .CK(CK));   //: @(429,709) /sn:0 /R:1 /w:[ 0 0 0 0 3 ]
  //: OUT g51 (_LDQ) @(690,724) /sn:0 /w:[ 0 ]
  //: OUT g55 (_WA) @(690,754) /sn:0 /w:[ 0 ]
  //: OUT g58 (_rd) @(701,1037) /sn:0 /w:[ 1 ]
  _GGREG8 #(10, 10, 20) IR (.Q(IRR), .D(w6), .EN(_ldir), .CLR(_CLR), .CK(CK));   //: @(151,98) /w:[ 1 5 1 9 19 ]
  _GGREG4 #(10, 10, 20) g77 (.Q(w3), .D(w48), .EN(w0), .CLR(_CLR), .CK(CK));   //: @(1069,353) /sn:0 /R:3 /w:[ 0 1 1 3 13 ]
  //: GROUND g2 (w9) @(380,534) /sn:0 /w:[ 0 ]
  //: OUT g76 (_DOUT) @(701,1137) /sn:0 /w:[ 0 ]
  //: comment g65 @(101,14)
  //: /line:"The IR and OPR registers store the"
  //: /line:"instruction and operand bytes of "
  //: /line:"the current instruction. "
  //: /end
  //: OUT g59 (_rdmdr) @(701,1047) /sn:0 /w:[ 1 ]
  _GGMUX2x3 #(8, 8) g72 (.I0(w38), .I1(w18), .S(w40), .Z(w44));   //: @(797,413) /sn:0 /R:2 /w:[ 1 1 0 1 ] /ss:0 /do:1
  //: joint g1 (w27) @(221, 480) /w:[ 1 2 -1 4 ]
  _GGROM8x8 #(10, 50) map (.A(w36), .D(w1), .OE(w2));   //: @(199,369) /w:[ 0 1 1 ]
  //: GROUND g16 (w2) @(199,422) /sn:0 /w:[ 0 ]
  assign {extra, _incmar, _rdpc, _ldhmdr, w0, _DOUT, _LDQH, _LDQL, w40, w42, w47, w43, spc, _wrt, _rdmdr, _rd, _ldpc, _ldmdr, _ldmar, _incpc, w49} = w8; //: CONCAT g11  @(489,1087) /sn:0 /R:2 /w:[ 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 ] /dr:0 /tp:0 /drp:0
  _GGREG8 #(10, 10, 20) OPR (.Q(OPR), .D(w6), .EN(_ldopr), .CLR(_CLR), .CK(CK));   //: @(280,98) /w:[ 1 3 1 11 17 ]
  _GGROM8x32 #(10, 50) m2 (.A(mp_nxtaddr), .D(w10), .OE(w11));   //: @(372,1088) /w:[ 0 1 1 ]
  _GGREG8 #(10, 10, 20) mpc (.Q(mp_nxtaddr), .D(w13), .EN(w9), .CLR(_CLR), .CK(CK));   //: @(331,511) /w:[ 7 1 1 0 7 ]
  //: frame g87 @(26,611) /sn:0 /wi:827 /ht:641 /tx:"Microinstruction Decode"
  assign w48 = {COUT, _Z, _LT, _GT}; //: CONCAT g78  @(1110,353) /sn:0 /R:2 /w:[ 0 0 1 1 1 ] /dr:0 /tp:0 /drp:1
  _GGMUX4x8 #(12, 12) g10 (.I0(w27), .I1(w23), .I2(w1), .I3(w12), .S(w14), .Z(w13));   //: @(331,417) /sn:0 /w:[ 3 1 0 1 1 0 ] /ss:0 /do:0
  //: OUT g50 (_CLQ) @(690,714) /sn:0 /w:[ 0 ]
  //: OUT g28 (FUNC) @(766,956) /sn:0 /w:[ 0 ]
  //: joint g27 (w32) @(937, 386) /w:[ 2 4 1 -1 ]
  //: joint g32 (w55) @(951, 331) /w:[ -1 2 8 1 ]
  //: GROUND g19 (w28) @(839,358) /sn:0 /w:[ 0 ]
  _GGROM8x32 #(10, 50) m1 (.A(mp_nxtaddr), .D(w26), .OE(w5));   //: @(368,710) /w:[ 5 1 1 ]
  //: IN g69 (_CLR) @(525,61) /sn:0 /R:3 /w:[ 5 ]
  //: joint g6 (_CLR) @(525, 74) /w:[ 2 4 6 1 ]
  OPRDEC g38 (.OPR(OPR), .IR(IRR), .MAP(w36), .OM1(w33), .COND(w38), .OM2(w37), .FUNC(w7), .SB(w45), .SA(w41));   //: @(132, 132) /sz:(192, 126) /sn:0 /p:[ Ti0>0 Ti1>0 Bo0<1 Ro0<1 Ro1<0 Ro2<1 Ro3<0 Ro4<1 Ro5<1 ]
  //: OUT g75 (_LDQH) @(701,1127) /sn:0 /w:[ 1 ]
  //: GROUND g9 (w5) @(368,751) /sn:0 /w:[ 0 ]
  //: OUT g57 (SB) @(766,890) /sn:0 /w:[ 0 ]
  //: OUT g53 (_ldmdr) @(701,1017) /sn:0 /w:[ 0 ]
  //: joint g7 (CK) @(102, 120) /w:[ 16 18 -1 15 ]
  _GGMUX2x4 #(8, 8) g71 (.I0(w45), .I1(w46), .S(w47), .Z(SB));   //: @(725,890) /sn:0 /R:1 /w:[ 0 0 0 1 ] /ss:1 /do:1
  //: GROUND g15 (w15) @(205,723) /sn:0 /w:[ 1 ]
  _GGMUX2x8 #(8, 8) g20 (.I0(IDATA), .I1(w27), .S(w35), .Z(w12));   //: @(393,390) /sn:0 /R:3 /w:[ 0 0 1 0 ] /ss:1 /do:0
  //: IN g31 (IR) @(57,70) /sn:0 /w:[ 0 ]
  _GGMUX2x4 #(8, 8) g68 (.I0(w41), .I1(w39), .S(w43), .Z(SA));   //: @(725,818) /sn:0 /R:1 /w:[ 0 1 0 0 ] /ss:1 /do:1
  //: VDD g39 (w19) @(421,649) /sn:0 /w:[ 1 ]
  //: joint g67 (w6) @(151, 65) /w:[ 2 -1 1 4 ]
  //: GROUND g43 (w20) @(455,1042) /sn:0 /w:[ 1 ]
  //: joint g48 (IDATA) @(540, 654) /w:[ 2 1 4 -1 ]
  //: frame g88 @(176,317) /sn:0 /wi:311 /ht:239 /tx:"Microcode Next Address Generation"
  //: joint g29 (ww) @(945, 358) /w:[ 2 4 1 -1 ]
  _GGMUX2x5 #(8, 8) g73 (.I0(w7), .I1(w49), .S(w42), .Z(FUNC));   //: @(725,956) /sn:0 /R:1 /w:[ 1 1 0 1 ] /ss:1 /do:1
  _GGNOR2 #(6) g25 (.I0(!w55), .I1(!w32), .Z(_SA0));   //: @(890,384) /sn:0 /R:2 /w:[ 13 0 0 ] /eb:0
  //: GROUND g17 (w23) @(360,367) /sn:0 /w:[ 0 ]
  //: comment g62 @(370,940)
  //: /line:"This is the high half"
  //: /line:"of the microinstruction"
  //: /line:"memory."
  //: /end
  //: joint g63 (CK) @(264, 771) /w:[ 2 4 -1 1 ]
  //: GROUND g42 (w30) @(455,678) /sn:0 /w:[ 1 ]
  //: OUT g52 (_ldmar) @(701,1007) /sn:0 /w:[ 1 ]
  //: OUT g83 (_incmar) @(701,1177) /sn:0 /w:[ 0 ]
  //: OUT g74 (_LDQL) @(701,1117) /sn:0 /w:[ 1 ]
  //: OUT g56 (SA) @(766,818) /sn:0 /w:[ 1 ]
  //: joint g5 (mp_nxtaddr) @(331, 709) /w:[ 4 6 -1 3 ]
  //: VDD g14 (w21) @(186,641) /sn:0 /w:[ 0 ]
  //: joint g80 (CK) @(102, 276) /w:[ 12 14 -1 11 ]
  assign {w4, w55, ww, w32} = w3; //: CONCAT g79  @(1030,353) /sn:0 /w:[ 1 0 3 3 1 ] /dr:0 /tp:0 /drp:0
  //: OUT g47 (IDATA) @(690,654) /sn:0 /w:[ 3 ]
  //: OUT g44 (_incpc) @(701,997) /sn:0 /w:[ 1 ]
  //: comment g85 @(16,131) /sn:0
  //: /line:"This block"
  //: /line:"decodes"
  //: /line:"insructions"
  //: /line:"producing"
  //: /line:"a map index,"
  //: /line:"register"
  //: /line:"numbers,"
  //: /line:"a function"
  //: /line:"code and a"
  //: /line:"condition"
  //: /line:"code."
  //: /end
  //: OUT g36 (_LDDATA) @(690,734) /sn:0 /w:[ 0 ]
  //: IN g21 (COUT) @(1163,375) /sn:0 /R:2 /w:[ 1 ]
  //: IN g24 (_LT) @(1168,345) /sn:0 /R:2 /w:[ 0 ]
  //: comment g84 @(694,22)
  //: /line:"This is a trival example of an"
  //: /line:"instruction unit.  The mpc register"
  //: /line:"contains the micro-instruction"
  //: /line:"program counter, and the two"
  //: /line:"registers on the data out of ROMs"
  //: /line:"m1 and m2 are the current micro-"
  //: /line:"instructions.  Note that since these"
  //: /line:"are two separate registers the a"
  //: /line:"single cycle jump delay."
  //: /end
  //: IN g23 (_Z) @(1164,361) /sn:0 /R:2 /w:[ 0 ]
  //: OUT g41 (spc) @(701,1067) /sn:0 /w:[ 1 ]
  //: VDD g40 (w24) @(421,1016) /sn:0 /w:[ 1 ]
  //: OUT g54 (_ldpc) @(701,1027) /sn:0 /w:[ 1 ]
  //: OUT g60 (_wrt) @(701,1057) /sn:0 /w:[ 1 ]
  //: OUT g81 (_ldhmdr) @(701,1157) /sn:0 /w:[ 0 ]
  //: joint g22 (w55) @(879, 300) /w:[ 3 4 6 -1 ]
  assign {w46, w39, _WA, _ldopr, _LDDATA, _LDQ, _CLQ, CIN, BOP, AOP, _ldir, w18, IDATA, w14} = mp_wrd0; //: CONCAT g0  @(483,709) /sn:0 /R:2 /w:[ 1 0 1 0 1 1 1 1 0 0 0 0 5 0 1 ] /dr:0 /tp:0 /drp:0
  //: IN g26 (_GT) @(1165,323) /sn:0 /R:2 /w:[ 0 ]
  _GGREG32 #(10, 10, 20) g35 (.Q(w8), .D(w10), .EN(w20), .CLR(w24), .CK(CK));   //: @(436,1087) /sn:0 /R:1 /w:[ 1 0 0 0 0 ]
  //: OUT g45 (AOP) @(690,684) /sn:0 /w:[ 1 ]
  //: OUT g46 (BOP) @(690,694) /sn:0 /w:[ 1 ]
  //: joint g70 (_CLR) @(385, 74) /w:[ 7 -1 8 10 ]
  //: OUT g82 (_rdpc) @(701,1167) /sn:0 /w:[ 1 ]
  assign {w25, w6} = IR; //: CONCAT g66  @(85,70) /sn:0 /R:2 /w:[ 1 0 1 ] /dr:0 /tp:0 /drp:0
  _GGADD8 #(68, 70, 62, 64) g12 (.A(mp_nxtaddr), .B(w15), .S(w27), .CI(w21), .CO(w22));   //: @(221,657) /sn:0 /R:2 /w:[ 9 0 5 1 0 ]
  _GGMUX8 #(20, 22) g18 (.I0(~w55), .I1(~w4), .I2(w55), .I3(ww), .I4(w32), .I5(_SA), .I6(_SA0), .I7(w28), .S(w44), .Z(w35));   //: @(797,311) /sn:0 /R:3 /w:[ 5 0 7 5 5 1 1 1 0 0 ] /ss:1 /do:0
  //: joint g30 (CK) @(102, 511) /w:[ 9 10 20 -1 ]
  //: joint g33 (w55) @(911, 353) /w:[ -1 9 10 12 ]
  //: OUT g49 (CIN) @(690,704) /sn:0 /w:[ 0 ]

endmodule
//: /netlistEnd

//: /netlistBegin ZREG4
module ZREG4(CK, SB, _ENA, B, DIN, _ENB, _WA, _CLR, SA, A);
//: interface  /sz:(107, 138) /bd:[ Ti0>DIN[15:0](52/107) Li0>SA[1:0](17/138) Li1>SB[1:0](33/138) Li2>_CLR(51/138) Li3>_ENA(70/138) Li4>_ENB(88/138) Li5>_WA(106/138) Li6>CK(123/138) Bo0<A[15:0](31/107) Bo1<B[15:0](79/107) ]
output [15:0] B;    //: /sn:0 {0}(#:507,666)(507,615){1}
input CK;    //: /sn:0 {0}(46,421)(314,421){1}
//: {2}(318,421)(463,421){3}
//: {4}(467,421)(578,421)(578,285)(612,285){5}
//: {6}(465,419)(465,279)(476,279){7}
//: {8}(316,419)(316,283)(326,283){9}
input _CLR;    //: /sn:0 {0}(552,274)(560,274)(560,237){1}
//: {2}(562,235)(703,235)(703,280)(688,280){3}
//: {4}(558,235)(414,235){5}
//: {6}(410,235)(367,235)(367,235)(54,235){7}
//: {8}(412,237)(412,278)(402,278){9}
supply0 [15:0] w0;    //: /sn:0 {0}(#:282,505)(282,477)(349,477){1}
//: {2}(353,477)(489,477)(489,527){3}
//: {4}(351,479)(351,527){5}
output [15:0] A;    //: /sn:0 {0}(#:369,669)(369,616){1}
input _ENA;    //: /sn:0 {0}(51,297)(78,297){1}
//: {2}(82,297)(104,297){3}
//: {4}(80,299)(80,586)(384,586)(384,608)(374,608){5}
input [1:0] SB;    //: /sn:0 {0}(#:458,543)(484,543){1}
input [1:0] SA;    //: /sn:0 {0}(#:51,543)(101,543){1}
//: {2}(105,543)(346,543){3}
//: {4}(103,541)(103,340)(121,340){5}
input _ENB;    //: /sn:0 {0}(512,607)(531,607)(531,566)(51,566){1}
input _WA;    //: /sn:0 {0}(52,269)(91,269)(91,292)(104,292){1}
input [15:0] DIN;    //: /sn:0 {0}(#:513,269)(513,122){1}
//: {2}(515,120)(649,120)(649,275){3}
//: {4}(511,120)(365,120){5}
//: {6}(361,120)(53,120){7}
//: {8}(363,122)(363,273){9}
wire w6;    //: /sn:0 {0}(552,284)(563,284)(563,346)(150,346){1}
wire [15:0] w81;    //: /sn:0 {0}(#:507,556)(507,599){1}
wire w19;    //: /sn:0 {0}(125,295)(134,295)(134,316){1}
wire w3;    //: /sn:0 {0}(402,288)(423,288)(423,334)(150,334){1}
wire [15:0] R2;    //: /sn:0 {0}(#:513,290)(513,485){1}
//: {2}(511,487)(375,487)(375,527){3}
//: {4}(513,489)(513,527){5}
wire w34;    //: /sn:0 {0}(150,358)(702,358)(702,290)(688,290){1}
wire w31;    //: /sn:0 {0}(150,322)(162,322){1}
wire [15:0] R1;    //: /sn:0 {0}(#:363,294)(363,449){1}
//: {2}(365,451)(501,451)(501,527){3}
//: {4}(363,453)(363,527){5}
wire [15:0] R3;    //: /sn:0 {0}(#:649,296)(649,505)(527,505){1}
//: {2}(523,505)(387,505)(387,527){3}
//: {4}(525,507)(525,527){5}
wire [15:0] w65;    //: /sn:0 {0}(#:369,556)(369,600){1}
//: enddecls

  _GGMUX4x16 #(12, 12) g8 (.I0(w0), .I1(R1), .I2(R2), .I3(R3), .S(SB), .Z(w81));   //: @(507,543) /sn:0 /w:[ 3 3 5 5 1 0 ] /ss:0 /do:0
  _GGNDEMUX4 #(4, 4) g4 (.I(SA), .E(~w19), .Z0(w31), .Z1(w3), .Z2(w6), .Z3(w34));   //: @(134,340) /sn:0 /R:1 /w:[ 5 1 0 1 1 0 ] /ss:1 /do:1
  _GGMUX4x16 #(12, 12) g13 (.I0(w0), .I1(R1), .I2(R2), .I3(R3), .S(SA), .Z(w65));   //: @(369,543) /sn:0 /w:[ 5 5 3 3 3 0 ] /ss:0 /do:0
  //: joint g34 (SA) @(103, 543) /w:[ 2 1 4 -1 ]
  //: IN g2 (CK) @(44,421) /sn:0 /w:[ 0 ]
  //: joint g1 (w0) @(351, 477) /w:[ 2 -1 1 4 ]
  //: comment g16 @(157,445) /sn:0
  //: /line:"Register R0 is hard-coded"
  //: /line:"to always be set to 0."
  //: /end
  _GGREG16 #(10, 10, 20) R2 (.Q(R2), .D(DIN), .EN(w6), .CLR(_CLR), .CK(CK));   //: @(513,279) /w:[ 0 0 0 0 7 ]
  //: joint g11 (R3) @(525, 505) /w:[ 1 -1 2 4 ]
  //: joint g28 (_ENA) @(80, 297) /w:[ 2 -1 1 4 ]
  //: joint g10 (R2) @(513, 487) /w:[ -1 1 2 4 ]
  //: IN g19 (SB) @(456,543) /sn:0 /w:[ 0 ]
  //: IN g27 (_ENA) @(49,297) /sn:0 /w:[ 0 ]
  //: OUT g32 (B) @(507,663) /sn:0 /R:3 /w:[ 0 ]
  //: joint g6 (DIN) @(363, 120) /w:[ 5 -1 6 8 ]
  //: joint g9 (_CLR) @(412, 235) /w:[ 5 -1 6 8 ]
  //: joint g7 (DIN) @(513, 120) /w:[ 2 -1 4 1 ]
  //: IN g20 (DIN) @(51,120) /sn:0 /w:[ 7 ]
  //: IN g31 (_ENB) @(49,566) /sn:0 /w:[ 1 ]
  //: joint g15 (CK) @(465, 421) /w:[ 4 6 3 -1 ]
  _GGREG16 #(10, 10, 20) R1 (.Q(R1), .D(DIN), .EN(w3), .CLR(_CLR), .CK(CK));   //: @(363,283) /w:[ 0 9 0 9 9 ]
  _GGREG16 #(10, 10, 20) R3 (.Q(R3), .D(DIN), .EN(w34), .CLR(_CLR), .CK(CK));   //: @(649,285) /w:[ 0 3 1 3 5 ]
  //: IN g25 (_WA) @(50,269) /sn:0 /w:[ 0 ]
  _GGBUFIF16 #(4, 6) g29 (.Z(A), .I(w65), .E(~_ENA));   //: @(369,606) /sn:0 /R:3 /w:[ 1 1 5 ]
  //: joint g5 (R1) @(363, 451) /w:[ 2 1 -1 4 ]
  //: joint g14 (CK) @(316, 421) /w:[ 2 8 1 -1 ]
  //: IN g21 (_CLR) @(52,235) /sn:0 /w:[ 7 ]
  //: GROUND g0 (w0) @(282,511) /sn:0 /w:[ 0 ]
  _GGOR2 #(6) g26 (.I0(_WA), .I1(_ENA), .Z(w19));   //: @(115,295) /sn:0 /w:[ 1 3 0 ] /eb:0
  //: IN g18 (SA) @(49,543) /sn:0 /w:[ 0 ]
  //: joint g12 (_CLR) @(560, 235) /w:[ 2 -1 4 1 ]
  _GGBUFIF16 #(4, 6) g30 (.Z(B), .I(w81), .E(~_ENB));   //: @(507,605) /sn:0 /R:3 /w:[ 1 1 0 ]
  //: OUT g33 (A) @(369,666) /sn:0 /R:3 /w:[ 0 ]

endmodule
//: /netlistEnd

//: /netlistBegin OPRDEC
module OPRDEC(SB, SA, FUNC, OPR, OM2, MAP, OM1, COND, IR);
//: interface  /sz:(192, 126) /bd:[ Ti0>IR[7:0](19/192) Ti1>OPR[7:0](148/192) Bo0<MAP[7:0](23/192) Ro0<SA[3:0](21/126) Ro1<SB[3:0](41/126) Ro2<FUNC[4:0](60/126) Ro3<OM2[1:0](92/126) Ro4<COND[2:0](109/126) Ro5<OM1[1:0](76/126) ]
input [7:0] IR;    //: /sn:0 {0}(#:569,291)(430,291){1}
//: {2}(429,291)(382,291){3}
//: {4}(381,291)(356,291){5}
//: {6}(355,291)(323,291){7}
//: {8}(322,291)(251,291){9}
//: {10}(250,291)(219,291){11}
//: {12}(218,291)(196,291){13}
//: {14}(195,291)(167,291){15}
//: {16}(166,291)(150,291){17}
supply1 [2:0] w19;    //: /sn:0 {0}(#:279,445)(234,445)(234,431){1}
input [7:0] OPR;    //: /sn:0 {0}(#:397,114)(352,114){1}
output [4:0] FUNC;    //: /sn:0 {0}(#:640,228)(505,228){1}
output [7:0] MAP;    //: /sn:0 {0}(#:590,294)(643,294){1}
output [3:0] SB;    //: /sn:0 {0}(#:493,90)(441,90)(441,109)(403,109){1}
output [1:0] OM1;    //: /sn:0 {0}(#:511,187)(642,187){1}
output [3:0] SA;    //: /sn:0 {0}(#:403,119)(445,119)(445,141)(489,141){1}
supply1 [1:0] w22;    //: /sn:0 {0}(#:385,412)(385,453)(446,453){1}
output [2:0] COND;    //: /sn:0 {0}(#:640,261)(506,261){1}
supply1 [2:0] w13;    //: /sn:0 {0}(#:422,411)(422,433)(446,433){1}
output [1:0] OM2;    //: /sn:0 {0}(#:572,517)(646,517){1}
wire w16;    //: /sn:0 {0}(458,489)(474,489)(474,512)(566,512){1}
wire [3:0] w14;    //: /sn:0 {0}(#:251,286)(251,184)(276,184){1}
wire [2:0] w4;    //: /sn:0 {0}(#:430,286)(430,261)(490,261){1}
wire w15;    //: /sn:0 {0}(297,184)(490,184){1}
wire w24;    //: /sn:0 {0}(219,295)(219,400)(237,400){1}
wire [2:0] w23;    //: /sn:0 {0}(#:300,443)(446,443){1}
wire [7:0] w20;    //: /sn:0 {0}(#:452,443)(550,443)(550,296)(569,296){1}
wire [4:0] w1;    //: /sn:0 {0}(#:382,286)(382,228)(489,228){1}
wire w25;    //: /sn:0 {0}(258,404)(271,404)(271,440)(279,440){1}
wire [1:0] w18;    //: /sn:0 {0}(#:356,295)(356,517)(392,517){1}
wire w8;    //: /sn:0 {0}(237,404)(167,404)(167,295){1}
wire w17;    //: /sn:0 {0}(437,486)(196,486)(196,409){1}
//: {2}(198,407)(237,407){3}
//: {4}(196,405)(196,295){5}
wire w11;    //: /sn:0 {0}(566,522)(398,522){1}
wire [1:0] w10;    //: /sn:0 {0}(#:323,286)(323,189)(490,189){1}
wire w26;    //: /sn:0 {0}(398,512)(420,512)(420,491)(437,491){1}
//: enddecls

  //: OUT g4 (SB) @(490,90) /sn:0 /w:[ 0 ]
  //: VDD g34 (w19) @(245,431) /sn:0 /w:[ 1 ]
  //: OUT g3 (SA) @(486,141) /sn:0 /w:[ 1 ]
  //: OUT g2 (FUNC) @(637,228) /sn:0 /w:[ 0 ]
  //: IN g1 (OPR) @(350,114) /sn:0 /w:[ 1 ]
  //: VDD g32 (w22) @(396,412) /sn:0 /w:[ 0 ]
  _GGAND2 #(6) g27 (.I0(w17), .I1(w26), .Z(w16));   //: @(448,489) /sn:0 /w:[ 0 1 0 ] /eb:0
  assign {SA, SB} = OPR; //: CONCAT g19  @(398,114) /sn:0 /R:2 /w:[ 0 1 0 ] /dr:0 /tp:0 /drp:0
  //: OUT g6 (OM2) @(643,517) /sn:0 /w:[ 1 ]
  //: OUT g7 (MAP) @(640,294) /sn:0 /w:[ 1 ]
  //: VDD g31 (w13) @(433,411) /sn:0 /w:[ 0 ]
  assign OM2 = {w16, w11}; //: CONCAT g20  @(571,517) /sn:0 /w:[ 0 1 0 ] /dr:0 /tp:0 /drp:1
  assign w8 = IR[6]; //: TAP g15 @(167,294) /sn:0 /R:3 /w:[ 1 15 16 ] /ss:0
  _GGBUF3 #(4) g39 (.I(w4), .Z(COND));   //: @(496,261) /sn:0 /w:[ 1 1 ]
  _GGAND2x8 #(6) g29 (.I0(IR), .I1(w20), .Z(MAP));   //: @(580,294) /sn:0 /w:[ 0 1 0 ] /eb:0
  assign w14 = IR[7:4]; //: TAP g25 @(251,294) /sn:0 /R:3 /w:[ 0 9 10 ] /ss:1
  _GGBUF5 #(4) g17 (.I(w1), .Z(FUNC));   //: @(495,228) /sn:0 /w:[ 1 1 ]
  assign {w26, w11} = w18; //: CONCAT g42  @(393,517) /sn:0 /R:2 /w:[ 0 1 1 ] /dr:1 /tp:0 /drp:0
  assign w17 = IR[7]; //: TAP g14 @(196,294) /sn:0 /R:3 /w:[ 5 13 14 ] /ss:0
  //: OUT g5 (OM1) @(639,187) /sn:0 /w:[ 1 ]
  assign w24 = IR[5]; //: TAP g36 @(219,294) /sn:0 /R:3 /w:[ 0 11 12 ] /ss:0
  _GGAND2x2 #(6) g24 (.I0({2{w15}}), .I1(w10), .Z(OM1));   //: @(501,187) /sn:0 /w:[ 1 1 0 ] /eb:0
  assign w18 = IR[1:0]; //: TAP g21 @(356,294) /sn:0 /R:3 /w:[ 0 5 6 ] /ss:0
  //: OUT g41 (COND) @(637,261) /sn:0 /w:[ 0 ]
  assign w10 = IR[3:2]; //: TAP g23 @(323,294) /sn:0 /R:3 /w:[ 0 7 8 ] /ss:1
  assign w4 = IR[4:2]; //: TAP g40 @(430,294) /sn:0 /R:3 /w:[ 0 1 2 ] /ss:1
  _GGNAND3 #(8) g35 (.I0(w24), .I1(!w8), .I2(w17), .Z(w25));   //: @(248,404) /sn:0 /w:[ 1 0 3 0 ] /eb:0
  _GGAND1x4 #(1) g22 (.I0(w14), .Z(w15));   //: @(287,184) /sn:0 /w:[ 1 0 ] /eb:0
  //: IN g0 (IR) @(148,291) /sn:0 /w:[ 17 ]
  //: joint g26 (w17) @(196, 407) /w:[ 2 4 -1 1 ]
  assign w1 = IR[5:1]; //: TAP g18 @(382,294) /sn:0 /R:3 /w:[ 0 3 4 ] /ss:1
  _GGAND2x3 #(6) g33 (.I0({3{w25}}), .I1(w19), .Z(w23));   //: @(290,443) /sn:0 /w:[ 1 0 0 ] /eb:0
  assign w20 = {w13, w23, w22}; //: CONCAT g30  @(451,443) /sn:0 /w:[ 0 1 1 1 ] /dr:0 /tp:0 /drp:1

endmodule
//: /netlistEnd

//: /netlistBegin REG16
module REG16(DIN, SB, _ENA, SA, A, B, CK, _WA, _CLR, _ENB);
//: interface  /sz:(108, 138) /bd:[ Ti0>DIN[15:0](53/108) Li0>_WA(101/138) Li1>_ENB(82/138) Li2>_ENA(66/138) Li3>_CLR(51/138) Li4>SB[3:0](33/138) Li5>SA[3:0](17/138) Li6>CK(118/138) Bo0<B[15:0](80/108) Bo1<A[15:0](32/108) ]
output [15:0] B;    //: /sn:0 {0}(#:1208,435)(1135,435){1}
//: {2}(1133,433)(1133,336){3}
//: {4}(1131,435)(882,435){5}
//: {6}(880,433)(880,337){7}
//: {8}(878,435)(647,435){9}
//: {10}(645,433)(645,337){11}
//: {12}(643,435)(387,435)(387,340){13}
input CK;    //: /sn:0 {0}(42,403)(292,403){1}
//: {2}(296,403)(402,403)(402,403)(510,403){3}
//: {4}(514,403)(645,403)(645,403)(779,403){5}
//: {6}(783,403)(1002,403)(1002,320)(1052,320){7}
//: {8}(781,401)(781,321)(800,321){9}
//: {10}(512,401)(512,321)(566,321){11}
//: {12}(294,401)(294,324)(307,324){13}
input _CLR;    //: /sn:0 {0}(43,359)(161,359){1}
//: {2}(165,359)(463,359){3}
//: {4}(467,359)(593,359)(593,359)(722,359){5}
//: {6}(726,359)(948,359)(948,248)(1052,248){7}
//: {8}(724,357)(724,249)(800,249){9}
//: {10}(465,357)(465,249)(566,249){11}
//: {12}(163,357)(163,252)(307,252){13}
output [15:0] A;    //: /sn:0 {0}(#:1210,467)(1087,467){1}
//: {2}(1085,465)(1085,336){3}
//: {4}(1083,467)(834,467){5}
//: {6}(832,465)(832,337){7}
//: {8}(830,467)(600,467){9}
//: {10}(598,465)(598,337){11}
//: {12}(596,467)(339,467)(339,340){13}
input _ENA;    //: /sn:0 {0}(222,461)(222,453)(35,453){1}
input [3:0] SB;    //: /sn:0 {0}(#:78,628)(36,628){1}
input [3:0] SA;    //: /sn:0 {0}(#:77,525)(33,525){1}
input _ENB;    //: /sn:0 {0}(222,561)(222,555)(35,555){1}
input _WA;    //: /sn:0 {0}(42,379)(277,379){1}
//: {2}(281,379)(388,379)(388,379)(498,379){3}
//: {4}(502,379)(633,379)(633,379)(767,379){5}
//: {6}(771,379)(989,379)(989,303)(1052,303){7}
//: {8}(769,377)(769,304)(800,304){9}
//: {10}(500,377)(500,304)(566,304){11}
//: {12}(279,377)(279,307)(307,307){13}
input [15:0] DIN;    //: /sn:0 {0}(#:116,156)(358,156){1}
//: {2}(362,156)(617,156){3}
//: {4}(621,156)(851,156){5}
//: {6}(855,156)(1106,156)(1106,196){7}
//: {8}(853,158)(853,197){9}
//: {10}(619,158)(619,197){11}
//: {12}(360,158)(360,200){13}
wire w46;    //: /sn:0 {0}(238,603)(969,603)(969,285)(1052,285){1}
wire w16;    //: /sn:0 {0}(238,467)(250,467)(250,271)(307,271){1}
wire [1:0] w15;    //: /sn:0 {0}(#:209,585)(194,585)(194,633)(84,633){1}
wire [1:0] w37;    //: /sn:0 {0}(#:209,485)(178,485)(178,530)(83,530){1}
wire w25;    //: /sn:0 {0}(238,591)(756,591)(756,286)(800,286){1}
wire w17;    //: /sn:0 {0}(238,567)(274,567)(274,289)(307,289){1}
wire [1:0] w49;    //: /sn:0 {0}(#:84,623)(140,623){1}
//: {2}(144,623)(447,623){3}
//: {4}(451,623)(705,623){5}
//: {6}(709,623)(935,623)(935,230)(1052,230){7}
//: {8}(707,621)(707,231)(800,231){9}
//: {10}(449,621)(449,231)(566,231){11}
//: {12}(142,621)(142,234)(307,234){13}
wire w10;    //: /sn:0 {0}(238,579)(489,579)(489,286)(566,286){1}
wire w47;    //: /sn:0 {0}(238,503)(955,503)(955,267)(1052,267){1}
wire [1:0] w50;    //: /sn:0 {0}(#:83,520)(128,520){1}
//: {2}(132,520)(430,520){3}
//: {4}(434,520)(688,520){5}
//: {6}(692,520)(918,520)(918,214)(1052,214){7}
//: {8}(690,518)(690,215)(800,215){9}
//: {10}(432,518)(432,215)(566,215){11}
//: {12}(130,518)(130,218)(307,218){13}
wire w9;    //: /sn:0 {0}(238,479)(478,479)(478,268)(566,268){1}
wire w26;    //: /sn:0 {0}(238,491)(741,491)(741,268)(800,268){1}
//: enddecls

  //: joint g8 (w49) @(449, 623) /w:[ 4 10 3 -1 ]
  //: joint g4 (w50) @(432, 520) /w:[ 4 10 3 -1 ]
  //: joint g37 (B) @(645, 435) /w:[ 9 10 12 -1 ]
  //: joint g34 (A) @(598, 467) /w:[ 9 10 12 -1 ]
  //: joint g13 (w49) @(707, 623) /w:[ 6 8 5 -1 ]
  //: joint g3 (w50) @(130, 520) /w:[ 2 12 1 -1 ]
  assign {w37, w50} = SA; //: CONCAT g1  @(78,525) /sn:0 /R:2 /w:[ 1 0 0 ] /dr:0 /tp:0 /drp:0
  //: joint g16 (_CLR) @(724, 359) /w:[ 6 8 5 -1 ]
  //: IN g11 (DIN) @(114,156) /sn:0 /w:[ 0 ]
  //: joint g28 (CK) @(781, 403) /w:[ 6 8 5 -1 ]
  //: IN g10 (SB) @(34,628) /sn:0 /w:[ 1 ]
  //: IN g32 (_ENA) @(33,453) /sn:0 /w:[ 1 ]
  //: joint g27 (CK) @(512, 403) /w:[ 4 10 3 -1 ]
  _GGNDEMUX4 #(4, 4) g19 (.I(w15), .E(~_ENB), .Z0(w17), .Z1(w10), .Z2(w25), .Z3(w46));   //: @(222,585) /sn:0 /R:1 /w:[ 0 0 0 0 0 0 ] /ss:1 /do:1
  ZREG4 RF0 (.DIN(DIN), .CK(CK), ._WA(_WA), ._ENB(w17), ._ENA(w16), ._CLR(_CLR), .SB(w49), .SA(w50), .B(B), .A(A));   //: @(308, 201) /sz:(107, 138) /p:[ Ti0>13 Li0>13 Li1>13 Li2>1 Li3>1 Li4>13 Li5>13 Li6>13 Bo0<13 Bo1<13 ]
  //: joint g38 (B) @(880, 435) /w:[ 5 6 8 -1 ]
  //: joint g6 (w50) @(690, 520) /w:[ 6 8 5 -1 ]
  //: joint g7 (w49) @(142, 623) /w:[ 2 12 1 -1 ]
  //: IN g9 (SA) @(31,525) /sn:0 /w:[ 1 ]
  //: joint g31 (DIN) @(853, 156) /w:[ 6 -1 5 8 ]
  //: joint g15 (_CLR) @(465, 359) /w:[ 4 10 3 -1 ]
  //: joint g39 (B) @(1133, 435) /w:[ 1 2 4 -1 ]
  //: joint g29 (DIN) @(360, 156) /w:[ 2 -1 1 12 ]
  //: joint g25 (_WA) @(769, 379) /w:[ 6 8 5 -1 ]
  _GGNDEMUX4 #(4, 4) g17 (.I(w37), .E(~_ENA), .Z0(w16), .Z1(w9), .Z2(w26), .Z3(w47));   //: @(222,485) /sn:0 /R:1 /w:[ 0 0 0 0 0 0 ] /ss:1 /do:1
  //: joint g14 (_CLR) @(163, 359) /w:[ 2 12 1 -1 ]
  assign {w15, w49} = SB; //: CONCAT g5  @(79,628) /sn:0 /R:2 /w:[ 1 0 0 ] /dr:0 /tp:0 /drp:0
  REG4 RF3 (.DIN(DIN), .SA(w50), .SB(w49), ._CLR(_CLR), ._ENA(w47), ._ENB(w46), ._WA(_WA), .CK(CK), .A(A), .B(B));   //: @(1053, 197) /sz:(109, 138) /p:[ Ti0>7 Li0>7 Li1>7 Li2>7 Li3>1 Li4>1 Li5>7 Li6>7 Bo0<3 Bo1<3 ]
  //: joint g36 (A) @(1085, 467) /w:[ 1 2 4 -1 ]
  //: joint g24 (_WA) @(500, 379) /w:[ 4 10 3 -1 ]
  //: OUT g41 (A) @(1207,467) /sn:0 /w:[ 0 ]
  //: joint g23 (_WA) @(279, 379) /w:[ 2 12 1 -1 ]
  //: OUT g40 (B) @(1205,435) /sn:0 /w:[ 0 ]
  REG4 RF1 (.DIN(DIN), .CK(CK), ._WA(_WA), ._ENB(w10), ._ENA(w9), ._CLR(_CLR), .SB(w49), .SA(w50), .B(B), .A(A));   //: @(567, 198) /sz:(106, 138) /p:[ Ti0>11 Li0>11 Li1>11 Li2>1 Li3>1 Li4>11 Li5>11 Li6>11 Bo0<11 Bo1<11 ]
  //: joint g35 (A) @(832, 467) /w:[ 5 6 8 -1 ]
  //: joint g26 (CK) @(294, 403) /w:[ 2 12 1 -1 ]
  //: IN g22 (CK) @(40,403) /sn:0 /w:[ 0 ]
  //: IN g18 (_WA) @(40,379) /sn:0 /w:[ 0 ]
  //: IN g12 (_CLR) @(41,359) /sn:0 /w:[ 0 ]
  //: IN g33 (_ENB) @(33,555) /sn:0 /w:[ 1 ]
  //: joint g30 (DIN) @(619, 156) /w:[ 4 -1 3 10 ]
  REG4 RF2 (.DIN(DIN), .SA(w50), .SB(w49), ._CLR(_CLR), ._ENA(w26), ._ENB(w25), ._WA(_WA), .CK(CK), .A(A), .B(B));   //: @(801, 198) /sz:(107, 138) /p:[ Ti0>9 Li0>9 Li1>9 Li2>9 Li3>1 Li4>1 Li5>9 Li6>9 Bo0<7 Bo1<7 ]

endmodule
//: /netlistEnd

//: /netlistBegin ALUbasic
module ALUbasic(B, A, OUT, COUT, CIN, FUNC);
//: interface  /sz:(165, 122) /bd:[ Ti0>A[15:0](38/165) Ti1>B[15:0](84/165) Ti2>FUNC[4:0](125/165) Li0>CIN(54/122) Bo0<OUT[15:0](91/165) Ro0<COUT(54/122) ]
input [15:0] B;    //: /sn:0 {0}(#:717,363)(717,178)(600,178){1}
//: {2}(596,178)(496,178){3}
//: {4}(492,178)(386,178){5}
//: {6}(382,178)(348,178){7}
//: {8}(344,178)(306,178){9}
//: {10}(302,178)(208,178){11}
//: {12}(304,180)(304,341){13}
//: {14}(346,180)(346,340){15}
//: {16}(384,180)(384,342){17}
//: {18}(494,180)(494,359){19}
//: {20}(598,180)(598,311){21}
input CIN;    //: /sn:0 {0}(638,311)(638,282){1}
input [15:0] A;    //: /sn:0 {0}(#:245,238)(215,238){1}
input [4:0] FUNC;    //: /sn:0 {0}(#:82,486)(117,486){1}
supply0 [15:0] w1;    //: /sn:0 {0}(#:217,312)(217,287){1}
//: {2}(219,285)(252,285)(252,456)(451,456)(451,480){3}
//: {4}(217,283)(217,258)(245,258){5}
output [15:0] OUT;    //: /sn:0 {0}(#:475,557)(475,509){1}
output COUT;    //: /sn:0 {0}(530,324)(530,375)(556,375){1}
wire [15:0] w6;    //: /sn:0 {0}(#:596,361)(596,332){1}
wire [15:0] w7;    //: /sn:0 {0}(#:478,480)(478,388){1}
wire [15:0] w16;    //: /sn:0 {0}(#:464,480)(464,416)(344,416)(344,361){1}
wire [15:0] w15;    //: /sn:0 {0}(#:458,480)(458,432)(302,432)(302,362){1}
wire [2:0] w0;    //: /sn:0 {0}(#:123,496)(452,496){1}
wire w3;    //: /sn:0 {0}(123,486)(176,486)(176,144)(261,144)(261,225){1}
wire w8;    //: /sn:0 {0}(123,476)(151,476)(151,97)(612,97)(612,284){1}
//: {2}(614,286)(633,286)(633,311){3}
//: {4}(610,286)(593,286)(593,311){5}
wire [15:0] w17;    //: /sn:0 {0}(#:471,480)(471,399)(382,399)(382,363){1}
wire [15:0] w2;    //: /sn:0 {0}(#:484,480)(484,439)(580,439)(580,390){1}
wire w12;    //: /sn:0 {0}(604,375)(636,375)(636,332){1}
wire [15:0] w11;    //: /sn:0 {0}(#:491,480)(491,453)(691,453)(691,392){1}
wire [15:0] w10;    //: /sn:0 {0}(#:498,480)(498,470)(711,470)(711,392){1}
wire [15:0] w5;    //: /sn:0 {0}(#:274,248)(297,248){1}
//: {2}(301,248)(339,248){3}
//: {4}(343,248)(377,248){5}
//: {6}(381,248)(460,248){7}
//: {8}(464,248)(562,248){9}
//: {10}(566,248)(685,248)(685,363){11}
//: {12}(564,250)(564,361){13}
//: {14}(462,250)(462,359){15}
//: {16}(379,250)(379,342){17}
//: {18}(341,250)(341,340){19}
//: {20}(299,250)(299,341){21}
//: enddecls

  //: IN g4 (B) @(206,178) /sn:0 /w:[ 11 ]
  _GGMUX2x16 #(8, 8) g8 (.I0(A), .I1(w1), .S(w3), .Z(w5));   //: @(261,248) /sn:0 /R:1 /w:[ 0 5 1 0 ] /ss:1 /do:1
  //: IN g3 (A) @(213,238) /sn:0 /w:[ 1 ]
  //: GROUND g13 (w1) @(217,318) /sn:0 /w:[ 0 ]
  _GGDIV16 #(492, 492) g2 (.A(w5), .B(B), .Q(w10), .R(w11));   //: @(701,379) /sn:0 /cpc:1 /w:[ 11 0 1 1 ]
  _GGMUL16 #(252) g1 (.A(w5), .B(B), .P(w7));   //: @(478,375) /sn:0 /cpc:1 /w:[ 15 19 1 ]
  //: joint g11 (w5) @(379, 248) /w:[ 6 -1 5 16 ]
  _GGXOR2x16 #(8) g16 (.I0({16{w8}}), .I1(B), .Z(w6));   //: @(596,322) /sn:0 /R:3 /w:[ 5 21 1 ] /eb:0
  //: joint g10 (w5) @(462, 248) /w:[ 8 -1 7 14 ]
  //: OUT g28 (OUT) @(475,554) /sn:0 /R:3 /w:[ 0 ]
  //: OUT g19 (COUT) @(530,327) /sn:0 /R:1 /w:[ 0 ]
  //: joint g27 (w8) @(612, 286) /w:[ 2 1 4 -1 ]
  _GGAND2x16 #(6) g6 (.I0(w5), .I1(B), .Z(w16));   //: @(344,351) /sn:0 /R:3 /w:[ 19 15 1 ] /eb:0
  _GGOR2x16 #(6) g7 (.I0(w5), .I1(B), .Z(w17));   //: @(382,353) /sn:0 /R:3 /w:[ 17 17 1 ] /eb:0
  //: joint g9 (w5) @(564, 248) /w:[ 10 -1 9 12 ]
  //: joint g15 (B) @(494, 178) /w:[ 3 -1 4 18 ]
  //: joint g20 (B) @(346, 178) /w:[ 7 -1 8 14 ]
  assign {w0, w3, w8} = FUNC; //: CONCAT g25  @(118,486) /sn:0 /R:2 /w:[ 0 0 0 1 ] /dr:0 /tp:0 /drp:0
  //: IN g17 (CIN) @(638,280) /sn:0 /R:3 /w:[ 1 ]
  _GGXOR2 #(8) g52 (.I0(w8), .I1(CIN), .Z(w12));   //: @(636,322) /sn:0 /R:3 /w:[ 3 0 1 ] /eb:0
  _GGMUX8x16 #(20, 20) g5 (.I0(w1), .I1(w15), .I2(w16), .I3(w17), .I4(w7), .I5(w2), .I6(w11), .I7(w10), .S(w0), .Z(OUT));   //: @(475,496) /sn:0 /w:[ 3 0 0 0 0 0 0 0 1 1 ] /ss:0 /do:0
  //: joint g14 (B) @(598, 178) /w:[ 1 -1 2 20 ]
  //: joint g24 (w1) @(217, 285) /w:[ 2 4 -1 1 ]
  _GGXOR2x16 #(8) g21 (.I0(w5), .I1(B), .Z(w15));   //: @(302,352) /sn:0 /R:3 /w:[ 21 13 1 ] /eb:0
  //: joint g23 (w5) @(299, 248) /w:[ 2 -1 1 20 ]
  //: IN g26 (FUNC) @(80,486) /sn:0 /w:[ 0 ]
  _GGADD16 #(132, 134, 126, 128) g0 (.A(w5), .B(w6), .S(w2), .CI(w12), .CO(COUT));   //: @(580,377) /sn:0 /w:[ 13 0 1 0 1 ]
  //: joint g22 (B) @(304, 178) /w:[ 9 -1 10 12 ]
  //: joint g18 (B) @(384, 178) /w:[ 5 -1 6 16 ]
  //: joint g12 (w5) @(341, 248) /w:[ 4 -1 3 18 ]

endmodule
//: /netlistEnd

//: /netlistBegin EUNIT
module EUNIT(_LDDATA, _CLR, SB, SA, AOP, BOP, _GT, _LDQ, _Z, _WA, CK, _CLQ, DATA, FUNC, _LT, _LDQH, _LDQL, CIN, IDATA, COUT, _DOUT);
//: interface  /sz:(128, 353) /bd:[ Ti0>CK(34/128) Ti1>_CLR(89/128) Li0>SB[3:0](33/353) Li1>_WA(50/353) Li2>AOP[1:0](65/353) Li3>BOP[1:0](81/353) Li4>FUNC[4:0](95/353) Li5>IDATA[7:0](113/353) Li6>_CLQ(133/353) Li7>_LDQ(150/353) Li8>CIN(165/353) Li9>SA[3:0](18/353) Li10>_LDDATA(182/353) Li11>_LDQH(200/353) Li12>_LDQL(220/353) Li13>_DOUT(239/353) Lo0<COUT(314/353) Lo1<_Z(296/353) Lo2<_GT(276/353) Lo3<_LT(258/353) Bt0=DATA[15:0](67/128) ]
output _Z;    //: /sn:0 {0}(646,543)(608,543){1}
input _CLQ;    //: /sn:0 {0}(549,811)(497,811){1}
output _LT;    //: /sn:0 {0}(645,575)(608,575){1}
input _LDQH;    //: /sn:0 {0}(837,798)(837,771)(810,771){1}
input CK;    //: /sn:0 {0}(498,352)(195,352)(195,407){1}
//: {2}(193,409)(186,409)(186,409)(185,409){3}
//: {4}(195,411)(195,829)(535,829){5}
//: {6}(539,829)(583,829){7}
//: {8}(537,831)(537,855)(724,855){9}
input CIN;    //: /sn:0 {0}(475,618)(499,618){1}
input _CLR;    //: /sn:0 {0}(308,285)(379,285){1}
//: {2}(383,285)(498,285){3}
//: {4}(381,287)(381,789)(522,789)(522,806)(549,806){5}
supply0 w0;    //: /sn:0 {0}(498,300)(463,300)(463,314){1}
//: {2}(465,316)(498,316){3}
//: {4}(463,318)(463,321){5}
input [4:0] FUNC;    //: /sn:0 {0}(#:477,541)(499,541){1}
inout [15:0] DATA;    //: /sn:0 {0}(#:997,676)(961,676){1}
//: {2}(959,674)(959,437)(866,437){3}
//: {4}(864,435)(864,414){5}
//: {6}(862,437)(610,437){7}
//: {8}(606,437)(474,437)(474,463){9}
//: {10}(608,439)(608,465){11}
//: {12}(957,676)(916,676){13}
input [3:0] SB;    //: /sn:0 {0}(#:310,267)(498,267){1}
input _LDDATA;    //: /sn:0 {0}(877,398)(907,398)(907,389){1}
input [1:0] AOP;    //: /sn:0 {0}(#:420,479)(457,479){1}
input _LDQ;    //: /sn:0 {0}(673,739)(706,739){1}
//: {2}(710,739)(738,739){3}
//: {4}(708,741)(708,755){5}
//: {6}(708,759)(708,766)(708,766)(708,772){7}
//: {8}(710,757)(842,757)(842,798){9}
input [3:0] SA;    //: /sn:0 {0}(#:310,251)(498,251){1}
input _WA;    //: /sn:0 {0}(498,335)(313,335){1}
input _DOUT;    //: /sn:0 {0}(908,671)(908,644){1}
supply0 [7:0] w30;    //: /sn:0 {0}(#:299,388)(299,378)(331,378)(331,413)(369,413){1}
input [1:0] BOP;    //: /sn:0 {0}(#:555,481)(591,481){1}
input _LDQL;    //: /sn:0 {0}(703,772)(703,764)(679,764){1}
output _GT;    //: /sn:0 {0}(645,560)(608,560){1}
input [7:0] IDATA;    //: /sn:0 {0}(#:369,423)(298,423){1}
output COUT;    //: /sn:0 {0}(645,592)(608,592){1}
wire w7;    //: /sn:0 {0}(840,819)(840,860)(800,860){1}
wire [15:0] w38;    //: /sn:0 {0}(#:480,492)(480,502)(531,502)(531,522){1}
wire [15:0] w21;    //: /sn:0 {0}(#:496,893)(292,893)(292,452)(460,452){1}
//: {2}(464,452)(596,452)(596,465){3}
//: {4}(462,454)(462,463){5}
wire [15:0] w31;    //: /sn:0 {0}(#:614,494)(614,509)(579,509)(579,522){1}
wire [15:0] w28;    //: /sn:0 {0}(#:632,465)(632,406)(579,406)(579,373){1}
wire [15:0] w36;    //: /sn:0 {0}(#:498,463)(498,406)(531,406)(531,373){1}
wire [15:0] w1;    //: /sn:0 {0}(#:900,676)(846,676){1}
//: {2}(844,674)(844,414){3}
//: {4}(842,676)(771,676){5}
//: {6}(770,676)(678,676){7}
//: {8}(677,676)(556,676)(556,651){9}
wire [7:0] QL;    //: /sn:0 {0}(#:502,888)(620,888)(620,840){1}
wire [7:0] QH;    //: /sn:0 {0}(#:502,898)(761,898)(761,866){1}
wire [7:0] w8;    //: /sn:0 {0}(#:620,819)(620,710)(769,710){1}
//: {2}(771,708)(771,680){3}
//: {4}(771,712)(771,723){5}
wire [15:0] w35;    //: /sn:0 {0}(#:486,463)(486,420){1}
//: {2}(488,418)(620,418)(620,465){3}
//: {4}(484,418)(375,418){5}
wire [15:0] DIN;    //: /sn:0 {0}(#:854,385)(854,169)(552,169)(552,233){1}
wire [7:0] w2;    //: /sn:0 {0}(#:761,752)(761,845){1}
wire [7:0] w12;    //: /sn:0 {0}(#:678,680)(678,700)(751,700)(751,723){1}
wire w10;    //: /sn:0 {0}(659,824)(669,824)(669,811){1}
//: {2}(671,809)(810,809)(810,850)(800,850){3}
//: {4}(667,809)(570,809){5}
wire w9;    //: /sn:0 {0}(659,834)(706,834)(706,793){1}
//: enddecls

  //: GROUND g4 (w0) @(463,327) /sn:0 /w:[ 5 ]
  _GGMUX2x16 #(8, 8) g8 (.I0(w1), .I1(DATA), .S(~_LDDATA), .Z(DIN));   //: @(854,398) /sn:0 /R:2 /w:[ 3 5 0 0 ] /ss:0 /do:1
  assign w21 = {QH, QL}; //: CONCAT g37  @(497,893) /sn:0 /R:2 /w:[ 0 0 0 ] /dr:0 /tp:0 /drp:1
  //: IN g34 (_LDDATA) @(907,387) /sn:0 /R:3 /w:[ 1 ]
  //: IN g3 (_CLR) @(306,285) /sn:0 /w:[ 0 ]
  assign w35 = {w30, IDATA}; //: CONCAT g13  @(374,418) /sn:0 /w:[ 5 1 0 ] /dr:0 /tp:0 /drp:1
  //: IN g2 (SB) @(308,267) /sn:0 /w:[ 0 ]
  //: IN g1 (SA) @(308,251) /sn:0 /w:[ 0 ]
  //: IN g11 (AOP) @(418,479) /sn:0 /w:[ 0 ]
  //: IN g16 (BOP) @(553,481) /sn:0 /w:[ 0 ]
  //: frame g50 @(422,693) /sn:0 /wi:442 /ht:238 /tx:"Q Register Handling"
  //: OUT g28 (_GT) @(642,560) /sn:0 /w:[ 0 ]
  //: IN g10 (_LDQ) @(671,739) /sn:0 /w:[ 0 ]
  _GGMUX4x16 #(12, 12) g19 (.I0(w21), .I1(DATA), .I2(w35), .I3(w36), .S(AOP), .Z(w38));   //: @(480,479) /sn:0 /w:[ 5 9 0 0 1 0 ] /ss:0 /do:0
  //: OUT g27 (_Z) @(643,543) /sn:0 /w:[ 0 ]
  //: joint g32 (_CLR) @(381, 285) /w:[ 2 -1 1 4 ]
  assign w8 = w1[7:0]; //: TAP g38 @(771,679) /sn:0 /R:3 /w:[ 3 5 6 ] /ss:0
  //: IN g6 (_WA) @(311,335) /sn:0 /w:[ 1 ]
  //: IN g7 (CK) @(183,409) /sn:0 /w:[ 3 ]
  //: IN g9 (_CLQ) @(495,811) /sn:0 /w:[ 1 ]
  //: joint g15 (w21) @(462, 452) /w:[ 2 -1 1 4 ]
  //: INOUT g20 (DATA) @(1005,676) /sn:0 /R:2 /w:[ 0 ]
  _GGNOR2 #(6) g31 (.I0(!_CLR), .I1(!_CLQ), .Z(w10));   //: @(560,809) /sn:0 /w:[ 5 0 5 ] /eb:0
  REG16 RF (.DIN(DIN), .CK(CK), .SA(SA), .SB(SB), ._CLR(_CLR), ._ENA(w0), ._ENB(w0), ._WA(_WA), .A(w36), .B(w28));   //: @(499, 234) /sz:(108, 138) /p:[ Ti0>1 Li0>0 Li1>1 Li2>1 Li3>3 Li4>0 Li5>3 Li6>0 Bo0<1 Bo1<1 ]
  assign w12 = w1[15:8]; //: TAP g39 @(678,679) /sn:0 /R:3 /w:[ 0 7 8 ] /ss:0
  ALU alu (.B(w31), .A(w38), .CIN(CIN), .FUNC(FUNC), .OUT(w1), .COUT(COUT), ._LT(_LT), ._GT(_GT), ._Z(_Z));   //: @(500, 523) /sz:(107, 127) /sn:0 /p:[ Ti0>1 Ti1>1 Li0>1 Li1>1 Bo0<9 Ro0<1 Ro1<1 Ro2<1 Ro3<1 ]
  _GGNOR2 #(6) g43 (.I0(!_LDQL), .I1(!_LDQ), .Z(w9));   //: @(706,783) /sn:0 /R:3 /w:[ 0 7 1 ] /eb:0
  _GGREG8 #(10, 10, 20) QL (.Q(QL), .D(w8), .EN(w9), .CLR(w10), .CK(CK));   //: @(620,829) /w:[ 1 0 0 0 7 ]
  //: joint g48 (w1) @(844, 676) /w:[ 1 2 4 -1 ]
  _GGREG8 #(10, 10, 20) QH (.Q(QH), .D(w2), .EN(w7), .CLR(w10), .CK(CK));   //: @(761,855) /w:[ 1 1 1 3 9 ]
  _GGBUFIF16 #(4, 6) g17 (.Z(DATA), .I(w1), .E(~_DOUT));   //: @(906,676) /sn:0 /cpc:1 /w:[ 13 0 0 ]
  //: IN g25 (FUNC) @(475,541) /sn:0 /w:[ 0 ]
  //: OUT g29 (_LT) @(642,575) /sn:0 /w:[ 0 ]
  //: joint g42 (CK) @(537, 829) /w:[ 6 -1 5 8 ]
  //: joint g5 (w0) @(463, 316) /w:[ 2 1 -1 4 ]
  //: GROUND g14 (w30) @(299,394) /sn:0 /w:[ 0 ]
  //: joint g44 (_LDQ) @(708, 739) /w:[ 2 -1 1 4 ]
  //: joint g47 (DATA) @(959, 676) /w:[ 1 2 12 -1 ]
  //: joint g36 (w8) @(771, 710) /w:[ -1 2 1 4 ]
  //: IN g24 (_LDQH) @(808,771) /sn:0 /w:[ 1 ]
  //: joint g21 (w35) @(486, 418) /w:[ 2 -1 4 1 ]
  //: joint g41 (CK) @(195, 409) /w:[ -1 1 2 4 ]
  //: IN g23 (_LDQL) @(677,764) /sn:0 /w:[ 1 ]
  //: joint g40 (w10) @(669, 809) /w:[ 2 -1 4 1 ]
  //: joint g22 (DATA) @(608, 437) /w:[ 7 -1 8 10 ]
  //: joint g0 (DATA) @(864, 437) /w:[ 3 4 6 -1 ]
  //: joint g46 (_LDQ) @(708, 757) /w:[ 6 5 8 -1 ]
  _GGNOR2 #(6) g45 (.I0(!_LDQH), .I1(!_LDQ), .Z(w7));   //: @(840,809) /sn:0 /R:3 /w:[ 0 9 0 ] /eb:0
  _GGMUX2x8 #(8, 8) g35 (.I0(w12), .I1(w8), .S(_LDQ), .Z(w2));   //: @(761,739) /sn:0 /w:[ 1 5 3 0 ] /ss:0 /do:0
  //: IN g26 (CIN) @(473,618) /sn:0 /w:[ 0 ]
  //: IN g12 (IDATA) @(296,423) /sn:0 /w:[ 1 ]
  _GGMUX4x16 #(12, 12) g18 (.I0(w21), .I1(DATA), .I2(w35), .I3(w28), .S(BOP), .Z(w31));   //: @(614,481) /sn:0 /w:[ 3 11 3 0 1 0 ] /ss:0 /do:0
  //: OUT g30 (COUT) @(642,592) /sn:0 /w:[ 0 ]
  //: IN g49 (_DOUT) @(908,642) /sn:0 /R:3 /w:[ 1 ]

endmodule
//: /netlistEnd


`timescale 1ns/1ns


//: /builtinBegin
module _GGNAND3 #(.Diz(1)) (I0, I1, I2, Z);
output Z;
input I0;
input I1;
input I2;

  assign #Diz Z = ~(I0 & I1 & I2);

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGAND2x2 #(.Diz(1)) (I0, I1, Z);
output [1:0] Z;
input [1:0] I0;
input [1:0] I1;

  assign #Diz Z = I0 & I1;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGXOR2 #(.Diz(1)) (I0, I1, Z);
output Z;
input I0;
input I1;

  assign #Diz Z = I0 ^ I1;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGMUX2x5 #(.Dsz(1), .Diz(1)) (I0, I1, S, Z);
input [4:0] I0, I1;
input S;
output [4:0] Z;
reg [4:0] Z;

  always @(*)
    begin
      case (S)
          1'h0: Z <= #Dsz I0;
          1'h1: Z <= #Dsz I1;
        default: Z <= #Dsz  1'h0;
      endcase
    end

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGMUX2x4 #(.Dsz(1), .Diz(1)) (I0, I1, S, Z);
input [3:0] I0, I1;
input S;
output [3:0] Z;
reg [3:0] Z;

  always @(*)
    begin
      case (S)
          1'h0: Z <= #Dsz I0;
          1'h1: Z <= #Dsz I1;
        default: Z <= #Dsz  1'h0;
      endcase
    end

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGNAND2 #(.Diz(1)) (I0, I1, Z);
output Z;
input I0;
input I1;

  assign #Diz Z = ~(I0 & I1);

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGNOR2 #(.Diz(1)) (I0, I1, Z);
output Z;
input I0;
input I1;

  assign #Diz Z = ~(I0 | I1);

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGXOR2x16 #(.Diz(1)) (I0, I1, Z);
output [15:0] Z;
input [15:0] I0;
input [15:0] I1;

  assign #Diz Z = I0 ^ I1;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGARSHIFT16 #(.Dsz(1), .Diz(1)) (I, Z, S);
input [15:0] I;input [3:0] S;output [15:0] Z;
  specify
    (I *> Z) = Diz;
    (S *> Z) = Dsz;
  endspecify

  assign Z = (I >>> S);

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGMUX2x3 #(.Dsz(1), .Diz(1)) (I0, I1, S, Z);
input [2:0] I0, I1;
input S;
output [2:0] Z;
reg [2:0] Z;

  always @(*)
    begin
      case (S)
          1'h0: Z <= #Dsz I0;
          1'h1: Z <= #Dsz I1;
        default: Z <= #Dsz  1'h0;
      endcase
    end

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGMUX4x8 #(.Dsz(1), .Diz(1)) (I0, I1, I2, I3, S, Z);
input [7:0] I0, I1, I2, I3;
input [1:0] S;
output [7:0] Z;
reg [7:0] Z;

  always @(*)
    begin
      case (S)
          2'h0: Z <= #Dsz I0;
          2'h1: Z <= #Dsz I1;
          2'h2: Z <= #Dsz I2;
          2'h3: Z <= #Dsz I3;
        default: Z <= #Dsz  2'h0;
      endcase
    end

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGREG8 #(.Dsetup(1), .Dhold(1), .Dck_q(1)) (Q, D, EN, CLR, CK);
input CK,EN,CLR;
input [7:0] D;
output [7:0] Q;
reg [7:0] Qreg;

  assign #Dck_q Q = Qreg;

  always @(posedge CK or negedge CLR)
    begin
    if (CLR === 1'b0)
      Qreg = 8'h0;
    else if (CK === 1'b1 && EN === 1'b0)
      Qreg = D;
    end

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGAND2x16 #(.Diz(1)) (I0, I1, Z);
output [15:0] Z;
input [15:0] I0;
input [15:0] I1;

  assign #Diz Z = I0 & I1;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGREG4 #(.Dsetup(1), .Dhold(1), .Dck_q(1)) (Q, D, EN, CLR, CK);
input CK,EN,CLR;
input [3:0] D;
output [3:0] Q;
reg [3:0] Qreg;

  assign #Dck_q Q = Qreg;

  always @(posedge CK or negedge CLR)
    begin
    if (CLR === 1'b0)
      Qreg = 4'h0;
    else if (CK === 1'b1 && EN === 1'b0)
      Qreg = D;
    end

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGAND2x3 #(.Diz(1)) (I0, I1, Z);
output [2:0] Z;
input [2:0] I0;
input [2:0] I1;

  assign #Diz Z = I0 & I1;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGBUF3 #(.Diz(1)) (I, Z);
input [2:0] I;
output [2:0] Z;
  assign #Diz Z = I;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGROM8x32 #(.Doe_d(1), .Da_d(1)) (A, D, OE);
input OE;
input [7:0] A;
output [31:0] D;
reg [31:0] m[0:255];

  assign D = (~OE) ? m[A] : 32'bz;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGNOR1x16 #(.Diz(1)) (I0, Z);
output Z;
input [15:0] I0;

  assign #Diz Z = ~( | I0);

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGLSHIFT16 #(.Dsz(1), .Diz(1)) (I, Z, S);
input [15:0] I;input [3:0] S;output [15:0] Z;
  specify
    (I *> Z) = Diz;
    (S *> Z) = Dsz;
  endspecify

  assign Z = (I << S);

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGROM8x8 #(.Doe_d(1), .Da_d(1)) (A, D, OE);
input OE;
input [7:0] A;
output [7:0] D;
reg [7:0] m[0:255];

  assign D = (~OE) ? m[A] : 8'bz;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGMUX8 #(.Dsz(1), .Diz(1)) (I0, I1, I2, I3, I4, I5, I6, I7, S, Z);
input I0, I1, I2, I3, I4, I5, I6, I7;
input [2:0] S;
output Z;
reg Z;

  always @(*)
    begin
      case (S)
          3'h0: Z <= #Dsz I0;
          3'h1: Z <= #Dsz I1;
          3'h2: Z <= #Dsz I2;
          3'h3: Z <= #Dsz I3;
          3'h4: Z <= #Dsz I4;
          3'h5: Z <= #Dsz I5;
          3'h6: Z <= #Dsz I6;
          3'h7: Z <= #Dsz I7;
        default: Z <= #Dsz  3'h0;
      endcase
    end

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGOR3 #(.Diz(1)) (I0, I1, I2, Z);
output Z;
input I0;
input I1;
input I2;

  assign #Diz Z = I0 | I1 | I2;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGAND1x4 #(.Diz(1)) (I0, Z);
output Z;
input [3:0] I0;

  assign #Diz Z =  & I0;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGADD8 #(.Dab_s(1), .Dab_co(1), .Dci_s(1), .Dci_co(1)) (A, B, S, CI, CO);
input CI;
output CO;
input [7:0] A,B;
output [7:0] S;

  specify
    (A,B *> S) = Dab_s;
    (A,B *> CO) = Dab_co;
    (CI *> S) = Dci_s;
    (CI *> CO) = Dci_co;
  endspecify

  assign {CO,S} = A + B + CI;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGNBUF #(.Diz(1)) (I, Z);
input I;
output Z;
  assign #Diz Z = ~ I;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGOR1x3 #(.Diz(1)) (I0, Z);
output Z;
input [2:0] I0;

  assign #Diz Z =  | I0;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGBUFIF16 #(.Dez(1), .Diz(1)) (Z, I, E);
input E;
input [15:0] I;
output [15:0] Z;

  specify
    (E *> Z) = Dez;
    (I *> Z) = Diz;
  endspecify

  assign Z = E ? (I) : 16'bz;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGREG32 #(.Dsetup(1), .Dhold(1), .Dck_q(1)) (Q, D, EN, CLR, CK);
input CK,EN,CLR;
input [31:0] D;
output [31:0] Q;
reg [31:0] Qreg;

  assign #Dck_q Q = Qreg;

  always @(posedge CK or negedge CLR)
    begin
    if (CLR === 1'b0)
      Qreg = 32'h0;
    else if (CK === 1'b1 && EN === 1'b0)
      Qreg = D;
    end

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGNDEMUX4 #(.Dez(1), .Diz(1)) (I, E, Z0, Z1, Z2, Z3);
input [1:0] I;
input E;
output Z0, Z1, Z2, Z3;
wire [3:0] Zcat;
  assign Zcat = 4'b1 << I;
  assign #1 Z0 = ~(E & Zcat[0]);
  assign #1 Z1 = ~(E & Zcat[1]);
  assign #1 Z2 = ~(E & Zcat[2]);
  assign #1 Z3 = ~(E & Zcat[3]);

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGADD16 #(.Dab_s(1), .Dab_co(1), .Dci_s(1), .Dci_co(1)) (A, B, S, CI, CO);
input CI;
output CO;
input [15:0] A,B;
output [15:0] S;

  specify
    (A,B *> S) = Dab_s;
    (A,B *> CO) = Dab_co;
    (CI *> S) = Dci_s;
    (CI *> CO) = Dci_co;
  endspecify

  assign {CO,S} = A + B + CI;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGAND2x8 #(.Diz(1)) (I0, I1, Z);
output [7:0] Z;
input [7:0] I0;
input [7:0] I1;

  assign #Diz Z = I0 & I1;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGMUX2x8 #(.Dsz(1), .Diz(1)) (I0, I1, S, Z);
input [7:0] I0, I1;
input S;
output [7:0] Z;
reg [7:0] Z;

  always @(*)
    begin
      case (S)
          1'h0: Z <= #Dsz I0;
          1'h1: Z <= #Dsz I1;
        default: Z <= #Dsz  1'h0;
      endcase
    end

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGRAM16x8 #(.Doe_d(1), .Dcs_d(1), .Da_d(1), .Daddr_setup(1), .Ddata_setup(1), .Daddr_hold(1), .Ddata_hold(1)) (A, D, WE, OE, CS);
input OE, WE, CS;
input [15:0] A;
inout [7:0] D;
reg [7:0] m[0:65535];

  assign D = (!CS && !OE) ? m[A] : 8'bz;

  always @(A or CS or WE or D)
    if (!CS && !WE)
         m[A] = D;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGREG16 #(.Dsetup(1), .Dhold(1), .Dck_q(1)) (Q, D, EN, CLR, CK);
input CK,EN,CLR;
input [15:0] D;
output [15:0] Q;
reg [15:0] Qreg;

  assign #Dck_q Q = Qreg;

  always @(posedge CK or negedge CLR)
    begin
    if (CLR === 1'b0)
      Qreg = 16'h0;
    else if (CK === 1'b1 && EN === 1'b0)
      Qreg = D;
    end

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGROLL16 #(.Dsz(1), .Diz(1)) (I, Z, S);
input [15:0] I;input [3:0] S;output [15:0] Z;
  specify
    (I *> Z) = Diz;
    (S *> Z) = Dsz;
  endspecify

  assign Z =  ((I << (S % 16)) | (I >> ((16 - S) % 16)));

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGOR1x16 #(.Diz(1)) (I0, Z);
output Z;
input [15:0] I0;

  assign #Diz Z =  | I0;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGMUX2x16 #(.Dsz(1), .Diz(1)) (I0, I1, S, Z);
input [15:0] I0, I1;
input S;
output [15:0] Z;
reg [15:0] Z;

  always @(*)
    begin
      case (S)
          1'h0: Z <= #Dsz I0;
          1'h1: Z <= #Dsz I1;
        default: Z <= #Dsz  1'h0;
      endcase
    end

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGCLOCK_P3000_0_50 (Z);
output Z;
reg Z;

initial #0
  begin 
    forever
      begin
        Z = 1'b0;
        #1500;
        Z = 1'b1;
        #1500;
      end
   end

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGRSHIFT16 #(.Dsz(1), .Diz(1)) (I, Z, S);
input [15:0] I;input [3:0] S;output [15:0] Z;
  specify
    (I *> Z) = Diz;
    (S *> Z) = Dsz;
  endspecify

  assign Z = (I >> S);

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGDIV16 #(.Dab_q(1), .Dab_r(1)) (A, B, Q, R);
input [15:0] A,B;
output [15:0] Q,R;
  assign #Dab_q Q = A / B;
  assign #Dab_r R = A % B;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGAND2 #(.Diz(1)) (I0, I1, Z);
output Z;
input I0;
input I1;

  assign #Diz Z = I0 & I1;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGMUL16 #(.Dab_p(1)) (A, B, P);
input [15:0] A,B;
output [15:0] P;
  assign #Dab_p P = A * B;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGBUF5 #(.Diz(1)) (I, Z);
input [4:0] I;
output [4:0] Z;
  assign #Diz Z = I;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGOR2 #(.Diz(1)) (I0, I1, Z);
output Z;
input I0;
input I1;

  assign #Diz Z = I0 | I1;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGMUX8x16 #(.Dsz(1), .Diz(1)) (I0, I1, I2, I3, I4, I5, I6, I7, S, Z);
input [15:0] I0, I1, I2, I3, I4, I5, I6, I7;
input [2:0] S;
output [15:0] Z;
reg [15:0] Z;

  always @(*)
    begin
      case (S)
          3'h0: Z <= #Dsz I0;
          3'h1: Z <= #Dsz I1;
          3'h2: Z <= #Dsz I2;
          3'h3: Z <= #Dsz I3;
          3'h4: Z <= #Dsz I4;
          3'h5: Z <= #Dsz I5;
          3'h6: Z <= #Dsz I6;
          3'h7: Z <= #Dsz I7;
        default: Z <= #Dsz  3'h0;
      endcase
    end

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGBUF16 #(.Diz(1)) (I, Z);
input [15:0] I;
output [15:0] Z;
  assign #Diz Z = I;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGOR2x16 #(.Diz(1)) (I0, I1, Z);
output [15:0] Z;
input [15:0] I0;
input [15:0] I1;

  assign #Diz Z = I0 | I1;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGBUFIF8 #(.Dez(1), .Diz(1)) (Z, I, E);
input E;
input [7:0] I;
output [7:0] Z;

  specify
    (E *> Z) = Dez;
    (I *> Z) = Diz;
  endspecify

  assign Z = E ? (I) : 8'bz;

endmodule
//: /builtinEnd


//: /builtinBegin
module _GGMUX4x16 #(.Dsz(1), .Diz(1)) (I0, I1, I2, I3, S, Z);
input [15:0] I0, I1, I2, I3;
input [1:0] S;
output [15:0] Z;
reg [15:0] Z;

  always @(*)
    begin
      case (S)
          2'h0: Z <= #Dsz I0;
          2'h1: Z <= #Dsz I1;
          2'h2: Z <= #Dsz I2;
          2'h3: Z <= #Dsz I3;
        default: Z <= #Dsz  2'h0;
      endcase
    end

endmodule
//: /builtinEnd

