#   Copyright (C) 1987-2004 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Wed May 23 18:26:47 2007
#

namespace eval EditCircDB {
  #
  # The 'props' variable contains the following elements:
  #
  #   file		File name
  #   filev		File version
  #   title		Circuit title
  #   discard		Discard changes on quiting (used for tutorial circuits)
  #   extbar		Extender bar style
  #   scripts		List of simulator scripts
  #   ok		Inicator that the values were confirmed
  #
  variable props

  proc nameFrame {w} {
    variable props

    labelframe $w [m circ.ident]
    frame $w.pad
    pack $w.pad -pady 5

    frame $w.g
    label $w.g.file_l -text [m circ.file]:
    entry $w.g.file_e -textvariable EditCircDB::props(file) -state disabled -relief sunken
    catch { $w.g.file_e configure  -disabledforeground black }
    label $w.g.ver_l -text [m circ.filev]:
    entry $w.g.ver_e -textvariable EditCircDB::props(filev) -state disabled -relief sunken -width 8
    catch { $w.g.ver_e configure -disabledforeground black }
    label $w.g.title_l -text [m circ.title]:
    entry $w.g.title_e -textvariable EditCircDB::props(title) -bg white
    $w.g.file_e xview moveto 1

    grid columnconfigure $w.g 1 -weight 1
    grid $w.g.file_l -row 0 -column 0 -sticky e -padx 5 -pady 3
    grid $w.g.file_e -row 0 -column 1 -sticky ew -padx 5 -pady 3
    grid $w.g.ver_l -row 1 -column 0 -sticky e -padx 5 -pady 3
    grid $w.g.ver_e -row 1 -column 1 -sticky w -padx 5 -pady 3
    grid $w.g.title_l -row 2 -column 0 -sticky e -padx 5 -pady 3
    grid $w.g.title_e -row 2 -column 1 -sticky ew -padx 5 -pady 3 

    pack $w.g -pady 3 -fill x -expand 1
  }

  proc clockFrame {w} {
    variable props

    labelframe $w [m opt.simclock] -relief groove -bd 2
    frame $w.pad
    pack $w.pad -pady 3

    radiobutton $w.all -text [m opt.posedge] -variable EditCircDB::props(clockMode) -value 0 \
	-command "$w.actNam configure -state disabled -foreground gray"
    radiobutton $w.act -text "[m opt.setclock]:" -variable EditCircDB::props(clockMode) -value 1 \
	-command "$w.actNam configure -state normal -foreground black"
    entry $w.actNam -width 15 -textvariable EditCircDB::props(clockName) -bg white

    if { $EditCircDB::props(clockMode) == 0 } {
      $w.actNam configure -state disabled
    }

    helpon $w.all [m ho.opt.ckall]
    helpon $w.act [m ho.opt.ckspec]

    pack $w.all -padx 5 -pady 5 -anchor w
    pack $w.act -side left -padx 5 -pady 5 -anchor w 
    pack $w.actNam -side left -padx 5 -pady 5 -anchor w -fill x -expand 1

  }

  proc timescaleFrame {w} {
    labelframe $w [m circ.timescale]
    frame $w.pad
    pack $w.pad -pady 3

    frame $w.g
    pack $w.g

    label $w.g.units_l -text [m circ.timescale.unit]
    label $w.g.precision_l -text [m circ.timescale.prec]

    Dropbox::new $w.g.units_n -variable EditCircDB::props(unitsN) -width 5 -bd 1 -highlightthickness 0
    Dropbox::new $w.g.units_u -variable EditCircDB::props(unitsU) -width 5 -bd 1 -highlightthickness 0
    Dropbox::new $w.g.precision_n -variable EditCircDB::props(precisionN) -width 5 -bd 1 -highlightthickness 0
    Dropbox::new $w.g.precision_u -variable EditCircDB::props(precisionU) -width 5 -bd 1 -highlightthickness 0

    grid $w.g.units_l -row 0 -column 0 -stick e -pady 5 -padx 1
    grid $w.g.units_n -row 0 -column 1 -stick w -pady 5 -padx 1
    grid $w.g.units_u -row 0 -column 2 -stick w -pady 5 -padx 1

    grid $w.g.precision_l -row 1 -column 0 -stick e -pady 5 -padx 1
    grid $w.g.precision_n -row 1 -column 1 -stick w -pady 5 -padx 1
    grid $w.g.precision_u -row 1 -column 2 -stick w -pady 5 -padx 1

    foreach n {1 10 100 } {
      Dropbox::itemadd $w.g.units_n $n
      Dropbox::itemadd $w.g.precision_n $n
    }
    foreach u {s ms us ns ps fs } {
      Dropbox::itemadd $w.g.units_u $u
      Dropbox::itemadd $w.g.precision_u $u
    }
  }


  proc flagsFrame {w} {
    variable props

    labelframe $w "Flags"
    frame $w.pad
    pack $w.pad -pady 5

    checkbutton $w.disc -text [m circ.discchg] -anchor w -variable EditCircDB::props(discard)
    checkbutton $w.extbar -text [m circ.extbar] -anchor w -variable EditCircDB::props(extbar)
    checkbutton $w.auto -text [m circ.autostart] -anchor w -variable EditCircDB::props(autostart)

    pack $w.disc $w.extbar $w.auto -fill both -anchor w -padx 5 -pady 2

    helpon $w.disc [m ho.circuit.discchg]
    helpon $w.extbar [m ho.circuit.extbar]
    helpon $w.auto [m ho.circuit.autostart]
  }

  #
  # Send dialog box contents back to gate 
  #
  proc save {w} {
    variable props

    set props(ok) 1
    gat_editCircProps save EditCircDB::props
  }

  proc editScript {args} {
    parseargs $args {-parent -value}
    NameDlg::post -parent $parent -value $value -title "TkGate: Edit Scripts" -caption [m circ.script.cap] \
	-explaination "" -label [m circ.script.label] -image [gifI circuit_prop.gif]
  }

  proc editLibrary {args} {
    # OBSOLETE
    parseargs $args {-parent -value}
    NameDlg::post -parent $parent -value $value -title "TkGate: Edit Library" -caption [m circ.vlib.cap] \
	-explaination "" -label [m circ.vlib.label] -image [gifI circuit_prop.gif]
  }

  proc dotab {w tab} {
    frame $w

    dialogImage $w.image -image [gifI circuit_prop.gif] -caption [m circ.label]  -explaination [m circ.exp] -width 175
    pack $w.image -side left  -fill both


    switch $tab {
      General {
	frame $w.pad -height 5
	pack $w.pad
	nameFrame $w.name
	flagsFrame $w.flags

	pack $w.name -fill both -padx 5 -pady 5
	pack $w.flags -fill both -padx 5 -pady 5
      }
      Simulator {
	global simScript_filter simScript_filetypes

	frame $w.pad -height 5
	pack $w.pad

	PathSelector::create $w.script -label [m circ.iniscript] -query tk_getOpenFile  -variable EditCircDB::props(scripts) \
	    -filter $simScript_filter -filetypes $simScript_filetypes -height 6 -edit EditCircDB::editScript

	clockFrame $w.clock
	timescaleFrame $w.timescale

	pack $w.script -fill both -padx 5 -pady 5
	pack $w.clock -fill both -padx 5 -pady 5
	pack $w.timescale -fill both -padx 5 -pady 5
      }
    }
  }

  proc post {args} {
    variable props

    set w .edcirc

    if { [catch { toplevel $w }] } { return }

    set props(file) ""
    set props(filev) ""
    set props(title) ""
    set props(discard) 0
    set props(extbar) 1
    set props(scripts) {}
    set props(vlibs) {}
    set props(clockMode) 0
    set props(clockName) ""
    set props(scripts) {}
    set props(ok) 0
    gat_editCircProps load EditCircDB::props

    wm resizable $w 0 0
    wm title $w "TKGate: Circuit Properties"
    wm geometry $w [offsetgeometry . 50 50]
    wm transient $w .

    okcancel $w.ok -okcommand "EditCircDB::save $w; destroy $w" -cancelcommand "destroy $w"
    pack $w.ok -fill both -side bottom

    set width [m @circ.width]
    set height [m @circ.height]
    set tabwidth [m @circ.tabwidth]
    set tabs {General Simulator}
    set tablabels [list [m circ.general] [m circ.simulator]]

    TabBox::new $w.tbox -width $width -height $height -tabwidth $tabwidth -tabs $tabs -tablabels $tablabels -command EditCircDB::dotab
    pack $w.tbox

    dialogWait $w
  }
}
