#   Copyright (C) 1987-2004 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Fri Sep 21 22:02:56 2007
#

#set imtest 0
#catch {
#  set imtest [tk useinputmethods 1]
#}

#############################################################################
#
# Tk font setup for Western Fonts
#
proc smallFonts {} {
  global tkg_fontScale

  set tkg_fontScale .75

  # Dialog caption font
  font create dialogCapFont -family Helvetica -size 10 -weight bold

  # Dialog explaination font
  font create dialogExpFont -family Helvetica -size 8

  # Big dialog explaination font
  font create dialogBigExpFont -family Helvetica -size 8 -weight bold

  # Fonts for basic labels
  font create labelFont  -family Helvetica -size 8
  font create boldLabelFont  -family Helvetica -size 8 -weight bold
  font create smallLabelFont  -family Helvetica -size 8

  # Font for basic buttons
  font create buttonFont  -family Helvetica -size 8

  # Font for menu entries
  font create menuFont  -family Helvetica -size 8

  # Font for entry/listbox entries
  font create entryFont  -family Helvetica -size 8

  # Font for menu buttons
  font create menuButtonFont  -family Helvetica -size 8

  # Font for HDL editor
  font create hdlFont  -family Courier -size 8
  font create hdlItalicFont  -family Courier -size 8 -slant italic
  font create hdlBoldFont  -family Courier -size 8 -weight bold
  font create hdlBoldItalicFont  -family Courier -size 8 -weight bold -slant italic

  #Fonts for tree widgers
  font create Tree:font -family Helvetica -size 8
  font create Tree:actfont -family Helvetica -size 8 -weight bold 
  font create Tree:act2font -family Helvetica -size 8 -weight bold -underline 1
}

proc normalFonts {} {
  global tkg_fontScale

  set tkg_fontScale 1

  # Dialog caption font
  font create dialogCapFont -family Helvetica -size 14 -weight bold 

  # Dialog explaination font
  font create dialogExpFont -family Helvetica -size 12

  # Big dialog explaination font
  font create dialogBigExpFont -family Helvetica -size 12 -weight bold

  # Font for basic labels
  font create labelFont  -family Helvetica -size 12
  font create boldLabelFont  -family Helvetica -size 12 -weight bold
  font create smallLabelFont  -family Helvetica -size 12

  # Font for basic buttons
  font create buttonFont  -family Helvetica -size 12

  # Font for entry/listbox entries
  font create entryFont  -family Helvetica -size 12

  # Font for menu entries
  font create menuFont  -family Helvetica -size 12

  # Font for menu buttons
  font create menuButtonFont  -family Helvetica -size 12

  # Font for HDL editor
  font create hdlFont  -family Courier -size 12
  font create hdlItalicFont  -family Courier -size 12 -slant italic
  font create hdlBoldFont  -family Courier -size 12 -weight bold
  font create hdlBoldItalicFont  -family Courier -size 12 -weight bold -slant italic

  #Fonts for tree widgers
  font create Tree:font -family Helvetica -size 12
  font create Tree:actfont -family Helvetica -size 12 -weight bold 
  font create Tree:act2font -family Helvetica -size 12 -weight bold -underline 1
}

proc largeFonts {} {
  global tkg_fontScale

  set tkg_fontScale 1.16

  # Dialog caption font
  font create dialogCapFont -family Helvetica -size 16 -weight bold 

  # Dialog explaination font
  font create dialogExpFont -family Helvetica -size 14

  # Big dialog explaination font
  font create dialogBigExpFont -family Helvetica -size 14 -weight bold 

  # Font for basic labels
  font create labelFont  -family Helvetica -size 14
  font create boldLabelFont  -family Helvetica -size 14 -weight bold
  font create smallLabelFont  -family Helvetica -size 14

  # Font for basic buttons
  font create buttonFont  -family Helvetica -size 14

  # Font for entry/listbox entries
  font create entryFont  -family Helvetica -size 14

  # Font for menu entries
  font create menuFont  -family Helvetica -size 14

  # Font for menu buttons
  font create menuButtonFont  -family Helvetica -size 14

  # Font for HDL editor
  font create hdlFont  -family Courier -size 14
  font create hdlItalicFont  -family Courier -size 14 -slant italic
  font create hdlBoldFont  -family Courier -size 14 -weight bold
  font create hdlBoldItalicFont  -family Courier -size 14 -weight bold -slant italic

  #Fonts for tree widgers
  font create Tree:font -family Helvetica -size 14
  font create Tree:actfont -family Helvetica -size 14 -weight bold 
  font create Tree:act2font -family Helvetica -size 14 -weight bold -underline 1
}

proc hugeFonts {} {
  global tkg_fontScale

  set tkg_fontScale 1.66

  # Dialog caption font
  font create dialogCapFont -family Helvetica -size 28 -weight bold

  # Dialog explaination font
  font create dialogExpFont -family Helvetica -size 20

  # Big dialog explaination font
  font create dialogBigExpFont -family Helvetica -size 20-weight bold

  # Fonts for basic labels
  font create labelFont  -family Helvetica -size 20 
  font create boldLabelFont  -family Helvetica -size 20 -weight bold
  font create smallLabelFont  -family Helvetica -size 20

  # Font for basic buttons
  font create buttonFont  -family Helvetica -size 20

  # Font for entry/listbox entries
  font create entryFont  -family Helvetica -size 20

  # Font for menu entries
  font create menuFont  -family Helvetica -size 20

  # Font for menu buttons
  font create menuButtonFont  -family Helvetica -size 20

  # Font for HDL editor
  font create hdlFont  -family Courier -size 20 
  font create hdlItalicFont  -family Courier -size 20 -slant italic
  font create hdlBoldFont  -family Courier -size 20 -weight bold
  font create hdlBoldItalicFont  -family Courier -size 20 -weight bold -slant italic

  #Fonts for tree widgers
  font create Tree:font -family Helvetica -size 20
  font create Tree:actfont -family Helvetica -size 20 -weight bold 
  font create Tree:act2font -family Helvetica -size 20 -weight bold -underline 1
}

#############################################################################
#
# Tk font setup for Japanese Fonts
#
proc smallJFonts {} {
  global tkg_fontScale

  set tkg_fontScale .75

  # Dialog caption font
  font create dialogCapFont -family Helvetica -size 10

  # Dialog explaination font
  font create dialogExpFont -family Helvetica -size 8

  # Big dialog explaination font
  font create dialogBigExpFont -family Helvetica -size 8

  # Fonts for basic labels
  font create labelFont  -family Helvetica -size 8
  font create boldLabelFont  -family Helvetica -size 8
  font create smallLabelFont  -family Helvetica -size 8

  # Font for basic buttons
  font create buttonFont  -family Helvetica -size 8

  # Font for menu entries
  font create menuFont  -family Helvetica -size 8

  # Font for entry/listbox entries
  font create entryFont  -family Helvetica -size 8

  # Font for menu buttons
  font create menuButtonFont  -family Helvetica -size 8

  # Font for HDL editor
  font create hdlFont  -family Courier -size 8
  font create hdlItalicFont  -family Courier -size 8 -slant italic
  font create hdlBoldFont  -family Courier -size 8
  font create hdlBoldItalicFont  -family Courier -size 8 -slant italic

  #Fonts for tree widgers
  font create Tree:font -family Helvetica -size 8
  font create Tree:actfont -family Helvetica -size 8 
  font create Tree:act2font -family Helvetica -size 8 -underline 1
}

proc normalJFonts {} {
  global tkg_fontScale

  set tkg_fontScale 1

  # Dialog caption font
  font create dialogCapFont -family fixed -size 16

  # Dialog explaination font
  font create dialogExpFont -family fixed -size 13

  # Big dialog explaination font
  font create dialogBigExpFont -family fixed -size 13

  # Fonts for basic labels
  font create labelFont -family fixed  -size 13
  font create boldLabelFont  -family Helvetica -size 13
  font create smallLabelFont -family fixed -size 13

  # Font for basic buttons
  font create buttonFont -family fixed  -size 13

  # Font for entry/listbox entries
  font create entryFont -family fixed  -size 13

  # Font for menu entries
  font create menuFont -family fixed -size 13

  # Font for menu buttons
  font create menuButtonFont -family fixed -size 13

  # Font for HDL editor
  font create hdlFont  -family Courier -size 13
  font create hdlItalicFont  -family Courier -size 13 -slant italic
  font create hdlBoldFont  -family Courier -size 13
  font create hdlBoldItalicFont  -family Courier -size 13 -slant italic

  #Fonts for tree widgers
  font create Tree:font -family fixed  -size 13
  font create Tree:actfont -family fixed  -size 13 
  font create Tree:act2font -family fixed  -size 13 -underline 1
}

proc largeJFonts {} {
  global tkg_fontScale

  set tkg_fontScale 1.16

  # Dialog caption font
  font create dialogCapFont -family fixed -size 16

  # Dialog explaination font
  font create dialogExpFont -family fixed -size 14

  # Big dialog explaination font
  font create dialogBigExpFont -family fixed -size 14

  # Fonts for basic labels
  font create labelFont  -family fixed -size 14
  font create boldLabelFont  -family Helvetica -size 14
  font create smallLabelFont  -family fixed -size 14

  # Font for basic buttons
  font create buttonFont  -family fixed -size 14

  # Font for entry/listbox entries
  font create entryFont  -family fixed -size 14

  # Font for menu entries
  font create menuFont  -family fixed -size 14

  # Font for menu buttons
  font create menuButtonFont  -family fixed -size 14

  # Font for HDL editor
  font create hdlFont  -family Courier -size 14
  font create hdlItalicFont  -family Courier -size 14 -slant italic
  font create hdlBoldFont  -family Courier -size 14 
  font create hdlBoldItalicFont  -family Courier -size 14 -slant italic

  #Fonts for tree widgers
  font create Tree:font -family fixed -size 14
  font create Tree:actfont -family fixed -size 14
  font create Tree:act2font -family fixed -size 14 -underline 1
}

proc hugeJFonts {} {
  global tkg_fontScale

  set tkg_fontScale 1.66

  # Dialog caption font
  font create dialogCapFont -family fixed -size 28

  # Dialog explaination font
  font create dialogExpFont -family fixed -size 20

  # Big dialog explaination font
  font create dialogBigExpFont -family fixed -size 20

  # Font for basic labels
  font create labelFont  -family fixed -size 20 
  font create boldLabelFont  -family Helvetica -size 20
  font create smallLabelFont  -family fixed -size 20

  # Font for basic buttons
  font create buttonFont  -family fixed -size 20

  # Font for entry/listbox entries
  font create entryFont  -family fixed -size 20

  # Font for menu entries
  font create menuFont  -family fixed -size 20

  # Font for menu buttons
  font create menuButtonFont  -family fixed -size 20

  # Font for HDL editor
  font create hdlFont  -family Courier -size 20 
  font create hdlItalicFont  -family Courier -size 20 -slant italic
  font create hdlBoldFont  -family Courier -size 20
  font create hdlBoldItalicFont  -family Courier -size 20 -slant italic

  #Fonts for tree widgers
  font create Tree:font -family fixed -size 20
  font create Tree:actfont -family fixed -size 20
  font create Tree:act2font -family fixed -size 20 -underline 1
}

#############################################################################
#
# Set up global options
#
if { $lang == "ja" } {
  ${tkg_fontSet}JFonts
} else {
  ${tkg_fontSet}Fonts
}

tk scaling 1

#
# Disable normal handling of Tab and BackTab
#
bind all <Tab> ""
bind all <<PrevWindow>> ""

#tk_setPalette "\#eee8e8"
#tk_bisque
option add *borderWidth 1
option add *Scrollbar*width 10
option add *Label*font labelFont
option add *Checkbutton*font labelFont
option add *Radiobutton*font labelFont
option add *Button*font buttonFont
option add *Menu*font menuFont
option add *Menubutton*font menuFont
option add *Entry*font entryFont
option add *Listbox*font entryFont
option add *Text*font hdlFont
option add *exportselection 0

option add *SpreadSheet*selectmode shift-multiple

#option add *Checkbutton*image [gifI checkoff.gif]
#option add *Checkbutton*selectImage [gifI checkon.gif]
#option add *Checkbutton*compound left
#option add *Checkbutton*indicatorOn 0
#option add *Checkbutton*relief flat

#option add *Checkbutton*boarderwidth 0
