#
# This is a namespace version of the Tabbox, but it is not up to date.
# Eventially this should replace the bara-bara functions that are used
# as a tab box now.
#
namespace eval Tabbox {
  variable details
  variable active

  proc reselect {w} {
    variable active
    _select $w $active($w)
  }

  proc select {w i} {
    variable active

    if { $active($w) == $i } return
    _select $w $i
  }

  proc _select {w i} {
    variable details
    variable active

    set active($w) $i

    set det $details($w)
    set bd [assoc bd $det]
    set tabheight [assoc tabheight $det]
    set tabwidth [assoc tabwidth $det]
    set activecolor [assoc activecolor $det]
    set inactivecolor [assoc inactivecolor $det]
    set command [assoc command $det]
    set tabs [assoc tabs $det]

    $w coords hider [expr $bd + $i*$tabwidth] $tabheight

    catch {
      for { set j 0 } { 1 } { incr j } {
	if { $j == $i } {
	  $w.b$j configure -background $activecolor
	  $w.b$j.l configure -background $activecolor
	} else {
	  $w.b$j configure -background $inactivecolor
	  $w.b$j.l configure -background $inactivecolor
	}
      }
    }

    if { $command != "" } {
      catch { destroy $w.f.f }
      $command $w.f.f [lindex $tabs $i]
      catch { pack $w.f.f -anchor center -expand 1 -fill both}
    }
  }
  
  proc new {w args} {
    variable details
    variable active

    set activecolor "#d9d9d9"
    set inactivecolor [. cget -background]
    set width 300
    set height 300
    set tabheight 25
    set tabwidth 50
    set tabs {}
    set bd 2
    set relief raised
    set command ""

    set active($w) ""

    parseargs $args {-width -height -tabheight -tabwidth -bd -relief -tabs -activecolor -inactivecolor -command}

    set details($w) {}
    lappend details($w) [list width $width]
    lappend details($w) [list height $height]
    lappend details($w) [list tabwidth $tabwidth]
    lappend details($w) [list tabheight $tabheight]
    lappend details($w) [list activecolor $activecolor]
    lappend details($w) [list inactivecolor $inactivecolor]
    lappend details($w) [list bd $bd]
    lappend details($w) [list command $command]
    lappend details($w) [list tabs $tabs]

    canvas $w -width $width -height $height -highlightthickness 0

    set x 0
    set y $tabheight

    set i 0
    foreach t $tabs {
      frame $w.b$i -height $tabheight -width $tabwidth -bd $bd -relief $relief
      frame $w.b$i.v -height [expr $tabheight - 2*$bd] -width 0
      frame $w.b$i.h -height 0 -width [expr $tabwidth -2*$bd-1]
      label $w.b$i.l -text $t
      pack $w.b$i.v -side left
      pack $w.b$i.h
      pack $w.b$i.l

      $w create window $x [expr $y + $bd] -anchor sw -window $w.b$i -tags tab$i
      set x [expr $x + $tabwidth]

      bind $w.b$i <Button-1> "Tabbox::select $w $i"
      bind $w.b$i.l <Button-1> "Tabbox::select $w $i"

      incr i
    }


    frame $w.f -width $width  -height [expr $height - $tabheight] -bd $bd -relief $relief
    frame $w.f.v -height [expr $height - $tabheight - 2*$bd] -width 0
    frame $w.f.h -height 0 -width [expr $width -2*$bd-1]
    pack $w.f.v -side left
    pack $w.f.h

    $w create window 0 $tabheight -anchor nw -window $w.f

    frame $w.hider -width [expr $tabwidth - 2*$bd] -height [expr 2*$bd+1]
    $w create window 0 0 -anchor w -window $w.hider -tags hider

    Tabbox::select $w 0

    set tabheight 30
  }
}
