#   Copyright (C) 1987-2004 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Wed Mar 30 10:57:48 2005

proc OLD_tkg_makeTechSelector {w} {
  global tkg_defaultTech

  labelframe $w [m b.tech]

  Dropbox::new $w.v -variable tkg_defaultTech -value $tkg_defaultTech -width 18
  Dropbox::itemadd $w.v [gat_getTechList]
  pack $w.v -anchor w  -padx 3 -pady 11
  helpon ${w}_label [m ho.deftech]
}

proc sidebar_tabs {w tab} {
  switch $tab {
    Nets {
      catch { pack forget $w.portlst }
      catch { pack $w.netlst -fill both -expand 1 }
    }
    Ports {
      catch { pack forget $w.netlst }
      catch { pack $w.portlst -fill both -expand 1 }
    }
  }
}


proc tkg_makeNetPortBox {w} {
  TabBox::new $w -width 20 -height *20 -tabwidth *50 \
      -tabs { Nets Ports} -command sidebar_tabs -tablabels {Nets Ports} -dodestroy 0 -expand 1 \
      -inactivecolor gray70 -noslider 1

  frame $w.f.f
  pack $w.f.f -fill both -expand 1

  PortList::create $w.f.f.portlst
  NetList::create $w.f.f.netlst
  pack $w.f.f.netlst -fill both -expand 1

  helpon $w.b0 [m ho.netlist]
  helpon $w.b1 [m ho.ports] 
}

#
# Set up the side-bar windows here.
#
proc tkg_setupSideBar {w} {
#  tkg_makeTechSelector $w.tech

  frame $w.strut -width 175
  pack $w.strut
  tkg_makeBlockList $w.blklst
  tkg_makeNetPortBox $w.nptab

  pane $w.blklst $w.nptab -orient vertical -handlelook {-relief flat -height 10} -decoration paneDecoration
}

#
# The user requested a property edit, but there are no gates seleted.  Look in the side
# bar windows to see if we can find something selected. 
#
proc tkg_editModuleOrNet {} {
  set net [NetList::getselection]
  if {$net != "" } { 
    gat_editNet $net
    return
  }
#  if { [BlockList::getselection] != "" || [BlockTree::getselection] != "" } {
#    EditModuleDB::post
#  }
}

