//: version "2.0"
//: property prefix = "_GG"
//: property title = "Interactive TTY Device"

//: /symbolBegin: 140603920
//: /iconBegin normal 3404 0 0
//: /data "#define bitmap_width 73"
//: /data "#define bitmap_height 53"
//: /data "static unsigned char bitmap_bits[] = {"
//: /data "   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x01, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x08, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,"
//: /data "   0xe8, 0x3b, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x48,"
//: /data "   0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x48, 0x80, 0x01,"
//: /data "   0x00, 0xe0, 0xff, 0xff, 0xff, 0x3f, 0x88, 0x48, 0x80, 0x01, 0x00, 0x50,"
//: /data "   0x00, 0x00, 0x00, 0x50, 0x88, 0x48, 0x80, 0x01, 0x00, 0x28, 0x00, 0x00,"
//: /data "   0x00, 0x88, 0x88, 0x38, 0x80, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0xc4,"
//: /data "   0x08, 0x00, 0x80, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0xa2, 0x08, 0x00,"
//: /data "   0x80, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x91, 0xe8, 0x38, 0x80, 0x00,"
//: /data "   0x80, 0x02, 0x00, 0x00, 0x80, 0x88, 0x28, 0x49, 0x80, 0x01, 0x40, 0x01,"
//: /data "   0x00, 0x00, 0x40, 0x84, 0x28, 0x49, 0x80, 0x01, 0xa0, 0xff, 0xff, 0xff,"
//: /data "   0x3f, 0x82, 0xe8, 0x48, 0x80, 0x01, 0x60, 0x00, 0x00, 0x00, 0x40, 0x81,"
//: /data "   0x28, 0x49, 0x80, 0x01, 0x20, 0xff, 0xff, 0xff, 0x8f, 0x80, 0x28, 0x39,"
//: /data "   0x80, 0x00, 0x20, 0x01, 0x00, 0x00, 0x90, 0x80, 0x08, 0x00, 0x80, 0x00,"
//: /data "   0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80, 0x08, 0x00, 0x80, 0x00, 0xa0, 0x7c,"
//: /data "   0xef, 0x03, 0xa0, 0x80, 0xe8, 0x7c, 0x86, 0x00, 0xa0, 0x00, 0x00, 0x00,"
//: /data "   0xa0, 0x80, 0x2f, 0x11, 0x81, 0x00, 0xa0, 0xdc, 0x0f, 0x00, 0xa0, 0x80,"
//: /data "   0x28, 0x11, 0x87, 0x01, 0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80, 0xef, 0x10,"
//: /data "   0x88, 0x01, 0xa0, 0x7c, 0xbf, 0x01, 0xa0, 0x80, 0x28, 0x11, 0x89, 0x01,"
//: /data "   0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80, 0x2f, 0x11, 0x86, 0x00, 0xa0, 0x04,"
//: /data "   0x00, 0x00, 0xa0, 0x80, 0x08, 0x00, 0x80, 0x00, 0xa0, 0x00, 0x00, 0x00,"
//: /data "   0xa0, 0x80, 0x0f, 0x00, 0x80, 0x00, 0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80,"
//: /data "   0xc8, 0x7c, 0x86, 0x00, 0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80, 0x2f, 0x11,"
//: /data "   0x81, 0x00, 0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80, 0x28, 0x10, 0x8f, 0x01,"
//: /data "   0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80, 0x2f, 0x10, 0x88, 0x01, 0xa0, 0x00,"
//: /data "   0x00, 0x00, 0xa0, 0x80, 0x28, 0x11, 0x89, 0x01, 0xa0, 0x00, 0x00, 0x00,"
//: /data "   0xa0, 0x80, 0xc8, 0x10, 0x86, 0x00, 0xa0, 0x00, 0x00, 0x00, 0xa0, 0x80,"
//: /data "   0x08, 0x00, 0x80, 0x00, 0x20, 0x01, 0x00, 0x00, 0x90, 0x80, 0x08, 0x00,"
//: /data "   0x80, 0x00, 0x20, 0xfe, 0xff, 0xff, 0x8f, 0x80, 0xe8, 0x30, 0x87, 0x00,"
//: /data "   0x60, 0x00, 0x00, 0x00, 0xc0, 0x80, 0x28, 0x09, 0x89, 0x00, 0xa0, 0xff,"
//: /data "   0xff, 0xff, 0xbf, 0x80, 0x28, 0x79, 0x89, 0x01, 0x10, 0x00, 0x00, 0x00,"
//: /data "   0x40, 0x80, 0x28, 0x41, 0x87, 0x01, 0xd0, 0xff, 0xff, 0xff, 0x4f, 0x80,"
//: /data "   0x28, 0x49, 0x89, 0x01, 0xc8, 0xaa, 0xaa, 0xaa, 0x2a, 0x40, 0xe8, 0x30,"
//: /data "   0x89, 0x00, 0xa8, 0xff, 0xff, 0xff, 0x27, 0x20, 0x08, 0x00, 0x80, 0x00,"
//: /data "   0xa4, 0xaa, 0xaa, 0xaa, 0x16, 0x10, 0x08, 0x00, 0x80, 0x00, 0xf4, 0xff,"
//: /data "   0xff, 0xff, 0x13, 0x08, 0xe8, 0x7c, 0x87, 0x00, 0x92, 0xaa, 0xaa, 0xaa,"
//: /data "   0x0a, 0x04, 0x28, 0x11, 0x89, 0x00, 0xfa, 0xff, 0xff, 0xff, 0x0b, 0x02,"
//: /data "   0x28, 0x11, 0x89, 0x01, 0x01, 0x00, 0x00, 0x00, 0x04, 0x01, 0x28, 0x11,"
//: /data "   0x87, 0x01, 0xff, 0xff, 0xff, 0xff, 0x87, 0x00, 0x28, 0x11, 0x89, 0x01,"
//: /data "   0x01, 0x00, 0x00, 0x00, 0x44, 0x00, 0xe8, 0x10, 0x89, 0x00, 0x01, 0x00,"
//: /data "   0x00, 0x00, 0x24, 0x00, 0x08, 0x00, 0x80, 0x00, 0x01, 0x00, 0x00, 0x00,"
//: /data "   0x14, 0x00, 0x08, 0x00, 0x80, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0c, 0x00,"
//: /data "   0xf8, 0xff, 0xff, 0x01, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00};"
//: /iconEnd
//: /iconBegin select 3389 0 0
//: /data "#define x_width 73"
//: /data "#define x_height 53"
//: /data "static unsigned char x_bits[] = {"
//: /data "   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x01, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x18, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,"
//: /data "   0xf8, 0x7b, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xd9,"
//: /data "   0xc0, 0x01, 0x00, 0xc0, 0xff, 0xff, 0xff, 0x3f, 0x98, 0xd9, 0xc0, 0x01,"
//: /data "   0x00, 0xe0, 0xff, 0xff, 0xff, 0x7f, 0x98, 0xd9, 0xc0, 0x01, 0x00, 0x70,"
//: /data "   0x00, 0x00, 0x00, 0xf8, 0x98, 0xd9, 0xc0, 0x01, 0x00, 0x38, 0x00, 0x00,"
//: /data "   0x00, 0xcc, 0x98, 0x79, 0xc0, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0xe6,"
//: /data "   0x18, 0x00, 0xc0, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0xf3, 0x18, 0x00,"
//: /data "   0xc0, 0x00, 0x00, 0x07, 0x00, 0x00, 0x80, 0xd9, 0xf8, 0x79, 0xc0, 0x00,"
//: /data "   0x80, 0x03, 0x00, 0x00, 0xc0, 0xcc, 0x78, 0xdb, 0xc0, 0x01, 0xc0, 0xff,"
//: /data "   0xff, 0xff, 0x7f, 0xc6, 0x78, 0xdb, 0xc0, 0x01, 0xe0, 0xff, 0xff, 0xff,"
//: /data "   0x3f, 0xc3, 0xf8, 0xd9, 0xc0, 0x01, 0x60, 0x00, 0x00, 0x00, 0xc0, 0xc1,"
//: /data "   0x78, 0xdb, 0xc0, 0x01, 0x60, 0xff, 0xff, 0xff, 0x8f, 0xc1, 0x78, 0x7b,"
//: /data "   0xc0, 0x00, 0xe0, 0xff, 0xff, 0xff, 0x9f, 0xc1, 0x18, 0x00, 0xc0, 0x00,"
//: /data "   0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1, 0x18, 0x00, 0xc0, 0x00, 0xe0, 0x7c,"
//: /data "   0xef, 0x03, 0xb0, 0xc1, 0xf8, 0x7d, 0xce, 0x00, 0xe0, 0x00, 0x00, 0x00,"
//: /data "   0xb0, 0xc1, 0x7f, 0x33, 0xc3, 0x00, 0xe0, 0xdc, 0x0f, 0x00, 0xb0, 0xc1,"
//: /data "   0x78, 0x33, 0xcf, 0x01, 0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1, 0xff, 0x30,"
//: /data "   0xd8, 0x01, 0xe0, 0x7c, 0xbf, 0x01, 0xb0, 0xc1, 0x78, 0x33, 0xdb, 0x01,"
//: /data "   0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1, 0x7f, 0x33, 0xce, 0x00, 0xe0, 0x04,"
//: /data "   0x00, 0x00, 0xb0, 0xc1, 0x18, 0x00, 0xc0, 0x00, 0xe0, 0x00, 0x00, 0x00,"
//: /data "   0xb0, 0xc1, 0x1f, 0x00, 0xc0, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1,"
//: /data "   0xd8, 0x7d, 0xce, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1, 0x7f, 0x33,"
//: /data "   0xc3, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1, 0x78, 0x30, 0xdf, 0x01,"
//: /data "   0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1, 0x7f, 0x30, 0xd8, 0x01, 0xe0, 0x00,"
//: /data "   0x00, 0x00, 0xb0, 0xc1, 0x78, 0x33, 0xdb, 0x01, 0xe0, 0x00, 0x00, 0x00,"
//: /data "   0xb0, 0xc1, 0xd8, 0x31, 0xce, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xb0, 0xc1,"
//: /data "   0x18, 0x00, 0xc0, 0x00, 0x60, 0x01, 0x00, 0x00, 0x98, 0xc1, 0x18, 0x00,"
//: /data "   0xc0, 0x00, 0x60, 0xfe, 0xff, 0xff, 0x8f, 0xc1, 0xf8, 0x70, 0xc7, 0x00,"
//: /data "   0xe0, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x78, 0x1b, 0xdb, 0x00, 0xe0, 0xff,"
//: /data "   0xff, 0xff, 0xbf, 0xc1, 0x78, 0xfb, 0xdb, 0x01, 0x30, 0x00, 0x00, 0x00,"
//: /data "   0xe0, 0xc0, 0x78, 0xc3, 0xcf, 0x01, 0xf0, 0xff, 0xff, 0xff, 0x6f, 0xc0,"
//: /data "   0x78, 0xdb, 0xdb, 0x01, 0xd8, 0xaa, 0xaa, 0xaa, 0x3a, 0x60, 0xf8, 0x70,"
//: /data "   0xdb, 0x00, 0xb8, 0xff, 0xff, 0xff, 0x37, 0x30, 0x18, 0x00, 0xc0, 0x00,"
//: /data "   0xac, 0xaa, 0xaa, 0xaa, 0x1e, 0x18, 0x18, 0x00, 0xc0, 0x00, 0xfc, 0xff,"
//: /data "   0xff, 0xff, 0x1b, 0x0c, 0xf8, 0x7c, 0xc7, 0x00, 0x96, 0xaa, 0xaa, 0xaa,"
//: /data "   0x0e, 0x06, 0x78, 0x33, 0xdb, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x0f, 0x03,"
//: /data "   0x78, 0x33, 0xdb, 0x01, 0x03, 0x00, 0x00, 0x00, 0x86, 0x01, 0x78, 0x33,"
//: /data "   0xc7, 0x01, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x00, 0x78, 0x33, 0xdb, 0x01,"
//: /data "   0xff, 0xff, 0xff, 0xff, 0x67, 0x00, 0xf8, 0x30, 0xdb, 0x00, 0x03, 0x00,"
//: /data "   0x00, 0x00, 0x36, 0x00, 0x18, 0x00, 0xc0, 0x00, 0x03, 0x00, 0x00, 0x00,"
//: /data "   0x1e, 0x00, 0xf8, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00,"
//: /data "   0xf8, 0xff, 0xff, 0x01, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00};"
//: /iconEnd
//: /port output TD[7:0] @(73, 5) /r:0
//: /port input DSR @(73, 38) /r:0
//: /port output RTS @(73, 22) /r:0
//: /port input RD[7:0] @(73, 13) /r:0
//: /port input CTS @(73, 30) /r:0
//: /port output DTR @(73, 46) /r:0
//: /symbolEnd

//: /netlistBegin main
module main;    //: root_module
wire w4;    //: /sn:0 {0}(161,113)(176,113){1}
wire [7:0] w0;    //: /sn:0 {0}(161,88)(176,88){1}
wire [7:0] w3;    //: /sn:0 {0}(161,96)(176,96){1}
wire w1;    //: /sn:0 {0}(161,121)(176,121){1}
wire w2;    //: /sn:0 {0}(161,105)(176,105){1}
wire w5;    //: /sn:0 {0}(161,129)(176,129){1}
//: enddecls

  TTY g0 (.TD(w0), .DSR(w1), .RTS(w2), .RD(w3), .CTS(w4), .DTR(w5));   //: @(124, 109) /symbol:140603920 /sn:0 /w:[ 0 0 0 0 0 0 ]

endmodule
//: /netlistEnd

//: /hdlBegin TTY
//: /symbol:140603920
//: interface  /sz:(40, 40) /bd:[ ]
//: enddecls
module TTY(TD, RD, RTS, CTS, DSR, DTR);
input CTS, DSR;
input [7:0] RD;
output [7:0] TD;
output RTS, DTR;
reg _RTS, _DTR;
reg [7:0] data;

  initial
    begin
      _RTS = 0;
      data = 0;
      _DTR = 0;
    end

  initial $tkg$post("TTY","%m");

  always
    begin
      _DTR = 1'b0;
      @(posedge DSR);
      # 10;
      _DTR = 1'b1;
      //      $tkg$exec("TTY::data %m %d", RD);
      $tkg$send("%m.RD",RD);
      # 10;
      @(negedge DSR);
      # 10;
    end

  always
    begin
      @ (negedge CTS);
      # 10;
      data = $tkg$recv("%m.TD");
      # 10;
      _RTS = 1'b1;
      @ (posedge CTS);
      # 10;
      _RTS = 1'b0;
    end

  assign TD =  data;
  assign RTS = _RTS;
  assign DTR = _DTR;

endmodule
//: /hdlEnd
