#!/bin/sh

copy_icons()
{
    # This function searches for common icon paths.

#    if test ! -d /usr/share/icons; then
#      if test -w /usr/share; then
#        mkdir /usr/share/icons/
#	chmod 755 /usr/share/icons
#      fi
#    fi
    if test -w /usr/share/icons; then
      cp $DIR_FROM/varicad"$ADDON".xpm /usr/share/icons/varicad"$ADDON".xpm
    fi
  
#    if test ! -d /usr/share/pixmaps; then
#      if test -w /usr/share; then
#	mkdir /usr/share/pixmaps/
#	chmod 755 /usr/share/pixmaps
#      fi
#    fi
    if test -w /usr/share/pixmaps/; then
      cp $DIR_FROM/varicad"$ADDON".xpm /usr/share/pixmaps/varicad"$ADDON".xpm
    fi
}

copy_wmconfig()
{  
#    if test ! -d /etc/X11/wmconfig/; then
#      if test -w /etc/X11; then
#	mkdir /etc/X11/wmconfig/
#	chmod 755 /etc/X11/wmconfig
#      fi
#    fi
    if test -w /etc/X11/wmconfig/; then
      cp $DIR_FROM/varicad"$ADDON".wmconfig /etc/X11/wmconfig/varicad"$ADDON"
    fi
    
    if test -d /etc/X11/applnk/; then
      if test ! -d /etc/X11/applnk/$MENU_GROUP/; then
	if test -w /etc/X11/applnk; then
	  mkdir /etc/X11/applnk/$MENU_GROUP/
	  chmod 755 /etc/X11/applnk/$MENU_GROUP
	fi
      fi
      if test -w /etc/X11/applnk/$MENU_GROUP; then
	cp $DIR_FROM/varicad"$ADDON".desktop /etc/X11/applnk/$MENU_GROUP
      fi
    fi
}

create_gnome_entries()
{
    # This function searches for common gnome icon paths.

    if test -d ${1}; then

      # gnome icon
      if test ! -d ${1}/pixmaps/ -a -w ${1}; then
        mkdir ${1}/pixmaps/
	chmod 755 ${1}/pixmaps
      fi
      if test -w ${1}/pixmaps; then cp $DIR_FROM/varicad"$ADDON".xpm ${1}/pixmaps/varicad"$ADDON".xpm; fi

      # gnome link
#      if test ! -d ${1}/apps/$MENU_GROUP -a -w ${1}/apps; then
#        mkdir ${1}/apps/$MENU_GROUP/
#	chmod 755 ${1}/apps/$MENU_GROUP
#      fi
#      if test -w ${1}/apps/$MENU_GROUP; then cp $DIR_FROM/varicad.desktop ${1}/apps/$MENU_GROUP/; fi

    fi
}

create_kde_entries()
{
    # This function searches for common kde2 and kde3 icon paths.

    if test -d ${1}; then

      DIR_HI=${1}/icons/hicolor
      if test -d "$DIR_HI" -a -w "$DIR_HI"; then
        if test -d "$DIR_HI"/48x48/apps -a -w "$DIR_HI"/48x48/apps; then cp $DIR_FROM/varicad"$ADDON"_48x48.png $DIR_HI/48x48/apps/varicad"$ADDON".png; fi
        if test -d "$DIR_HI"/32x32/apps -a -w "$DIR_HI"/32x32/apps; then cp $DIR_FROM/varicad"$ADDON"_32x32.png $DIR_HI/32x32/apps/varicad"$ADDON".png; fi
        if test -d "$DIR_HI"/22x22/apps -a -w "$DIR_HI"/22x22/apps; then cp $DIR_FROM/varicad"$ADDON"_22x22.png $DIR_HI/22x22/apps/varicad"$ADDON".png; fi
      fi

      DIR_LO=${1}/icons/locolor
      if test -d $DIR_LO -a -w $DIR_LO; then
        if test -d $DIR_LO/32x32/apps -a -w $DIR_LO/32x32/apps; then cp $DIR_FROM/varicad"$ADDON"_32x32.png $DIR_LO/32x32/apps/varicad"$ADDON".png; fi
        if test -d $DIR_LO/22x22/apps -a -w $DIR_LO/22x22/apps; then cp $DIR_FROM/varicad"$ADDON"_22x22.png $DIR_LO/22x22/apps/varicad"$ADDON".png; fi
        if test -d $DIR_LO/16x16/apps -a -w $DIR_LO/16x16/apps; then cp $DIR_FROM/varicad"$ADDON"_16x16.png $DIR_LO/16x16/apps/varicad"$ADDON".png; fi
      fi

#      if test -d ${1}/applnk/; then
#        if test ! -d ${1}/applnk/$MENU_GROUP/ -a -w ${1}/applnk; then
#	    mkdir ${1}/applnk/$MENU_GROUP/
#	    chmod 755 ${1}/applnk/$MENU_GROUP
#	fi
#	if test -w ${1}/applnk/$MENU_GROUP; then cp $DIR_FROM/varicad.desktop ${1}/applnk/$MENU_GROUP; fi
#      fi

#      if test -d ${1}/applnk-mdk/; then
#        if test ! -d ${1}/applnk-mdk/$MENU_GROUP/ -a -w ${1}/applnk-mdk; then
#	    mkdir ${1}/applnk-mdk/$MENU_GROUP/
#	    chmod 755 ${1}/applnk-mdk/$MENU_GROUP
#	fi
#	if test -w ${1}/applnk-mdk/$MENU_GROUP; then cp $DIR_FROM/varicad.desktop ${1}/applnk-mdk/$MENU_GROUP; fi
#      fi

    fi  

}

create_desktop_entries()
{
    # www.freedesktop.org standarts

    DIR_SHARE=/usr/share
    if test -d $DIR_SHARE; then

      DIR_HI=$DIR_SHARE/icons/hicolor
      if test -d "$DIR_HI" -a -w "$DIR_HI"; then
        if test -d "$DIR_HI"/48x48/apps -a -w "$DIR_HI"/48x48/apps; then cp $DIR_FROM/varicad"$ADDON"_48x48.png $DIR_HI/48x48/apps/varicad"$ADDON".png; fi
        if test -d "$DIR_HI"/32x32/apps -a -w "$DIR_HI"/32x32/apps; then cp $DIR_FROM/varicad"$ADDON"_32x32.png $DIR_HI/32x32/apps/varicad"$ADDON".png; fi
        if test -d "$DIR_HI"/22x22/apps -a -w "$DIR_HI"/22x22/apps; then cp $DIR_FROM/varicad"$ADDON"_22x22.png $DIR_HI/22x22/apps/varicad"$ADDON".png; fi
      fi

      DIR_LO=$DIR_SHARE/icons/locolor
      if test -d $DIR_LO -a -w $DIR_LO; then
        if test -d $DIR_LO/32x32/apps -a -w $DIR_LO/32x32/apps; then cp $DIR_FROM/varicad"$ADDON"_32x32.png $DIR_LO/32x32/apps/varicad"$ADDON".png; fi
        if test -d $DIR_LO/22x22/apps -a -w $DIR_LO/22x22/apps; then cp $DIR_FROM/varicad"$ADDON"_22x22.png $DIR_LO/22x22/apps/varicad"$ADDON".png; fi
        if test -d $DIR_LO/16x16/apps -a -w $DIR_LO/16x16/apps; then cp $DIR_FROM/varicad"$ADDON"_16x16.png $DIR_LO/16x16/apps/varicad"$ADDON".png; fi
      fi

      if test -d $DIR_SHARE/applications/; then
	if test -w $DIR_SHARE/applications/; then cp $DIR_FROM/varicad"$ADDON".desktop $DIR_SHARE/applications/; fi
      fi
      
      if test -d $DIR_SHARE/mimelnk/application/; then
	if test -w $DIR_SHARE/mimelnk/application/; then cp $DIR_FROM/x-varicad"$ADDON".desktop $DIR_SHARE/mimelnk/application/; fi
      fi

      update-desktop-database 2> /dev/null
      update-mime-database 2> /dev/null
    fi
}

update_mandrake_menu()
{
    if test -x /usr/bin/update-menus; then

	test ! -d /usr/lib/menu && test -w /usr/lib && mkdir /usr/lib/menu/
	test -d /usr/lib/menu -a -w /usr/lib/menu && cp $DIR_FROM/varicad"$ADDON".mdkmenu /usr/lib/menu/varicad

	test ! -d /usr/share/icons && test -w /usr/share && mkdir /usr/share/icons/ && chmod 755 /usr/share/icons
	test -d /usr/share/icons -a -w /usr/share/icons && cp $DIR_FROM/varicad"$ADDON"_32x32.png /usr/share/icons/varicad"$ADDON".png

	test ! -d /usr/share/icons/mini && test -w /usr/share/icons && mkdir /usr/share/icons/mini/ && chmod 755 /usr/share/icons/mini
	test -d /usr/share/icons/mini -a -w /usr/share/icons/mini && cp $DIR_FROM/varicad"$ADDON"_16x16.png /usr/share/icons/mini/varicad"$ADDON".png

	test ! -d /usr/share/icons/large && test -w /usr/share/icons && mkdir /usr/share/icons/large && chmod 755 /usr/share/icons/large
	test -d /usr/share/icons/large -a -w /usr/share/icons/large && cp $DIR_FROM/varicad"$ADDON"_48x48.png /usr/share/icons/large/varicad"$ADDON".png

	/usr/bin/update-menus || true
    fi
}

#  DIR_FROM=/opt/VariCAD/desktop/
  DIR_FROM=./
  ADDON=""
  if test -f varicadview.xpm ; then
    ADDON="view"
  fi
  MENU_GROUP=Graphics

  copy_icons
  copy_wmconfig
  create_gnome_entries /opt/gnome/share
  create_gnome_entries /usr/share/gnome
  create_kde_entries /opt/kde2/share
  create_kde_entries /opt/kde3/share
  create_kde_entries /usr/share
  create_desktop_entries
  update_mandrake_menu
